/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import org.openspaces.admin.internal.pu.elastic.GridServiceAgentFailureDetectionConfig;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.machines.AbstractMachinesSlaPolicy;

public class CapacityMachinesSlaPolicy
extends AbstractMachinesSlaPolicy {
    private CapacityRequirements capacityRequirements;
    private GridServiceAgentFailureDetectionConfig agentFailureDetectionConfig;

    public CapacityRequirements getCapacityRequirements() {
        return this.capacityRequirements;
    }

    public void setCapacityRequirements(CapacityRequirements capacityRequirements) {
        this.capacityRequirements = capacityRequirements;
    }

    @Override
    public boolean isStopMachineSupported() {
        return true;
    }

    public GridServiceAgentFailureDetectionConfig getAgentFailureDetectionConfig() {
        return this.agentFailureDetectionConfig;
    }

    public void setAgentFailureDetectionConfig(GridServiceAgentFailureDetectionConfig agentFailureDetectionConfig) {
        this.agentFailureDetectionConfig = agentFailureDetectionConfig;
    }

    @Override
    public String getScaleStrategyName() {
        return "Manual Capacity Scale Strategy";
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.capacityRequirements == null) {
            throw new IllegalArgumentException("capacityRequirements cannot be null");
        }
        if (this.agentFailureDetectionConfig == null) {
            throw new IllegalArgumentException("disabledAgentFailureDetectionIpAddresses cannot be null");
        }
    }

    public String toString() {
        return "AbstractMachinesSlaPolicy{maxNumberOfMachines=" + this.getMaximumNumberOfMachines() + ", minimumNumberOfMachines=" + this.getMinimumNumberOfMachines() + ", containerMemoryCapacityInMB=" + this.getContainerMemoryCapacityInMB() + ", machineProvisioning=" + this.getMachineProvisioning() + ", machineIsolation=" + this.getMachineIsolation() + ", maxNumberOfContainersPerMachine=" + this.getMaximumNumberOfContainersPerMachine() + ", machinesCache=" + this.getDiscoveredMachinesCache() + ", zones=" + this.getGridServiceAgentZones() + ", allowAboveAverageMemoryPerMachine=" + this.isAllowAboveAverageMemoryPerMachine() + ", capacityRequirements=" + this.capacityRequirements + ", agentFailureDetectionConfig=" + this.agentFailureDetectionConfig + '}';
    }
}

