/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.pu.elastic.GridServiceAgentFailureDetectionConfig;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ExactZonesConfigurer;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirementType;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.capacity.CpuCapacityRequirement;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;
import org.openspaces.grid.gsm.capacity.NumberOfMachinesCapacityRequirement;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.machines.AbstractMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.BinPackingSolver;
import org.openspaces.grid.gsm.machines.CapacityMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.EagerMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.FailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureCleanupCloudResources;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureStoppedMachine;
import org.openspaces.grid.gsm.machines.GridServiceAgentFutures;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.RecoveringFailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.StartedGridServiceAgent;
import org.openspaces.grid.gsm.machines.exceptions.CannotDetermineIfNeedToStartMoreMachinesException;
import org.openspaces.grid.gsm.machines.exceptions.CloudCleanupFailedException;
import org.openspaces.grid.gsm.machines.exceptions.DelayingScaleInUntilAllMachinesHaveStartedException;
import org.openspaces.grid.gsm.machines.exceptions.DiscoveredTwoAgentsWithTheSameIpAddress;
import org.openspaces.grid.gsm.machines.exceptions.ExpectedMachineWithMoreMemoryException;
import org.openspaces.grid.gsm.machines.exceptions.FailedGridServiceAgentReconnectedException;
import org.openspaces.grid.gsm.machines.exceptions.FailedToStartNewGridServiceAgentException;
import org.openspaces.grid.gsm.machines.exceptions.FailedToStartNewMachineException;
import org.openspaces.grid.gsm.machines.exceptions.FailedToStopGridServiceAgentException;
import org.openspaces.grid.gsm.machines.exceptions.FailedToStopMachineException;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementPendingContainerDeallocationException;
import org.openspaces.grid.gsm.machines.exceptions.InconsistentMachineProvisioningException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToStartMoreGridServiceAgentsException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.StartedTooManyMachinesException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.UnexpectedShutdownOfNewGridServiceAgentException;
import org.openspaces.grid.gsm.machines.isolation.PublicMachineIsolation;
import org.openspaces.grid.gsm.machines.isolation.SharedMachineIsolation;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticGridServiceAgentProvisioningException;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticMachineProvisioningException;

class DefaultMachinesSlaEnforcementEndpoint
implements MachinesSlaEnforcementEndpoint {
    private static final long START_AGENT_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.start-agent-timeout-seconds", 1800L);
    private static final long STOP_AGENT_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.stop-agent-timeout-seconds", 600L);
    private static final long CLEANUP_CLOUD_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.cleanup-cloud-timeout-seconds", 600L);
    private final ProcessingUnit pu;
    private final Log logger;
    private final MachinesSlaEnforcementState state;

    public DefaultMachinesSlaEnforcementEndpoint(ProcessingUnit pu, MachinesSlaEnforcementState state) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null.");
        }
        this.state = state;
        this.pu = pu;
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(DefaultMachinesSlaEnforcementEndpoint.class)), pu);
        this.logger.debug((Object)("DefaultMachinesSlaEnforcementEndpoint instance created for Processing Unit " + pu.getName() + ". Using state instance " + state));
    }

    @Override
    public CapacityRequirementsPerAgent getAllocatedCapacity(AbstractMachinesSlaPolicy sla) {
        return this.state.getAllocatedCapacity(this.getKey(sla));
    }

    @Override
    public CapacityRequirementsPerAgent getAllocatedCapacityFilterUndiscoveredAgents(AbstractMachinesSlaPolicy sla) {
        CapacityRequirementsPerAgent checkedAllocatedCapacity = new CapacityRequirementsPerAgent();
        CapacityRequirementsPerAgent allocatedCapacity = this.getAllocatedCapacity(sla);
        for (String agentUid : allocatedCapacity.getAgentUids()) {
            GridServiceAgent agent = this.pu.getAdmin().getGridServiceAgents().getAgentByUID(agentUid);
            if (agent != null) {
                CapacityRequirements capacity = allocatedCapacity.getAgentCapacity(agentUid);
                checkedAllocatedCapacity = checkedAllocatedCapacity.add(agentUid, capacity);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Found allocated capacity on agent that is no longer discovered " + agentUid));
        }
        return checkedAllocatedCapacity;
    }

    @Override
    public void enforceSla(CapacityMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException, GridServiceAgentSlaEnforcementInProgressException {
        this.validateSla(sla);
        long memoryInMB = MachinesSlaUtils.getMemoryInMB(sla.getCapacityRequirements());
        if (memoryInMB < (long)sla.getMinimumNumberOfMachines() * sla.getContainerMemoryCapacityInMB()) {
            throw new IllegalArgumentException("Memory capacity " + memoryInMB + "MB is less than the minimum of " + sla.getMinimumNumberOfMachines() + " containers with " + sla.getContainerMemoryCapacityInMB() + "MB each. sla.agentZone=" + sla.getGridServiceAgentZones());
        }
        if (memoryInMB > (long)this.getMaximumNumberOfMachines(sla) * sla.getContainerMemoryCapacityInMB()) {
            throw new IllegalArgumentException("Memory capacity " + memoryInMB + "MB is more than the maximum of " + this.getMaximumNumberOfMachines(sla) + " containers with " + sla.getContainerMemoryCapacityInMB() + "MB each. sla.agentZone=" + sla.getGridServiceAgentZones());
        }
        this.validateProvisionedMachines(sla);
        this.validateNoTwoDiscoveredAgentsHaveSameIpAddress(sla);
        this.setMachineIsolation(sla);
        this.enforceSlaInternal(sla);
    }

    private int getMaximumNumberOfMachines(AbstractMachinesSlaPolicy sla) {
        int numberOfMachinesFromSamePu = this.state.getAllocatedCapacityOfOtherKeysFromSamePu(this.getKey(sla)).getAgentUids().size();
        int maxNumberOfMachines = sla.getMaximumNumberOfMachines() - numberOfMachinesFromSamePu;
        if (maxNumberOfMachines < 0 && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("number of allocated machines (" + this.state.getAllocatedCapacity(this.pu).getAgentUids().size() + ") is above maximum " + sla.getMaximumNumberOfMachines() + ":" + this.state.getAllocatedCapacity(this.pu)));
        }
        return Math.max(sla.getMinimumNumberOfMachines(), maxNumberOfMachines);
    }

    private MachinesSlaEnforcementState.StateKey getKey(AbstractMachinesSlaPolicy sla) {
        return new MachinesSlaEnforcementState.StateKey(this.pu, sla.getGridServiceAgentZones());
    }

    @Override
    public void recoverStateOnEsmStart(AbstractMachinesSlaPolicy sla) throws SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, UndeployInProgressException {
        if (!this.isCompletedStateRecovery(sla)) {
            if (!sla.isUndeploying()) {
                this.state.validateUndeployNotInProgress(this.pu);
            }
            this.setMachineIsolation(sla);
            Set<String> puZones = this.pu.getRequiredContainerZones().getZones();
            if (puZones.size() != 1) {
                throw new IllegalStateException("PU has to have exactly 1 zone defined");
            }
            String containerZone = puZones.iterator().next();
            Admin admin = this.pu.getAdmin();
            for (ProcessingUnitInstance instance : this.pu.getInstances()) {
                GridServiceContainer container = instance.getGridServiceContainer();
                if (container.getAgentId() == -1 || container.getGridServiceAgent() != null) continue;
                throw new NeedToWaitUntilAllGridServiceAgentsDiscoveredException(this.pu, container);
            }
            CapacityRequirementsPerAgent allocatedCapacityForPu = this.state.getAllocatedCapacity(this.pu);
            for (GridServiceAgent agent : admin.getGridServiceAgents()) {
                if (!sla.getGridServiceAgentZones().isSatisfiedBy(agent.getExactZones())) continue;
                String agentUid = agent.getUid();
                long allocatedMemoryOnAgentInMB = MachinesSlaUtils.getMemoryInMB(allocatedCapacityForPu.getAgentCapacityOrZero(agentUid));
                int numberOfContainersForPuOnAgent = ContainersSlaUtils.getContainersByZoneOnAgentUid(admin, containerZone, agentUid).size();
                long memoryToAllocateOnAgentInMB = (long)numberOfContainersForPuOnAgent * sla.getContainerMemoryCapacityInMB() - allocatedMemoryOnAgentInMB;
                if (memoryToAllocateOnAgentInMB <= 0L) continue;
                this.logger.info((Object)("Recovering " + memoryToAllocateOnAgentInMB + "MB allocated for PU" + this.pu.getName() + " on agent " + this.agentToString(agent)));
                CapacityRequirements capacityToAllocateOnAgent = new CapacityRequirements(new MemoryCapacityRequirement((Long)memoryToAllocateOnAgentInMB));
                this.allocateManualCapacity(sla, capacityToAllocateOnAgent, new CapacityRequirementsPerAgent().add(agentUid, capacityToAllocateOnAgent));
            }
            if (sla instanceof CapacityMachinesSlaPolicy) {
                GridServiceAgents agents = admin.getGridServiceAgents();
                this.updateAgentsWithDisabledFailureDetection((CapacityMachinesSlaPolicy)sla, agents);
            }
            this.completedStateRecovery(sla);
        }
    }

    private void validateProvisionedMachines(AbstractMachinesSlaPolicy sla) throws GridServiceAgentSlaEnforcementInProgressException, MachinesSlaEnforcementInProgressException {
        Collection<GridServiceAgent> discoveredAgents = sla.getDiscoveredMachinesCache().getDiscoveredAgents();
        HashSet<GridServiceAgent> undiscoveredAgents = new HashSet<GridServiceAgent>();
        for (GridServiceAgent agent : MachinesSlaUtils.convertAgentUidsToAgentsIfDiscovered(this.getAllocatedCapacity(sla).getAgentUids(), this.pu.getAdmin())) {
            if (discoveredAgents.contains(agent)) continue;
            undiscoveredAgents.add(agent);
        }
        if (undiscoveredAgents.size() > 0) {
            throw new InconsistentMachineProvisioningException(this.getProcessingUnit(), undiscoveredAgents);
        }
    }

    private void validateNoTwoDiscoveredAgentsHaveSameIpAddress(AbstractMachinesSlaPolicy sla) throws GridServiceAgentSlaEnforcementInProgressException, MachinesSlaEnforcementInProgressException {
        Collection<GridServiceAgent> discoveredAgents = sla.getDiscoveredMachinesCache().getDiscoveredAgents();
        this.validateNoTwoDiscoveredAgentsHaveSameIpAddress(discoveredAgents);
    }

    private void validateNoTwoDiscoveredAgentsHaveSameIpAddress(Collection<GridServiceAgent> discoveredAgents) throws DiscoveredTwoAgentsWithTheSameIpAddress {
        HashMap<String, String> agentUidPerIpAddress = new HashMap<String, String>();
        for (GridServiceAgent agent : discoveredAgents) {
            String ipAddress = MachinesSlaUtils.getAgentIpAddress(agent);
            String agentUid = agent.getUid();
            String otherAgentUid = (String)agentUidPerIpAddress.get(ipAddress);
            if (otherAgentUid != null) {
                throw new DiscoveredTwoAgentsWithTheSameIpAddress(this.pu, ipAddress, otherAgentUid, agentUid);
            }
            agentUidPerIpAddress.put(ipAddress, agentUid);
        }
    }

    private void updateAgentsWithDisabledFailureDetection(CapacityMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException {
        Collection<GridServiceAgent> discoveredAgents = sla.getDiscoveredMachinesCache().getDiscoveredAgents();
        this.updateAgentsWithDisabledFailureDetection(sla, discoveredAgents);
    }

    private void updateAgentsWithDisabledFailureDetection(CapacityMachinesSlaPolicy sla, Iterable<GridServiceAgent> discoveredAgents) {
        GridServiceAgentFailureDetectionConfig failureDetectionConfig = sla.getAgentFailureDetectionConfig();
        long now = System.currentTimeMillis();
        for (GridServiceAgent agent : discoveredAgents) {
            String ipAddress = MachinesSlaUtils.getAgentIpAddress(agent);
            switch (failureDetectionConfig.getFailureDetectionStatus(ipAddress, now)) {
                case ENABLE_FAILURE_DETECTION: {
                    this.enableAgentFailureDetection(ipAddress);
                    break;
                }
                case DISABLE_FAILURE_DETECTION: {
                    this.disableFailoverDetectionForAgent(agent);
                    break;
                }
            }
        }
    }

    private void disableFailoverDetectionForAgent(GridServiceAgent agent) {
        String ipAddress;
        String oldAgentUid;
        String agentUid = agent.getUid();
        if (!agentUid.equals(oldAgentUid = this.state.disableFailoverDetection(ipAddress = MachinesSlaUtils.getAgentIpAddress(agent), agentUid))) {
            this.logger.info((Object)("Disabled failure detection of new agent " + agentUid + " (ip=" + ipAddress + ")"));
            if (oldAgentUid != null) {
                this.state.replaceAllocation(oldAgentUid, agentUid);
                this.logger.info((Object)("Replaced old agent " + oldAgentUid + " with new agent " + agentUid));
            }
        }
    }

    private void enableAgentFailureDetection(String ipAddress) {
        String agentUid = this.state.enableFailoverDetection(ipAddress);
        if (agentUid != null) {
            this.logger.info((Object)("Enabled failure detection for Agent " + agentUid + " (ip=" + ipAddress + ")"));
        }
    }

    private void validateSla(AbstractMachinesSlaPolicy sla) {
        if (sla == null) {
            throw new IllegalArgumentException("SLA cannot be null");
        }
        sla.validate();
    }

    @Override
    public void enforceSla(EagerMachinesSlaPolicy sla) throws GridServiceAgentSlaEnforcementInProgressException {
        this.validateSla(sla);
        try {
            this.validateProvisionedMachines(sla);
        }
        catch (MachinesSlaEnforcementInProgressException e) {
            this.logger.warn((Object)"Ignoring failure to related to new machines, since now in eager mode", (Throwable)e);
        }
        this.setMachineIsolation(sla);
        this.enforceSlaInternal(sla);
    }

    private void enforceSlaInternal(EagerMachinesSlaPolicy sla) throws GridServiceAgentSlaEnforcementInProgressException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving un-allocated capacity BEFORE state update. SLA=" + sla));
                this.getUnallocatedCapacity(sla);
            }
            this.updateFailedMachinesState(sla);
            this.updateFutureAgentsState(sla);
            this.updateRestrictedMachinesState(sla);
            this.updateAgentsMarkedForDeallocationState(sla);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving un-allocated capacity AFTER state update SLA=" + sla));
                this.getUnallocatedCapacity(sla);
            }
            this.unmarkAgentsMarkedForDeallocationToSatisfyMinimumNumberOfMachines(sla);
            this.allocateEagerCapacity(sla);
        }
        catch (MachinesSlaEnforcementInProgressException e) {
            this.logger.warn((Object)"Ignoring failure to related to new machines, since now in eager mode", (Throwable)e);
        }
        int machineShortage = this.getMachineShortageInOrderToReachMinimumNumberOfMachines(sla);
        if (machineShortage > 0) {
            CapacityRequirements capacityRequirements = new CapacityRequirements(new NumberOfMachinesCapacityRequirement((Integer)machineShortage));
            throw new NeedToStartMoreGridServiceAgentsException(sla, this.state, capacityRequirements, this.pu);
        }
        if (!this.getCapacityMarkedForDeallocation(sla).equalsZero()) {
            throw new GridServiceAgentSlaEnforcementPendingContainerDeallocationException(this.getProcessingUnit(), this.getCapacityMarkedForDeallocation(sla));
        }
    }

    public ProcessingUnit getProcessingUnit() {
        return this.pu;
    }

    private void enforceSlaInternal(CapacityMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException, GridServiceAgentSlaEnforcementInProgressException {
        this.updateAgentsWithDisabledFailureDetection(sla);
        this.updateFailedMachinesState(sla);
        this.updateFutureAgentsState(sla);
        this.updateRestrictedMachinesState(sla);
        this.updateAgentsMarkedForDeallocationState(sla);
        CapacityRequirementsPerAgent capacityMarkedForDeallocation = this.getCapacityMarkedForDeallocation(sla);
        CapacityRequirementsPerAgent capacityAllocated = this.getAllocatedCapacity(sla);
        if (this.getNumberOfFutureAgents(sla) > 0 && !capacityMarkedForDeallocation.equalsZero()) {
            throw new IllegalStateException("Cannot have both agents pending to be started and agents pending deallocation. capacityMarkedForDeallocation=" + capacityMarkedForDeallocation + " getNumberOfFutureAgents(sla)=" + this.getNumberOfFutureAgents(sla) + " sla.agentZones=" + sla.getGridServiceAgentZones());
        }
        CapacityRequirements target = sla.getCapacityRequirements();
        CapacityRequirementsPerAgent capacityAllocatedAndMarked = capacityMarkedForDeallocation.add(capacityAllocated);
        int machineShortage = this.getMachineShortageInOrderToReachMinimumNumberOfMachines(sla);
        RecoveringFailedGridServiceAgent[] failedAgents = this.getFailedAgentsNotBeingRecovered(sla);
        if (failedAgents.length > 0 && sla.getMachineProvisioning().isStartMachineSupported()) {
            CapacityRequirements capacityRequirements = new CapacityRequirements(new NumberOfMachinesCapacityRequirement((Integer)failedAgents.length));
            if (this.isFutureAgentsOfOtherSharedServices(sla)) {
                throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit(), "Cannot determine if need to recover from machine failover, waiting for other machines from same tenant to start first.");
            }
            for (RecoveringFailedGridServiceAgent failedAgent : failedAgents) {
                failedAgent.incrementRecoveryAttempt();
            }
            ExactZonesConfig exactZones = ((ExactZonesConfigurer)new ExactZonesConfigurer().addZones(sla.getGridServiceAgentZones().getZones())).create();
            FutureGridServiceAgent[] futureAgents = sla.getMachineProvisioning().startMachinesAsync(capacityRequirements, exactZones, this.toFailedGridServiceAgents(failedAgents), START_AGENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            this.addFutureAgents(sla, futureAgents, capacityRequirements);
            this.logger.info((Object)(futureAgents.length + " machine(s) is started in order to recover from failure of " + MachinesSlaUtils.failedAgentUidsToString(futureAgents) + " in zones " + exactZones + " reservationIds=" + MachinesSlaUtils.reservationIdsToString(futureAgents)));
        } else if (!capacityAllocatedAndMarked.getTotalAllocatedCapacity().equals(target) && capacityAllocatedAndMarked.getTotalAllocatedCapacity().greaterOrEquals(target) && machineShortage == 0) {
            if (this.getNumberOfFutureAgents(sla) > 0) {
                throw new DelayingScaleInUntilAllMachinesHaveStartedException(this.getProcessingUnit());
            }
            this.logger.debug((Object)("Considering scale in: target is " + target + " minimum #machines is " + sla.getMinimumNumberOfMachines() + ", machines started " + this.getAllocatedCapacity(sla) + ", machines pending deallocation " + this.getCapacityMarkedForDeallocation(sla)));
            CapacityRequirements surplusCapacity = capacityAllocatedAndMarked.getTotalAllocatedCapacity().subtract(target);
            int surplusMachines = capacityAllocatedAndMarked.getAgentUids().size() - sla.getMinimumNumberOfMachines();
            for (String agentUid : capacityMarkedForDeallocation.getAgentUids()) {
                CapacityRequirements agentCapacity = capacityMarkedForDeallocation.getAgentCapacity(agentUid);
                if (surplusCapacity.greaterOrEquals(agentCapacity) && surplusMachines > 0) {
                    surplusCapacity = surplusCapacity.subtract(agentCapacity);
                    --surplusMachines;
                    continue;
                }
                this.unmarkCapacityForDeallocation(sla, agentUid, agentCapacity);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Agent " + this.agentToString(agentUid) + " is no longer marked for deallocation in order to maintain capacity. Allocated machine agents are: " + this.getAllocatedCapacity(sla)));
            }
            if (!surplusCapacity.equalsZero()) {
                this.deallocateManualCapacity(sla, surplusCapacity);
            }
        } else if (!capacityAllocatedAndMarked.getTotalAllocatedCapacity().greaterOrEquals(target)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Considering to start more machines in order to reach target capacity of " + target + ". Current capacity is " + this.getAllocatedCapacity(sla).getTotalAllocatedCapacity()));
            }
            CapacityRequirements shortageCapacity = this.getCapacityShortage(sla, target);
            for (String agentUid : capacityMarkedForDeallocation.getAgentUids()) {
                if (MachinesSlaUtils.getMemoryInMB(shortageCapacity) == 0L) break;
                CapacityRequirements agentCapacity = capacityMarkedForDeallocation.getAgentCapacity(agentUid);
                CapacityRequirements requiredCapacity = agentCapacity.min(shortageCapacity);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Agent " + this.agentToString(agentUid) + " is no longer marked for deallocation in order to maintain capacity."));
                }
                this.unmarkCapacityForDeallocation(sla, agentUid, requiredCapacity);
                shortageCapacity = shortageCapacity.subtract(requiredCapacity);
            }
            if (!shortageCapacity.equalsZero()) {
                this.logger.debug((Object)("Trying to allocate shortage capacity of " + shortageCapacity + " on existing machines."));
                this.allocateManualCapacity(sla, shortageCapacity);
                shortageCapacity = this.getCapacityShortage(sla, target);
            }
            if (!shortageCapacity.equalsZero()) {
                if (!sla.getMachineProvisioning().isStartMachineSupported()) {
                    throw new NeedToStartMoreGridServiceAgentsException(sla, this.state, shortageCapacity, this.pu);
                }
                ExactZonesConfig exactZones = ((ExactZonesConfigurer)new ExactZonesConfigurer().addZones(sla.getGridServiceAgentZones().getZones())).create();
                this.logger.debug((Object)("Shortage capacity of " + shortageCapacity + " still remains. Need to start more machines. Starting a new machine on zone " + exactZones));
                FutureGridServiceAgent[] futureAgents = sla.getMachineProvisioning().startMachinesAsync(shortageCapacity, exactZones, new FailedGridServiceAgent[0], START_AGENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                this.addFutureAgents(sla, futureAgents, shortageCapacity);
                this.logger.info((Object)("One or more new machine(s) is started in order to fill capacity shortage " + shortageCapacity + " for zones " + exactZones + " reservationIds=" + MachinesSlaUtils.reservationIdsToString(futureAgents) + " Allocated machine agents are: " + this.getAllocatedCapacity(sla) + " Pending future machine(s) requests " + this.getNumberOfFutureAgents(sla)));
            }
        } else {
            if (machineShortage > 0) {
                this.logger.info((Object)("Considering to start more machines to reach required minimum number of machines: " + capacityAllocated + " started, " + capacityMarkedForDeallocation + " marked for deallocation, " + sla.getMinimumNumberOfMachines() + " is the required minimum number of machines."));
                machineShortage = this.unmarkAgentsMarkedForDeallocationToSatisfyMinimumNumberOfMachines(sla);
                if (machineShortage > 0) {
                    this.allocateNumberOfMachines(sla, machineShortage);
                    machineShortage = this.getMachineShortageInOrderToReachMinimumNumberOfMachines(sla);
                }
                if (machineShortage > 0) {
                    CapacityRequirements capacityRequirements = new CapacityRequirements(new NumberOfMachinesCapacityRequirement((Integer)machineShortage));
                    if (!sla.getMachineProvisioning().isStartMachineSupported()) {
                        throw new NeedToStartMoreGridServiceAgentsException(sla, this.state, capacityRequirements, this.pu);
                    }
                    ExactZonesConfig exactZones = ((ExactZonesConfigurer)new ExactZonesConfigurer().addZones(sla.getGridServiceAgentZones().getZones())).create();
                    FutureGridServiceAgent[] futureAgents = sla.getMachineProvisioning().startMachinesAsync(capacityRequirements, exactZones, new FailedGridServiceAgent[0], START_AGENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                    this.addFutureAgents(sla, futureAgents, capacityRequirements);
                    this.logger.info((Object)(machineShortage + " new machine(s) is scheduled to be started in order to reach the minimum of " + sla.getMinimumNumberOfMachines() + " machines, for zones " + exactZones + " reservationIds=" + MachinesSlaUtils.reservationIdsToString(futureAgents) + ". Allocated machine agents are: " + this.getAllocatedCapacity(sla)));
                }
                throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit());
            }
            this.logger.debug((Object)("No action required in order to enforce machines sla. target=" + target + "| allocated=" + capacityAllocated.toDetailedString() + "| marked for deallocation=" + capacityMarkedForDeallocation.toDetailedString() + "| #futures=" + this.getNumberOfFutureAgents(sla) + " |#minimumMachines=" + sla.getMinimumNumberOfMachines()));
        }
        if (!this.getCapacityMarkedForDeallocation(sla).equalsZero()) {
            throw new GridServiceAgentSlaEnforcementPendingContainerDeallocationException(this.getProcessingUnit(), this.getCapacityMarkedForDeallocation(sla));
        }
        if (this.getNumberOfFutureAgents(sla) > 0) {
            throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit());
        }
        if (!this.getFutureStoppedMachines(sla).isEmpty()) {
            throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit());
        }
    }

    private FailedGridServiceAgent[] toFailedGridServiceAgents(RecoveringFailedGridServiceAgent[] recoveringFailedAgents) {
        int size = recoveringFailedAgents.length;
        FailedGridServiceAgent[] failedAgents = new FailedGridServiceAgent[size];
        for (int i = 0; i < size; ++i) {
            failedAgents[i] = this.toFailedGridServiceAgent(recoveringFailedAgents[i]);
        }
        return failedAgents;
    }

    private FailedGridServiceAgent toFailedGridServiceAgent(RecoveringFailedGridServiceAgent recoveringFailedAgent) {
        String agentUid = recoveringFailedAgent.getAgentUid();
        int recoveryAttempts = recoveringFailedAgent.getRecoveryAttempts();
        Object agentContext = this.state.getAgentContext(agentUid);
        FailedGridServiceAgent failedGridServiceAgent = new FailedGridServiceAgent(agentUid, agentContext, recoveryAttempts);
        return failedGridServiceAgent;
    }

    private RecoveringFailedGridServiceAgent[] getFailedAgentsNotBeingRecovered(CapacityMachinesSlaPolicy sla) {
        return this.state.getAgentsMarkedAsFailedNotBeingRecovered(this.getKey(sla));
    }

    private Collection<FutureStoppedMachine> getFutureStoppedMachines(CapacityMachinesSlaPolicy sla) {
        return this.state.getMachinesGoingDown(this.getKey(sla));
    }

    private CapacityRequirements getCapacityShortage(CapacityMachinesSlaPolicy sla, CapacityRequirements target) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirements shortageCapacity = target.subtractOrZero(this.getAllocatedCapacity(sla).getTotalAllocatedCapacity());
        for (GridServiceAgentFutures futureAgents : this.getFutureAgents(sla)) {
            CapacityRequirements expectedCapacityRequirements = futureAgents.getExpectedCapacity();
            for (CapacityRequirement shortageCapacityRequirement : shortageCapacity.getRequirements()) {
                CapacityRequirement expectedCapacityRequirement = expectedCapacityRequirements.getRequirement(shortageCapacityRequirement.getType());
                if (shortageCapacityRequirement.equalsZero() || !expectedCapacityRequirement.equalsZero()) continue;
                throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit(), "Cannot determine if more machines need to be started, waiting for relevant " + this.getProcessingUnit() + " machines to start first to offset machine shortage.");
            }
            shortageCapacity = shortageCapacity.subtractOrZero(expectedCapacityRequirements);
        }
        if (!shortageCapacity.equalsZero() && this.isFutureAgentsOfOtherSharedServices(sla)) {
            throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit(), "Cannot determine if more machines need to be started, waiting for other machines from same tenant to start first, to offset machine shortage.");
        }
        return shortageCapacity;
    }

    private int unmarkAgentsMarkedForDeallocationToSatisfyMinimumNumberOfMachines(AbstractMachinesSlaPolicy sla) throws CannotDetermineIfNeedToStartMoreMachinesException {
        int machineShortage = this.getMachineShortageInOrderToReachMinimumNumberOfMachines(sla);
        CapacityRequirementsPerAgent capacityAllocated = this.getAllocatedCapacity(sla);
        CapacityRequirementsPerAgent capacityMarkedForDeallocation = this.getCapacityMarkedForDeallocation(sla);
        if (!capacityMarkedForDeallocation.equalsZero()) {
            for (String agentUid : capacityMarkedForDeallocation.getAgentUids()) {
                if (machineShortage <= 0 || capacityAllocated.getAgentUids().contains(agentUid)) continue;
                CapacityRequirements agentCapacity = capacityMarkedForDeallocation.getAgentCapacity(agentUid);
                this.unmarkCapacityForDeallocation(sla, agentUid, agentCapacity);
                --machineShortage;
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Agent " + this.agentToString(agentUid) + " is no longer marked for deallocation in order to reach the minimum of " + sla.getMinimumNumberOfMachines() + " machines."));
            }
        }
        return machineShortage;
    }

    private int getMachineShortageInOrderToReachMinimumNumberOfMachines(AbstractMachinesSlaPolicy sla) throws CannotDetermineIfNeedToStartMoreMachinesException {
        boolean cannotDetermineExpectedNumberOfMachines = false;
        CapacityRequirementsPerAgent capacityAllocated = this.getAllocatedCapacity(sla);
        int machineShortage = sla.getMinimumNumberOfMachines() - capacityAllocated.getAgentUids().size();
        if (this.getNumberOfFutureAgents(sla) > 0) {
            for (GridServiceAgentFutures future : this.getFutureAgents(sla)) {
                int expectedNumberOfMachines = DefaultMachinesSlaEnforcementEndpoint.numberOfMachines(future.getExpectedCapacity());
                if (expectedNumberOfMachines == 0) {
                    cannotDetermineExpectedNumberOfMachines = true;
                    continue;
                }
                machineShortage -= expectedNumberOfMachines;
            }
        }
        if (machineShortage > 0 && cannotDetermineExpectedNumberOfMachines) {
            throw new CannotDetermineIfNeedToStartMoreMachinesException(this.getProcessingUnit(), machineShortage);
        }
        if (machineShortage < 0) {
            machineShortage = 0;
        }
        return machineShortage;
    }

    private void updateAgentsMarkedForDeallocationState(AbstractMachinesSlaPolicy sla) throws FailedToStopMachineException, FailedToStopGridServiceAgentException {
        CapacityRequirementsPerAgent capacityMarkedForDeallocation = this.getCapacityMarkedForDeallocation(sla);
        for (String agentUid : capacityMarkedForDeallocation.getAgentUids()) {
            GridServiceAgent agent = this.pu.getAdmin().getGridServiceAgents().getAgentByUID(agentUid);
            if (agent == null) {
                this.deallocateAgentCapacity(sla, agentUid);
                this.logger.info((Object)("pu " + this.pu.getName() + " agent " + agentUid + " has shutdown."));
                continue;
            }
            if (MachinesSlaUtils.getMemoryInMB(this.getAllocatedCapacity(sla).getAgentCapacityOrZero(agentUid)) >= sla.getContainerMemoryCapacityInMB()) {
                this.deallocateAgentCapacity(sla, agentUid);
                this.logger.info((Object)("pu " + this.pu.getName() + " is still allocated on agent " + agentUid));
                continue;
            }
            if (MachinesSlaUtils.getNumberOfChildContainersForProcessingUnit(agent, this.pu) != 0) continue;
            if (!sla.isStopMachineSupported()) {
                this.logger.info((Object)("Agent running on machine " + MachinesSlaUtils.getAgentIpAddress(agent) + " is not stopped since scale strategy " + sla.getScaleStrategyName() + " does not support automatic start/stop of machines"));
                this.deallocateAgentCapacity(sla, agentUid);
                continue;
            }
            if (!MachinesSlaUtils.isAgentAutoShutdownEnabled(agent)) {
                this.logger.info((Object)("Agent running on machine " + MachinesSlaUtils.getAgentIpAddress(agent) + " is not stopped since it does not have the auto-shutdown flag"));
                this.deallocateAgentCapacity(sla, agentUid);
                continue;
            }
            if (MachinesSlaUtils.isManagementRunningOnMachine(agent.getMachine())) {
                this.logger.info((Object)("Agent running on machine " + MachinesSlaUtils.getAgentIpAddress(agent) + " is not stopped since it is running management processes."));
                this.deallocateAgentCapacity(sla, agentUid);
                continue;
            }
            if (this.state.isAgentSharedWithOtherProcessingUnits(this.pu, agent.getUid())) {
                this.logger.info((Object)("Agent running on machine " + MachinesSlaUtils.getAgentIpAddress(agent) + " is not stopped since it is shared with other processing units."));
                this.deallocateAgentCapacity(sla, agentUid);
                continue;
            }
            Set<Long> childProcessesIds = MachinesSlaUtils.getChildProcessesIds(agent);
            if (!childProcessesIds.isEmpty()) {
                this.logger.warn((Object)("Agent " + this.agentToString(agentUid) + " cannot be shutdown due to the following child processes: " + childProcessesIds));
                continue;
            }
            this.stopMachine(sla, agent);
        }
        this.cleanMachinesGoingDown(sla);
    }

    private void stopMachine(AbstractMachinesSlaPolicy sla, GridServiceAgent agent) {
        if (!this.isAgentExistsInStoppedMachinesFutures(agent)) {
            this.logger.info((Object)("Agent " + this.agentToString(agent) + " is no longer in use by any processing unit. It is going down!"));
            NonBlockingElasticMachineProvisioning machineProvisioning = sla.getMachineProvisioning();
            FutureStoppedMachine stopMachineFuture = machineProvisioning.stopMachineAsync(agent, STOP_AGENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            this.addFutureStoppedMachine(sla, stopMachineFuture);
        }
    }

    public boolean isAgentExistsInStoppedMachinesFutures(GridServiceAgent agent) {
        Collection<FutureStoppedMachine> machinesGoingDown = this.state.getMachinesGoingDown();
        for (FutureStoppedMachine machineGoingDown : machinesGoingDown) {
            if (!machineGoingDown.getGridServiceAgent().getUid().equals(agent.getUid())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not calling stopMachine for agent with uid = " + agent.getUid() + " because a request was already sent to shut it down"));
            }
            return true;
        }
        return false;
    }

    private void addFutureStoppedMachine(AbstractMachinesSlaPolicy sla, FutureStoppedMachine stopMachineFuture) {
        this.state.addFutureStoppedMachine(this.getKey(sla), stopMachineFuture);
    }

    private void updateRestrictedMachinesState(AbstractMachinesSlaPolicy sla) {
        Map<String, List<String>> restrictedMachines = this.getRestrictedAgentUidsForPuWithReason(sla);
        for (String agentUid : this.getAllocatedCapacity(sla).getAgentUids()) {
            if (!restrictedMachines.containsKey(agentUid)) continue;
            this.logger.info((Object)("Agent " + this.agentToString(agentUid) + " is restricted for pu " + this.pu.getName() + " reason:" + restrictedMachines.get(agentUid)));
            this.markAgentRestrictedForPu(sla, agentUid);
        }
    }

    private void updateFailedMachinesState(AbstractMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException {
        GridServiceAgents agents = this.pu.getAdmin().getGridServiceAgents();
        for (String agentUid : this.getAllocatedCapacity(sla).getAgentUids()) {
            if (agents.getAgentByUID(agentUid) != null) continue;
            if (this.state.isAgentFailoverDisabled(agentUid)) {
                this.logger.debug((Object)("Ignored agent " + this.agentToString(agentUid) + " that was killed since failure detection is disabled."));
                continue;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Agent " + this.agentToString(agentUid) + " was killed unexpectedly."));
            }
            this.markAgentAsFailed(sla, agentUid);
        }
        for (RecoveringFailedGridServiceAgent failedAgent : this.getAgentsMarkedAsFailed(sla)) {
            if (!sla.isUndeploying() && agents.getAgentByUID(failedAgent.getAgentUid()) == null) continue;
            this.logger.debug((Object)("Agent " + this.agentToString(failedAgent.getAgentUid()) + " has recovered."));
            this.unmarkAgentAsFailed(sla, failedAgent);
        }
    }

    private void cleanMachinesGoingDown(AbstractMachinesSlaPolicy sla) throws FailedToStopMachineException, FailedToStopGridServiceAgentException {
        for (FutureStoppedMachine futureStoppedMachine : this.state.getMachinesGoingDown(this.getKey(sla))) {
            GridServiceAgent agent = futureStoppedMachine.getGridServiceAgent();
            Exception exception = null;
            try {
                if (futureStoppedMachine.isDone()) {
                    futureStoppedMachine.get();
                    if (agent.isDiscovered()) {
                        throw new IllegalStateException("Agent [" + agent.getUid() + "] should not be discovered at this point.");
                    }
                    this.removeFutureStoppedMachine(sla, futureStoppedMachine);
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TimeoutException || cause instanceof ElasticMachineProvisioningException || cause instanceof ElasticGridServiceAgentProvisioningException || cause instanceof InterruptedException) {
                    exception = e;
                }
                throw new IllegalStateException("Unexpected Exception from machine provisioning.", cause);
            }
            catch (TimeoutException e) {
                exception = e;
            }
            if (exception == null) continue;
            if (this.logger.isDebugEnabled()) {
                if (agent.isDiscovered()) {
                    this.logger.debug((Object)("Agent [" + agent.getUid() + "] is still discovered. Another processing unit may use it if needed.if not, another attempt to shut it down will be executed."));
                } else {
                    this.logger.debug((Object)("agent [" + agent.getUid() + "] is not discovered. but an error happened while terminating the machine"));
                }
            }
            this.removeFutureStoppedMachine(sla, futureStoppedMachine);
            if (exception.getCause() != null && exception.getCause() instanceof ElasticGridServiceAgentProvisioningException) {
                throw new FailedToStopGridServiceAgentException(this.pu, agent, exception);
            }
            throw new FailedToStopMachineException(this.pu, agent, exception);
        }
    }

    private void removeFutureStoppedMachine(AbstractMachinesSlaPolicy sla, FutureStoppedMachine futureStoppedMachine) {
        this.state.removeFutureStoppedMachine(this.getKey(sla), futureStoppedMachine);
    }

    private void updateFutureAgentsState(AbstractMachinesSlaPolicy sla) throws GridServiceAgentSlaEnforcementInProgressException, MachinesSlaEnforcementInProgressException {
        Collection<GridServiceAgentFutures> doneFutureAgentss = this.getAllDoneFutureAgents(sla);
        Collection<GridServiceAgent> discoveredAgents = sla.getDiscoveredMachinesCache().getDiscoveredAgents();
        for (GridServiceAgentFutures doneFutureAgents : doneFutureAgentss) {
            for (FutureGridServiceAgent doneFutureAgent : doneFutureAgents.getFutureGridServiceAgents()) {
                try {
                    this.validateHealthyAgent(sla, discoveredAgents, doneFutureAgent);
                }
                catch (InconsistentMachineProvisioningException e) {
                    throw e;
                }
                catch (FailedToStartNewMachineException e) {
                    doneFutureAgents.removeFutureAgent(doneFutureAgent);
                    if (sla.isUndeploying()) {
                        this.logger.info((Object)"Ignoring failure to start new machine, since undeploy is in progress", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
                catch (FailedToStartNewGridServiceAgentException e) {
                    doneFutureAgents.removeFutureAgent(doneFutureAgent);
                    if (sla.isUndeploying()) {
                        this.logger.info((Object)"Ignoring failure to start new agent, since undeploy is in progress", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
                catch (UnexpectedShutdownOfNewGridServiceAgentException e) {
                    doneFutureAgents.removeFutureAgent(doneFutureAgent);
                    if (sla.isUndeploying()) {
                        this.logger.info((Object)"Ignoring failure to start new grid service agent, since undeploy is in progress", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
                catch (FailedGridServiceAgentReconnectedException e) {
                    doneFutureAgents.removeFutureAgent(doneFutureAgent);
                    if (sla.isUndeploying()) {
                        this.logger.info((Object)"Ignoring problem with new grid service agent, since undeploy is in progress", (Throwable)e);
                        continue;
                    }
                    this.stopMachine(sla, e.getNewAgent());
                    throw e;
                }
            }
        }
        for (GridServiceAgentFutures doneFutureAgents : doneFutureAgentss) {
            Collection<GridServiceAgent> healthyAgents = doneFutureAgents.getGridServiceAgents();
            if (healthyAgents.size() > 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Agents that were started by machineProvisioning new agents: " + MachinesSlaUtils.agentsToString(healthyAgents) + " provisioned agents:" + MachinesSlaUtils.agentsToString(discoveredAgents)));
                }
                CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacityIncludeNewMachines(sla, healthyAgents);
                if (DefaultMachinesSlaEnforcementEndpoint.numberOfMachines(doneFutureAgents.getExpectedCapacity()) > 0) {
                    this.allocateNumberOfMachines(sla, DefaultMachinesSlaEnforcementEndpoint.numberOfMachines(doneFutureAgents.getExpectedCapacity()), unallocatedCapacity);
                } else if (!doneFutureAgents.getExpectedCapacity().equalsZero()) {
                    this.allocateManualCapacity(sla, doneFutureAgents.getExpectedCapacity(), unallocatedCapacity);
                } else {
                    throw new IllegalStateException("futureAgents expected capacity malformed. doneFutureAgents=" + doneFutureAgents.getExpectedCapacity());
                }
            }
            this.removeSuccesfullyStartedFutureAgents(sla, doneFutureAgents);
            ArrayList<GridServiceAgent> unallocatedAgents = new ArrayList<GridServiceAgent>();
            for (GridServiceAgent newAgent : healthyAgents) {
                String agentUid = newAgent.getUid();
                CapacityRequirements agentCapacity = this.getAllocatedCapacity(sla).getAgentCapacityOrZero(agentUid);
                if (!agentCapacity.equalsZero()) continue;
                unallocatedAgents.add(newAgent);
            }
            if (unallocatedAgents.size() <= 0) continue;
            if (!sla.getMachineProvisioning().isStartMachineSupported()) {
                this.logger.info((Object)("Agents " + MachinesSlaUtils.machinesToString(unallocatedAgents) + " are not needed for pu " + this.pu.getName()));
                continue;
            }
            StartedTooManyMachinesException tooManyMachinesExceptions = new StartedTooManyMachinesException(this.pu, unallocatedAgents);
            this.logger.warn((Object)("Stopping machines " + MachinesSlaUtils.machinesToString(unallocatedAgents) + " Agents provisioned by cloud: " + discoveredAgents), (Throwable)tooManyMachinesExceptions);
            for (GridServiceAgent unallocatedAgent : unallocatedAgents) {
                this.stopMachine(sla, unallocatedAgent);
            }
            throw tooManyMachinesExceptions;
        }
    }

    private CapacityRequirementsPerAgent getUnallocatedCapacityIncludeNewMachines(AbstractMachinesSlaPolicy sla, Collection<GridServiceAgent> newMachines) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacity(sla);
        for (GridServiceAgent newAgent : newMachines) {
            if (unallocatedCapacity.getAgentUids().contains(newAgent.getUid())) {
                throw new IllegalStateException("unallocated capacity cannot contain future agents. unallocatedCapacity=" + unallocatedCapacity + "newAgent.getUid()=" + newAgent.getUid() + "sla.agentZones=" + sla.getGridServiceAgentZones());
            }
            CapacityRequirements newAgentCapacity = MachinesSlaUtils.getMachineTotalCapacity(newAgent, sla);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Agent started and provisioned successfully on a new machine " + this.agentToString(newAgent) + " has " + newAgentCapacity));
            }
            unallocatedCapacity = unallocatedCapacity.add(newAgent.getUid(), newAgentCapacity);
        }
        return unallocatedCapacity;
    }

    private void validateHealthyAgent(AbstractMachinesSlaPolicy sla, Collection<GridServiceAgent> discoveredAgents, FutureGridServiceAgent futureAgent) throws UnexpectedShutdownOfNewGridServiceAgentException, InconsistentMachineProvisioningException, FailedToStartNewGridServiceAgentException, FailedToStartNewMachineException, ExpectedMachineWithMoreMemoryException, FailedGridServiceAgentReconnectedException {
        GridServiceAgent reconnectedFailedAgent;
        NonBlockingElasticMachineProvisioning machineProvisioning = sla.getMachineProvisioning();
        Collection<String> usedAgentUids = this.state.getAllUsedAgentUids();
        Collection<String> usedAgentUidsForPu = this.state.getUsedAgentUids(this.getKey(sla));
        StartedGridServiceAgent newStartedAgent = null;
        Exception exception = null;
        try {
            newStartedAgent = (StartedGridServiceAgent)futureAgent.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException || cause instanceof ElasticMachineProvisioningException || cause instanceof ElasticGridServiceAgentProvisioningException || cause instanceof InterruptedException) {
                exception = e;
            }
            throw new IllegalStateException("Unexpected Exception from machine provisioning.", e);
        }
        catch (TimeoutException e) {
            exception = e;
        }
        if (exception != null) {
            if (exception.getCause() != null && exception.getCause() instanceof ElasticGridServiceAgentProvisioningException) {
                throw new FailedToStartNewGridServiceAgentException(this.pu, exception);
            }
            throw new FailedToStartNewMachineException(this.pu, exception);
        }
        if (newStartedAgent == null) {
            throw new IllegalStateException("Machine provisioning future is done without exception, but returned null.");
        }
        GridServiceAgent newAgent = newStartedAgent.getAgent();
        if (newAgent == null) {
            throw new IllegalStateException("Machine provisioning future is done without exception, but returned a null agent.");
        }
        GSAReservationId actualReservationId = ((InternalGridServiceAgent)newAgent).getReservationId();
        if (actualReservationId == null) {
            throw new IllegalStateException("Machine provisioning future is done without exception, but returned a null reservationId from the agent");
        }
        GSAReservationId expectedReservationId = futureAgent.getReservationId();
        if (!actualReservationId.equals(expectedReservationId)) {
            throw new IllegalStateException("Machine provisioning future is done without exception, but returned an agent " + this.agentToString(newAgent) + "with the wrong reservationId: expected=" + expectedReservationId + " actual=" + actualReservationId);
        }
        if (!newAgent.isDiscovered()) {
            UnexpectedShutdownOfNewGridServiceAgentException unexpectedShutdownException = new UnexpectedShutdownOfNewGridServiceAgentException(newAgent.getMachine(), this.pu);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Failed to start agent on new machine.", (Throwable)unexpectedShutdownException);
            }
            throw unexpectedShutdownException;
        }
        if (usedAgentUidsForPu.contains(newAgent.getUid())) {
            throw new IllegalStateException("Machine provisioning for " + this.pu.getName() + " has provided the agent " + this.agentToString(newAgent) + " which is already in use by this PU.The machine is ignored");
        }
        if (usedAgentUids.contains(newAgent.getUid())) {
            throw new IllegalStateException("Machine provisioning for " + this.pu.getName() + " has provided the agent " + this.agentToString(newAgent) + " which is already in use by another PU.This machine is ignored");
        }
        if (!discoveredAgents.contains(newAgent)) {
            NonBlockingElasticMachineProvisioning oldMachineProvisioning = futureAgent.getMachineProvisioning();
            if (oldMachineProvisioning != null && !MachinesSlaUtils.isAgentConformsToMachineProvisioningConfig(newAgent, oldMachineProvisioning.getConfig()) && oldMachineProvisioning == machineProvisioning) {
                throw new IllegalStateException(this.agentToString(newAgent) + " has been started but with the wrong zone or management settings. newagent.zones=" + newAgent.getExactZones() + " oldMachineProvisioning.config.zones=" + oldMachineProvisioning.getConfig().getGridServiceAgentZones());
            }
            throw new InconsistentMachineProvisioningException(this.getProcessingUnit(), newAgent);
        }
        if (sla.isUndeploying()) {
            this.logger.info((Object)("Not performing memory validation on agent " + newAgent.getUid() + " since undeploy is in progress"));
        } else {
            this.validateMemory(sla, newAgent);
        }
        FailedGridServiceAgent failedAgent = futureAgent.getFailedGridServiceAgent();
        if (failedAgent != null && (reconnectedFailedAgent = this.isFailedAgentDiscovered(discoveredAgents, failedAgent)) != null) {
            throw new FailedGridServiceAgentReconnectedException(this.pu, newAgent, failedAgent, reconnectedFailedAgent);
        }
    }

    private void validateMemory(AbstractMachinesSlaPolicy sla, GridServiceAgent newAgent) throws ExpectedMachineWithMoreMemoryException {
        long containerMB;
        long reservedMB = MachinesSlaUtils.getMemoryInMB(MachinesSlaUtils.getReservedCapacity(sla, newAgent));
        long totalMB = MachinesSlaUtils.getMemoryInMB(MachinesSlaUtils.getMachineCapacity(newAgent));
        long availableMB = totalMB - reservedMB;
        if (availableMB < (containerMB = sla.getContainerMemoryCapacityInMB())) {
            throw new ExpectedMachineWithMoreMemoryException(this.pu, newAgent.getMachine(), totalMB, reservedMB, containerMB);
        }
    }

    private GridServiceAgent isFailedAgentDiscovered(Collection<GridServiceAgent> discoveredAgents, FailedGridServiceAgent failedAgent) {
        for (GridServiceAgent discoveredAgent : discoveredAgents) {
            if (!discoveredAgent.getUid().equals(failedAgent.getAgentUid())) continue;
            return discoveredAgent;
        }
        return null;
    }

    private void allocateEagerCapacity(AbstractMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException {
        long allocatedMemoryForPuAfter;
        CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacity(sla);
        long maxAllocatedMemoryForPu = (long)this.getMaximumNumberOfMachines(sla) * sla.getContainerMemoryCapacityInMB();
        long allocatedMemoryForPu = MachinesSlaUtils.getMemoryInMB(this.getAllocatedCapacity(sla).getTotalAllocatedCapacity());
        if (allocatedMemoryForPu > maxAllocatedMemoryForPu) {
            throw new IllegalStateException("maxAllocatedMemoryForPu=" + this.getMaximumNumberOfMachines(sla) + "*" + sla.getContainerMemoryCapacityInMB() + "=" + maxAllocatedMemoryForPu + " cannot be smaller than allocatedMemoryForPu=" + this.getAllocatedCapacity(sla).toDetailedString());
        }
        long unallocatedMemory = MachinesSlaUtils.getMemoryInMB(unallocatedCapacity.getTotalAllocatedCapacity());
        long memoryToAllocate = Math.min(maxAllocatedMemoryForPu - allocatedMemoryForPu, unallocatedMemory);
        CapacityRequirements capacityToAllocate = unallocatedCapacity.getTotalAllocatedCapacity().set(new MemoryCapacityRequirement((Long)memoryToAllocate));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("capacityToAllocate=" + capacityToAllocate + " maxAllocatedMemoryForPu=" + maxAllocatedMemoryForPu + " unallocatedCapacity=" + unallocatedCapacity.toDetailedString()));
        }
        if (!capacityToAllocate.equalsZero()) {
            this.allocateManualCapacity(sla, capacityToAllocate, unallocatedCapacity);
        }
        if ((allocatedMemoryForPuAfter = MachinesSlaUtils.getMemoryInMB(this.getAllocatedCapacity(sla).getTotalAllocatedCapacity())) > maxAllocatedMemoryForPu) {
            throw new IllegalStateException("allocatedMemoryForPuAfter=" + allocatedMemoryForPuAfter + " greater than maxAllocatedMemoryForPu=" + this.getMaximumNumberOfMachines(sla) + "*" + sla.getContainerMemoryCapacityInMB() + "=" + maxAllocatedMemoryForPu + "allocatedMemoryForPu=" + allocatedMemoryForPu + "=" + this.getAllocatedCapacity(sla).toDetailedString() + " capacityToAllocate=" + capacityToAllocate + " maxAllocatedMemoryForPu=" + maxAllocatedMemoryForPu + " unallocatedCapacity=" + unallocatedCapacity.toDetailedString());
        }
    }

    private void allocateManualCapacity(AbstractMachinesSlaPolicy sla, CapacityRequirements capacityToAllocate) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacity(sla);
        this.allocateManualCapacity(sla, capacityToAllocate, unallocatedCapacity);
    }

    private void allocateManualCapacity(AbstractMachinesSlaPolicy sla, CapacityRequirements capacityToAllocate, CapacityRequirementsPerAgent unallocatedCapacity) {
        BinPackingSolver solver = this.createBinPackingSolver(sla, unallocatedCapacity);
        solver.solveManualCapacityScaleOut(capacityToAllocate);
        this.allocateCapacity(sla, solver.getAllocatedCapacityResult());
        this.markCapacityForDeallocation(sla, solver.getDeallocatedCapacityResult());
    }

    private void deallocateManualCapacity(AbstractMachinesSlaPolicy sla, CapacityRequirements capacityToDeallocate) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacity(sla);
        BinPackingSolver solver = this.createBinPackingSolver(sla, unallocatedCapacity);
        solver.solveManualCapacityScaleIn(capacityToDeallocate);
        this.allocateCapacity(sla, solver.getAllocatedCapacityResult());
        this.markCapacityForDeallocation(sla, solver.getDeallocatedCapacityResult());
    }

    private void allocateNumberOfMachines(AbstractMachinesSlaPolicy sla, int numberOfFreeAgents) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent unallocatedCapacity = this.getUnallocatedCapacity(sla);
        this.allocateNumberOfMachines(sla, numberOfFreeAgents, unallocatedCapacity);
    }

    private void allocateNumberOfMachines(AbstractMachinesSlaPolicy sla, int numberOfMachines, CapacityRequirementsPerAgent unallocatedCapacity) {
        BinPackingSolver solver = this.createBinPackingSolver(sla, unallocatedCapacity);
        solver.solveNumberOfMachines(numberOfMachines);
        this.allocateCapacity(sla, solver.getAllocatedCapacityResult());
        this.markCapacityForDeallocation(sla, solver.getDeallocatedCapacityResult());
    }

    private BinPackingSolver createBinPackingSolver(AbstractMachinesSlaPolicy sla, CapacityRequirementsPerAgent unallocatedCapacity) {
        this.logger.debug((Object)"Creating BinPackingSolver");
        BinPackingSolver solver = new BinPackingSolver();
        solver.setLogger(this.logger);
        solver.setAllowMoreThanAverageMemoryPerMachine(sla.isAllowAboveAverageMemoryPerMachine());
        solver.setContainerMemoryCapacityInMB(sla.getContainerMemoryCapacityInMB());
        solver.setUnallocatedCapacity(unallocatedCapacity);
        solver.setAllocatedCapacityForPu(this.getAllocatedCapacity(sla));
        solver.setMaxAllocatedMemoryCapacityOfPuInMB((long)this.getMaximumNumberOfMachines(sla) * sla.getContainerMemoryCapacityInMB());
        solver.setMaxAllocatedMemoryCapacityOfPuPerMachineInMB((long)sla.getMaximumNumberOfContainersPerMachine() * sla.getContainerMemoryCapacityInMB());
        solver.setMinimumNumberOfMachines(sla.getMinimumNumberOfMachines());
        HashMap<String, Long> scaleInPriorityPerAgentUid = new HashMap<String, Long>();
        GridServiceAgents agents = this.pu.getAdmin().getGridServiceAgents();
        long FIRST_PRIORITY = Long.MAX_VALUE;
        long SECOND_PRIORITY = 0x7FFFFFFFFFFFFFFEL;
        long THIRD_PRIORITY = 0x7FFFFFFFFFFFFFFDL;
        long FOURTH_PRIORITY = 0x7FFFFFFFFFFFFFFCL;
        long now = System.currentTimeMillis();
        for (String agentUid : this.getAllocatedCapacity(sla).getAgentUids()) {
            long agentOrderToDeallocateContainers = 0L;
            GridServiceAgent agent = agents.getAgentByUID(agentUid);
            if (agent != null) {
                if (MachinesSlaUtils.isManagementRunningOnMachine(agent.getMachine())) {
                    agentOrderToDeallocateContainers = Long.MAX_VALUE;
                } else if (this.state.isAgentSharedWithOtherProcessingUnits(this.pu, agentUid)) {
                    agentOrderToDeallocateContainers = 0x7FFFFFFFFFFFFFFEL;
                } else if (!MachinesSlaUtils.isAgentAutoShutdownEnabled(agent)) {
                    agentOrderToDeallocateContainers = 0x7FFFFFFFFFFFFFFDL;
                } else {
                    long startTime = agent.getVirtualMachine().getDetails().getStartTime();
                    long runDuration = now - startTime;
                    if (runDuration > 0x7FFFFFFFFFFFFFFCL) {
                        runDuration = 0x7FFFFFFFFFFFFFFCL;
                    }
                    agentOrderToDeallocateContainers = runDuration;
                }
            }
            scaleInPriorityPerAgentUid.put(agentUid, agentOrderToDeallocateContainers);
        }
        solver.setAgentAllocationPriority(scaleInPriorityPerAgentUid);
        this.logger.debug((Object)("BinPackingSolver created : " + solver));
        return solver;
    }

    private CapacityRequirementsPerAgent getUnallocatedCapacity(AbstractMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent physicalCapacity = this.getPhysicalProvisionedCapacity(sla);
        CapacityRequirementsPerAgent usedCapacity = this.state.getAllUsedCapacity();
        Map<String, List<String>> restrictedAgentUids = this.getRestrictedAgentUidsForPuWithReason(sla);
        CapacityRequirementsPerAgent unallocatedCapacity = new CapacityRequirementsPerAgent();
        boolean isNotDedicatedMachineProvisioning = sla.getMachineIsolation().getClass().isAssignableFrom(SharedMachineIsolation.class) || sla.getMachineIsolation().getClass().isAssignableFrom(PublicMachineIsolation.class);
        boolean shareCPUAmongEPUs = isNotDedicatedMachineProvisioning && Boolean.valueOf(System.getProperty("org.openspaces.grid.esm.shareCPUAmongEPUs", "true")) != false;
        CapacityRequirementType<CpuCapacityRequirement> cpuCapacityRequirementType = null;
        CapacityRequirementsPerAgent allocatedCapacityForPU = null;
        if (shareCPUAmongEPUs) {
            allocatedCapacityForPU = this.state.getAllocatedCapacity(this.pu);
            cpuCapacityRequirementType = new CpuCapacityRequirement().getType();
        }
        for (String agentUid : physicalCapacity.getAgentUids()) {
            if (restrictedAgentUids.containsKey(agentUid)) continue;
            CapacityRequirements unallocatedCapacityOnAgent = physicalCapacity.getAgentCapacity(agentUid).subtractOrZero(usedCapacity.getAgentCapacityOrZero(agentUid));
            if (shareCPUAmongEPUs) {
                unallocatedCapacityOnAgent = unallocatedCapacityOnAgent.subtractOrZero(unallocatedCapacityOnAgent.getRequirement(cpuCapacityRequirementType));
                Fraction physicalCPUOnAgent = physicalCapacity.getAgentCapacity(agentUid).getRequirement(cpuCapacityRequirementType).getCpu();
                Fraction allocatedCPUForPUOnAgent = allocatedCapacityForPU.getAgentCapacityOrZero(agentUid).getRequirement(cpuCapacityRequirementType).getCpu();
                CpuCapacityRequirement unallocatedCPUCapacityOnAgent = new CpuCapacityRequirement(physicalCPUOnAgent.subtract(allocatedCPUForPUOnAgent));
                unallocatedCapacityOnAgent = unallocatedCapacityOnAgent.set(unallocatedCPUCapacityOnAgent);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("agentUid=" + agentUid + ", unallocatedCPUCapacityOnAgent = (physicalCPUOnAgent - allocatedCPUForPUOnAgent) = (" + physicalCPUOnAgent + " - " + allocatedCPUForPUOnAgent + ") = " + unallocatedCPUCapacityOnAgent.getCpu()));
                }
            }
            unallocatedCapacity = unallocatedCapacity.add(agentUid, unallocatedCapacityOnAgent);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("shareCPUAmongEPUs=" + shareCPUAmongEPUs + ", machineIsolationClass=" + sla.getMachineIsolation().getClass().getName()));
            this.logger.debug((Object)("unallocatedCapacity=" + unallocatedCapacity.toDetailedString()));
        }
        return unallocatedCapacity;
    }

    private CapacityRequirementsPerAgent getPhysicalProvisionedCapacity(AbstractMachinesSlaPolicy sla) throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerAgent totalCapacity = new CapacityRequirementsPerAgent();
        for (GridServiceAgent agent : sla.getDiscoveredMachinesCache().getDiscoveredAgents()) {
            if (!agent.isDiscovered()) continue;
            totalCapacity = totalCapacity.add(agent.getUid(), MachinesSlaUtils.getMachineTotalCapacity(agent, sla));
        }
        return totalCapacity;
    }

    private static int numberOfMachines(CapacityRequirements capacityRequirements) {
        return capacityRequirements.getRequirement(new NumberOfMachinesCapacityRequirement().getType()).getNumberOfMachines();
    }

    private CapacityRequirementsPerAgent getCapacityMarkedForDeallocation(AbstractMachinesSlaPolicy sla) {
        return this.state.getCapacityMarkedForDeallocation(this.getKey(sla));
    }

    private Map<String, List<String>> getRestrictedAgentUidsForPuWithReason(AbstractMachinesSlaPolicy sla) {
        return this.state.getRestrictedAgentUids(this.getKey(sla));
    }

    private void setMachineIsolation(AbstractMachinesSlaPolicy sla) {
        this.state.setMachineIsolation(this.getKey(sla), sla.getMachineIsolation());
    }

    private int getNumberOfFutureAgents(AbstractMachinesSlaPolicy sla) {
        return this.state.getNumberOfFutureAgents(this.getKey(sla));
    }

    private void addFutureAgents(CapacityMachinesSlaPolicy sla, FutureGridServiceAgent[] futureAgents, CapacityRequirements shortageCapacity) {
        this.state.addFutureAgents(this.getKey(sla), futureAgents, shortageCapacity);
    }

    private Collection<GridServiceAgentFutures> getFutureAgents(AbstractMachinesSlaPolicy sla) {
        return this.state.getFutureAgents(this.getKey(sla));
    }

    private boolean isFutureAgentsOfOtherSharedServices(AbstractMachinesSlaPolicy sla) {
        return this.state.isFutureAgentsOfOtherSharedServices(this.getKey(sla));
    }

    private void unmarkCapacityForDeallocation(AbstractMachinesSlaPolicy sla, String agentUid, CapacityRequirements agentCapacity) {
        this.state.unmarkCapacityForDeallocation(this.getKey(sla), agentUid, agentCapacity);
    }

    private void deallocateAgentCapacity(AbstractMachinesSlaPolicy sla, String agentUid) {
        this.state.deallocateAgentCapacity(this.getKey(sla), agentUid);
    }

    private void markAgentAsFailed(AbstractMachinesSlaPolicy sla, String agentUid) {
        this.state.markAgentAsFailed(this.getKey(sla), agentUid);
    }

    private void markAgentRestrictedForPu(AbstractMachinesSlaPolicy sla, String agentUid) {
        this.state.markAgentRestrictedForPu(this.getKey(sla), agentUid);
    }

    private void unmarkAgentAsFailed(AbstractMachinesSlaPolicy sla, RecoveringFailedGridServiceAgent failedAgent) {
        this.state.unmarkAgentAsFailed(this.getKey(sla), failedAgent.getAgentUid());
    }

    private RecoveringFailedGridServiceAgent[] getAgentsMarkedAsFailed(AbstractMachinesSlaPolicy sla) {
        return this.state.getAgentsMarkedAsFailed(this.getKey(sla));
    }

    private Collection<GridServiceAgentFutures> getAllDoneFutureAgents(AbstractMachinesSlaPolicy sla) {
        return this.state.getAllDoneFutureAgents(this.getKey(sla));
    }

    private void removeSuccesfullyStartedFutureAgents(AbstractMachinesSlaPolicy sla, GridServiceAgentFutures doneFutureAgents) {
        this.state.removeSuccesfullyStartedFutureAgents(this.getKey(sla), doneFutureAgents);
    }

    private void allocateCapacity(AbstractMachinesSlaPolicy sla, CapacityRequirementsPerAgent capacityToAllocate) {
        for (String agentUid : capacityToAllocate.getAgentUids()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("allocating capacity " + capacityToAllocate.getAgentCapacity(agentUid) + " on " + this.agentToString(agentUid) + " for " + this.pu.getName() + " " + sla.getGridServiceAgentZones()));
            }
            this.state.allocateCapacity(this.getKey(sla), agentUid, capacityToAllocate.getAgentCapacity(agentUid));
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("allocated capacity " + capacityToAllocate.getAgentCapacity(agentUid) + " on " + this.agentToString(agentUid) + " for " + this.pu.getName() + " " + sla.getGridServiceAgentZones()));
        }
    }

    private void markCapacityForDeallocation(AbstractMachinesSlaPolicy sla, CapacityRequirementsPerAgent capacityToMarkForDeallocation) {
        for (String agentUid : capacityToMarkForDeallocation.getAgentUids()) {
            this.state.markCapacityForDeallocation(this.getKey(sla), agentUid, capacityToMarkForDeallocation.getAgentCapacity(agentUid));
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("marking capacity for deallocation " + capacityToMarkForDeallocation.getAgentCapacity(agentUid) + " on " + this.agentToString(agentUid)));
        }
    }

    private void completedStateRecovery(AbstractMachinesSlaPolicy sla) {
        this.state.completedStateRecovery(this.getKey(sla));
    }

    private boolean isCompletedStateRecovery(AbstractMachinesSlaPolicy sla) {
        return this.state.isCompletedStateRecovery(this.getKey(sla));
    }

    @Override
    public void recoveredStateOnEsmStart(ProcessingUnit otherPu) {
        this.state.recoveredStateOnEsmStart(otherPu);
    }

    @Override
    public MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit otherPu) {
        return this.state.getRecoveredStateOnEsmStart(otherPu);
    }

    @Override
    public Set<ZonesConfig> getGridServiceAgentsZones() {
        return this.state.getGridServiceAgentsZones(this.pu);
    }

    @Override
    public Set<ZonesConfig> getUndeployedGridServiceAgentsZones() {
        return this.state.getUndeployedGridServiceAgentsZones(this.pu);
    }

    @Override
    public boolean replaceAllocatedCapacity(AbstractMachinesSlaPolicy sla) {
        return this.state.replaceAllocatedCapacity(this.getKey(sla), this.pu.getAdmin());
    }

    @Override
    public void beforeUndeployedProcessingUnit(ProcessingUnit pu) {
        this.state.beforeUndeployProcessingUnit(pu);
    }

    @Override
    public void afterUndeployedProcessingUnit(ProcessingUnit pu) {
        this.state.afterUndeployProcessingUnit(pu);
    }

    @Override
    public void cleanupCloud(ProcessingUnit pu, NonBlockingElasticMachineProvisioning machineProvisioning) throws MachinesSlaEnforcementInProgressException {
        FutureCleanupCloudResources future;
        if (this.state.getCleanupFuture(pu) == null) {
            future = machineProvisioning.cleanupCloudResources(CLEANUP_CLOUD_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            this.state.setCleanupFuture(pu, future);
        }
        if (!(future = this.state.getCleanupFuture(pu)).isDone()) {
            throw new MachinesSlaEnforcementInProgressException(this.getProcessingUnit(), "Cloud cleanup is in progress");
        }
        Exception exception = null;
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException || cause instanceof ElasticMachineProvisioningException || cause instanceof InterruptedException) {
                exception = e;
            }
            throw new IllegalStateException("Unexpected Exception from machine provisioning.", e);
        }
        catch (TimeoutException e) {
            exception = e;
        }
        if (exception != null && !future.isMarked()) {
            future.mark();
            throw new CloudCleanupFailedException(pu, exception);
        }
    }

    private String agentToString(String agentUid) {
        return MachinesSlaUtils.agentToString(this.pu.getAdmin(), agentUid);
    }

    private String agentToString(GridServiceAgent agent) {
        return MachinesSlaUtils.agentToString(agent);
    }
}

