/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgent;
import org.openspaces.grid.gsm.machines.StartedGridServiceAgent;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;

class GridServiceAgentFutures {
    Collection<FutureGridServiceAgent> futureAgents;
    CapacityRequirements expectedCapacity = new CapacityRequirements(new CapacityRequirement[0]);

    GridServiceAgentFutures(FutureGridServiceAgent[] futureAgents, CapacityRequirements capacityRequirements) {
        GridServiceAgentFutures.validate(futureAgents);
        if (capacityRequirements.equalsZero()) {
            throw new IllegalArgumentException("capacityRequirements cannot be empty");
        }
        this.futureAgents = new ArrayList<FutureGridServiceAgent>(Arrays.asList(futureAgents));
        this.expectedCapacity = capacityRequirements;
    }

    CapacityRequirements getExpectedCapacity() {
        return this.expectedCapacity;
    }

    public Collection<GSAReservationId> getReservationIds() {
        HashSet<GSAReservationId> reservationIds = new HashSet<GSAReservationId>();
        for (FutureGridServiceAgent futureAgent : this.futureAgents) {
            reservationIds.add(futureAgent.getReservationId());
        }
        return reservationIds;
    }

    public Collection<GridServiceAgent> getGridServiceAgents() {
        HashSet<GridServiceAgent> agents = new HashSet<GridServiceAgent>();
        for (FutureGridServiceAgent futureAgent : this.futureAgents) {
            if (!futureAgent.isDone() || futureAgent.getException() != null) continue;
            try {
                agents.add(((StartedGridServiceAgent)futureAgent.get()).getAgent());
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {}
        }
        return agents;
    }

    public boolean isDone() {
        for (FutureGridServiceAgent futureAgent : this.futureAgents) {
            if (futureAgent.isDone()) continue;
            return false;
        }
        return true;
    }

    public Collection<FutureGridServiceAgent> getFutureGridServiceAgents() {
        return Collections.unmodifiableCollection(new ArrayList<FutureGridServiceAgent>(this.futureAgents));
    }

    public void removeFutureAgent(FutureGridServiceAgent futureAgent) {
        if (!this.futureAgents.contains(futureAgent)) {
            throw new IllegalStateException("futureAgent does not exist");
        }
        this.futureAgents.remove(futureAgent);
    }

    private static void validate(FutureGridServiceAgent[] futureAgents) {
        if (futureAgents == null) {
            throw new IllegalArgumentException("future agents cannot be null");
        }
        if (futureAgents.length == 0) {
            throw new IllegalArgumentException("future agents cannot be empty");
        }
        NonBlockingElasticMachineProvisioning machineProvisioning = null;
        for (FutureGridServiceAgent futureAgent : futureAgents) {
            if (machineProvisioning == null) {
                machineProvisioning = futureAgent.getMachineProvisioning();
            }
            if (futureAgent.getMachineProvisioning() == machineProvisioning) continue;
            throw new IllegalArgumentException("All future agents must origin from the same machine provisioning object");
        }
    }

    public NonBlockingElasticMachineProvisioning getMachineProvisioning() {
        return this.futureAgents.iterator().next().getMachineProvisioning();
    }
}

