/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.DefaultMachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementEnforcement;
import org.openspaces.grid.gsm.sla.exceptions.ServiceLevelAgreementEnforcementEndpointAlreadyExistsException;

public class MachinesSlaEnforcement
implements ServiceLevelAgreementEnforcement<MachinesSlaEnforcementEndpoint> {
    private final MachinesSlaEnforcementState state;
    private final Map<ProcessingUnit, MachinesSlaEnforcementEndpoint> endpoints = new HashMap<ProcessingUnit, MachinesSlaEnforcementEndpoint>();

    public MachinesSlaEnforcement(MachinesSlaEnforcementState state) {
        this.state = state;
    }

    @Override
    public MachinesSlaEnforcementEndpoint createEndpoint(ProcessingUnit pu) throws ServiceLevelAgreementEnforcementEndpointAlreadyExistsException {
        if (!this.isEndpointDestroyed(pu)) {
            throw new ServiceLevelAgreementEnforcementEndpointAlreadyExistsException();
        }
        DefaultMachinesSlaEnforcementEndpoint endpoint = new DefaultMachinesSlaEnforcementEndpoint(pu, this.state);
        this.endpoints.put(pu, endpoint);
        return endpoint;
    }

    @Override
    public void destroyEndpoint(ProcessingUnit pu) {
        this.endpoints.remove(pu);
    }

    public void destroy() throws Exception {
        for (ProcessingUnit pu : this.endpoints.keySet()) {
            this.destroyEndpoint(pu);
        }
    }

    private boolean isEndpointDestroyed(ProcessingUnit pu) {
        return this.endpoints.get(pu) == null;
    }

    public void failedRecoveredStateOnEsmStart(ProcessingUnit pu) {
        this.state.failedRecoveredStateOnEsmStart(pu);
    }
}

