/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.zone.config.ZonesConfigUtils;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.RequiredZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.machines.FailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureCleanupCloudResources;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureStoppedMachine;
import org.openspaces.grid.gsm.machines.GridServiceAgentFutures;
import org.openspaces.grid.gsm.machines.RecoveringFailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.StartedGridServiceAgent;
import org.openspaces.grid.gsm.machines.backup.MachinesState;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolation;
import org.openspaces.grid.gsm.machines.isolation.PublicMachineIsolation;

public class MachinesSlaEnforcementState {
    private final Log logger = new SingleThreadedPollingLog(LogFactory.getLog(MachinesSlaEnforcementState.class));
    private final Map<StateKey, StateValue> state = new HashMap<StateKey, StateValue>();
    private final Map<ProcessingUnit, RecoveryState> recoveredStatePerProcessingUnit = new HashMap<ProcessingUnit, RecoveryState>();
    private final Set<ProcessingUnit> validatedUndeployNotInProgressPerProcessingUnit = new HashSet<ProcessingUnit>();
    private final Map<ProcessingUnit, FutureCleanupCloudResources> cloudCleanupPerProcessingUnit = new HashMap<ProcessingUnit, FutureCleanupCloudResources>();
    private final Map<String, String> agentWithFailoverDisabledPerIpAddress = new HashMap<String, String>();
    private final Map<String, Object> agentsContext = new LinkedHashMap<String, Object>();
    private long machinesStateVersion = 0L;

    public boolean isHoldingStateForProcessingUnit(ProcessingUnit pu) {
        return !this.getGridServiceAgentsZones(pu).isEmpty();
    }

    private StateValue getState(StateKey key) {
        if (!this.state.containsKey(key)) {
            this.state.put(key, new StateValue());
        }
        return this.state.get(key);
    }

    public void addFutureAgents(StateKey key, FutureGridServiceAgent[] futureAgents, CapacityRequirements capacityRequirements) {
        this.getState(key).addFutureAgents(futureAgents, capacityRequirements);
    }

    public void allocateCapacity(StateKey key, String agentUid, CapacityRequirements capacity) {
        this.getState(key).allocateCapacity(agentUid, capacity);
    }

    public void markCapacityForDeallocation(StateKey key, String agentUid, CapacityRequirements capacity) {
        this.getState(key).markCapacityForDeallocation(agentUid, capacity);
    }

    public void unmarkCapacityForDeallocation(StateKey key, String agentUid, CapacityRequirements capacity) {
        this.getState(key).unmarkCapacityForDeallocation(agentUid, capacity);
    }

    public void deallocateCapacity(StateKey key, String agentUid, CapacityRequirements capacity) {
        this.getState(key).deallocateCapacity(agentUid, capacity);
    }

    public CapacityRequirementsPerAgent getCapacityMarkedForDeallocation(StateKey key) {
        return this.getState(key).markedForDeallocationCapacity;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacity(StateKey key) {
        return this.getState(key).allocatedCapacity;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacityOfOtherKeysFromSamePu(StateKey key) {
        CapacityRequirementsPerAgent capacityRequirementsPerAgent = new CapacityRequirementsPerAgent();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            StateKey otherKey = pair.getKey();
            if (!otherKey.pu.equals(key.pu) || otherKey.gridServiceAgentZones.equals(key.gridServiceAgentZones)) continue;
            CapacityRequirementsPerAgent otherAllocatedCapacity = this.getAllocatedCapacity(otherKey);
            capacityRequirementsPerAgent = capacityRequirementsPerAgent.add(otherAllocatedCapacity);
        }
        return capacityRequirementsPerAgent;
    }

    public int getNumberOfFutureAgents(StateKey key) {
        return this.getState(key).futureAgents.size();
    }

    public Collection<GridServiceAgentFutures> getFutureAgents(StateKey key) {
        return Collections.unmodifiableCollection(this.getState(key).futureAgents);
    }

    public Collection<GridServiceAgentFutures> getAllDoneFutureAgents(StateKey key) {
        return this.getState(key).getAllDoneFutureAgents();
    }

    public Collection<String> getAllUsedAgentUids() {
        return this.getAllUsedCapacity().getAgentUids();
    }

    public CapacityRequirementsPerAgent getAllUsedCapacity() {
        CapacityRequirementsPerAgent allUsedCapacity = new CapacityRequirementsPerAgent();
        for (StateKey key : this.state.keySet()) {
            allUsedCapacity = allUsedCapacity.add(this.getAllUsedCapacity(key));
        }
        return allUsedCapacity;
    }

    private CapacityRequirementsPerAgent getAllUsedCapacity(StateKey key) {
        StateValue value = this.getState(key);
        return value.allocatedCapacity.add(value.markedForDeallocationCapacity);
    }

    public boolean isAgentSharedWithOtherProcessingUnits(ProcessingUnit pu, String agentUid) {
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            StateValue value;
            if (pair.getKey().pu.equals(pu) || (value = pair.getValue()).allocatedCapacity.getAgentCapacityOrZero(agentUid).equalsZero() && value.markedForDeallocationCapacity.getAgentCapacityOrZero(agentUid).equalsZero()) continue;
            return true;
        }
        return false;
    }

    public Collection<FutureStoppedMachine> getMachinesGoingDown(StateKey key) {
        return this.getState(key).getMachineGoingDown();
    }

    public void markAgentAsFailed(StateKey key, String agentUid) {
        this.markAgentCapacityForDeallocation(key, agentUid);
        this.addFailedAgent(key, agentUid);
    }

    public void markAgentRestrictedForPu(StateKey key, String agentUid) {
        this.markAgentCapacityForDeallocation(key, agentUid);
    }

    private void markAgentCapacityForDeallocation(StateKey key, String uid) {
        CapacityRequirements agentCapacity = this.getAllocatedCapacity(key).getAgentCapacity(uid);
        this.markCapacityForDeallocation(key, uid, agentCapacity);
    }

    public void deallocateAgentCapacity(StateKey key, String agentUid) {
        CapacityRequirements agentCapacity = this.getCapacityMarkedForDeallocation(key).getAgentCapacity(agentUid);
        this.deallocateCapacity(key, agentUid, agentCapacity);
    }

    public Map<String, List<String>> getRestrictedAgentUids(StateKey key) {
        Admin admin = key.pu.getAdmin();
        ElasticProcessingUnitMachineIsolation puIsolation = this.getState(key).machineIsolation;
        HashMap<String, List<String>> restrictedAgentUidsWithReason = new HashMap<String, List<String>>();
        if (!(puIsolation instanceof PublicMachineIsolation)) {
            Collection<StateKey> keysWithDifferentIsolation = this.getKeysWithDifferentIsolation(key);
            Collection<StateKey> keysWithSameIsolation = this.getKeysWithSameIsolation(key);
            for (StateKey stateKey : keysWithDifferentIsolation) {
                StateValue otherValue = this.getState(stateKey);
                for (String string : otherValue.allocatedCapacity.getAgentUids()) {
                    this.initValue(restrictedAgentUidsWithReason, string);
                    ((List)restrictedAgentUidsWithReason.get(string)).add(stateKey.pu + "machineIsolation=" + this.getState(stateKey).machineIsolation + " allocated on machine which restricts  " + key.pu.getName() + " machineIsolation=" + this.getState(key).machineIsolation);
                }
                for (String string : otherValue.markedForDeallocationCapacity.getAgentUids()) {
                    this.initValue(restrictedAgentUidsWithReason, string);
                    ((List)restrictedAgentUidsWithReason.get(string)).add(stateKey.pu + "machineIsolation=" + this.getState(stateKey).machineIsolation + " marked for deallocation on machine which restricts  " + key.pu.getName() + " machineIsolation=" + this.getState(key).machineIsolation);
                }
                for (FutureStoppedMachine futureStoppedMachine : otherValue.getMachineGoingDown()) {
                    GridServiceAgent gridServiceAgent = futureStoppedMachine.getGridServiceAgent();
                    this.initValue(restrictedAgentUidsWithReason, gridServiceAgent.getUid());
                    ((List)restrictedAgentUidsWithReason.get(gridServiceAgent.getUid())).add(stateKey.pu + "machineIsolation=" + this.getState(stateKey).machineIsolation + " is shutting down the agent which restricts  " + key.pu.getName() + " machineIsolation=" + this.getState(key).machineIsolation);
                }
            }
            HashSet<RequiredZonesConfig> allowedContainerZoness = new HashSet<RequiredZonesConfig>();
            for (StateKey otherKey : keysWithSameIsolation) {
                allowedContainerZoness.add(otherKey.pu.getRequiredContainerZones());
            }
            for (GridServiceContainer container : admin.getGridServiceContainers()) {
                if (container.getGridServiceAgent() == null) continue;
                boolean allowed = false;
                for (ZonesConfig zonesConfig : allowedContainerZoness) {
                    if (!container.getExactZones().isStasfies(zonesConfig)) continue;
                    allowed = true;
                    break;
                }
                if (allowed) continue;
                String string = container.getGridServiceAgent().getUid();
                this.initValue(restrictedAgentUidsWithReason, string);
                ((List)restrictedAgentUidsWithReason.get(string)).add("Machine has a container with restricted zones " + ContainersSlaUtils.gscToString(container));
            }
        }
        Map<GSAReservationId, Collection<GridServiceAgent>> agentsByReservationId = ((InternalGridServiceAgents)admin.getGridServiceAgents()).getAgentsGroupByReservationId();
        Map<GSAReservationId, StateKey> futureAgentsReservationIds = this.getFutureAgentsReservationIds();
        for (Map.Entry entry : futureAgentsReservationIds.entrySet()) {
            GSAReservationId reservationId = (GSAReservationId)entry.getKey();
            StateKey startedTheAgent = (StateKey)entry.getValue();
            Collection<GridServiceAgent> collection = agentsByReservationId.get(reservationId);
            if (collection == null) continue;
            for (GridServiceAgent agent : collection) {
                String agentUid = agent.getUid();
                this.initValue(restrictedAgentUidsWithReason, agentUid);
                ((List)restrictedAgentUidsWithReason.get(agentUid)).add("Agent has been started by " + startedTheAgent + " but not allocated yet. ReservationID=" + reservationId);
            }
        }
        if (key.gridServiceAgentZones != null) {
            for (GridServiceAgent gridServiceAgent : admin.getGridServiceAgents()) {
                if (gridServiceAgent.getExactZones().isStasfies(key.gridServiceAgentZones)) continue;
                String agentUid = gridServiceAgent.getUid();
                this.initValue(restrictedAgentUidsWithReason, agentUid);
                ((List)restrictedAgentUidsWithReason.get(agentUid)).add("Agent zones=" + gridServiceAgent.getExactZones().getZones() + " does not match " + key.gridServiceAgentZones);
            }
        }
        return restrictedAgentUidsWithReason;
    }

    private Collection<StateKey> getKeysWithSameIsolation(StateKey key) {
        ElasticProcessingUnitMachineIsolation puIsolation = this.getState(key).machineIsolation;
        HashSet<StateKey> keysWithSameIsolation = new HashSet<StateKey>();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            ElasticProcessingUnitMachineIsolation otherPuIsolation = pair.getValue().machineIsolation;
            if (otherPuIsolation == null) {
                throw new IllegalStateException(pair.getKey() + " should have set machine isolation");
            }
            if (!otherPuIsolation.equals(puIsolation)) continue;
            keysWithSameIsolation.add(pair.getKey());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("PUs with same isolation of " + key + " are: " + keysWithSameIsolation));
        }
        return keysWithSameIsolation;
    }

    private Collection<StateKey> getKeysWithDifferentIsolation(StateKey key) {
        ElasticProcessingUnitMachineIsolation puIsolation = this.getState(key).machineIsolation;
        HashSet<StateKey> keysWithDifferentIsolation = new HashSet<StateKey>();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            ElasticProcessingUnitMachineIsolation otherPuIsolation = pair.getValue().machineIsolation;
            if (otherPuIsolation == null) {
                throw new IllegalStateException(pair.getKey() + " should have set machine isolation");
            }
            if (otherPuIsolation.equals(puIsolation)) continue;
            keysWithDifferentIsolation.add(pair.getKey());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("PUs with different isolation than pu " + key + " are: " + keysWithDifferentIsolation));
        }
        return keysWithDifferentIsolation;
    }

    private Map<GSAReservationId, StateKey> getFutureAgentsReservationIds() {
        HashMap<GSAReservationId, StateKey> reservationIds = new HashMap<GSAReservationId, StateKey>();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            for (GridServiceAgentFutures futureAgents : pair.getValue().futureAgents) {
                for (GSAReservationId reservationId : futureAgents.getReservationIds()) {
                    reservationIds.put(reservationId, pair.getKey());
                }
            }
        }
        return reservationIds;
    }

    private void initValue(Map<String, List<String>> mapOfLists, String key) {
        if (!mapOfLists.containsKey(key)) {
            mapOfLists.put(key, new LinkedList());
        }
    }

    public void removeSuccesfullyStartedFutureAgents(StateKey key, GridServiceAgentFutures doneFutureAgents) {
        this.getState(key).removeFutureAgents(doneFutureAgents);
        for (FutureGridServiceAgent doneFutureAgent : doneFutureAgents.getFutureGridServiceAgents()) {
            FailedGridServiceAgent failedAgent = doneFutureAgent.getFailedGridServiceAgent();
            if (failedAgent != null) {
                String failedAgentUid = failedAgent.getAgentUid();
                for (StateKey okey : this.state.keySet()) {
                    this.unmarkAgentAsFailed(okey, failedAgentUid);
                }
                this.removeAgentContext(failedAgentUid);
            }
            try {
                String agentUid = ((StartedGridServiceAgent)doneFutureAgent.get()).getAgent().getUid();
                Object agentContext = ((StartedGridServiceAgent)doneFutureAgent.get()).getAgentContext();
                this.addAgentContext(agentUid, agentContext);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void unmarkAgentAsFailed(StateKey key, String agentUid) {
        this.getState(key).removeFailedAgent(agentUid);
    }

    private void addAgentContext(String agentUid, Object agentContext) {
        this.agentsContext.put(agentUid, agentContext);
        ++this.machinesStateVersion;
    }

    public Object getAgentContext(String agentUid) {
        return this.agentsContext.get(agentUid);
    }

    public void removeFutureStoppedMachine(StateKey key, FutureStoppedMachine futureStoppedMachine) {
        this.getState(key).removeFutureStoppedMachine(futureStoppedMachine);
        String agentUid = futureStoppedMachine.getGridServiceAgent().getUid();
        this.removeAgentContext(agentUid);
    }

    private void removeAgentContext(String agentUid) {
        this.agentsContext.remove(agentUid);
        ++this.machinesStateVersion;
    }

    public Collection<FutureStoppedMachine> getMachinesGoingDown() {
        ArrayList<FutureStoppedMachine> machinesGoingDown = new ArrayList<FutureStoppedMachine>();
        for (StateValue value : this.state.values()) {
            machinesGoingDown.addAll(value.getMachineGoingDown());
        }
        return Collections.unmodifiableList(new ArrayList(machinesGoingDown));
    }

    public void addFutureStoppedMachine(StateKey key, FutureStoppedMachine futureStoppedMachine) {
        this.getState(key).addFutureStoppedMachine(futureStoppedMachine);
    }

    public Collection<String> getUsedAgentUids(StateKey key) {
        StateValue stateValue = this.getState(key);
        return stateValue.allocatedCapacity.add(stateValue.markedForDeallocationCapacity).getAgentUids();
    }

    public void setMachineIsolation(StateKey key, ElasticProcessingUnitMachineIsolation isolation) {
        if (isolation == null) {
            throw new IllegalArgumentException("machine isolation cannot be null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(key + " machine isolation is " + isolation));
        }
        this.getState(key).machineIsolation = isolation;
    }

    public ElasticProcessingUnitMachineIsolation getMachineIsolation(StateKey key) {
        ElasticProcessingUnitMachineIsolation machineIsolation = this.getState(key).machineIsolation;
        if (machineIsolation == null) {
            throw new IllegalStateException(key + " machine isolation has not been defined");
        }
        return machineIsolation;
    }

    public boolean isCompletedStateRecovery(StateKey key) {
        return this.getState(key).completedStateRecoveryAfterRestart;
    }

    public void completedStateRecovery(StateKey key) {
        this.getState(key).completedStateRecoveryAfterRestart();
    }

    public void recoveredStateOnEsmStart(ProcessingUnit otherPu) {
        this.recoveredStatePerProcessingUnit.put(otherPu, RecoveryState.RECOVERY_SUCCESS);
    }

    public void failedRecoveredStateOnEsmStart(ProcessingUnit otherPu) {
        this.recoveredStatePerProcessingUnit.put(otherPu, RecoveryState.RECOVERY_FAILED);
    }

    public RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit pu) {
        RecoveryState recoveryState = this.recoveredStatePerProcessingUnit.get(pu);
        if (recoveryState == null) {
            recoveryState = RecoveryState.NOT_RECOVERED;
        }
        return recoveryState;
    }

    public Set<ZonesConfig> getGridServiceAgentsZones(ProcessingUnit pu) {
        HashSet<ZonesConfig> zones = new HashSet<ZonesConfig>();
        for (StateKey key : this.getStateForProcessingUnit(pu).keySet()) {
            zones.add(key.gridServiceAgentZones);
        }
        return zones;
    }

    public Set<ZonesConfig> getUndeployedGridServiceAgentsZones(ProcessingUnit pu) {
        HashSet<ZonesConfig> zones = new HashSet<ZonesConfig>();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            if (!pair.getKey().pu.equals(pu) || !pair.getValue().equalsZero()) continue;
            zones.add(pair.getKey().gridServiceAgentZones);
        }
        return zones;
    }

    public Map<GridServiceAgent, Map<ProcessingUnit, CapacityRequirements>> groupCapacityPerProcessingUnitPerAgent(StateKey key) {
        HashMap<GridServiceAgent, Map<ProcessingUnit, CapacityRequirements>> capacityPerPuPerAgent = new HashMap<GridServiceAgent, Map<ProcessingUnit, CapacityRequirements>>();
        Admin admin = key.pu.getAdmin();
        Set<String> restrictedAgentUids = this.getRestrictedAgentUids(key).keySet();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            ProcessingUnit otherPu = pair.getKey().pu;
            CapacityRequirementsPerAgent otherPuCapacityPerAgents = pair.getValue().allocatedCapacity;
            for (String agentUid : otherPuCapacityPerAgents.getAgentUids()) {
                GridServiceAgent agent = admin.getGridServiceAgents().getAgentByUID(agentUid);
                if (restrictedAgentUids.contains(agentUid) || agent == null) continue;
                if (!capacityPerPuPerAgent.containsKey(agent)) {
                    capacityPerPuPerAgent.put(agent, new HashMap());
                }
                if (!((Map)capacityPerPuPerAgent.get(agent)).containsKey(otherPu)) {
                    ((Map)capacityPerPuPerAgent.get(agent)).put(otherPu, new CapacityRequirements(new CapacityRequirement[0]));
                }
                CapacityRequirements otherPuCapacityOnAgent = (CapacityRequirements)((Map)capacityPerPuPerAgent.get(agent)).get(otherPu);
                CapacityRequirements otherPuCapacityOnAgentIncrease = otherPuCapacityPerAgents.getAgentCapacity(agentUid);
                otherPuCapacityOnAgent = otherPuCapacityOnAgent.add(otherPuCapacityOnAgentIncrease);
                ((Map)capacityPerPuPerAgent.get(agent)).put(otherPu, otherPuCapacityOnAgent);
            }
        }
        return capacityPerPuPerAgent;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacity(ProcessingUnit otherPu) {
        CapacityRequirementsPerAgent capacityRequirementsPerAgent = new CapacityRequirementsPerAgent();
        for (ZonesConfig zones : this.getGridServiceAgentsZones(otherPu)) {
            capacityRequirementsPerAgent = capacityRequirementsPerAgent.add(this.getAllocatedCapacity(new StateKey(otherPu, zones)));
        }
        return capacityRequirementsPerAgent;
    }

    public boolean replaceAllocatedCapacity(StateKey key, Admin admin) {
        boolean changed = false;
        CapacityRequirementsPerAgent allocatedCapacityPerAgent = this.getState(key).allocatedCapacity;
        ArrayList<String> agentUids = new ArrayList<String>(allocatedCapacityPerAgent.getAgentUids());
        for (String agentUid : agentUids) {
            ExactZonesConfig agentZones;
            GridServiceAgent agent = admin.getGridServiceAgents().getAgentByUID(agentUid);
            if (agent == null || key.gridServiceAgentZones.equals(agentZones = agent.getExactZones())) continue;
            CapacityRequirements capacity = allocatedCapacityPerAgent.getAgentCapacity(agentUid);
            this.markCapacityForDeallocation(key, agentUid, capacity);
            this.deallocateCapacity(key, agentUid, capacity);
            StateKey newKey = new StateKey(key.pu, agentZones);
            this.setMachineIsolation(newKey, this.getMachineIsolation(key));
            this.allocateCapacity(newKey, agentUid, capacity);
            changed = true;
        }
        if (this.getState(key).allocatedCapacity.equalsZero()) {
            this.removeKey(key);
        }
        return changed;
    }

    private void removeKey(StateKey key) {
        if (!this.getState(key).equalsZero()) {
            throw new IllegalStateException("Cannot remove " + key + " since it does not equal zero " + this.getState(key));
        }
        this.state.remove(key);
    }

    public RecoveringFailedGridServiceAgent[] getAgentsMarkedAsFailedNotBeingRecovered(StateKey key) {
        LinkedHashSet<String> restartingAgentUids = new LinkedHashSet<String>();
        for (GridServiceAgentFutures futureAgents : this.getFutureAgents(key)) {
            for (FutureGridServiceAgent futureAgent : futureAgents.getFutureGridServiceAgents()) {
                FailedGridServiceAgent failedAgent = futureAgent.getFailedGridServiceAgent();
                if (failedAgent == null) continue;
                restartingAgentUids.add(failedAgent.getAgentUid());
            }
        }
        ArrayList<RecoveringFailedGridServiceAgent> failedAgentsForKey = new ArrayList<RecoveringFailedGridServiceAgent>();
        for (RecoveringFailedGridServiceAgent failedAgent : this.getState(key).getFailedAgents()) {
            if (restartingAgentUids.contains(failedAgent.getAgentUid())) continue;
            failedAgentsForKey.add(failedAgent);
        }
        return failedAgentsForKey.toArray(new RecoveringFailedGridServiceAgent[failedAgentsForKey.size()]);
    }

    public RecoveringFailedGridServiceAgent[] getAgentsMarkedAsFailed(StateKey key) {
        Collection<RecoveringFailedGridServiceAgent> failedAgentsForKey = this.getState(key).getFailedAgents();
        return failedAgentsForKey.toArray(new RecoveringFailedGridServiceAgent[failedAgentsForKey.size()]);
    }

    private void addFailedAgent(StateKey key, String agentUid) {
        RecoveringFailedGridServiceAgent failedAgent = null;
        block0: for (StateValue value : this.state.values()) {
            for (RecoveringFailedGridServiceAgent otherFailedAgent : value.getFailedAgents()) {
                if (!otherFailedAgent.getAgentUid().equals(agentUid)) continue;
                failedAgent = otherFailedAgent;
                continue block0;
            }
        }
        if (failedAgent == null) {
            failedAgent = new RecoveringFailedGridServiceAgent(agentUid);
        }
        this.getState(key).addFailedAgent(failedAgent);
    }

    public void beforeUndeployProcessingUnit(ProcessingUnit pu) {
        this.validatedUndeployNotInProgressPerProcessingUnit.remove(pu);
    }

    public void afterUndeployProcessingUnit(ProcessingUnit pu) {
        Iterator<StateKey> stateKeyIterator = this.state.keySet().iterator();
        while (stateKeyIterator.hasNext()) {
            ProcessingUnit statePu = stateKeyIterator.next().pu;
            if (!statePu.equals(pu)) continue;
            stateKeyIterator.remove();
        }
        this.recoveredStatePerProcessingUnit.remove(pu);
        this.cloudCleanupPerProcessingUnit.remove(pu);
    }

    public Map<StateKey, StateValue> getStateForProcessingUnit(ProcessingUnit pu) {
        TreeMap<StateKey, StateValue> pustate = new TreeMap<StateKey, StateValue>();
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            if (!pair.getKey().pu.equals(pu) || pair.getValue().equalsZero()) continue;
            pustate.put(pair.getKey(), pair.getValue());
        }
        return pustate;
    }

    public void validateUndeployNotInProgress(ProcessingUnit pu) throws UndeployInProgressException {
        if (!this.validatedUndeployNotInProgressPerProcessingUnit.contains(pu)) {
            Map<StateKey, StateValue> filteredState = this.getStateForProcessingUnit(pu);
            if (!filteredState.isEmpty()) {
                UndeployInProgressException undeployInProgressException = new UndeployInProgressException(pu);
                this.logger.info((Object)(undeployInProgressException.getMessage() + " Details: " + filteredState.toString()), (Throwable)undeployInProgressException);
                throw undeployInProgressException;
            }
            this.validatedUndeployNotInProgressPerProcessingUnit.add(pu);
        }
    }

    public boolean isFutureAgentsOfOtherSharedServices(StateKey key) {
        Collection<StateKey> keysWithSameIsolation = this.getKeysWithSameIsolation(key);
        for (Map.Entry<StateKey, StateValue> pair : this.state.entrySet()) {
            StateKey otherKey = pair.getKey();
            if (key.equals(otherKey) || !keysWithSameIsolation.contains(otherKey) || this.getNumberOfFutureAgents(otherKey) <= 0) continue;
            return true;
        }
        return false;
    }

    public FutureCleanupCloudResources getCleanupFuture(ProcessingUnit pu) {
        return this.cloudCleanupPerProcessingUnit.get(pu);
    }

    public void setCleanupFuture(ProcessingUnit pu, FutureCleanupCloudResources future) {
        this.cloudCleanupPerProcessingUnit.put(pu, future);
    }

    public String disableFailoverDetection(String ipAddress, String agentUid) {
        return this.agentWithFailoverDisabledPerIpAddress.put(ipAddress, agentUid);
    }

    public String enableFailoverDetection(String ipAddress) {
        return this.agentWithFailoverDisabledPerIpAddress.remove(ipAddress);
    }

    public boolean isAgentFailoverDisabled(String agentUid) {
        return this.agentWithFailoverDisabledPerIpAddress.values().contains(agentUid);
    }

    public String getAgentWithDisabledFailoverDetectionForIpAddress(String ipAddress) {
        return this.agentWithFailoverDisabledPerIpAddress.get(ipAddress);
    }

    public void replaceAllocation(String otherAgentUid, String newAgentUid) {
        for (StateValue puState : this.state.values()) {
            puState.replaceAllocation(otherAgentUid, newAgentUid);
        }
        Object context = this.agentsContext.remove(otherAgentUid);
        if (context != null) {
            this.addAgentContext(newAgentUid, context);
        }
    }

    public MachinesState toMachinesState() {
        ArrayList<DocumentProperties> agentsProperties = new ArrayList<DocumentProperties>();
        for (StateKey key : this.state.keySet()) {
            for (String agentUid : this.getAllUsedCapacity(key).getAgentUids()) {
                int isStopping = 0;
                boolean isFailed = false;
                agentsProperties.add(this.toAgentProperties(key, agentUid, false, false));
            }
            for (RecoveringFailedGridServiceAgent failedAgent : this.getAgentsMarkedAsFailed(key)) {
                String agentUid = failedAgent.getAgentUid();
                boolean isStopping = false;
                boolean isFailed = true;
                agentsProperties.add(this.toAgentProperties(key, agentUid, false, true));
            }
            for (FutureStoppedMachine stoppingAgent : this.getMachinesGoingDown(key)) {
                String agentUid = stoppingAgent.getGridServiceAgent().getUid();
                boolean isStopping = true;
                boolean isFailed = false;
                agentsProperties.add(this.toAgentProperties(key, agentUid, true, false));
            }
        }
        DocumentProperties properties = new DocumentProperties().setProperty("platformLogicalVersion", (Object)PlatformLogicalVersion.getLogicalVersion()).setProperty("agentsContext", this.agentsContext).setProperty("agentsProperties", agentsProperties);
        MachinesState machinesState = new MachinesState();
        machinesState.setProperties(properties);
        machinesState.setVersion(this.machinesStateVersion);
        return machinesState;
    }

    private DocumentProperties toAgentProperties(StateKey key, String agentUid, boolean isStopping, boolean isFailed) {
        String agentZone = ZonesConfigUtils.zonesToString(key.gridServiceAgentZones);
        String puName = key.pu.getName();
        return new DocumentProperties().setProperty("puName", (Object)puName).setProperty("agentZones", (Object)agentZone).setProperty("agentUid", (Object)agentUid).setProperty("isStopping", (Object)isStopping).setProperty("isFailed", (Object)isFailed);
    }

    public void fromMachinesState(MachinesState state) {
        this.machinesStateVersion = state.getVersion();
        DocumentProperties properties = state.getProperties();
        this.agentsContext.clear();
        this.agentsContext.putAll((Map)properties.getProperty("agentsContext"));
        Collection<String> allUsedAgentUids = this.getAllUsedAgentUids();
        Map<String, ProcessingUnit> allProcessingUnits = this.getAllProcessingUnits();
        List agentsProperties = (List)properties.getProperty("agentsProperties");
        for (DocumentProperties agentProperties : agentsProperties) {
            boolean isStopping = (Boolean)agentProperties.getProperty("isStopping");
            String agentUid = (String)agentProperties.getProperty("agentUid");
            String puName = (String)agentProperties.getProperty("puName");
            ProcessingUnit pu = allProcessingUnits.get(puName);
            boolean isFailed = (Boolean)agentProperties.getProperty("isFailed");
            if (pu == null) {
                this.logger.info((Object)("Ignoring missing " + puName + " agent " + agentUid + " since " + puName + " was uninstalled"));
                isFailed = false;
            } else if (!allUsedAgentUids.contains(agentUid)) {
                if (isStopping) {
                    this.logger.info((Object)("Ignoring missing " + puName + " agent " + agentUid + " since it was being stopped"));
                } else if (isFailed) {
                    this.logger.info((Object)("Marking " + puName + " agent " + agentUid + " as failed since it was previously marked as failed."));
                } else {
                    this.logger.info((Object)("Marking " + puName + " agent " + agentUid + " as failed since it cannot be discovered."));
                    isFailed = true;
                }
            }
            if (!isFailed) continue;
            ZonesConfig agentZones = ZonesConfigUtils.zonesFromString((String)agentProperties.getProperty("agentZones"));
            StateKey key = new StateKey(pu, agentZones);
            this.addFailedAgent(key, agentUid);
        }
    }

    private Map<String, ProcessingUnit> getAllProcessingUnits() {
        LinkedHashMap<String, ProcessingUnit> puNames = new LinkedHashMap<String, ProcessingUnit>();
        for (StateKey key : this.state.keySet()) {
            ProcessingUnit pu = key.pu;
            puNames.put(pu.getName(), pu);
        }
        return puNames;
    }

    public long getVersion() {
        return this.machinesStateVersion;
    }

    public static enum RecoveryState {
        NOT_RECOVERED,
        RECOVERY_SUCCESS,
        RECOVERY_FAILED;

    }

    class StateValue {
        private CapacityRequirementsPerAgent allocatedCapacity = new CapacityRequirementsPerAgent();
        private final List<GridServiceAgentFutures> futureAgents = new ArrayList<GridServiceAgentFutures>();
        private CapacityRequirementsPerAgent markedForDeallocationCapacity = new CapacityRequirementsPerAgent();
        private ElasticProcessingUnitMachineIsolation machineIsolation;
        private List<FutureStoppedMachine> machinesBeingStopped = new ArrayList<FutureStoppedMachine>();
        private boolean completedStateRecoveryAfterRestart;
        private List<RecoveringFailedGridServiceAgent> failedAgents = new ArrayList<RecoveringFailedGridServiceAgent>();

        StateValue() {
        }

        public void addFutureStoppedMachine(FutureStoppedMachine futureStoppedMachine) {
            this.machinesBeingStopped.add(futureStoppedMachine);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void removeFutureStoppedMachine(FutureStoppedMachine futureStoppedMachine) {
            this.machinesBeingStopped.remove(futureStoppedMachine);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public Collection<FutureStoppedMachine> getMachineGoingDown() {
            return Collections.unmodifiableList(new ArrayList<FutureStoppedMachine>(this.machinesBeingStopped));
        }

        public void addFutureAgents(FutureGridServiceAgent[] newFutureAgents, CapacityRequirements capacityRequirements) {
            this.futureAgents.add(new GridServiceAgentFutures(newFutureAgents, capacityRequirements));
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void allocateCapacity(String agentUid, CapacityRequirements capacity) {
            if (this.machineIsolation == null) {
                throw new IllegalStateException(this + " should have set machine isolation before allocating capacity");
            }
            MachinesSlaEnforcementState.this.logger.trace((Object)("Adding {" + agentUid + ", " + capacity + "} to allocatedCapacity = " + this.allocatedCapacity.toDetailedString()));
            this.allocatedCapacity = this.allocatedCapacity.add(agentUid, capacity);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void markCapacityForDeallocation(String agentUid, CapacityRequirements capacity) {
            if (this.machineIsolation == null) {
                throw new IllegalStateException(this + " should have set machine isolation before marking capacity for de-allocation");
            }
            MachinesSlaEnforcementState.this.logger.trace((Object)("Subtracting {" + agentUid + ", " + capacity + "} from allocatedCapacity = " + this.allocatedCapacity));
            this.allocatedCapacity = this.allocatedCapacity.subtract(agentUid, capacity);
            MachinesSlaEnforcementState.this.logger.trace((Object)("Adding {" + agentUid + ", " + capacity + "} to markedForDeallocationCapacity = " + this.markedForDeallocationCapacity));
            this.markedForDeallocationCapacity = this.markedForDeallocationCapacity.add(agentUid, capacity);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void unmarkCapacityForDeallocation(String agentUid, CapacityRequirements capacity) {
            if (this.machineIsolation == null) {
                throw new IllegalStateException(this + " should have set machine isolation before un-marking capacity for de-allocation");
            }
            MachinesSlaEnforcementState.this.logger.trace((Object)("Subtracting {" + agentUid + ", " + capacity + "} from markedForDeallocationCapacity = " + this.markedForDeallocationCapacity));
            this.markedForDeallocationCapacity = this.markedForDeallocationCapacity.subtract(agentUid, capacity);
            this.allocateCapacity(agentUid, capacity);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void deallocateCapacity(String agentUid, CapacityRequirements capacity) {
            if (this.machineIsolation == null) {
                throw new IllegalStateException(this + " should have set machine isolation before de-allocating capacity");
            }
            MachinesSlaEnforcementState.this.logger.trace((Object)("Subtracting {" + agentUid + ", " + capacity + "} from markedForDeallocationCapacity = " + this.markedForDeallocationCapacity));
            this.markedForDeallocationCapacity = this.markedForDeallocationCapacity.subtract(agentUid, capacity);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void replaceAllocation(String oldAgentUid, String newAgentUid) {
            CapacityRequirements agentAllocatedCapacity;
            CapacityRequirements agentDeallocationCapacity = this.markedForDeallocationCapacity.getAgentCapacityOrZero(oldAgentUid);
            if (!agentDeallocationCapacity.equalsZero()) {
                this.markedForDeallocationCapacity = this.markedForDeallocationCapacity.subtractAgent(oldAgentUid).add(newAgentUid, agentDeallocationCapacity);
            }
            if (!(agentAllocatedCapacity = this.allocatedCapacity.getAgentCapacityOrZero(oldAgentUid)).equalsZero()) {
                this.allocatedCapacity = this.allocatedCapacity.subtractAgent(oldAgentUid);
                this.allocateCapacity(newAgentUid, agentAllocatedCapacity);
            }
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public Collection<GridServiceAgentFutures> getAllDoneFutureAgents() {
            ArrayList<GridServiceAgentFutures> doneFutures = new ArrayList<GridServiceAgentFutures>();
            for (GridServiceAgentFutures future : this.futureAgents) {
                if (!future.isDone()) continue;
                doneFutures.add(future);
            }
            return doneFutures;
        }

        public void removeFutureAgents(GridServiceAgentFutures futureAgentsToRemove) {
            if (this.machineIsolation == null) {
                throw new IllegalStateException(this + " should have set machine isolation before removing future agent");
            }
            this.futureAgents.remove(futureAgentsToRemove);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void completedStateRecoveryAfterRestart() {
            this.completedStateRecoveryAfterRestart = true;
        }

        public String toString() {
            return "StateValue [" + (this.allocatedCapacity != null ? "allocatedCapacity=" + this.allocatedCapacity + ", " : "") + (this.futureAgents != null ? "futureAgents=" + this.futureAgents + ", " : "") + (this.markedForDeallocationCapacity != null ? "markedForDeallocationCapacity=" + this.markedForDeallocationCapacity + ", " : "") + (this.machineIsolation != null ? "machineIsolation=" + this.machineIsolation + ", " : "") + "completedStateRecoveryAfterRestart=" + this.completedStateRecoveryAfterRestart + ", failedAgents=" + this.failedAgents + "]";
        }

        public boolean equalsZero() {
            return this.allocatedCapacity.equalsZero() && this.markedForDeallocationCapacity.equalsZero() && this.futureAgents.isEmpty();
        }

        public Collection<RecoveringFailedGridServiceAgent> getFailedAgents() {
            return Collections.unmodifiableCollection(this.failedAgents);
        }

        public void addFailedAgent(RecoveringFailedGridServiceAgent failedAgent) {
            this.failedAgents.add(failedAgent);
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }

        public void removeFailedAgent(String agentUid) {
            Iterator<RecoveringFailedGridServiceAgent> it = this.failedAgents.iterator();
            while (it.hasNext()) {
                if (!it.next().getAgentUid().equals(agentUid)) continue;
                it.remove();
            }
            MachinesSlaEnforcementState.this.machinesStateVersion++;
        }
    }

    public static class StateKey
    implements Comparable<StateKey> {
        ProcessingUnit pu;
        ZonesConfig gridServiceAgentZones;

        public StateKey(ProcessingUnit pu, ZonesConfig gridServiceAgentZones) {
            this.pu = pu;
            this.gridServiceAgentZones = gridServiceAgentZones;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gridServiceAgentZones == null ? 0 : this.gridServiceAgentZones.hashCode());
            result = 31 * result + (this.pu == null ? 0 : this.pu.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateKey other = (StateKey)obj;
            if (this.gridServiceAgentZones == null ? other.gridServiceAgentZones != null : !this.gridServiceAgentZones.equals(other.gridServiceAgentZones)) {
                return false;
            }
            return !(this.pu == null ? other.pu != null : !this.pu.equals(other.pu));
        }

        public String toString() {
            return "StateKey [" + (this.pu != null ? "pu=" + this.pu.getName() + ", " : "") + (this.gridServiceAgentZones != null ? "agentZones=" + this.gridServiceAgentZones : "") + "]";
        }

        @Override
        public int compareTo(StateKey o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

