/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import com.gigaspaces.grid.gsa.AgentProcessDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.openspaces.admin.Admin;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.ElasticMachineProvisioningConfig;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.internal.commons.math.ConvergenceException;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.MachineCapacityRequirements;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.machines.AbstractMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.FailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgent;

public class MachinesSlaUtils {
    public static Set<Long> getChildProcessesIds(GridServiceAgent agent) {
        HashSet<Long> pids = new HashSet<Long>();
        for (AgentProcessDetails details : agent.getProcessesDetails().getProcessDetails()) {
            pids.add(details.getProcessId());
        }
        return pids;
    }

    public static boolean isManagementRunningOnMachine(Machine machine) {
        return machine.getGridServiceManagers().getSize() > 0 || machine.getLookupServices().getSize() > 0 || machine.getElasticServiceManagers().getSize() > 0;
    }

    public static List<GridServiceAgent> sortManagementFirst(Collection<GridServiceAgent> agents) {
        ArrayList<GridServiceAgent> sortedAgents = new ArrayList<GridServiceAgent>(agents);
        Collections.sort(sortedAgents, new Comparator<GridServiceAgent>(){

            @Override
            public int compare(GridServiceAgent agent1, GridServiceAgent agent2) {
                boolean management1 = MachinesSlaUtils.isManagementRunningOnMachine(agent1.getMachine());
                boolean management2 = MachinesSlaUtils.isManagementRunningOnMachine(agent2.getMachine());
                if (management1 && !management2) {
                    return -1;
                }
                if (management2 && !management1) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedAgents;
    }

    public static String agentToString(Admin admin, String agentUid) {
        GridServiceAgent agent = admin.getGridServiceAgents().getAgentByUID(agentUid);
        if (agent != null) {
            return MachinesSlaUtils.agentToString(agent);
        }
        return "uid " + agentUid;
    }

    public static String agentToString(GridServiceAgent agent) {
        return "pid[" + agent.getVirtualMachine().getDetails().getPid() + "] host[" + MachinesSlaUtils.machineToString(agent.getMachine()) + "] zone[" + agent.getExactZones() + "]";
    }

    public static String machineToString(Machine machine) {
        return machine.getHostName() + "/" + machine.getHostAddress();
    }

    public static String gscToString(GridComponent container) {
        return "pid[" + container.getVirtualMachine().getDetails().getPid() + "] host[" + MachinesSlaUtils.machineToString(container.getMachine()) + "]";
    }

    public static String machinesToString(Collection<GridServiceAgent> agents) {
        Object[] machinesToString = new String[agents.size()];
        int i = 0;
        for (GridServiceAgent agent : agents) {
            machinesToString[i] = MachinesSlaUtils.machineToString(agent.getMachine());
            ++i;
        }
        return Arrays.toString(machinesToString);
    }

    public static String esmToString(ElasticServiceManager esm) {
        return "pid[" + esm.getVirtualMachine().getDetails().getPid() + "] host[" + MachinesSlaUtils.machineToString(esm.getMachine()) + "]";
    }

    public static CapacityRequirements getMachineTotalCapacity(GridServiceAgent agent, AbstractMachinesSlaPolicy sla) {
        return MachinesSlaUtils.getMachineCapacity(agent).subtractOrZero(MachinesSlaUtils.getReservedCapacity(sla, agent));
    }

    public static MachineCapacityRequirements getMachineCapacity(GridServiceAgent agent) {
        return new MachineCapacityRequirements(agent.getMachine());
    }

    public static Fraction convertCpuCoresFromDoubleToFraction(double cpu) {
        Fraction targetCpuCores;
        try {
            targetCpuCores = new Fraction(cpu);
        }
        catch (ConvergenceException e) {
            targetCpuCores = new Fraction((int)Math.ceil(cpu * 2.0), 2);
        }
        return targetCpuCores;
    }

    public static int getNumberOfChildContainersForProcessingUnit(GridServiceAgent agent, ProcessingUnit pu) {
        return MachinesSlaUtils.getContainersByZoneOnMachine(ContainersSlaUtils.getContainerZone(pu), agent.getMachine()).size();
    }

    private static List<GridServiceContainer> getContainersByZoneOnMachine(String zone, Machine machine) {
        ArrayList<GridServiceContainer> containers = new ArrayList<GridServiceContainer>();
        for (GridServiceContainer container : machine.getGridServiceContainers()) {
            if (!ContainersSlaUtils.isContainerMatchesZone(container, zone)) continue;
            containers.add(container);
        }
        return containers;
    }

    public static Collection<GridServiceAgent> convertAgentUidsToAgents(Iterable<String> agentUids, Admin admin) {
        ArrayList<GridServiceAgent> agents = new ArrayList<GridServiceAgent>();
        GridServiceAgents gridServiceAgents = admin.getGridServiceAgents();
        for (String agentUid : agentUids) {
            GridServiceAgent agent = gridServiceAgents.getAgentByUID(agentUid);
            if (agent == null) {
                throw new IllegalStateException("At this point agent " + agentUid + " must be discovered.");
            }
            agents.add(agent);
        }
        return agents;
    }

    public static Collection<GridServiceAgent> convertAgentUidsToAgentsIfDiscovered(Iterable<String> agentUids, Admin admin) {
        ArrayList<GridServiceAgent> agents = new ArrayList<GridServiceAgent>();
        GridServiceAgents gridServiceAgents = admin.getGridServiceAgents();
        for (String agentUid : agentUids) {
            GridServiceAgent agent = gridServiceAgents.getAgentByUID(agentUid);
            if (agent == null) continue;
            agents.add(agent);
        }
        return agents;
    }

    public static boolean isAgentConformsToMachineProvisioningConfig(GridServiceAgent agent, ElasticMachineProvisioningConfig machineProvisioningConfig) {
        return MachinesSlaUtils.zoneFilter(agent, machineProvisioningConfig) && MachinesSlaUtils.managementFilter(agent, machineProvisioningConfig);
    }

    private static boolean managementFilter(GridServiceAgent agent, ElasticMachineProvisioningConfig machineProvisioningConfig) {
        return !machineProvisioningConfig.isDedicatedManagementMachines() || !MachinesSlaUtils.isManagementRunningOnMachine(agent.getMachine());
    }

    private static boolean zoneFilter(GridServiceAgent agent, ElasticMachineProvisioningConfig machineProvisioningConfig) {
        boolean match = agent.getExactZones().isStasfies(machineProvisioningConfig.getGridServiceAgentZones());
        if (agent.getExactZones().getZones().isEmpty() && machineProvisioningConfig.isGridServiceAgentZoneMandatory()) {
            match = false;
        }
        return match;
    }

    public static long getMemoryInMB(CapacityRequirements capacity) {
        return capacity.getRequirement(new MemoryCapacityRequirement().getType()).getMemoryInMB();
    }

    public static boolean isAgentAutoShutdownEnabled(GridServiceAgent agent) {
        String autoShutdownFlag = ContainersSlaUtils.getCommandLineArgumentRemovePrefix(agent, "-Dcom.gs.agent.auto-shutdown-enabled=");
        return Boolean.valueOf(autoShutdownFlag);
    }

    public static Collection<GridServiceAgent> sortAndFilterAgents(GridServiceAgent[] agents, ElasticMachineProvisioningConfig machineProvisioningConfig, Log logger) {
        LinkedHashSet<GridServiceAgent> filteredAgents = new LinkedHashSet<GridServiceAgent>();
        for (GridServiceAgent agent : agents) {
            if (!agent.isDiscovered()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Agent " + MachinesSlaUtils.machineToString(agent.getMachine()) + " has shutdown."));
                continue;
            }
            if (!MachinesSlaUtils.isAgentConformsToMachineProvisioningConfig(agent, machineProvisioningConfig)) {
                if (!logger.isDebugEnabled()) continue;
                agent.getExactZones().isStasfies(machineProvisioningConfig.getGridServiceAgentZones());
                ExactZonesConfig agentZones = agent.getExactZones();
                ZonesConfig puZones = machineProvisioningConfig.getGridServiceAgentZones();
                boolean isDedicatedManagedmentMachines = machineProvisioningConfig.isDedicatedManagementMachines();
                boolean isManagementRunningOnMachine = MachinesSlaUtils.isManagementRunningOnMachine(agent.getMachine());
                StringBuilder logMessage = new StringBuilder();
                logMessage.append("Agent ").append(MachinesSlaUtils.machineToString(agent.getMachine())).append(" does not conform to machine provisioning SLA. ").append("Agent zones: ").append(agentZones).append(",").append("PU zones: ").append(puZones).append(", ").append("Is dedicated management machines: ").append(isDedicatedManagedmentMachines).append(", ").append("Is management running on machine: ").append(isManagementRunningOnMachine);
                logger.debug((Object)logMessage.toString());
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Agent " + MachinesSlaUtils.machineToString(agent.getMachine()) + " conforms to machine provisioning SLA."));
            }
            filteredAgents.add(agent);
        }
        List<GridServiceAgent> sortedFilteredAgents = MachinesSlaUtils.sortManagementFirst(filteredAgents);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Provisioned Agents: " + MachinesSlaUtils.machinesToString(sortedFilteredAgents)));
        }
        return sortedFilteredAgents;
    }

    public static CapacityRequirements getReservedCapacity(AbstractMachinesSlaPolicy sla, GridServiceAgent agent) {
        if (MachinesSlaUtils.isManagementRunningOnMachine(agent.getMachine())) {
            CapacityRequirements reservedCapacityPerManagementMachine = sla.getReservedCapacityPerManagementMachine();
            return reservedCapacityPerManagementMachine;
        }
        CapacityRequirements reservedCapacityPerMachine = sla.getReservedCapacityPerMachine();
        return reservedCapacityPerMachine;
    }

    public static String getAgentIpAddress(GridServiceAgent agent) {
        return agent.getMachine().getHostAddress();
    }

    public static String agentsToString(Collection<GridServiceAgent> agents) {
        Object[] agentsToString = new String[agents.size()];
        int i = 0;
        for (GridServiceAgent agent : agents) {
            agentsToString[i] = MachinesSlaUtils.agentToString(agent);
            ++i;
        }
        return Arrays.toString(agentsToString);
    }

    public static String reservationIdsToString(FutureGridServiceAgent[] futureAgents) {
        ArrayList<String> reservationIds = new ArrayList<String>(futureAgents.length);
        for (FutureGridServiceAgent futureAgent : futureAgents) {
            reservationIds.add(futureAgent.getReservationId().toString());
        }
        return ((Object)reservationIds).toString();
    }

    public static String failedAgentUidsToString(FutureGridServiceAgent[] futureAgents) {
        ArrayList<String> agentUids = new ArrayList<String>(futureAgents.length);
        for (FutureGridServiceAgent futureAgent : futureAgents) {
            FailedGridServiceAgent failedAgent = futureAgent.getFailedGridServiceAgent();
            if (failedAgent == null) continue;
            agentUids.add(failedAgent.getAgentUid());
        }
        return ((Object)agentUids).toString();
    }
}

