/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.backup;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.IdQuery;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.core.GigaSpace;
import org.openspaces.grid.esm.EsmSystemProperties;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.backup.MachinesState;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackup;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupFailureException;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupInProgressException;
import org.openspaces.grid.gsm.machines.backup.MachinesStateRecoveryFailureException;
import org.openspaces.grid.gsm.machines.backup.MachinesStateRecoveryInProgressException;

public class MachinesStateBackupToSpace
implements MachinesStateBackup {
    private final Log logger = new SingleThreadedPollingLog(LogFactory.getLog(this.getClass()));
    public static final Integer SINGLETON_ID = 0;
    private final MachinesSlaEnforcementState machinesSlaEnforcementState;
    private final GigaSpace space;
    private final AtomicLong writeCompletedVersion;
    private final AtomicReference<Throwable> lastError;
    private final ThreadFactory threadFactory = new GSThreadFactory(this.getClass().getName(), true);
    private final ExecutorService service = Executors.newSingleThreadExecutor(this.threadFactory);
    private final InternalAdmin admin;
    private static final long BACKUP_INTERVAL_MILLISECONDS = Long.getLong("org.openspaces.grid.state-backup-to-space-interval-milliseconds", EsmSystemProperties.ESM_BACKUP_INTERVAL_MILLISECONDS_DEFAULT);
    private ScheduledFuture<?> scheduledFuture;
    private boolean started = false;
    private boolean recovered = false;
    private AsyncFuture<MachinesState> asyncRead;

    public MachinesStateBackupToSpace(Admin admin, GigaSpace space, MachinesSlaEnforcementState machinesSlaEnforcementState) {
        this.admin = (InternalAdmin)admin;
        this.space = space;
        this.machinesSlaEnforcementState = machinesSlaEnforcementState;
        this.writeCompletedVersion = new AtomicLong(machinesSlaEnforcementState.getVersion() - 1L);
        this.lastError = new AtomicReference();
    }

    private void startBackup() {
        if (this.started) {
            return;
        }
        this.scheduledFuture = this.admin.scheduleWithFixedDelayNonBlockingStateChange(new Runnable(){
            private Future<?> future = null;

            @Override
            public void run() {
                long currentVersion = MachinesStateBackupToSpace.this.machinesSlaEnforcementState.getVersion();
                if (MachinesStateBackupToSpace.this.writeCompletedVersion.get() == currentVersion) {
                    MachinesStateBackupToSpace.this.logger.trace((Object)("Already wrote machines state to space. version=" + currentVersion));
                    return;
                }
                if (this.future != null && !this.future.isDone()) {
                    MachinesStateBackupToSpace.this.logger.trace((Object)"Machine state write is in progress");
                } else {
                    this.write(currentVersion);
                }
            }

            private void write(final long currentVersion) {
                try {
                    final MachinesState machinesState = MachinesStateBackupToSpace.this.machinesSlaEnforcementState.toMachinesState();
                    machinesState.setId(SINGLETON_ID);
                    if (machinesState.getVersion() != currentVersion) {
                        throw new IllegalStateException("Expected version " + currentVersion + ", instead got " + machinesState.getVersion());
                    }
                    this.future = MachinesStateBackupToSpace.this.service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MachinesStateBackupToSpace.this.logger.trace((Object)("Before writing machines state to space. version=" + currentVersion));
                                MachinesStateBackupToSpace.this.space.write((Object)machinesState, Long.MAX_VALUE);
                                MachinesStateBackupToSpace.this.writeCompletedVersion.set(currentVersion);
                                MachinesStateBackupToSpace.this.lastError.set(null);
                                MachinesStateBackupToSpace.this.logger.trace((Object)("Successfully written machines state to space. version=" + currentVersion));
                            }
                            catch (Throwable t) {
                                MachinesStateBackupToSpace.this.logger.debug((Object)("Failed writing machines state to space. version=" + currentVersion), t);
                                MachinesStateBackupToSpace.this.lastError.set(t);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    MachinesStateBackupToSpace.this.logger.debug((Object)("Failed writing machines state to space. version=" + currentVersion), t);
                    MachinesStateBackupToSpace.this.lastError.set(t);
                }
            }
        }, 0L, BACKUP_INTERVAL_MILLISECONDS, TimeUnit.MILLISECONDS);
        this.started = true;
    }

    @Override
    public void close() {
        this.scheduledFuture.cancel(false);
        this.service.shutdownNow();
    }

    @Override
    public void validateBackupCompleted(ProcessingUnit pu) throws MachinesStateBackupFailureException, MachinesStateBackupInProgressException {
        Throwable lastError = this.lastError.get();
        if (lastError != null) {
            throw new MachinesStateBackupFailureException(pu, lastError);
        }
        if (this.writeCompletedVersion.get() != this.machinesSlaEnforcementState.getVersion()) {
            throw new MachinesStateBackupInProgressException(pu);
        }
    }

    @Override
    public void recoverAndStartBackup(ProcessingUnit pu) throws MachinesStateRecoveryFailureException, MachinesStateRecoveryInProgressException {
        this.recover(pu);
        this.startBackup();
    }

    private void recover(ProcessingUnit pu) throws MachinesStateRecoveryFailureException, MachinesStateRecoveryInProgressException {
        if (!this.recovered) {
            MachinesState machinesState = this.readMachineStateFromSpace(pu);
            if (machinesState != null) {
                this.logger.info((Object)("Recovering machines state from " + this.space.getName()));
                this.machinesSlaEnforcementState.fromMachinesState(machinesState);
            } else {
                this.logger.debug((Object)("Not recovering machines state from " + this.space.getName() + " since it's empty."));
            }
            this.recovered = true;
        }
    }

    private MachinesState readMachineStateFromSpace(ProcessingUnit pu) throws MachinesStateRecoveryFailureException, MachinesStateRecoveryInProgressException {
        if (this.asyncRead == null) {
            this.asyncRead = this.space.asyncRead((ISpaceQuery)new IdQuery(MachinesState.class, (Object)SINGLETON_ID));
        }
        if (this.asyncRead != null && this.asyncRead.isDone()) {
            try {
                return (MachinesState)this.asyncRead.get();
            }
            catch (ExecutionException e) {
                throw new MachinesStateRecoveryFailureException(pu, e);
            }
            catch (InterruptedException e) {
                throw new MachinesStateRecoveryFailureException(pu, e);
            }
        }
        throw new MachinesStateRecoveryInProgressException(pu);
    }
}

