/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementLoggerBehavior;

public class ExpectedMachineWithMoreMemoryException
extends MachinesSlaEnforcementInProgressException
implements SlaEnforcementFailure,
SlaEnforcementLoggerBehavior {
    private static final long serialVersionUID = 1L;

    public ExpectedMachineWithMoreMemoryException(ProcessingUnit pu, Exception cause) {
        super(pu, "Machine provisioning failed to start a new machine. Cause:" + cause.getMessage(), cause);
    }

    public ExpectedMachineWithMoreMemoryException(ProcessingUnit pu, Machine machine, long totalMB, long reservedMB, long containerMB) {
        super(pu, ExpectedMachineWithMoreMemoryException.message(machine, totalMB, reservedMB, containerMB));
    }

    private static String message(Machine machine, long totalMB, long reservedMB, long containerMB) {
        return "Expected machine with more memory. Machine " + MachinesSlaUtils.machineToString(machine) + " has been started with not enough memory. Actual total memory is " + totalMB + "MB. Which is less than (reserved + container) = (" + reservedMB + "MB+" + containerMB + "MB) = " + (reservedMB + containerMB) + "MB";
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticMachineProvisioningFailureEvent event = new DefaultElasticMachineProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }

    @Override
    public boolean isAlwaysLogStackTrace() {
        return true;
    }

    @Override
    public boolean isAlwaysLogDuplicateException() {
        return true;
    }
}

