/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.FailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class FailedGridServiceAgentReconnectedException
extends GridServiceAgentSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final String newAgentUid;
    private final String failedAgentUid;
    private final int failedAgentRecoveryAttempt;
    private final GridServiceAgent newAgent;
    private final GridServiceAgent reconnectedFailedAgent;

    public FailedGridServiceAgentReconnectedException(ProcessingUnit pu, GridServiceAgent newAgent, FailedGridServiceAgent failedAgent, GridServiceAgent reconnectedFailedAgent) {
        super(pu, "New agent " + MachinesSlaUtils.agentToString(newAgent) + " was started, in response to a machine failure, but the failed agent it was meant to replace has reconnected: " + MachinesSlaUtils.agentToString(reconnectedFailedAgent));
        this.newAgentUid = newAgent.getUid();
        this.failedAgentUid = reconnectedFailedAgent.getUid();
        this.failedAgentRecoveryAttempt = failedAgent.getRecoveryAttempts();
        this.newAgent = newAgent;
        this.reconnectedFailedAgent = reconnectedFailedAgent;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.failedAgentRecoveryAttempt;
        result = 31 * result + (this.failedAgentUid == null ? 0 : this.failedAgentUid.hashCode());
        result = 31 * result + (this.newAgentUid == null ? 0 : this.newAgentUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FailedGridServiceAgentReconnectedException other = (FailedGridServiceAgentReconnectedException)obj;
        if (this.failedAgentRecoveryAttempt != other.failedAgentRecoveryAttempt) {
            return false;
        }
        if (this.failedAgentUid == null ? other.failedAgentUid != null : !this.failedAgentUid.equals(other.failedAgentUid)) {
            return false;
        }
        return !(this.newAgentUid == null ? other.newAgentUid != null : !this.newAgentUid.equals(other.newAgentUid));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticGridServiceAgentProvisioningFailureEvent event = new DefaultElasticGridServiceAgentProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }

    public GridServiceAgent getNewAgent() {
        return this.newAgent;
    }

    public GridServiceAgent getOldAgent() {
        return this.reconnectedFailedAgent;
    }
}

