/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class FailedToStopGridServiceAgentException
extends GridServiceAgentSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private String agentUid;

    public FailedToStopGridServiceAgentException(ProcessingUnit pu, GridServiceAgent agent, Exception cause) {
        super(pu, FailedToStopGridServiceAgentException.meesage(pu, agent) + " Cause: " + cause.getMessage(), (Throwable)cause);
        this.agentUid = agent.getUid();
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticMachineProvisioningFailureEvent event = new DefaultElasticMachineProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.agentUid == null ? 0 : this.agentUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FailedToStopGridServiceAgentException other = (FailedToStopGridServiceAgentException)obj;
        return !(this.agentUid == null ? other.agentUid != null : !this.agentUid.equals(other.agentUid));
    }

    private static String meesage(ProcessingUnit pu, GridServiceAgent agent) {
        String errorMessage = "Failed to stop existing Grid Service Agent [" + agent.getUid() + "] of pu " + pu.getName() + " and host " + agent.getMachine().getHostAddress();
        return errorMessage;
    }
}

