/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementLoggerBehavior;

public class FailedToStopMachineException
extends MachinesSlaEnforcementInProgressException
implements SlaEnforcementFailure,
SlaEnforcementLoggerBehavior {
    private static final long serialVersionUID = 1L;
    private String agentUid;

    public FailedToStopMachineException(ProcessingUnit pu, GridServiceAgent agent, Exception exception) {
        super(pu, FailedToStopMachineException.message(agent) + " Cause: " + exception.getMessage(), exception);
        this.agentUid = agent.getUid();
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticMachineProvisioningFailureEvent event = new DefaultElasticMachineProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.agentUid == null ? 0 : this.agentUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FailedToStopMachineException other = (FailedToStopMachineException)obj;
        return !(this.agentUid == null ? other.agentUid != null : !this.agentUid.equals(other.agentUid));
    }

    private static String message(GridServiceAgent agent) {
        String errorMessage = "Failed shutting down machine with ip " + agent.getMachine().getHostAddress() + " of agent " + agent.getUid() + "Shutdown this machine manually";
        return errorMessage;
    }

    @Override
    public boolean isAlwaysLogStackTrace() {
        return true;
    }

    @Override
    public boolean isAlwaysLogDuplicateException() {
        return true;
    }
}

