/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.MachineCapacityRequirements;
import org.openspaces.grid.gsm.machines.AbstractMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;
import org.springframework.util.StringUtils;

public class NeedToStartMoreGridServiceAgentsException
extends GridServiceAgentSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final CapacityRequirements capacityShortage;

    public NeedToStartMoreGridServiceAgentsException(AbstractMachinesSlaPolicy sla, MachinesSlaEnforcementState state, CapacityRequirements capacityShortage, ProcessingUnit pu) {
        super(pu, NeedToStartMoreGridServiceAgentsException.createMessage(sla, state, capacityShortage, pu));
        this.capacityShortage = capacityShortage;
    }

    private static String createMessage(AbstractMachinesSlaPolicy sla, MachinesSlaEnforcementState state, CapacityRequirements capacityShortage, ProcessingUnit pu) {
        return NeedToStartMoreGridServiceAgentsException.createBasicMessage(capacityShortage) + ". " + NeedToStartMoreGridServiceAgentsException.otherPusOnSameMachinesReport(sla, state, pu) + ". " + NeedToStartMoreGridServiceAgentsException.restrictedMachinesReport(sla, state, pu);
    }

    private static String createBasicMessage(CapacityRequirements capacityShortage) {
        return "Cannot enforce Machines SLA since there are not enough machines available. Need more capacity: " + capacityShortage;
    }

    private static String restrictedMachinesReport(AbstractMachinesSlaPolicy sla, MachinesSlaEnforcementState state, ProcessingUnit pu) {
        HashMap<String, String> restrictedMachinesWithReasons = new HashMap<String, String>();
        Map<String, List<String>> restrictedAgentUidsWithReasons = state.getRestrictedAgentUids(NeedToStartMoreGridServiceAgentsException.getKey(pu, sla));
        for (Map.Entry<String, List<String>> pair : restrictedAgentUidsWithReasons.entrySet()) {
            String agentUid = pair.getKey();
            String ipAddress = MachinesSlaUtils.agentToString(pu.getAdmin(), agentUid);
            String reason = StringUtils.collectionToCommaDelimitedString((Collection)pair.getValue());
            restrictedMachinesWithReasons.put(ipAddress, reason);
        }
        return "restricted machines:" + restrictedMachinesWithReasons;
    }

    private static String otherPusOnSameMachinesReport(AbstractMachinesSlaPolicy sla, MachinesSlaEnforcementState state, ProcessingUnit pu) {
        Map<GridServiceAgent, Map<ProcessingUnit, CapacityRequirements>> createReportOfAllMachines = state.groupCapacityPerProcessingUnitPerAgent(NeedToStartMoreGridServiceAgentsException.getKey(pu, sla));
        StringBuilder message = new StringBuilder("Capacity Report of all relevant machines:");
        for (Map.Entry<GridServiceAgent, Map<ProcessingUnit, CapacityRequirements>> agentpair : createReportOfAllMachines.entrySet()) {
            GridServiceAgent agent = agentpair.getKey();
            MachineCapacityRequirements total = new MachineCapacityRequirements(agent.getMachine());
            CapacityRequirements free = total;
            String ipAddress = MachinesSlaUtils.machineToString(agent.getMachine());
            CapacityRequirements reserved = MachinesSlaUtils.getReservedCapacity(sla, agent);
            message.append("\"").append(ipAddress).append("\":{").append("total:{").append(total).append("},").append("reserved:{").append(reserved).append("},");
            free = free.subtractOrZero(reserved);
            for (Map.Entry<ProcessingUnit, CapacityRequirements> pupair : agentpair.getValue().entrySet()) {
                String puName = pupair.getKey().getName();
                CapacityRequirements capacity = pupair.getValue();
                message.append(puName).append(":{").append(capacity.toString()).append("},");
                free = free.subtractOrZero(capacity);
            }
            message.append("free:").append(free).append("},");
        }
        int lastIndex = message.length() - 1;
        if (message.charAt(lastIndex) == ',') {
            message.deleteCharAt(lastIndex);
        }
        return message.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.capacityShortage == null ? 0 : this.capacityShortage.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NeedToStartMoreGridServiceAgentsException other = (NeedToStartMoreGridServiceAgentsException)obj;
        return !(this.capacityShortage == null ? other.capacityShortage != null : !this.capacityShortage.equals(other.capacityShortage));
    }

    private static MachinesSlaEnforcementState.StateKey getKey(ProcessingUnit pu, AbstractMachinesSlaPolicy sla) {
        return new MachinesSlaEnforcementState.StateKey(pu, sla.getGridServiceAgentZones());
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticGridServiceAgentProvisioningFailureEvent event = new DefaultElasticGridServiceAgentProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

