/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class StartedTooManyMachinesException
extends MachinesSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final String[] agentUids;

    public StartedTooManyMachinesException(ProcessingUnit pu, Collection<GridServiceAgent> agents) {
        super(pu, "Started too many machines " + MachinesSlaUtils.machinesToString(agents) + ". They are not needed by " + pu.getName());
        this.agentUids = StartedTooManyMachinesException.createAgentUids(agents);
    }

    private static String[] createAgentUids(Collection<GridServiceAgent> agents) {
        String[] agentUids = new String[agents.size()];
        int i = 0;
        for (GridServiceAgent agent : agents) {
            agentUids[i] = agent.getUid();
            ++i;
        }
        return agentUids;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.agentUids);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartedTooManyMachinesException other = (StartedTooManyMachinesException)obj;
        return Arrays.equals(this.agentUids, other.agentUids);
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticMachineProvisioningFailureEvent event = new DefaultElasticMachineProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

