/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.exceptions;

import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class UnexpectedShutdownOfNewGridServiceAgentException
extends GridServiceAgentSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final String machineUid;

    public UnexpectedShutdownOfNewGridServiceAgentException(Machine machine, ProcessingUnit pu) {
        super(pu, "New machine " + MachinesSlaUtils.machineToString(machine) + " was started and the agent was also started, but then it was shutdown unexpectedly.");
        this.machineUid = machine.getUid();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.machineUid == null ? 0 : this.machineUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnexpectedShutdownOfNewGridServiceAgentException other = (UnexpectedShutdownOfNewGridServiceAgentException)obj;
        return !(this.machineUid == null ? other.machineUid != null : !this.machineUid.equals(other.machineUid));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticGridServiceAgentProvisioningFailureEvent event = new DefaultElasticGridServiceAgentProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

