/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.plugins;

import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningProgressChangedEventListener;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningProgressChangedEventListener;
import org.openspaces.admin.pu.elastic.ElasticMachineProvisioningConfig;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.NumberOfMachinesCapacityRequirement;
import org.openspaces.grid.gsm.machines.FailedGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureCleanupCloudResources;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgent;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgents;
import org.openspaces.grid.gsm.machines.FutureStoppedMachine;
import org.openspaces.grid.gsm.machines.StartedGridServiceAgent;
import org.openspaces.grid.gsm.machines.exceptions.NoClassDefFoundElasticMachineProvisioningException;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolation;
import org.openspaces.grid.gsm.machines.plugins.ElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticGridServiceAgentProvisioningException;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticMachineProvisioningException;

public class NonBlockingElasticMachineProvisioningAdapter
implements NonBlockingElasticMachineProvisioning {
    private ElasticMachineProvisioning machineProvisioning;
    private final ExecutorService executorService;
    private final ScheduledThreadPoolExecutor scheduledExecutorService;
    private static final Log logger = LogFactory.getLog(NonBlockingElasticMachineProvisioningAdapter.class);
    private static final int THROTTLING_DELAY_SECONDS = 0;

    public NonBlockingElasticMachineProvisioningAdapter(ElasticMachineProvisioning machineProvisioning, ExecutorService executorService, ScheduledThreadPoolExecutor scheduledExecutorService) {
        this.machineProvisioning = machineProvisioning;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public FutureGridServiceAgent[] startMachinesAsync(CapacityRequirements capacityRequirements, final ExactZonesConfig zones, FailedGridServiceAgent[] failedAgents, final long duration, final TimeUnit unit) {
        if (!this.isStartMachineSupported()) {
            throw new UnsupportedOperationException();
        }
        final GSAReservationId reservationId = GSAReservationId.randomGSAReservationId();
        final CapacityRequirements singleMachineCapacity = this.machineProvisioning.getCapacityOfSingleMachine();
        int numberOfMachines = NonBlockingElasticMachineProvisioningAdapter.calcNumberOfMachines(capacityRequirements, this.machineProvisioning);
        if (numberOfMachines < failedAgents.length) {
            throw new IllegalArgumentException("capacity requirements should be at least " + failedAgents.length + " machines for failure recovery. Instead found " + numberOfMachines + " machines, capacity = " + capacityRequirements);
        }
        FutureGridServiceAgent[] futureAgents = new FutureGridServiceAgent[numberOfMachines];
        for (int i = 0; i < futureAgents.length; ++i) {
            final AtomicReference<Object> ref = new AtomicReference<Object>(null);
            int throttlingDelay = i * 0;
            final long start = System.currentTimeMillis();
            final long end = start + (long)(throttlingDelay * 1000) + unit.toMillis(duration);
            final FailedGridServiceAgent failedAgent = failedAgents.length > i ? failedAgents[i] : null;
            this.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info((Object)"Starting a new machine");
                        StartedGridServiceAgent agent = NonBlockingElasticMachineProvisioningAdapter.this.machineProvisioning.startMachine(zones, reservationId, failedAgent, duration, unit);
                        ref.set(agent);
                        logger.info((Object)"New machine started");
                    }
                    catch (ElasticMachineProvisioningException e) {
                        ref.set(e);
                    }
                    catch (ElasticGridServiceAgentProvisioningException e) {
                        ref.set(e);
                    }
                    catch (InterruptedException e) {
                        ref.set(e);
                    }
                    catch (TimeoutException e) {
                        ref.set(e);
                    }
                    catch (NoClassDefFoundError e) {
                        ref.set(new NoClassDefFoundElasticMachineProvisioningException(e));
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Unexpected exception:" + e.getMessage()), e);
                        ref.set(e);
                    }
                }
            }, throttlingDelay, TimeUnit.SECONDS);
            futureAgents[i] = new FutureGridServiceAgent(){

                public boolean isDone() {
                    return System.currentTimeMillis() > end || ref.get() != null;
                }

                public ExecutionException getException() {
                    Object result = ref.get();
                    if (result != null && result instanceof Throwable) {
                        Throwable throwable = (Throwable)result;
                        return new ExecutionException(throwable.getMessage(), throwable);
                    }
                    return null;
                }

                public boolean isTimedOut() {
                    Object result = ref.get();
                    return System.currentTimeMillis() > end || result != null && result instanceof TimeoutException;
                }

                public Date getTimestamp() {
                    return new Date(start);
                }

                public StartedGridServiceAgent get() throws ExecutionException, IllegalStateException, TimeoutException {
                    Object result = ref.get();
                    if (result == null) {
                        if (System.currentTimeMillis() > end) {
                            throw new TimeoutException("Starting a new machine took more than " + unit.toSeconds(duration) + " seconds to complete.");
                        }
                        throw new IllegalStateException("Async operation is not done yet.");
                    }
                    if (this.getException() != null) {
                        throw this.getException();
                    }
                    return (StartedGridServiceAgent)result;
                }

                @Override
                public NonBlockingElasticMachineProvisioning getMachineProvisioning() {
                    return NonBlockingElasticMachineProvisioningAdapter.this;
                }

                @Override
                public CapacityRequirements getFutureCapacity() {
                    return singleMachineCapacity;
                }

                @Override
                public GSAReservationId getReservationId() {
                    return reservationId;
                }

                @Override
                public FailedGridServiceAgent getFailedGridServiceAgent() {
                    return failedAgent;
                }
            };
        }
        return futureAgents;
    }

    @Override
    public FutureStoppedMachine stopMachineAsync(final GridServiceAgent agent, final long duration, final TimeUnit unit) {
        final AtomicReference atomicExceptionRef = new AtomicReference();
        final AtomicBoolean atomicDone = new AtomicBoolean(false);
        if (!this.isStartMachineSupported()) {
            throw new UnsupportedOperationException();
        }
        final long start = System.currentTimeMillis();
        final long end = System.currentTimeMillis() + unit.toMillis(duration);
        final String hostAddress = agent.getMachine().getHostAddress();
        this.submit(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)("Stopping machine " + hostAddress));
                try {
                    NonBlockingElasticMachineProvisioningAdapter.this.machineProvisioning.stopMachine(new StartedGridServiceAgent(agent, null), duration, unit);
                    logger.info((Object)("machine " + hostAddress + " successfully stopped."));
                    atomicDone.set(true);
                }
                catch (ElasticMachineProvisioningException e) {
                    atomicExceptionRef.set(e);
                }
                catch (ElasticGridServiceAgentProvisioningException e) {
                    atomicExceptionRef.set(e);
                }
                catch (InterruptedException e) {
                    atomicExceptionRef.set(e);
                }
                catch (TimeoutException e) {
                    atomicExceptionRef.set(e);
                }
                catch (NoClassDefFoundError e) {
                    atomicExceptionRef.set(new NoClassDefFoundElasticMachineProvisioningException(e));
                }
                catch (Throwable e) {
                    atomicExceptionRef.set(e);
                }
            }
        });
        return new FutureStoppedMachine(){

            public boolean isTimedOut() {
                Throwable exception = (Throwable)atomicExceptionRef.get();
                return exception instanceof TimeoutException || !this.isDone() && System.currentTimeMillis() > end;
            }

            public boolean isDone() {
                return atomicDone.get() || atomicExceptionRef.get() != null;
            }

            public Date getTimestamp() {
                return new Date(start);
            }

            public ExecutionException getException() {
                ExecutionException executionException = null;
                Throwable throwable = (Throwable)atomicExceptionRef.get();
                if (throwable != null) {
                    executionException = new ExecutionException(throwable.getMessage(), throwable);
                }
                return executionException;
            }

            public Void get() throws ExecutionException, IllegalStateException, TimeoutException {
                if (!this.isDone()) {
                    throw new IllegalStateException("Async operation has not completed yet");
                }
                if (this.isDone() && this.getException() == null) {
                    return null;
                }
                throw this.getException();
            }

            @Override
            public GridServiceAgent getGridServiceAgent() {
                return agent;
            }
        };
    }

    private void submit(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    private void submit(final Runnable runnable, long delay, TimeUnit unit) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                NonBlockingElasticMachineProvisioningAdapter.this.submit(runnable);
            }
        }, delay, unit);
    }

    @Override
    public FutureGridServiceAgents getDiscoveredMachinesAsync(final long duration, final TimeUnit unit) {
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        final long start = System.currentTimeMillis();
        final long end = start + unit.toMillis(duration);
        this.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    GridServiceAgent[] agents = NonBlockingElasticMachineProvisioningAdapter.this.machineProvisioning.getDiscoveredMachines(duration, unit);
                    ref.set(agents);
                }
                catch (ElasticMachineProvisioningException e) {
                    ref.set(e);
                }
                catch (ElasticGridServiceAgentProvisioningException e) {
                    ref.set(e);
                }
                catch (InterruptedException e) {
                    ref.set(e);
                }
                catch (TimeoutException e) {
                    ref.set(e);
                }
                catch (NoClassDefFoundError e) {
                    ref.set(new NoClassDefFoundElasticMachineProvisioningException(e));
                }
                catch (Throwable e) {
                    logger.error((Object)"Unexpected exception", e);
                    ref.set(e);
                }
            }
        });
        return new FutureGridServiceAgents(){

            public boolean isDone() {
                return System.currentTimeMillis() > end || ref.get() != null;
            }

            public ExecutionException getException() {
                Object result = ref.get();
                if (result != null && result instanceof Throwable) {
                    Throwable throwable = (Throwable)result;
                    return new ExecutionException(throwable.getMessage(), throwable);
                }
                return null;
            }

            public boolean isTimedOut() {
                Object result = ref.get();
                return System.currentTimeMillis() > end || result != null && result instanceof TimeoutException;
            }

            public Date getTimestamp() {
                return new Date(start);
            }

            public GridServiceAgent[] get() throws ExecutionException, IllegalStateException, TimeoutException {
                Object result = ref.get();
                if (result == null) {
                    if (System.currentTimeMillis() > end) {
                        throw new TimeoutException("Starting a new machine took more than " + unit.toSeconds(duration) + " seconds to complete.");
                    }
                    throw new IllegalStateException("Async operation is not done yet.");
                }
                if (this.getException() != null) {
                    throw this.getException();
                }
                return (GridServiceAgent[])result;
            }
        };
    }

    @Override
    public ElasticMachineProvisioningConfig getConfig() {
        return this.machineProvisioning.getConfig();
    }

    @Override
    public boolean isStartMachineSupported() {
        return this.machineProvisioning.isStartMachineSupported();
    }

    private static int calcNumberOfMachines(CapacityRequirements capacityRequirements, ElasticMachineProvisioning machineProvisioning) {
        NumberOfMachinesCapacityRequirement numberOfMachinesCapacityRequirement = capacityRequirements.getRequirement(new NumberOfMachinesCapacityRequirement().getType());
        int maxNumberOfMachines = Math.max(1, numberOfMachinesCapacityRequirement.getNumberOfMachines());
        CapacityRequirements singleMachineCapacityRequirements = machineProvisioning.getCapacityOfSingleMachine().subtractOrZero(machineProvisioning.getConfig().getReservedCapacityPerMachine());
        for (CapacityRequirement capacityRequirement : capacityRequirements.getRequirements()) {
            int numberOfMachines;
            CapacityRequirement singleMachinecapacityRequirement = singleMachineCapacityRequirements.getRequirement(capacityRequirement.getType());
            if (singleMachinecapacityRequirement.equalsZero() || (numberOfMachines = (int)Math.ceil(capacityRequirement.divide(singleMachinecapacityRequirement))) <= maxNumberOfMachines) continue;
            maxNumberOfMachines = numberOfMachines;
        }
        logger.info((Object)(maxNumberOfMachines + " machines are required in order to satisfy capacity requirements: " + capacityRequirements));
        return maxNumberOfMachines;
    }

    @Override
    public FutureCleanupCloudResources cleanupCloudResources(final long duration, final TimeUnit unit) {
        final AtomicReference atomicExceptionRef = new AtomicReference();
        final AtomicBoolean atomicDone = new AtomicBoolean(false);
        if (!this.isStartMachineSupported()) {
            throw new UnsupportedOperationException();
        }
        final long start = System.currentTimeMillis();
        final long end = System.currentTimeMillis() + unit.toMillis(duration);
        this.submit(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Cleaning cloud resources");
                try {
                    NonBlockingElasticMachineProvisioningAdapter.this.machineProvisioning.cleanupMachineResources(duration, unit);
                    logger.info((Object)"Cleaned cloud resources.");
                    atomicDone.set(true);
                }
                catch (ElasticMachineProvisioningException e) {
                    atomicExceptionRef.set(e);
                }
                catch (InterruptedException e) {
                    atomicExceptionRef.set(e);
                }
                catch (TimeoutException e) {
                    atomicExceptionRef.set(e);
                }
                catch (NoClassDefFoundError e) {
                    atomicExceptionRef.set(new NoClassDefFoundElasticMachineProvisioningException(e));
                }
                catch (Throwable e) {
                    atomicExceptionRef.set(e);
                }
            }
        });
        return new FutureCleanupCloudResources(){
            boolean mark;

            public boolean isTimedOut() {
                Throwable exception = (Throwable)atomicExceptionRef.get();
                return exception instanceof TimeoutException || !this.isDone() && System.currentTimeMillis() > end;
            }

            public boolean isDone() {
                return atomicDone.get() || atomicExceptionRef.get() != null;
            }

            public Date getTimestamp() {
                return new Date(start);
            }

            public ExecutionException getException() {
                ExecutionException executionException = null;
                Throwable throwable = (Throwable)atomicExceptionRef.get();
                if (throwable != null) {
                    executionException = new ExecutionException(throwable.getMessage(), throwable);
                }
                return executionException;
            }

            public Void get() throws ExecutionException, IllegalStateException, TimeoutException {
                if (!this.isDone()) {
                    throw new IllegalStateException("Async operation has not completed yet");
                }
                if (this.isDone() && this.getException() == null) {
                    return null;
                }
                throw this.getException();
            }

            @Override
            public boolean isMarked() {
                return this.mark;
            }

            @Override
            public void mark() {
                this.mark = true;
            }
        };
    }

    @Override
    public void setElasticProcessingUnitMachineIsolation(ElasticProcessingUnitMachineIsolation isolation) {
        this.machineProvisioning.setElasticProcessingUnitMachineIsolation(isolation);
    }

    @Override
    public void setElasticMachineProvisioningProgressChangedEventListener(ElasticMachineProvisioningProgressChangedEventListener machineEventListener) {
        this.machineProvisioning.setElasticMachineProvisioningProgressChangedEventListener(machineEventListener);
    }

    @Override
    public void setElasticGridServiceAgentProvisioningProgressEventListener(ElasticGridServiceAgentProvisioningProgressChangedEventListener agentEventListener) {
        this.machineProvisioning.setElasticGridServiceAgentProvisioningProgressEventListener(agentEventListener);
    }

    public ElasticMachineProvisioning getElasticMachineProvisioning() {
        return this.machineProvisioning;
    }
}

