/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines.plugins;

import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.openspaces.grid.gsm.machines.plugins.ElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioningAdapter;

public class NonBlockingElasticMachineProvisioningAdapterFactory {
    private static final int MIN_THREADS = 1;
    private static final int MAX_THREADS = Integer.getInteger("org.openspaces.esm.machine_provisioning_max_threads", 64);
    private static final long KEEP_ALIVE_TIME = TimeUnit.SECONDS.toMillis(60L);
    private final ThreadFactory threadFactory = new GSThreadFactory(this.getClass().getName(), true);
    private ExecutorService service = DynamicExecutors.newScalingThreadPool((int)1, (int)MAX_THREADS, (long)KEEP_ALIVE_TIME, (ThreadFactory)this.threadFactory);
    private ScheduledThreadPoolExecutor scheduledExecutorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, this.threadFactory);

    public NonBlockingElasticMachineProvisioningAdapter create(ElasticMachineProvisioning machineProvisioning) {
        return new NonBlockingElasticMachineProvisioningAdapter(machineProvisioning, this.service, this.scheduledExecutorService);
    }

    public void destroy() {
        this.service.shutdownNow();
        this.scheduledExecutorService.shutdownNow();
    }
}

