/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CpuCapacityRequirement;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.rebalancing.FutureStatefulProcessingUnitInstance;
import org.openspaces.grid.gsm.rebalancing.FutureStatelessProcessingUnitInstance;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementState;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaPolicy;
import org.openspaces.grid.gsm.rebalancing.RebalancingUtils;
import org.openspaces.grid.gsm.rebalancing.exceptions.FutureProcessingUnitInstanceDeploymentException;
import org.openspaces.grid.gsm.rebalancing.exceptions.NumberOfInstancesIsBelowMinimumException;
import org.openspaces.grid.gsm.rebalancing.exceptions.NumberOfInstancesPerPartitionIsBelowMinimumException;
import org.openspaces.grid.gsm.rebalancing.exceptions.ProcessingUnitIsNotEvenlyDistributedAccrossMachinesException;
import org.openspaces.grid.gsm.rebalancing.exceptions.ProcessingUnitIsNotEvenlyDistributedAcrossContainersException;
import org.openspaces.grid.gsm.rebalancing.exceptions.ProcessingUnitIsNotInTactException;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.rebalancing.exceptions.WrongContainerProcessingUnitRelocationException;

class DefaultRebalancingSlaEnforcementEndpoint
implements RebalancingSlaEnforcementEndpoint {
    private static final Fraction MIN_CPU_CORES_PER_MACHINE_FOR_REBALANCING = new Fraction(1, 100);
    private static final long STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.stateful_deployment_timeout_seconds", 3600L);
    private static final long STATELESS_DEPLOYMENT_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.stateless_deployment_timeout_seconds", 300L);
    private static final long STATEFUL_DEPLOYMENT_FAILURE_FORGET_SECONDS = Long.getLong("org.openspaces.grid.stateful_deployment_failure_forget_seconds", 60L);
    private static final long STATELESS_DEPLOYMENT_FAILURE_FORGET_SECONDS = Long.getLong("org.openspaces.grid.stateless_deployment_failure_forget_seconds", 60L);
    private final ProcessingUnit pu;
    private final RebalancingSlaEnforcementState state;
    private final Log logger;
    private int lastResortPartitionRestart = 0;
    private int lastResortPartitionRelocate = 0;
    private int lastPartitionToRelocateWhenCompromised = 0;

    DefaultRebalancingSlaEnforcementEndpoint(ProcessingUnit pu, RebalancingSlaEnforcementState state) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null");
        }
        this.pu = pu;
        this.state = state;
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(DefaultRebalancingSlaEnforcementEndpoint.class)), pu);
    }

    public ProcessingUnit getProcessingUnit() {
        return this.pu;
    }

    @Override
    public void enforceSla(RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        if (this.state.isDestroyedProcessingUnit(this.pu)) {
            throw new IllegalStateException("endpoint destroyed");
        }
        if (sla == null) {
            throw new IllegalArgumentException("sla cannot be null");
        }
        sla.validate();
        for (GridServiceContainer container : sla.getContainers()) {
            if (container.getGridServiceAgent() == null) {
                throw new IllegalStateException("container " + RebalancingUtils.gscToString(container) + " has no agent.");
            }
            String agentUid = container.getGridServiceAgent().getUid();
            if (!sla.getAllocatedCapacity().getAgentUids().contains(agentUid)) {
                throw new IllegalArgumentException("List of agents must be a superset of agents that started the containers, agentUids=" + sla.getAllocatedCapacity().getAgentUids().toString() + " does not include agent " + agentUid);
            }
            if (!sla.getAllocatedCapacity().getAgentCapacity(agentUid).getRequirement(new CpuCapacityRequirement().getType()).equalsZero()) continue;
            sla.setAllocatedCapacity(sla.getAllocatedCapacity().add(agentUid, new CapacityRequirements(new CpuCapacityRequirement(MIN_CPU_CORES_PER_MACHINE_FOR_REBALANCING))));
            if (!sla.isEager()) continue;
            if (Boolean.valueOf(System.getProperty("org.openspaces.grid.esm.disableCPURebalancingIfZeroCPU", "true")).booleanValue()) {
                this.logger.warn((Object)("Disabling CPU Rebalancing for pu " + RebalancingUtils.processingUnitDeploymentToString(this.pu) + " since machine with agentUid=" + agentUid + " reported to have 0 available processors. Once this problem is fixed, restart the ESM and CPU re-balancing will be enabled"));
                sla.ignoreCpuRebalancing(true);
                continue;
            }
            this.logger.warn((Object)("Machine with agentUid=" + agentUid + " reported to have 0 available processors. PU details: " + RebalancingUtils.processingUnitDeploymentToString(this.pu) + ". org.openspaces.grid.esm.disableCPURebalancingIfZeroCPU is enabled therefore CPU rebalancing won't be disabled"));
        }
        String zone = this.pu.getRequiredZones()[0];
        for (GridServiceContainer container : sla.getContainers()) {
            Set<String> zones = container.getZones().keySet();
            if (zones.size() != 1) {
                throw new IllegalArgumentException("Container " + RebalancingUtils.gscToString(container) + " must have exactly one zone.");
            }
            if (zones.contains(zone)) continue;
            throw new IllegalArgumentException("Container " + RebalancingUtils.gscToString(container) + " must have the zone " + zone);
        }
        this.enforceSlaInternal(sla);
    }

    private void enforceSlaInternal(RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        this.cleanFutureStatefulDeployments();
        this.cleanFutureStatelessDeployments();
        this.cleanRemovedStatelessProcessingUnitInstances();
        if (sla.getSchemaConfig().isPartitionedSync2BackupSchema()) {
            this.enforceSlaStatefulProcessingUnit(sla);
        } else if (sla.getSchemaConfig().isDefaultSchema()) {
            this.enforceSlaStatelessProcessingUnit(sla);
        } else {
            throw new IllegalStateException(this.pu.getName() + " schema " + sla.getSchemaConfig().getSchema() + " is not supported.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.pu.getName() + " rebalancing is complete"));
        }
    }

    private void enforceSlaStatelessProcessingUnit(RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        GridServiceContainer[] containers = sla.getContainers();
        if (this.state.getRemovedStatelessProcessingUnitInstances(this.pu).size() == 0 || this.pu.getInstances().length < sla.getMinimumNumberOfInstancesPerPartition()) {
            this.increasePlannedInstancesUntilDeployedOnApprovedContainers(containers);
        }
        if (this.pu.getInstances().length < sla.getMinimumNumberOfInstancesPerPartition()) {
            throw new NumberOfInstancesIsBelowMinimumException(this.pu, sla.getMinimumNumberOfInstancesPerPartition());
        }
        this.decreasePlannedInstancesIfMoreThanAllContainers(sla);
        this.removeInstancesNotOnApprovedContainers(sla, containers);
        if (!RebalancingUtils.isProcessingUnitIntact(this.pu, containers)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Rebalancing incomplete since not all instances of " + this.pu.getName() + " are accounted for. Containers marked for deallocation: " + ContainersSlaUtils.gscsToString(sla.getContainersMarkedForDeallocation())));
            }
            throw new ProcessingUnitIsNotInTactException(this.pu);
        }
    }

    private void increasePlannedInstancesUntilDeployedOnApprovedContainers(GridServiceContainer[] containers) throws ProcessingUnitIsNotEvenlyDistributedAcrossContainersException {
        if (this.state.getNumberOfFutureDeployments(this.pu) > 0) {
            throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances deployment is in progress", this.pu, containers);
        }
        Collection<FutureStatelessProcessingUnitInstance> futureInstances = RebalancingUtils.incrementNumberOfStatelessInstancesAsync(this.pu, containers, this.logger, STATELESS_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        this.state.addFutureStatelessDeployments(futureInstances);
        if (this.state.getNumberOfFutureDeployments(this.pu) > 0) {
            throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances deployment is in progress", this.pu, containers);
        }
    }

    private void removeInstancesNotOnApprovedContainers(RebalancingSlaPolicy sla, GridServiceContainer[] containers) throws ProcessingUnitIsNotEvenlyDistributedAcrossContainersException {
        HashSet<GridServiceContainer> approvedContainers = new HashSet<GridServiceContainer>(Arrays.asList(containers));
        ArrayList<ProcessingUnitInstance> instancesToRemove = new ArrayList<ProcessingUnitInstance>();
        for (GridServiceContainer container : this.pu.getAdmin().getGridServiceContainers()) {
            if (approvedContainers.contains(container)) continue;
            for (ProcessingUnitInstance instance : container.getProcessingUnitInstances(this.pu.getName())) {
                instancesToRemove.add(instance);
            }
        }
        if (instancesToRemove.size() > 0) {
            for (ProcessingUnitInstance instanceToRemove : instancesToRemove) {
                if (this.pu.getInstances().length - this.state.getRemovedStatelessProcessingUnitInstances(this.pu).size() <= sla.getMinimumNumberOfInstancesPerPartition()) {
                    this.logger.info((Object)("Not removing pu instance " + RebalancingUtils.puInstanceToString(instanceToRemove) + " even though deployed on an unapproved container. #instances=" + this.pu.getInstances().length + "-" + this.state.getRemovedStatelessProcessingUnitInstances(this.pu).size() + " #minInstances=" + sla.getMinimumNumberOfInstancesPerPartition()));
                    break;
                }
                this.removeInstance(instanceToRemove);
            }
            throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances removal is in progress", this.pu, containers);
        }
        if (this.state.getRemovedStatelessProcessingUnitInstances(this.pu).iterator().hasNext()) {
            throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances removal is in progress", this.pu, containers);
        }
    }

    private void decreasePlannedInstancesIfMoreThanAllContainers(RebalancingSlaPolicy sla) throws ProcessingUnitIsNotInTactException {
        int totalContainers;
        final int numberOfInstancesBeforeDecrement = this.pu.getNumberOfInstances();
        if (numberOfInstancesBeforeDecrement > (totalContainers = RebalancingUtils.getContainersOnMachines(this.pu).length) && numberOfInstancesBeforeDecrement > sla.getMinimumNumberOfInstancesPerPartition()) {
            ((InternalAdmin)this.pu.getAdmin()).scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean decremented = ((InternalProcessingUnit)DefaultRebalancingSlaEnforcementEndpoint.this.pu).decrementPlannedInstances();
                        if (decremented) {
                            DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Planned number of instances is " + numberOfInstancesBeforeDecrement + " instead of " + totalContainers + ". Removed one pu instance of " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName()));
                        } else if (DefaultRebalancingSlaEnforcementEndpoint.this.logger.isInfoEnabled()) {
                            DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Number of instances is " + numberOfInstancesBeforeDecrement + " instead of " + totalContainers + ". Retry to remove one pu instance of " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName() + " next time."));
                        }
                    }
                    catch (AdminException e) {
                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Failed to decrement planned number of instances for " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName()), (Throwable)e);
                    }
                    catch (Throwable t) {
                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.warn((Object)("Unexpected exception when decrementing planned number of instances for " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName()), t);
                    }
                }
            });
            throw new ProcessingUnitIsNotInTactException(this.pu, "Planned number of instances is " + numberOfInstancesBeforeDecrement + " instead of " + totalContainers);
        }
    }

    private void removeInstance(final ProcessingUnitInstance instance) {
        if (!this.state.isStatelessProcessingUnitInstanceBeingRemoved(instance)) {
            this.state.addRemovedStatelessProcessingUnitInstance(instance);
            ((InternalAdmin)this.pu.getAdmin()).scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("removing pu instance " + RebalancingUtils.puInstanceToString(instance) + " since deployed on an unapproved container"));
                        instance.decrement();
                    }
                    catch (AdminException e) {
                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Failed to remove instance " + RebalancingUtils.puInstanceToString(instance)), (Throwable)e);
                        DefaultRebalancingSlaEnforcementEndpoint.this.state.removeRemovedStatelessProcessingUnitInstance(instance);
                    }
                    catch (Throwable t) {
                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.warn((Object)("Unexpected exception when removing " + RebalancingUtils.puInstanceToString(instance)), t);
                        DefaultRebalancingSlaEnforcementEndpoint.this.state.removeRemovedStatelessProcessingUnitInstance(instance);
                    }
                }
            });
        }
    }

    private void enforceSlaStatefulProcessingUnit(RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        if (!RebalancingUtils.isProcessingUnitHasMinimumNumberOfInstancesPerPartition(this.pu, sla.getMinimumNumberOfInstancesPerPartition())) {
            throw new NumberOfInstancesPerPartitionIsBelowMinimumException(this.pu, sla.getMinimumNumberOfInstancesPerPartition());
        }
        if (!RebalancingUtils.isProcessingUnitIntact(this.pu)) {
            if (this.pu.getStatus().equals((Object)DeploymentStatus.COMPROMISED)) {
                this.rebalanceDueToCompromisedInstances(sla.getContainers(), sla);
            }
            throw new ProcessingUnitIsNotInTactException(this.pu, "Skipping enforce SLA until all instances of " + this.pu.getName() + " are accounted for. " + RebalancingUtils.getProcessingUnitIntactDescription(this.pu, this.pu.getAdmin().getGridServiceContainers().getContainers()));
        }
        GridServiceContainer[] containers = sla.getContainers();
        if (this.pu.getNumberOfBackups() == 1) {
            this.rebalanceNumberOfInstancesPerContainer(containers, sla, true);
            if (this.state.getNumberOfFutureDeployments(this.pu) > 0) {
                this.logger.debug((Object)("Rebalancing of backup instances is in progress after Stage 1. Number of deployments in progress is " + this.state.getNumberOfFutureDeployments(this.pu)));
                throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances deployment is in progress", this.pu, containers);
            }
            boolean processingUnitIntact = RebalancingUtils.isProcessingUnitIntact(this.pu, containers);
            boolean ignoreCpuRebalancing = sla.ignoreCpuRebalancing();
            if (!processingUnitIntact) {
                this.logger.debug((Object)"Not re-balancing according to CPU since processing unit is not intact");
            }
            if (ignoreCpuRebalancing) {
                this.logger.debug((Object)("Not re-balancing according to CPU since 'sla.ignoreCpuRebalancing()' is set to true for SLA " + sla));
            }
            if (processingUnitIntact && !ignoreCpuRebalancing) {
                this.rebalanceNumberOfPrimaryInstancesPerMachine(containers, sla);
                if (this.state.getNumberOfFutureDeployments(this.pu) > 0) {
                    this.logger.debug((Object)("Restarting of primary instances is in progress after Stage 2. Number of deployments in progress is " + this.state.getNumberOfFutureDeployments(this.pu)));
                    throw new ProcessingUnitIsNotEvenlyDistributedAccrossMachinesException(this.pu);
                }
            }
        }
        this.rebalanceNumberOfInstancesPerContainer(containers, sla, false);
        if (this.state.getNumberOfFutureDeployments(this.pu) > 0) {
            this.logger.debug((Object)("Rebalancing of primary or backup instances is in progress after Stage 3. Number of deployments in progress is " + this.state.getNumberOfFutureDeployments(this.pu)));
            throw new ProcessingUnitIsNotEvenlyDistributedAcrossContainersException("Instances deployment is in progress", this.pu, containers);
        }
        if (!RebalancingUtils.isProcessingUnitIntact(this.pu, containers)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Rebalancing incomplete since not all instances of " + this.pu.getName() + " are accounted for. Containers marked for deallocation: " + ContainersSlaUtils.gscsToString(sla.getContainersMarkedForDeallocation())));
            }
            throw new ProcessingUnitIsNotInTactException(this.pu);
        }
    }

    private void rebalanceDueToCompromisedInstances(GridServiceContainer[] containers, RebalancingSlaPolicy sla) {
        FutureStatefulProcessingUnitInstance futureInstance;
        while ((futureInstance = this.rebalanceDueToCompromisedInstancesStep(containers, sla.getMaximumNumberOfConcurrentRelocationsPerMachine(), sla.isAtMostOneConcurrentRelocation())) != null) {
            this.state.addFutureStatefulDeployment(futureInstance);
        }
    }

    private FutureStatefulProcessingUnitInstance rebalanceDueToCompromisedInstancesStep(GridServiceContainer[] containers, int maximumNumberOfRelocationsPerMachine, boolean atMostOneConcurrentRelocation) {
        if (this.pu.getMaxInstancesPerVM() == 0 || this.pu.getMaxInstancesPerMachine() == 0 || this.pu.getNumberOfBackups() == 0 || this.state.getNumberOfFutureDeployments(this.pu) > 0 || RebalancingUtils.isProcessingUnitIntact(this.pu)) {
            return null;
        }
        List<GridServiceContainer> sortedContainers = RebalancingUtils.sortAllContainersByNumberOfInstancesAboveMinimum(this.pu, containers);
        if (sortedContainers.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No containers available, can't resolve COMPROMISED state");
            }
            return null;
        }
        GridServiceContainer emptyContainer = sortedContainers.get(0);
        if (emptyContainer.getProcessingUnitInstances().length != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No empty container found to resolve COMPROMISED state; container with least instances: " + RebalancingUtils.gscToString(emptyContainer)));
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to re-balance due to compromised state; Found empty container: " + RebalancingUtils.gscToString(emptyContainer) + ". Containers sorted by least number of instances: " + RebalancingUtils.gscsToString(sortedContainers)));
        }
        if (this.isConflictingDeploymentInProgress(emptyContainer, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cannot relocate instances to empty container: " + RebalancingUtils.gscToString(emptyContainer) + " since a conflicting relocation is already in progress."));
            }
            return null;
        }
        while (this.lastPartitionToRelocateWhenCompromised <= this.pu.getNumberOfInstances() - 1) {
            ProcessingUnitInstance candidateInstance;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Trying to relocate a backup from partition " + this.lastPartitionToRelocateWhenCompromised));
            }
            if ((candidateInstance = this.pu.getPartition(this.lastPartitionToRelocateWhenCompromised).getBackup()) != null) {
                GridServiceContainer source = candidateInstance.getGridServiceContainer();
                int instancesInSource = source.getProcessingUnitInstances(this.pu.getName()).length;
                int plannedMinimumNumberOfInstancesForSource = RebalancingUtils.getPlannedMinimumNumberOfInstancesForContainer(source, containers, this.pu);
                if (candidateInstance.getSpaceInstance() == null) {
                    this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since embedded space is not detected"));
                } else if (candidateInstance.getSpaceInstance().getMode() != SpaceMode.BACKUP) {
                    this.logger.debug((Object)("Prefer not to relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since it is not a backup, and backups are preferred for relocation"));
                } else {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Candidate for re-location is " + RebalancingUtils.puInstanceToString(candidateInstance) + " from source " + RebalancingUtils.gscToString(source)));
                    }
                    for (GridServiceContainer target : sortedContainers) {
                        int numberOfOtherInstancesFromPartitionInTargetMachine;
                        int numberOfOtherInstancesFromPartitionInTargetContainer;
                        int plannedMaximumNumberOfInstancesForTarget;
                        if (target.getMachine().equals(source.getMachine())) {
                            this.logger.debug((Object)("Not re-locating " + RebalancingUtils.puInstanceToString(candidateInstance) + " to " + ContainersSlaUtils.gscToString(target) + " since containers are on the same host."));
                            continue;
                        }
                        if (this.isConflictingDeploymentInProgress(target, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) {
                            this.logger.debug((Object)("Cannot relocate instances to " + RebalancingUtils.gscToString(target) + " since a conflicting relocation is already in progress."));
                            continue;
                        }
                        int instancesInTarget = target.getProcessingUnitInstances(this.pu.getName()).length;
                        if (instancesInTarget >= (plannedMaximumNumberOfInstancesForTarget = RebalancingUtils.getPlannedMaximumNumberOfInstancesForContainer(target, containers, this.pu))) {
                            this.logger.debug((Object)("Not re-locating " + RebalancingUtils.puInstanceToString(candidateInstance) + " to " + ContainersSlaUtils.gscToString(target) + " since target container cannot host any more instances. Instances in target: " + instancesInTarget + " maximum planned: " + plannedMaximumNumberOfInstancesForTarget));
                            continue;
                        }
                        if (this.pu.getMaxInstancesPerVM() > 0 && (numberOfOtherInstancesFromPartitionInTargetContainer = RebalancingUtils.getOtherInstancesFromSamePartitionInContainer(target, candidateInstance).size()) >= this.pu.getMaxInstancesPerVM()) {
                            this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since container already hosts " + numberOfOtherInstancesFromPartitionInTargetContainer + " instance(s) from the same partition."));
                            continue;
                        }
                        if (this.pu.getMaxInstancesPerMachine() > 0 && (numberOfOtherInstancesFromPartitionInTargetMachine = RebalancingUtils.getOtherInstancesFromSamePartitionInMachine(target.getMachine(), candidateInstance).size()) >= this.pu.getMaxInstancesPerMachine()) {
                            this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since machine already contains " + numberOfOtherInstancesFromPartitionInTargetMachine + " instance(s) from the same partition."));
                            continue;
                        }
                        this.logger.info((Object)("Relocating " + RebalancingUtils.puInstanceToString(candidateInstance) + " of partition " + this.lastPartitionToRelocateWhenCompromised + " from " + RebalancingUtils.gscToString(source) + " with " + source.getProcessingUnitInstances().length + " instances to " + RebalancingUtils.gscToString(target) + " with " + target.getProcessingUnitInstances().length + " instances due to compromised state."));
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(this.pu.getName() + "; instancesInSource: " + instancesInSource + " PlannedMinimumNumberOfInstances for source: " + plannedMinimumNumberOfInstancesForSource + " instancesInTarget: " + instancesInTarget + " PlannedMaximumNumberOfInstances for target: " + plannedMaximumNumberOfInstancesForTarget + "; Current state is " + RebalancingUtils.processingUnitDeploymentToString(this.pu)));
                        }
                        return RebalancingUtils.relocateProcessingUnitInstanceAsync(target, candidateInstance, this.logger, STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                    }
                }
            }
            ++this.lastPartitionToRelocateWhenCompromised;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Haven't found any partition to relocate and resolve compromised state; will try again next iteration.");
        }
        if (this.lastPartitionToRelocateWhenCompromised > this.pu.getNumberOfInstances() - 1) {
            this.lastPartitionToRelocateWhenCompromised = 0;
        }
        return null;
    }

    private void rebalanceNumberOfInstancesPerContainer(GridServiceContainer[] containers, RebalancingSlaPolicy sla, boolean relocateOnlyBackups) throws RebalancingSlaEnforcementInProgressException {
        FutureStatefulProcessingUnitInstance futureInstance;
        this.logger.debug((Object)("Trying to re-balance number of instances per container. relocateOnlyBackups=" + relocateOnlyBackups));
        while ((futureInstance = this.rebalanceNumberOfInstancesPerContainerStep(containers, relocateOnlyBackups, sla.getMaximumNumberOfConcurrentRelocationsPerMachine(), sla.isAtMostOneConcurrentRelocation(), sla.getContainersMarkedForDeallocation())) != null) {
            this.state.addFutureStatefulDeployment(futureInstance);
        }
    }

    private FutureStatefulProcessingUnitInstance rebalanceNumberOfInstancesPerContainerStep(GridServiceContainer[] containers, boolean onlyBackups, int maximumNumberOfRelocationsPerMachine, boolean atMostOneConcurrentRelocation, Collection<GridServiceContainer> containersMarkedForDeallocation) throws RebalancingSlaEnforcementInProgressException {
        List<GridServiceContainer> sortedContainers = RebalancingUtils.sortAllContainersByNumberOfInstancesAboveMinimum(this.pu, containers);
        this.logger.debug((Object)("Containers sorted by number of instances above minimum: " + RebalancingUtils.gscsToString(sortedContainers)));
        boolean conflict = false;
        block0: for (int targetIndex = 0; targetIndex < sortedContainers.size(); ++targetIndex) {
            int plannedMaximumNumberOfInstancesForTarget;
            GridServiceContainer target = sortedContainers.get(targetIndex);
            this.logger.trace((Object)("Considering target container for re-location as " + ContainersSlaUtils.gscToString(target)));
            if (this.isConflictingDeploymentInProgress(target, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) {
                conflict = true;
                this.logger.debug((Object)("Cannot relocate instances to " + RebalancingUtils.gscToString(target) + " since a conflicting relocation is already in progress."));
                continue;
            }
            int instancesInTarget = target.getProcessingUnitInstances(this.pu.getName()).length;
            if (instancesInTarget >= (plannedMaximumNumberOfInstancesForTarget = RebalancingUtils.getPlannedMaximumNumberOfInstancesForContainer(target, containers, this.pu))) {
                this.logger.debug((Object)("Cannot relocate instances to " + RebalancingUtils.gscToString(target) + " since the target cannot host any more instances. Instances in target: " + instancesInTarget + " maximum planned: " + plannedMaximumNumberOfInstancesForTarget));
                break;
            }
            if (containersMarkedForDeallocation.contains(target)) {
                this.logger.info((Object)("Cannot relocate instance to " + RebalancingUtils.gscToString(target) + " since it is marked for deallocation."));
                continue;
            }
            for (int sourceIndex = sortedContainers.size() - 1; sourceIndex > targetIndex; --sourceIndex) {
                int plannedMinimumNumberOfInstancesForSource;
                final GridServiceContainer source = sortedContainers.get(sourceIndex);
                this.logger.trace((Object)("Considering source container for re-location as " + ContainersSlaUtils.gscToString(source)));
                if (this.isConflictingDeploymentInProgress(source, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) {
                    conflict = true;
                    this.logger.debug((Object)("Cannot relocate instances from " + RebalancingUtils.gscToString(source) + " since a conflicting relocation is already in progress."));
                    continue;
                }
                int instancesInSource = source.getProcessingUnitInstances(this.pu.getName()).length;
                if (instancesInSource <= (plannedMinimumNumberOfInstancesForSource = RebalancingUtils.getPlannedMinimumNumberOfInstancesForContainer(source, containers, this.pu))) {
                    this.logger.debug((Object)("Cannot relocate instances from " + RebalancingUtils.gscToString(source) + " since the source cannot give up any instances. Instances in source: " + instancesInSource + " minimum planned: " + plannedMinimumNumberOfInstancesForSource));
                    continue block0;
                }
                int plannedMinimumNumberOfInstancesForTarget = RebalancingUtils.getPlannedMinimumNumberOfInstancesForContainer(target, containers, this.pu);
                int plannedMaximumNumberOfInstancesForSource = RebalancingUtils.getPlannedMaximumNumberOfInstancesForContainer(source, containers, this.pu);
                if (instancesInTarget >= plannedMinimumNumberOfInstancesForTarget && instancesInSource <= plannedMaximumNumberOfInstancesForSource) {
                    this.logger.debug((Object)("No use relocating instances from " + RebalancingUtils.gscToString(source) + " to " + RebalancingUtils.gscToString(target) + " since they are both balanced. Instances in target: " + instancesInTarget + " minimum planned: " + plannedMinimumNumberOfInstancesForTarget + "; Instances in source : " + instancesInSource + " maximum planned: " + plannedMaximumNumberOfInstancesForSource));
                    continue block0;
                }
                for (ProcessingUnitInstance candidateInstance : source.getProcessingUnitInstances(this.pu.getName())) {
                    int numberOfOtherInstancesFromPartitionInTargetMachine;
                    int numberOfOtherInstancesFromPartitionInTargetContainer;
                    this.logger.trace((Object)("Candidate from " + RebalancingUtils.gscToString(source) + " for re-location is " + RebalancingUtils.puInstanceToString(candidateInstance)));
                    if (candidateInstance.getSpaceInstance() == null) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since embedded space is not detected"));
                        continue;
                    }
                    if (onlyBackups && candidateInstance.getSpaceInstance().getMode() != SpaceMode.BACKUP) {
                        this.logger.debug((Object)("Prefer not to relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since it is not a backup, and backups are preferred for relocation"));
                        continue;
                    }
                    if (!RebalancingUtils.isProcessingUnitPartitionIntact(candidateInstance)) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since instances from the same partition are missing"));
                        conflict = true;
                        continue;
                    }
                    if (this.isConflictingStatefulDeploymentInProgress(candidateInstance)) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since another instance from the same partition is being relocated"));
                        conflict = true;
                        continue;
                    }
                    for (Machine sourceReplicationMachine : RebalancingUtils.getMachinesHostingContainers(RebalancingUtils.getReplicationSourceContainers(candidateInstance))) {
                        if (!this.isConflictingOperationInProgress(sourceReplicationMachine, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) continue;
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since replication source is on machine " + RebalancingUtils.machineToString(sourceReplicationMachine) + " which is busy with another relocation"));
                        conflict = true;
                    }
                    if (this.pu.isRequiresIsolation() && target.getProcessingUnitInstances().length != 0) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since container already hosts an instance and processing unit requires isolation"));
                        continue;
                    }
                    if (this.pu.getMaxInstancesPerVM() > 0 && (numberOfOtherInstancesFromPartitionInTargetContainer = RebalancingUtils.getOtherInstancesFromSamePartitionInContainer(target, candidateInstance).size()) >= this.pu.getMaxInstancesPerVM()) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since container already hosts " + numberOfOtherInstancesFromPartitionInTargetContainer + " instance(s) from the same partition."));
                        continue;
                    }
                    if (this.pu.getMaxInstancesPerMachine() > 0 && (numberOfOtherInstancesFromPartitionInTargetMachine = RebalancingUtils.getOtherInstancesFromSamePartitionInMachine(target.getMachine(), candidateInstance).size()) >= this.pu.getMaxInstancesPerMachine()) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since machine already contains " + numberOfOtherInstancesFromPartitionInTargetMachine + " instance(s) from the same partition."));
                        if (source.getProcessingUnitInstances().length != 1 || !containersMarkedForDeallocation.contains(source)) continue;
                        ((InternalAdmin)this.pu.getAdmin()).scheduleAdminOperation(new Runnable(){

                            @Override
                            public void run() {
                                boolean hasAtMostOneProcessingUnitInstances;
                                boolean bl = hasAtMostOneProcessingUnitInstances = source.getProcessingUnitInstances().length <= 1;
                                if (hasAtMostOneProcessingUnitInstances) {
                                    DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Killing container " + ContainersSlaUtils.gscToString(source) + " since it is marked for deallocation."));
                                    try {
                                        source.kill();
                                    }
                                    catch (Exception e) {
                                        DefaultRebalancingSlaEnforcementEndpoint.this.logger.warn((Object)("Failed to kill container " + ContainersSlaUtils.gscToString(source)), (Throwable)e);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    this.logger.info((Object)("Relocating " + RebalancingUtils.puInstanceToString(candidateInstance) + " from " + RebalancingUtils.gscToString(source) + " with " + source.getProcessingUnitInstances().length + " instances to " + RebalancingUtils.gscToString(target) + " with " + target.getProcessingUnitInstances().length + " instances due to rebalance."));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(this.pu.getName() + " instancesInSource: " + instancesInSource + " PlannedMinimumNumberOfInstances for source: " + plannedMinimumNumberOfInstancesForSource + " PlannedMaximumNumberOfInstances for source: " + plannedMaximumNumberOfInstancesForSource + "; instancesInTarget: " + instancesInTarget + " PlannedMinimumNumberOfInstances for target: " + plannedMinimumNumberOfInstancesForTarget + " PlannedMaximumNumberOfInstances for target: " + plannedMaximumNumberOfInstancesForTarget + "; Current state is " + RebalancingUtils.processingUnitDeploymentToString(this.pu)));
                    }
                    return RebalancingUtils.relocateProcessingUnitInstanceAsync(target, candidateInstance, this.logger, STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                }
            }
        }
        if (!onlyBackups && this.pu.getNumberOfBackups() > 0 && this.state.getNumberOfFutureDeployments(this.pu) == 0 && RebalancingUtils.isProcessingUnitIntact(this.pu) && !RebalancingUtils.isEvenlyDistributedAcrossContainers(this.pu, containers)) {
            this.logger.debug((Object)("Optimal rebalancing heuristics failed balancing instances per container in this deployment. Performing non-optimal relocation heuristics. Will try to re-locate only backups. Starting with partition " + this.lastResortPartitionRelocate + ". Current deployment state is " + RebalancingUtils.processingUnitDeploymentToString(this.pu)));
            while (this.lastResortPartitionRelocate <= this.pu.getNumberOfInstances() - 1) {
                this.logger.trace((Object)("Trying to relocate a backup from partition " + this.lastResortPartitionRelocate));
                ProcessingUnitInstance candidateInstance = this.pu.getPartition(this.lastResortPartitionRelocate).getBackup();
                if (candidateInstance != null) {
                    int plannedMinimumNumberOfInstancesForSource;
                    int instancesInSource;
                    GridServiceContainer source = candidateInstance.getGridServiceContainer();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Candidate for re-location is " + RebalancingUtils.puInstanceToString(candidateInstance) + " from source " + RebalancingUtils.gscToString(source)));
                    }
                    if ((instancesInSource = source.getProcessingUnitInstances(this.pu.getName()).length) <= (plannedMinimumNumberOfInstancesForSource = RebalancingUtils.getPlannedMinimumNumberOfInstancesForContainer(source, containers, this.pu))) {
                        this.logger.debug((Object)("Cannot relocate instances from " + RebalancingUtils.gscToString(source) + " since the source cannot give up any instances. Instances in source: " + instancesInSource + " minimum planned: " + plannedMinimumNumberOfInstancesForSource));
                    } else {
                        this.logger.trace((Object)("Candidate for re-location is " + RebalancingUtils.puInstanceToString(candidateInstance) + " from source " + RebalancingUtils.gscToString(source)));
                        for (GridServiceContainer target : sortedContainers) {
                            int numberOfOtherInstancesFromPartitionInTargetMachine;
                            int numberOfOtherInstancesFromPartitionInTargetContainer;
                            int plannedMaximumNumberOfInstancesForTarget;
                            if (target.getMachine().equals(source.getMachine())) {
                                this.logger.debug((Object)("Not re-locating " + RebalancingUtils.puInstanceToString(candidateInstance) + " to " + ContainersSlaUtils.gscToString(target) + " since containers are on the same host."));
                                continue;
                            }
                            if (this.isConflictingDeploymentInProgress(target, maximumNumberOfRelocationsPerMachine, atMostOneConcurrentRelocation)) {
                                this.logger.debug((Object)("Cannot relocate instances to " + RebalancingUtils.gscToString(target) + " since a conflicting relocation is already in progress."));
                                continue;
                            }
                            int instancesInTarget = target.getProcessingUnitInstances(this.pu.getName()).length;
                            if (instancesInTarget >= (plannedMaximumNumberOfInstancesForTarget = RebalancingUtils.getPlannedMaximumNumberOfInstancesForContainer(target, containers, this.pu))) {
                                this.logger.debug((Object)("Not re-locating " + RebalancingUtils.puInstanceToString(candidateInstance) + " to " + ContainersSlaUtils.gscToString(target) + " since target container cannot host any more instances. Instances in target: " + instancesInTarget + " maximum planned: " + plannedMaximumNumberOfInstancesForTarget));
                                continue;
                            }
                            if (this.pu.getMaxInstancesPerVM() > 0 && (numberOfOtherInstancesFromPartitionInTargetContainer = RebalancingUtils.getOtherInstancesFromSamePartitionInContainer(target, candidateInstance).size()) >= this.pu.getMaxInstancesPerVM()) {
                                this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since container already hosts " + numberOfOtherInstancesFromPartitionInTargetContainer + " instance(s) from the same partition."));
                                continue;
                            }
                            if (this.pu.getMaxInstancesPerMachine() > 0 && (numberOfOtherInstancesFromPartitionInTargetMachine = RebalancingUtils.getOtherInstancesFromSamePartitionInMachine(target.getMachine(), candidateInstance).size()) >= this.pu.getMaxInstancesPerMachine()) {
                                this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " to container " + RebalancingUtils.gscToString(target) + " since machine already contains " + numberOfOtherInstancesFromPartitionInTargetMachine + " instance(s) from the same partition."));
                                continue;
                            }
                            this.logger.info((Object)("Relocating " + RebalancingUtils.puInstanceToString(candidateInstance) + " of partition " + this.lastResortPartitionRelocate + " from " + RebalancingUtils.gscToString(source) + " with " + source.getProcessingUnitInstances().length + " instances to " + RebalancingUtils.gscToString(target) + " with " + target.getProcessingUnitInstances().length + " instances due to rebalance heuristics."));
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)(this.pu.getName() + "; instancesInSource: " + instancesInSource + " PlannedMinimumNumberOfInstances for source: " + plannedMinimumNumberOfInstancesForSource + " instancesInTarget: " + instancesInTarget + " PlannedMaximumNumberOfInstances for target: " + plannedMaximumNumberOfInstancesForTarget + "; Current state is " + RebalancingUtils.processingUnitDeploymentToString(this.pu)));
                            }
                            return RebalancingUtils.relocateProcessingUnitInstanceAsync(target, candidateInstance, this.logger, STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                        }
                    }
                }
                ++this.lastResortPartitionRelocate;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Haven't found any partition to relocate; will try again next iteration.");
            }
            if (this.lastResortPartitionRelocate > this.pu.getNumberOfInstances() - 1) {
                this.lastResortPartitionRelocate = 0;
            }
        }
        if (conflict) {
            throw new RebalancingSlaEnforcementInProgressException(this.pu);
        }
        return null;
    }

    private void rebalanceNumberOfPrimaryInstancesPerMachine(GridServiceContainer[] containers, RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        FutureStatefulProcessingUnitInstance futureInstance;
        this.logger.debug((Object)"Trying to Re-balance number of primary instances per machine.");
        while ((futureInstance = this.rebalanceNumberOfPrimaryInstancesPerCpuCoreStep(containers, sla)) != null) {
            this.state.addFutureStatefulDeployment(futureInstance);
        }
    }

    private FutureStatefulProcessingUnitInstance rebalanceNumberOfPrimaryInstancesPerCpuCoreStep(GridServiceContainer[] containers, RebalancingSlaPolicy sla) throws RebalancingSlaEnforcementInProgressException {
        Machine[] machines = RebalancingUtils.getMachinesHostingContainers(containers);
        List<Machine> sortedMachines = RebalancingUtils.sortMachinesByNumberOfPrimaryInstancesPerCpuCore(this.pu, machines, sla.getAllocatedCapacity());
        Fraction optimalCpuCoresPerPrimary = RebalancingUtils.getAverageCpuCoresPerPrimary(this.pu, sla.getAllocatedCapacity());
        boolean conflict = false;
        for (int targetIndex = 0; targetIndex < sortedMachines.size(); ++targetIndex) {
            Machine source;
            Machine target = sortedMachines.get(targetIndex);
            for (int sourceIndex = sortedMachines.size() - 1; sourceIndex > targetIndex && RebalancingUtils.isRestartRecommended(this.pu, source = sortedMachines.get(sourceIndex), target, optimalCpuCoresPerPrimary, sla.getAllocatedCapacity()); --sourceIndex) {
                if (this.isConflictingOperationInProgress(target, 1, true)) {
                    conflict = true;
                    this.logger.debug((Object)("Cannot restart a primary instance who's backup is on machine " + RebalancingUtils.machineToString(target) + " since a conflicting relocation is already in progress."));
                    continue;
                }
                if (this.isConflictingOperationInProgress(source, 1, true)) {
                    conflict = true;
                    this.logger.debug((Object)("Cannot restart a primary instance from machine " + RebalancingUtils.machineToString(source) + " since a conflicting relocation is already in progress."));
                    continue;
                }
                for (ProcessingUnitInstance candidateInstance : source.getProcessingUnitInstances(this.pu.getName())) {
                    if (candidateInstance.getSpaceInstance() == null) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since embedded space is not detected"));
                        continue;
                    }
                    if (candidateInstance.getSpaceInstance().getMode() != SpaceMode.PRIMARY) {
                        this.logger.debug((Object)("Cannot restart instance " + RebalancingUtils.puInstanceToString(candidateInstance) + " since it is not primary."));
                        continue;
                    }
                    if (!RebalancingUtils.isProcessingUnitPartitionIntact(candidateInstance)) {
                        this.logger.debug((Object)("Cannot restart " + RebalancingUtils.puInstanceToString(candidateInstance) + " since instances from the same partition are missing"));
                        conflict = true;
                        continue;
                    }
                    if (this.isConflictingStatefulDeploymentInProgress(candidateInstance)) {
                        this.logger.debug((Object)("Cannot relocate " + RebalancingUtils.puInstanceToString(candidateInstance) + " since another instance from the same partition is being relocated"));
                        conflict = true;
                        continue;
                    }
                    Machine[] sourceReplicationMachines = RebalancingUtils.getMachinesHostingContainers(RebalancingUtils.getReplicationSourceContainers(candidateInstance));
                    if (sourceReplicationMachines.length > 1) {
                        throw new IllegalArgumentException("pu " + this.pu.getName() + " must have exactly one backup instance per partition in order for the primary restart algorithm to work.");
                    }
                    if (!sourceReplicationMachines[0].equals(target)) {
                        this.logger.debug((Object)("Cannot restart " + RebalancingUtils.puInstanceToString(candidateInstance) + "since replication source is on " + RebalancingUtils.machineToString(sourceReplicationMachines[0]) + " and not on the target machine " + RebalancingUtils.machineToString(target)));
                        continue;
                    }
                    if (this.logger.isInfoEnabled()) {
                        String sourceToString = RebalancingUtils.machineToString(source);
                        String targetToString = RebalancingUtils.machineToString(target);
                        int numberOfPrimaryInstancesOnTarget = RebalancingUtils.getNumberOfPrimaryInstancesOnMachine(this.pu, target);
                        Fraction numberOfCpuCoresOnTarget = RebalancingUtils.getNumberOfCpuCores(target, sla.getAllocatedCapacity());
                        int numberOfPrimaryInstancesOnSource = RebalancingUtils.getNumberOfPrimaryInstancesOnMachine(this.pu, source);
                        Fraction numberOfCpuCoresOnSource = RebalancingUtils.getNumberOfCpuCores(source, sla.getAllocatedCapacity());
                        this.logger.info((Object)("Restarting " + RebalancingUtils.puInstanceToString(candidateInstance) + " instance on machine " + sourceToString + " so that machine " + sourceToString + " would have less instances per cpu core, and " + targetToString + " would have more primary instances per cpu core. " + sourceToString + " has " + numberOfPrimaryInstancesOnSource + " primary instances running on " + numberOfCpuCoresOnSource + " cpu cores. " + targetToString + " has " + numberOfPrimaryInstancesOnTarget + " primary instances running on " + numberOfCpuCoresOnTarget + " cpu cores."));
                    }
                    return RebalancingUtils.restartProcessingUnitInstanceAsync(candidateInstance, this.logger, STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                }
            }
        }
        if (this.state.getNumberOfFutureDeployments(this.pu) == 0 && RebalancingUtils.isProcessingUnitIntact(this.pu) && RebalancingUtils.isEvenlyDistributedAcrossContainers(this.pu, containers) && !RebalancingUtils.isEvenlyDistributedAcrossMachines(this.pu, sla.getAllocatedCapacity())) {
            this.logger.debug((Object)("Optimal primary rebalancing hueristics failed balancing primaries in this deployment. Performing non-optimal restart heuristics. Starting with partition " + this.lastResortPartitionRestart));
            while (this.lastResortPartitionRestart < this.pu.getNumberOfInstances() - 1) {
                ProcessingUnitInstance candidateInstance = this.pu.getPartition(this.lastResortPartitionRestart).getPrimary();
                Machine source = candidateInstance.getMachine();
                Machine[] sourceReplicationMachines = RebalancingUtils.getMachinesHostingContainers(RebalancingUtils.getReplicationSourceContainers(candidateInstance));
                if (sourceReplicationMachines.length > 1) {
                    throw new IllegalArgumentException("pu " + this.pu.getName() + " must have exactly one backup instance per partition in order for the primary restart algorithm to work.");
                }
                if (sourceReplicationMachines[0].equals(source)) {
                    this.logger.debug((Object)("Cannot restart " + RebalancingUtils.puInstanceToString(candidateInstance) + "since replication source is on same machine as primary, so restarting will have not change number of primaries on machine."));
                } else {
                    Fraction optimalCpuCores;
                    Fraction numberOfCpuCoresOnSource = RebalancingUtils.getNumberOfCpuCores(source, sla.getAllocatedCapacity());
                    if (numberOfCpuCoresOnSource.compareTo(optimalCpuCores = new Fraction(RebalancingUtils.getNumberOfPrimaryInstancesOnMachine(this.pu, source)).multiply(optimalCpuCoresPerPrimary)) <= 0) {
                        if (this.logger.isInfoEnabled()) {
                            String sourceToString = RebalancingUtils.machineToString(source);
                            int numberOfPrimaryInstancesOnSource = RebalancingUtils.getNumberOfPrimaryInstancesOnMachine(this.pu, source);
                            this.logger.info((Object)("Restarting " + RebalancingUtils.puInstanceToString(candidateInstance) + " instance on machine " + sourceToString + " so that machine " + sourceToString + " would have less instances per cpu core. " + sourceToString + " has " + numberOfPrimaryInstancesOnSource + " primary instances running on " + numberOfCpuCoresOnSource + " cpu cores. "));
                        }
                        return RebalancingUtils.restartProcessingUnitInstanceAsync(candidateInstance, this.logger, STATEFUL_DEPLOYMENT_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                    }
                }
                ++this.lastResortPartitionRestart;
            }
            if (this.lastResortPartitionRestart >= this.pu.getNumberOfInstances() - 1) {
                this.lastResortPartitionRestart = 0;
            }
        }
        if (conflict) {
            throw new RebalancingSlaEnforcementInProgressException(this.pu);
        }
        return null;
    }

    private void cleanFutureStatefulDeployments() throws RebalancingSlaEnforcementInProgressException {
        FutureStatefulProcessingUnitInstance future;
        this.cleanFailedFutureStatefulDeployments();
        while ((future = this.state.removeOneDoneFutureStatefulDeployments(this.pu)) != null) {
            Throwable throwable = null;
            try {
                ProcessingUnitInstance puInstance = (ProcessingUnitInstance)future.get();
                this.logger.info((Object)("Processing unit instance deployment completed successfully " + RebalancingUtils.puInstanceToString(puInstance)));
            }
            catch (ExecutionException e) {
                throwable = e.getCause();
            }
            catch (TimeoutException e) {
                throwable = e;
            }
            if (throwable == null) continue;
            this.state.addFailedStatefulDeployment(future);
            this.throwFutureProcessingUnitInstanceException(throwable);
        }
    }

    private void cleanFutureStatelessDeployments() throws RebalancingSlaEnforcementInProgressException {
        FutureStatelessProcessingUnitInstance future;
        this.cleanFailedFutureStatelessDeployments();
        while ((future = this.state.removeOneDoneFutureStatelessDeployments(this.pu)) != null) {
            Throwable throwable = null;
            try {
                ProcessingUnitInstance puInstance = (ProcessingUnitInstance)future.get();
                this.logger.info((Object)("Processing unit instance deployment completed successfully " + RebalancingUtils.puInstanceToString(puInstance)));
            }
            catch (ExecutionException e) {
                throwable = e.getCause();
            }
            catch (TimeoutException e) {
                throwable = e;
            }
            if (throwable == null) continue;
            this.state.addFailedStatelessDeployment(future);
            this.throwFutureProcessingUnitInstanceException(throwable);
        }
    }

    private void cleanFailedFutureStatefulDeployments() {
        for (FutureStatefulProcessingUnitInstance future : this.state.getFailedStatefulDeployments(this.pu)) {
            int passedSeconds = (int)((System.currentTimeMillis() - future.getTimestamp().getTime()) / 1000L);
            if (future.getException() != null && future.getException().getCause() instanceof WrongContainerProcessingUnitRelocationException && future.getTargetContainer().isDiscovered() && (long)passedSeconds < STATEFUL_DEPLOYMENT_FAILURE_FORGET_SECONDS) continue;
            this.logger.info((Object)("Forgetting relocation error " + future.getFailureMessage()));
            this.state.removeFailedFutureStatefulDeployment(future);
        }
    }

    private void cleanRemovedStatelessProcessingUnitInstances() {
        for (ProcessingUnitInstance instance : this.state.getRemovedStatelessProcessingUnitInstances(this.pu)) {
            if (instance.isDiscovered()) continue;
            this.state.removeRemovedStatelessProcessingUnitInstance(instance);
            this.logger.info((Object)("Processing Unit Instance " + RebalancingUtils.puInstanceToString(instance) + " removed successfully."));
        }
    }

    private void throwFutureProcessingUnitInstanceException(Throwable throwable) throws RebalancingSlaEnforcementInProgressException {
        if (throwable instanceof RebalancingSlaEnforcementInProgressException) {
            throw (RebalancingSlaEnforcementInProgressException)throwable;
        }
        if (throwable instanceof AdminException) {
            throw new FutureProcessingUnitInstanceDeploymentException(this.pu, throwable);
        }
        if (throwable instanceof TimeoutException) {
            throw new FutureProcessingUnitInstanceDeploymentException(this.pu, throwable);
        }
        throw new IllegalStateException("Unexpected exception type", throwable);
    }

    private void cleanFailedFutureStatelessDeployments() {
        for (final FutureStatelessProcessingUnitInstance future : this.state.getFailedStatelessDeployments(this.pu)) {
            int passedSeconds = (int)((System.currentTimeMillis() - future.getTimestamp().getTime()) / 1000L);
            if (future.getException() != null && future.getTargetContainer().isDiscovered() && (long)passedSeconds < STATELESS_DEPLOYMENT_FAILURE_FORGET_SECONDS) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring failure to relocate stateless pu instance " + future.getProcessingUnit() + " Will try again in " + (STATELESS_DEPLOYMENT_FAILURE_FORGET_SECONDS - (long)passedSeconds) + " seconds."), (Throwable)future.getException());
                continue;
            }
            final InternalAdmin admin = (InternalAdmin)this.pu.getAdmin();
            admin.scheduleAdminOperation(new Runnable(){

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block7: {
                        try {
                            boolean decremented = ((InternalProcessingUnit)DefaultRebalancingSlaEnforcementEndpoint.this.pu).decrementPlannedInstances();
                            if (!DefaultRebalancingSlaEnforcementEndpoint.this.logger.isInfoEnabled()) break block7;
                            if (decremented) {
                                DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)"Decreased number of planned instances in the GSM. It will be incremented shortly (instance deployment retry)");
                                break block7;
                            }
                            DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Failed to decrement planned number of instances for " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName() + " meaning that instance is ok."));
                        }
                        catch (AdminException e) {
                            DefaultRebalancingSlaEnforcementEndpoint.this.logger.warn((Object)("Unexpected failure to decrement planned number of instances for " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName()), (Throwable)e);
                            admin.scheduleNonBlockingStateChange(new Runnable(){

                                @Override
                                public void run() {
                                    DefaultRebalancingSlaEnforcementEndpoint.this.logger.info((Object)("Cleaning deployment error before retry. Error was:" + future.getFailureMessage()));
                                    DefaultRebalancingSlaEnforcementEndpoint.this.state.removeFailedFutureStatelessDeployment(future);
                                }
                            });
                        }
                        catch (Throwable t) {
                            DefaultRebalancingSlaEnforcementEndpoint.this.logger.warn((Object)("Unexpected exception when decrementing planned number of instances for " + DefaultRebalancingSlaEnforcementEndpoint.this.pu.getName()), t);
                            admin.scheduleNonBlockingStateChange(new /* invalid duplicate definition of identical inner class */);
                            {
                                catch (Throwable throwable) {
                                    admin.scheduleNonBlockingStateChange(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                            }
                        }
                    }
                    admin.scheduleNonBlockingStateChange(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    private boolean isConflictingDeploymentInProgress(GridServiceContainer container, int maximumNumberOfConcurrentRelocationsPerMachine, boolean atMostOneConcurrentRelocation) {
        GridServiceContainer targetContainer;
        if (maximumNumberOfConcurrentRelocationsPerMachine <= 0) {
            throw new IllegalStateException("maximumNumberOfConcurrentRelocationsPerMachine must be 1 or higher");
        }
        int concurrentRelocationsInContainer = 0;
        for (FutureStatefulProcessingUnitInstance futureStatefulProcessingUnitInstance : this.state.getAllFutureStatefulProcessingUnitInstances()) {
            targetContainer = futureStatefulProcessingUnitInstance.getTargetContainer();
            GridServiceContainer sourceContainer = futureStatefulProcessingUnitInstance.getSourceContainer();
            List<GridServiceContainer> replicationSourceContainers = Arrays.asList(futureStatefulProcessingUnitInstance.getReplicaitonSourceContainers());
            if (!sourceContainer.equals(container) && !targetContainer.equals(container) && !replicationSourceContainers.contains(container)) continue;
            ++concurrentRelocationsInContainer;
        }
        for (FutureStatelessProcessingUnitInstance futureStatelessProcessingUnitInstance : this.state.getAllFutureStatelessProcessingUnitInstances()) {
            targetContainer = futureStatelessProcessingUnitInstance.getTargetContainer();
            if (!targetContainer.equals(container)) continue;
            ++concurrentRelocationsInContainer;
        }
        return concurrentRelocationsInContainer > 0 || this.isConflictingOperationInProgress(container.getMachine(), maximumNumberOfConcurrentRelocationsPerMachine, atMostOneConcurrentRelocation);
    }

    private boolean isConflictingOperationInProgress(Machine machine, int maximumNumberOfConcurrentRelocationsPerMachine, boolean atMostOneConcurrentRelocation) {
        if (atMostOneConcurrentRelocation) {
            return this.isRelocationInProgress();
        }
        return this.isConflictingOperationInProgress(machine, maximumNumberOfConcurrentRelocationsPerMachine);
    }

    private boolean isRelocationInProgress() {
        List<FutureStatefulProcessingUnitInstance> allFutureStatefulProcessingUnitInstances = this.state.getAllFutureStatefulProcessingUnitInstances();
        for (FutureStatefulProcessingUnitInstance futureStatefulProcessingUnitInstance : allFutureStatefulProcessingUnitInstances) {
            if (futureStatefulProcessingUnitInstance.isDone()) continue;
            this.logger.debug((Object)("Relocation of " + futureStatefulProcessingUnitInstance.getInstanceId() + " is in progress from " + ContainersSlaUtils.gscToString(futureStatefulProcessingUnitInstance.getSourceContainer()) + " to " + ContainersSlaUtils.gscToString(futureStatefulProcessingUnitInstance.getTargetContainer())));
            return true;
        }
        this.logger.debug((Object)"No active re-locations found.");
        return false;
    }

    private boolean isConflictingOperationInProgress(Machine machine, int maximumNumberOfConcurrentRelocationsPerMachine) {
        GridServiceContainer targetContainer;
        if (maximumNumberOfConcurrentRelocationsPerMachine <= 0) {
            maximumNumberOfConcurrentRelocationsPerMachine = Integer.MAX_VALUE;
        }
        int concurrentRelocationsInMachine = 0;
        for (FutureStatefulProcessingUnitInstance futureStatefulProcessingUnitInstance : this.state.getAllFutureStatefulProcessingUnitInstances()) {
            targetContainer = futureStatefulProcessingUnitInstance.getTargetContainer();
            List<GridServiceContainer> replicationSourceContainers = Arrays.asList(futureStatefulProcessingUnitInstance.getReplicaitonSourceContainers());
            Machine targetMachine = targetContainer.getMachine();
            HashSet<Machine> replicaitonSourceMachines = new HashSet<Machine>();
            for (GridServiceContainer replicationSourceContainer : replicationSourceContainers) {
                replicaitonSourceMachines.add(replicationSourceContainer.getMachine());
            }
            if (!targetMachine.equals(machine) && !replicaitonSourceMachines.contains(machine)) continue;
            ++concurrentRelocationsInMachine;
        }
        for (FutureStatelessProcessingUnitInstance futureStatelessProcessingUnitInstance : this.state.getAllFutureStatelessProcessingUnitInstances()) {
            targetContainer = futureStatelessProcessingUnitInstance.getTargetContainer();
            Machine targetMachine = targetContainer.getMachine();
            if (!targetMachine.equals(machine)) continue;
            this.logger.debug((Object)("A Relocation to " + ContainersSlaUtils.gscToString(futureStatelessProcessingUnitInstance.getTargetContainer()) + " is in progress."));
            ++concurrentRelocationsInMachine;
        }
        return concurrentRelocationsInMachine >= maximumNumberOfConcurrentRelocationsPerMachine;
    }

    private boolean isConflictingStatefulDeploymentInProgress(ProcessingUnitInstance candidateInstance) {
        for (FutureStatefulProcessingUnitInstance future : this.state.getAllFutureStatefulProcessingUnitInstances()) {
            if (!future.getProcessingUnit().equals(candidateInstance.getProcessingUnit()) || future.getInstanceId() != candidateInstance.getInstanceId()) continue;
            return true;
        }
        return false;
    }
}

