/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.rebalancing.DefaultRebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.FutureStatefulProcessingUnitInstance;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementState;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementEnforcement;
import org.openspaces.grid.gsm.sla.exceptions.ServiceLevelAgreementEnforcementEndpointAlreadyExistsException;

public class RebalancingSlaEnforcement
implements ServiceLevelAgreementEnforcement<RebalancingSlaEnforcementEndpoint> {
    private final RebalancingSlaEnforcementState state = new RebalancingSlaEnforcementState();
    private final HashMap<ProcessingUnit, RebalancingSlaEnforcementEndpoint> endpoints = new HashMap();

    public void enableTracing() {
        this.state.enableTracing();
    }

    public List<FutureStatefulProcessingUnitInstance> getTrace() {
        return this.state.getDoneFutureStatefulDeployments();
    }

    public void destroy() {
        for (ProcessingUnit pu : this.endpoints.keySet()) {
            this.destroyEndpoint(pu);
        }
    }

    @Override
    public RebalancingSlaEnforcementEndpoint createEndpoint(ProcessingUnit pu) throws ServiceLevelAgreementEnforcementEndpointAlreadyExistsException {
        if (pu.getRequiredZones().length != 1) {
            throw new IllegalStateException("Processing Unit must have exactly one container zone defined.");
        }
        if (!this.isEndpointDestroyed(pu)) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for the pu already exists.");
        }
        ProcessingUnit otherPu1 = this.getEndpointsWithSameNameAs(pu);
        if (otherPu1 != null) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for a pu with the same name already exists.");
        }
        ProcessingUnit otherPu2 = this.getEndpointsWithSameContainersZoneAs(pu);
        if (otherPu2 != null) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for a pu with the same (containers) zone already exists: " + otherPu2.getName());
        }
        DefaultRebalancingSlaEnforcementEndpoint endpoint = new DefaultRebalancingSlaEnforcementEndpoint(pu, this.state);
        this.endpoints.put(pu, endpoint);
        this.state.initProcessingUnit(pu);
        return endpoint;
    }

    @Override
    public void destroyEndpoint(ProcessingUnit pu) {
        this.state.destroyProcessingUnit(pu);
        this.endpoints.remove(pu);
    }

    private boolean isEndpointDestroyed(ProcessingUnit pu) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null");
        }
        return !this.endpoints.containsKey(pu) || this.state.isDestroyedProcessingUnit(pu);
    }

    private ProcessingUnit getEndpointsWithSameContainersZoneAs(ProcessingUnit pu) {
        for (ProcessingUnit endpointPu : this.endpoints.keySet()) {
            if (!RebalancingSlaEnforcement.getContainerZone(endpointPu).equals(RebalancingSlaEnforcement.getContainerZone(pu))) continue;
            return endpointPu;
        }
        return null;
    }

    private ProcessingUnit getEndpointsWithSameNameAs(ProcessingUnit pu) {
        for (ProcessingUnit endpointPu : this.endpoints.keySet()) {
            if (!endpointPu.getName().equals(pu.getName())) continue;
            return endpointPu;
        }
        return null;
    }

    private static String getContainerZone(ProcessingUnit pu) {
        Object[] zones = pu.getRequiredZones();
        if (zones.length == 0) {
            throw new IllegalArgumentException("Elastic Processing Unit must have exactly one (container) zone. " + pu.getName() + " has been deployed with no zones defined.");
        }
        if (zones.length > 1) {
            throw new IllegalArgumentException("Elastic Processing Unit must have exactly one (container) zone. " + pu.getName() + " has been deployed with " + zones.length + " zones : " + Arrays.toString(zones));
        }
        return zones[0];
    }
}

