/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.grid.gsm.rebalancing.FutureStatefulProcessingUnitInstance;
import org.openspaces.grid.gsm.rebalancing.FutureStatelessProcessingUnitInstance;

class RebalancingSlaEnforcementState {
    private final Map<ProcessingUnit, List<FutureStatefulProcessingUnitInstance>> futureStatefulDeploymentPerProcessingUnit = new HashMap<ProcessingUnit, List<FutureStatefulProcessingUnitInstance>>();
    private final Map<ProcessingUnit, List<FutureStatelessProcessingUnitInstance>> futureStatelessDeploymentPerProcessingUnit = new HashMap<ProcessingUnit, List<FutureStatelessProcessingUnitInstance>>();
    private final List<FutureStatefulProcessingUnitInstance> failedStatefulDeployments = new ArrayList<FutureStatefulProcessingUnitInstance>();
    private final List<FutureStatelessProcessingUnitInstance> failedStatelessDeployments = new ArrayList<FutureStatelessProcessingUnitInstance>();
    private final List<ProcessingUnitInstance> removedStatelessProcessingUnitInstances = new ArrayList<ProcessingUnitInstance>();
    private boolean tracingEnabled = false;
    private final List<FutureStatefulProcessingUnitInstance> doneFutureStatefulDeployments = new ArrayList<FutureStatefulProcessingUnitInstance>();
    private final List<FutureStatelessProcessingUnitInstance> doneFutureStatelessDeployments = new ArrayList<FutureStatelessProcessingUnitInstance>();

    public void initProcessingUnit(ProcessingUnit pu) {
        this.futureStatefulDeploymentPerProcessingUnit.put(pu, new ArrayList());
        this.futureStatelessDeploymentPerProcessingUnit.put(pu, new ArrayList());
    }

    public void destroyProcessingUnit(ProcessingUnit pu) {
        this.futureStatefulDeploymentPerProcessingUnit.remove(pu);
        this.futureStatelessDeploymentPerProcessingUnit.remove(pu);
    }

    public List<FutureStatefulProcessingUnitInstance> getAllFutureStatefulProcessingUnitInstances() {
        ArrayList<FutureStatefulProcessingUnitInstance> futures = new ArrayList<FutureStatefulProcessingUnitInstance>();
        for (ProcessingUnit pu : this.futureStatefulDeploymentPerProcessingUnit.keySet()) {
            futures.addAll((Collection<FutureStatefulProcessingUnitInstance>)this.futureStatefulDeploymentPerProcessingUnit.get(pu));
        }
        futures.addAll(this.failedStatefulDeployments);
        return futures;
    }

    public List<FutureStatelessProcessingUnitInstance> getAllFutureStatelessProcessingUnitInstances() {
        ArrayList<FutureStatelessProcessingUnitInstance> futures = new ArrayList<FutureStatelessProcessingUnitInstance>();
        for (ProcessingUnit pu : this.futureStatelessDeploymentPerProcessingUnit.keySet()) {
            futures.addAll((Collection<FutureStatelessProcessingUnitInstance>)this.futureStatelessDeploymentPerProcessingUnit.get(pu));
        }
        futures.addAll(this.failedStatelessDeployments);
        return futures;
    }

    public boolean isDestroyedProcessingUnit(ProcessingUnit pu) {
        return this.futureStatefulDeploymentPerProcessingUnit.get(pu) == null || this.futureStatelessDeploymentPerProcessingUnit.get(pu) == null;
    }

    public int getNumberOfFutureDeployments(ProcessingUnit pu) {
        return this.futureStatefulDeploymentPerProcessingUnit.get(pu).size() + this.futureStatelessDeploymentPerProcessingUnit.get(pu).size();
    }

    public void addFutureStatelessDeployments(Iterable<FutureStatelessProcessingUnitInstance> futureInstances) {
        for (FutureStatelessProcessingUnitInstance futureInstance : futureInstances) {
            this.addFutureStatelessDeployment(futureInstance);
        }
    }

    private void addFutureStatelessDeployment(FutureStatelessProcessingUnitInstance futureInstance) {
        ProcessingUnit pu = futureInstance.getProcessingUnit();
        this.futureStatelessDeploymentPerProcessingUnit.get(pu).add(futureInstance);
    }

    public void addFutureStatefulDeployments(Iterable<FutureStatefulProcessingUnitInstance> futureInstances) {
        for (FutureStatefulProcessingUnitInstance futureInstance : futureInstances) {
            this.addFutureStatefulDeployment(futureInstance);
        }
    }

    public void addFutureStatefulDeployment(FutureStatefulProcessingUnitInstance futureInstance) {
        ProcessingUnit pu = futureInstance.getProcessingUnit();
        this.futureStatefulDeploymentPerProcessingUnit.get(pu).add(futureInstance);
    }

    public FutureStatefulProcessingUnitInstance removeOneDoneFutureStatefulDeployments(ProcessingUnit pu) {
        List<FutureStatefulProcessingUnitInstance> list = this.futureStatefulDeploymentPerProcessingUnit.get(pu);
        if (list == null) {
            throw new IllegalStateException("endpoint for pu " + pu.getName() + " has already been destroyed.");
        }
        Iterator<FutureStatefulProcessingUnitInstance> iterator = list.iterator();
        while (iterator.hasNext()) {
            FutureStatefulProcessingUnitInstance future = iterator.next();
            if (!future.getProcessingUnit().equals(pu) || !future.isDone()) continue;
            if (this.tracingEnabled) {
                this.doneFutureStatefulDeployments.add(future);
            }
            iterator.remove();
            return future;
        }
        return null;
    }

    public FutureStatelessProcessingUnitInstance removeOneDoneFutureStatelessDeployments(ProcessingUnit pu) {
        List<FutureStatelessProcessingUnitInstance> list = this.futureStatelessDeploymentPerProcessingUnit.get(pu);
        if (list == null) {
            throw new IllegalStateException("endpoint for pu " + pu.getName() + " has already been destroyed.");
        }
        Iterator<FutureStatelessProcessingUnitInstance> iterator = list.iterator();
        while (iterator.hasNext()) {
            FutureStatelessProcessingUnitInstance future = iterator.next();
            if (!future.getProcessingUnit().equals(pu) || !future.isDone()) continue;
            if (this.tracingEnabled) {
                this.doneFutureStatelessDeployments.add(future);
            }
            iterator.remove();
            return future;
        }
        return null;
    }

    public void addFailedStatefulDeployment(FutureStatefulProcessingUnitInstance future) {
        this.failedStatefulDeployments.add(future);
    }

    public void addFailedStatelessDeployment(FutureStatelessProcessingUnitInstance future) {
        this.failedStatelessDeployments.add(future);
    }

    public Iterable<FutureStatelessProcessingUnitInstance> getFailedStatelessDeployments(ProcessingUnit pu) {
        ArrayList<FutureStatelessProcessingUnitInstance> failedDeployments = new ArrayList<FutureStatelessProcessingUnitInstance>();
        for (FutureStatelessProcessingUnitInstance future : this.failedStatelessDeployments) {
            if (!future.getProcessingUnit().equals(pu)) continue;
            failedDeployments.add(future);
        }
        return failedDeployments;
    }

    public Iterable<FutureStatefulProcessingUnitInstance> getFailedStatefulDeployments(ProcessingUnit pu) {
        ArrayList<FutureStatefulProcessingUnitInstance> failedDeployments = new ArrayList<FutureStatefulProcessingUnitInstance>();
        for (FutureStatefulProcessingUnitInstance future : this.failedStatefulDeployments) {
            if (!future.getProcessingUnit().equals(pu)) continue;
            failedDeployments.add(future);
        }
        return failedDeployments;
    }

    public void removeFailedFutureStatelessDeployment(FutureStatelessProcessingUnitInstance future) {
        this.failedStatelessDeployments.remove(future);
    }

    public void removeFailedFutureStatefulDeployment(FutureStatefulProcessingUnitInstance future) {
        this.failedStatefulDeployments.remove(future);
    }

    public void enableTracing() {
        this.tracingEnabled = true;
    }

    public List<FutureStatefulProcessingUnitInstance> getDoneFutureStatefulDeployments() {
        return this.doneFutureStatefulDeployments;
    }

    public List<ProcessingUnitInstance> getRemovedStatelessProcessingUnitInstances(ProcessingUnit pu) {
        ArrayList<ProcessingUnitInstance> removedInstances = new ArrayList<ProcessingUnitInstance>();
        for (ProcessingUnitInstance instance : this.removedStatelessProcessingUnitInstances) {
            if (!instance.getProcessingUnit().equals(pu)) continue;
            removedInstances.add(instance);
        }
        return removedInstances;
    }

    public void removeRemovedStatelessProcessingUnitInstance(ProcessingUnitInstance instance) {
        this.removedStatelessProcessingUnitInstances.remove(instance);
    }

    public void addRemovedStatelessProcessingUnitInstance(ProcessingUnitInstance instance) {
        this.removedStatelessProcessingUnitInstances.add(instance);
    }

    public boolean isStatelessProcessingUnitInstanceBeingRemoved(ProcessingUnitInstance instance) {
        return this.removedStatelessProcessingUnitInstances.contains(instance);
    }
}

