/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing;

import java.util.Collection;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementPolicy;

public class RebalancingSlaPolicy
extends ServiceLevelAgreementPolicy {
    private GridServiceContainer[] containers;
    private Collection<GridServiceContainer> containersMarkedForDeallocation;
    private int maxNumberOfConcurrentRelocationsPerMachine;
    private boolean atMostOneConcurrentRelocation = false;
    private ProcessingUnitSchemaConfig schema;
    private CapacityRequirementsPerAgent allocatedCapacity;
    private int minimumNumberOfInstancesPerPartition;
    private boolean ignoreCpuRebalancing;
    private boolean eager;

    public boolean isAtMostOneConcurrentRelocation() {
        return this.atMostOneConcurrentRelocation;
    }

    public void setAtMostOneConcurrentRelocation(boolean atMostOneConcurrentRelocation) {
        this.atMostOneConcurrentRelocation = atMostOneConcurrentRelocation;
    }

    public void setContainers(GridServiceContainer[] containers) {
        this.containers = containers;
    }

    public GridServiceContainer[] getContainers() {
        return this.containers;
    }

    public void setContainersMarkedForDeallocation(Collection<GridServiceContainer> containersMarkedForDeallocation) {
        this.containersMarkedForDeallocation = containersMarkedForDeallocation;
    }

    public Collection<GridServiceContainer> getContainersMarkedForDeallocation() {
        return this.containersMarkedForDeallocation;
    }

    public void setMaximumNumberOfConcurrentRelocationsPerMachine(int maxNumberOfConcurrentRelocationsPerMachine) {
        this.maxNumberOfConcurrentRelocationsPerMachine = maxNumberOfConcurrentRelocationsPerMachine;
    }

    public int getMaximumNumberOfConcurrentRelocationsPerMachine() {
        return this.maxNumberOfConcurrentRelocationsPerMachine;
    }

    public ProcessingUnitSchemaConfig getSchemaConfig() {
        return this.schema;
    }

    public void setSchemaConfig(ProcessingUnitSchemaConfig schemaConfig) {
        this.schema = schemaConfig;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacity() {
        return this.allocatedCapacity;
    }

    public void setAllocatedCapacity(CapacityRequirementsPerAgent allocatedCapacity) {
        this.allocatedCapacity = allocatedCapacity;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        if (this.containers == null) {
            throw new IllegalArgumentException("containers cannot be null");
        }
        if (this.maxNumberOfConcurrentRelocationsPerMachine <= 0) {
            throw new IllegalArgumentException("maxNumberOfConcurrentRelocationsPerMachine must be positive");
        }
        if (this.schema == null) {
            throw new IllegalArgumentException("PU schema cannot be null");
        }
        if (this.allocatedCapacity == null) {
            throw new IllegalArgumentException("allocatedCapacity cannot be null");
        }
        if (this.minimumNumberOfInstancesPerPartition < 0) {
            throw new IllegalArgumentException("minimumNumberOfInstancesPerPartition must be zero or positive");
        }
    }

    public int getMinimumNumberOfInstancesPerPartition() {
        return this.minimumNumberOfInstancesPerPartition;
    }

    public void setMinimumNumberOfInstancesPerPartition(int minimumNumberOfInstancesPerPartition) {
        this.minimumNumberOfInstancesPerPartition = minimumNumberOfInstancesPerPartition;
    }

    public void eager(boolean eager) {
        this.eager = eager;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void ignoreCpuRebalancing(boolean ignore) {
        this.ignoreCpuRebalancing = ignore;
    }

    public boolean ignoreCpuRebalancing() {
        return this.ignoreCpuRebalancing;
    }

    public String toString() {
        return "RebalancingSlaPolicy{containers=" + ContainersSlaUtils.gscsToString(this.containers) + ", maxNumberOfConcurrentRelocationsPerMachine=" + this.maxNumberOfConcurrentRelocationsPerMachine + ", schema=" + this.schema + ", allocatedCapacity=" + this.allocatedCapacity + ", minimumNumberOfInstancesPerPartition=" + this.minimumNumberOfInstancesPerPartition + ", ignoreCpuRebalancing=" + this.ignoreCpuRebalancing + ", eager=" + this.eager + '}';
    }
}

