/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing.exceptions;

import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticProcessingUnitInstanceProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class NumberOfInstancesIsBelowMinimumException
extends RebalancingSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;

    public NumberOfInstancesIsBelowMinimumException(ProcessingUnit pu, int minimumNumberOfInstances) {
        super(pu, NumberOfInstancesIsBelowMinimumException.message(pu, minimumNumberOfInstances));
    }

    private static String message(ProcessingUnit pu, int minimumNumberOfInstances) {
        return "Number of " + pu.getName() + " instances (" + pu.getInstances().length + ") is below the minimum of " + minimumNumberOfInstances + " instances.";
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticProcessingUnitInstanceProvisioningFailureEvent event = new DefaultElasticProcessingUnitInstanceProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

