/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.rebalancing.exceptions;

import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticProcessingUnitInstanceProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class NumberOfInstancesPerPartitionIsBelowMinimumException
extends RebalancingSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;

    public NumberOfInstancesPerPartitionIsBelowMinimumException(ProcessingUnit pu, int minimumNumberOfInstancesPerPartition) {
        super(pu, NumberOfInstancesPerPartitionIsBelowMinimumException.message(pu, minimumNumberOfInstancesPerPartition));
    }

    private static String message(ProcessingUnit pu, int minimumNumberOfInstancesPerPartition) {
        return "Number of " + pu.getName() + " instances per partition is below the minimum of " + minimumNumberOfInstancesPerPartition + " instances.";
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticProcessingUnitInstanceProvisioningFailureEvent event = new DefaultElasticProcessingUnitInstanceProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

