/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.pu.elastic.GridServiceAgentFailureDetectionConfig;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfigurer;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsPerZonesConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyAgentZonesAwareConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyCapacityRequirementConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.RequiredZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.util.MemoryUnit;
import org.openspaces.grid.gsm.GridServiceAgentFailureDetectionConfigAware;
import org.openspaces.grid.gsm.GridServiceContainerConfigAware;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerZones;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.containers.ContainersSlaPolicy;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementPendingProcessingUnitDeallocationException;
import org.openspaces.grid.gsm.machines.CapacityMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementPendingContainerDeallocationException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaHasChangedException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.PerZonesGridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.PerZonesMachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.WaitingForDiscoveredMachinesException;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaPolicy;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.strategy.AbstractScaleStrategyBean;

public abstract class AbstractCapacityScaleStrategyBean
extends AbstractScaleStrategyBean
implements GridServiceContainerConfigAware,
GridServiceAgentFailureDetectionConfigAware,
RebalancingSlaEnforcementEndpointAware,
ContainersSlaEnforcementEndpointAware,
MachinesSlaEnforcementEndpointAware {
    private GridServiceContainerConfig containersConfig;
    private MachinesSlaEnforcementEndpoint machinesEndpoint;
    private ContainersSlaEnforcementEndpoint containersEndpoint;
    private RebalancingSlaEnforcementEndpoint rebalancingEndpoint;
    private GridServiceAgentFailureDetectionConfig agentFailureDetectionConfig;
    private CapacityRequirementsPerZonesConfig plannedCapacity;
    private ScaleStrategyConfig scaleStrategy;

    @Override
    public void setMachinesSlaEnforcementEndpoint(MachinesSlaEnforcementEndpoint machinesService) {
        this.machinesEndpoint = machinesService;
    }

    @Override
    public void setContainersSlaEnforcementEndpoint(ContainersSlaEnforcementEndpoint containersService) {
        this.containersEndpoint = containersService;
    }

    @Override
    public void setRebalancingSlaEnforcementEndpoint(RebalancingSlaEnforcementEndpoint relocationService) {
        this.rebalancingEndpoint = relocationService;
    }

    @Override
    public void setAgentFailureDetectionConfig(GridServiceAgentFailureDetectionConfig agentFailureDetectionConfig) {
        this.agentFailureDetectionConfig = agentFailureDetectionConfig;
    }

    protected ZonesConfig getDefaultZones() {
        return this.getMachineProvisioning().getConfig().getGridServiceAgentZones();
    }

    protected void setPlannedCapacity(CapacityRequirementsPerZones plannedCapacity) {
        this.setPlannedCapacity(new CapacityRequirementsPerZonesConfig(plannedCapacity));
    }

    protected void setPlannedCapacity(ScaleStrategyCapacityRequirementConfig newPlannedCapacityForDefaultZone) {
        CapacityRequirementsPerZonesConfig newPlannedCapacity = new CapacityRequirementsPerZonesConfig();
        if (!newPlannedCapacityForDefaultZone.toCapacityRequirements().equalsZero()) {
            newPlannedCapacity.addCapacity(this.getDefaultZones(), newPlannedCapacityForDefaultZone);
        }
        this.setPlannedCapacity(newPlannedCapacity);
    }

    protected boolean setPlannedCapacity(CapacityRequirementsPerZonesConfig newPlannedCapacity) {
        if (newPlannedCapacity == null) {
            throw new IllegalArgumentException("capacityRequirement cannot be null");
        }
        if (this.plannedCapacity != null && newPlannedCapacity.toCapacityRequirementsPerZones().equals(this.plannedCapacity.toCapacityRequirementsPerZones())) {
            return false;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Setting planned capacity to " + newPlannedCapacity + " (old planned capacity = " + this.plannedCapacity + ")"));
        }
        CapacityRequirementsPerZonesConfig oldPlannedCapacity = this.plannedCapacity;
        this.plannedCapacity = newPlannedCapacity;
        long roundedMemoryInMB = this.calcRoundedTotalMemoryInMB();
        long totalMemoryInMB = this.getTotalPlannedMemoryInMB();
        if (totalMemoryInMB > roundedMemoryInMB) {
            throw new IllegalStateException("totalMemoryInMB (" + totalMemoryInMB + ") cannot be bigger than roundedTotalMemoryInMB (" + roundedMemoryInMB + ")");
        }
        if (totalMemoryInMB < roundedMemoryInMB) {
            long memoryShortage = roundedMemoryInMB - totalMemoryInMB;
            CapacityRequirementsConfig increase = new CapacityRequirementsConfigurer().memoryCapacity((int)memoryShortage, MemoryUnit.MEGABYTES).create();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Increasing planned capacity by " + increase + " to round up memory to nearest number of containers."));
            }
            newPlannedCapacity.addCapacity(this.getDefaultZones(), increase);
            this.plannedCapacity = newPlannedCapacity;
        }
        this.capacityPlannedNumberOfInstancesChangedEvent(oldPlannedCapacity);
        return true;
    }

    private void capacityPlannedNumberOfInstancesChangedEvent(CapacityRequirementsPerZonesConfig oldPlannedCapacity) {
        if (!this.isStatefulProcessingUnit()) {
            boolean log = false;
            int newPlannedNumberOfInstances = this.calcTargetNumberOfContainersForStateless(this.plannedCapacity, false);
            int oldPlannedNumberOfInstances = this.calcTargetNumberOfContainersForStateless(oldPlannedCapacity, false);
            int actualNumberOfInstances = this.getProcessingUnit().getInstances().length;
            ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent event = new ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent(actualNumberOfInstances, oldPlannedNumberOfInstances, newPlannedNumberOfInstances);
            event.setComplete(false);
            event.setUndeploying(false);
            event.setProcessingUnitName(this.getProcessingUnit().getName());
            event.setGridServiceAgentZones(null);
            super.capacityPlanningInProgressEvent(event);
        }
    }

    protected CapacityRequirementsPerZonesConfig getPlannedCapacity() {
        return this.plannedCapacity;
    }

    protected void setScaleStrategyConfig(ScaleStrategyConfig scaleStrategy) {
        this.scaleStrategy = scaleStrategy;
    }

    private int getMaximumNumberOfContainersPerMachine() {
        return this.scaleStrategy.isAtMostOneContainerPerMachine() ? 1 : this.getMaximumNumberOfInstances();
    }

    @Override
    public void setGridServiceContainerConfig(GridServiceContainerConfig containersConfig) {
        this.containersConfig = containersConfig;
    }

    public GridServiceContainerConfig getGridServiceContainerConfig() {
        return this.containersConfig;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.machinesEndpoint == null) {
            throw new IllegalStateException("machines endpoint cannot be null.");
        }
        if (this.containersEndpoint == null) {
            throw new IllegalStateException("containers endpoint cannot be null");
        }
        if (this.rebalancingEndpoint == null) {
            throw new IllegalStateException("rebalancing endpoint cannot be null.");
        }
        super.afterPropertiesSet();
        if (this.getLogger().isInfoEnabled()) {
            if (this.agentFailureDetectionConfig.getFailureDetectionIpAddresses().isEmpty()) {
                this.getLogger().info((Object)"Agent failure detection is enabled");
            } else {
                for (String ipAddress : this.agentFailureDetectionConfig.getFailureDetectionIpAddresses()) {
                    GridServiceAgentFailureDetectionConfig.FailureDetectionStatus failureDetectionStatus = this.agentFailureDetectionConfig.getFailureDetectionStatus(ipAddress, System.currentTimeMillis());
                    if (!failureDetectionStatus.equals((Object)GridServiceAgentFailureDetectionConfig.FailureDetectionStatus.DISABLE_FAILURE_DETECTION)) continue;
                    this.getLogger().info((Object)("Agent failure detection is disabled for ip " + ipAddress));
                }
            }
        }
    }

    protected void enforcePlannedCapacity() throws SlaEnforcementInProgressException {
        if (this.plannedCapacity == null) {
            throw new IllegalStateException("capacityPerZones cannot be null");
        }
        if (this.scaleStrategy == null) {
            throw new IllegalStateException("scaleStrategy cannot be null");
        }
        CapacityRequirementsPerAgent totalAllocatedCapacity = new CapacityRequirementsPerAgent();
        PerZonesMachinesSlaEnforcementInProgressException pendingMachinesExceptions = new PerZonesMachinesSlaEnforcementInProgressException(this.getProcessingUnit());
        PerZonesGridServiceAgentSlaEnforcementInProgressException pendingAgentsExceptions = new PerZonesGridServiceAgentSlaEnforcementInProgressException(this.getProcessingUnit());
        ContainersSlaEnforcementPendingProcessingUnitDeallocationException pendingContainersException = null;
        RebalancingSlaEnforcementInProgressException pendingRebalancingException = null;
        for (CapacityMachinesSlaPolicy sla : this.getMachinesSlas(this.getAllZones())) {
            ZonesConfig zones = sla.getGridServiceAgentZones();
            try {
                this.enforceMachinesSla(sla);
            }
            catch (MachinesSlaHasChangedException e) {
                throw e;
            }
            catch (GridServiceAgentSlaEnforcementPendingContainerDeallocationException e) {
                pendingAgentsExceptions.addReason(zones, e);
            }
            catch (GridServiceAgentSlaEnforcementInProgressException e) {
                if (this.isStatefulProcessingUnit()) {
                    throw e;
                }
                pendingAgentsExceptions.addReason(zones, e);
            }
            catch (MachinesSlaEnforcementInProgressException e) {
                if (this.isStatefulProcessingUnit()) {
                    throw e;
                }
                pendingMachinesExceptions.addReason(zones, e);
            }
            CapacityRequirementsPerAgent allocatedCapacity = this.machinesEndpoint.getAllocatedCapacityFilterUndiscoveredAgents(sla);
            totalAllocatedCapacity = totalAllocatedCapacity.add(allocatedCapacity);
        }
        try {
            this.enforceContainersSla(totalAllocatedCapacity);
        }
        catch (ContainersSlaEnforcementPendingProcessingUnitDeallocationException e) {
            pendingContainersException = e;
        }
        try {
            this.enforceRebalancingSla(this.containersEndpoint.getContainers(), totalAllocatedCapacity);
        }
        catch (RebalancingSlaEnforcementInProgressException e) {
            pendingRebalancingException = e;
        }
        if (pendingRebalancingException != null) {
            throw pendingRebalancingException;
        }
        if (pendingContainersException != null) {
            throw pendingContainersException;
        }
        if (pendingAgentsExceptions.hasReason()) {
            throw pendingAgentsExceptions;
        }
        if (pendingMachinesExceptions.hasReason()) {
            throw pendingMachinesExceptions;
        }
    }

    private boolean replacePlannedCapacity(ZonesConfig zonesToRemove, CapacityRequirementsPerAgent capacityToAdd) {
        CapacityRequirementsPerZones newCapacityPerZones;
        if (this.getLogger().isDebugEnabled() && zonesToRemove instanceof RequiredZonesConfig) {
            this.getLogger().debug((Object)("Replacing zones " + zonesToRemove + " with " + capacityToAdd));
        }
        if ((newCapacityPerZones = this.plannedCapacity.toCapacityRequirementsPerZones()).getZones().contains(zonesToRemove)) {
            newCapacityPerZones = newCapacityPerZones.subtractZones(zonesToRemove);
        }
        for (String agentUid : capacityToAdd.getAgentUids()) {
            GridServiceAgent agent = this.getAdmin().getGridServiceAgents().getAgentByUID(agentUid);
            ZonesConfig zones = agent != null ? agent.getExactZones() : zonesToRemove;
            CapacityRequirements agentCapacity = capacityToAdd.getAgentCapacity(agentUid);
            newCapacityPerZones = newCapacityPerZones.add(zones, agentCapacity);
        }
        return this.setPlannedCapacity(new CapacityRequirementsPerZonesConfig(newCapacityPerZones));
    }

    private Set<ZonesConfig> getAllZones() throws MachinesSlaEnforcementInProgressException {
        HashSet<ZonesConfig> allZones = new HashSet<ZonesConfig>();
        allZones.addAll(this.machinesEndpoint.getGridServiceAgentsZones());
        allZones.addAll(this.getPlannedZones());
        return allZones;
    }

    protected Set<ZonesConfig> getPlannedZones() {
        return this.plannedCapacity.toCapacityRequirementsPerZones().getZones();
    }

    private void enforceMachinesSla(CapacityMachinesSlaPolicy sla) throws WaitingForDiscoveredMachinesException, MachinesSlaEnforcementInProgressException, GridServiceAgentSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing machines SLA.");
        }
        try {
            this.machinesEndpoint.enforceSla(sla);
            if (this.isGridServiceAgentZonesAware()) {
                CapacityRequirementsPerAgent allocatedCapacity = this.machinesEndpoint.getAllocatedCapacity(sla);
                boolean replacedAllocated = this.machinesEndpoint.replaceAllocatedCapacity(sla);
                boolean replacedPlanned = this.replacePlannedCapacity(sla.getGridServiceAgentZones(), allocatedCapacity);
                if (replacedPlanned || replacedAllocated) {
                    throw new MachinesSlaHasChangedException(this.getProcessingUnit(), sla.getGridServiceAgentZones(), sla.getCapacityRequirements(), allocatedCapacity);
                }
            }
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningCompletedEvent(sla.getGridServiceAgentZones());
        }
        catch (MachinesSlaEnforcementInProgressException e) {
            this.machineProvisioningInProgressEvent(e, sla.getGridServiceAgentZones());
            throw e;
        }
        catch (GridServiceAgentSlaEnforcementInProgressException e) {
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningInProgressEvent(e, sla.getGridServiceAgentZones());
            throw e;
        }
    }

    private CapacityMachinesSlaPolicy getMachinesSla(ZonesConfig zones, int minimumNumberOfMachines, CapacityRequirements capacityRequirements) {
        CapacityMachinesSlaPolicy sla = new CapacityMachinesSlaPolicy();
        sla.setMachineProvisioning(super.getMachineProvisioning());
        sla.setCapacityRequirements(capacityRequirements);
        sla.setAgentFailureDetectionConfig(this.agentFailureDetectionConfig);
        sla.setMinimumNumberOfMachines(minimumNumberOfMachines);
        sla.setMaximumNumberOfMachines(this.getMaximumNumberOfInstances());
        sla.setMaximumNumberOfContainersPerMachine(this.getMaximumNumberOfContainersPerMachine());
        sla.setContainerMemoryCapacityInMB(this.containersConfig.getMaximumMemoryCapacityInMB());
        sla.setAllowAboveAverageMemoryPerMachine(this.getConfig().isAllowAboveAverageMemoryPerMachine());
        sla.setMachineIsolation(this.getIsolation());
        sla.setDiscoveredMachinesCache(this.getDiscoveredMachinesCache());
        sla.setGridServiceAgentZones(zones);
        return sla;
    }

    private void enforceContainersSla(CapacityRequirementsPerAgent allocatedCapacity) throws ContainersSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing containers SLA.");
        }
        ContainersSlaPolicy sla = new ContainersSlaPolicy();
        sla.setNewContainerConfig(this.containersConfig);
        sla.setClusterCapacityRequirements(allocatedCapacity);
        sla.setAtMostOneContainerScalePerMachine(false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Containers Manual SLA Policy: #requirements=" + sla.getClusterCapacityRequirements().toDetailedString() + " newContainerConfig.maximumMemoryCapacityInMB=" + sla.getNewContainerConfig().getMaximumMemoryCapacityInMB()));
        }
        try {
            this.containersEndpoint.enforceSla(sla);
            this.containerProvisioningCompletedEvent();
        }
        catch (ContainersSlaEnforcementInProgressException e) {
            this.containerProvisioningInProgressEvent(e);
            throw e;
        }
    }

    private void enforceRebalancingSla(GridServiceContainer[] containers, CapacityRequirementsPerAgent allocatedCapacity) throws RebalancingSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing rebalancing SLA.");
        }
        RebalancingSlaPolicy sla = new RebalancingSlaPolicy();
        sla.setContainers(containers);
        sla.setContainersMarkedForDeallocation(this.containersEndpoint.getContainersMarkedForDeallocation());
        sla.setMaximumNumberOfConcurrentRelocationsPerMachine(this.scaleStrategy.getMaxConcurrentRelocationsPerMachine());
        sla.setSchemaConfig(this.getSchemaConfig());
        sla.setAllocatedCapacity(allocatedCapacity);
        if (this.getSchemaConfig().isDefaultSchema() && this.scaleStrategy instanceof AutomaticCapacityScaleConfig) {
            AutomaticCapacityScaleConfig automaticCapacityScaleConfig = (AutomaticCapacityScaleConfig)this.scaleStrategy;
            int minimumNumberOfInstancesPerPartition = (int)(automaticCapacityScaleConfig.getMinCapacity().getMemoryCapacityInMB() / this.containersConfig.getMaximumMemoryCapacityInMB());
            sla.setMinimumNumberOfInstancesPerPartition(minimumNumberOfInstancesPerPartition);
        } else {
            sla.setMinimumNumberOfInstancesPerPartition(1);
        }
        try {
            this.rebalancingEndpoint.enforceSla(sla);
            this.puInstanceProvisioningCompletedEvent();
        }
        catch (RebalancingSlaEnforcementInProgressException e) {
            this.puInstanceProvisioningInProgressEvent(e);
            throw e;
        }
    }

    protected long calcRoundedTotalMemoryInMB() {
        int targetNumberOfContainers = this.calcTargetNumberOfContainers();
        return (long)targetNumberOfContainers * this.containersConfig.getMaximumMemoryCapacityInMB();
    }

    private int calcTargetNumberOfContainers() {
        if (this.getTotalPlannedMemoryInMB() > 0L) {
            if (this.isStatefulProcessingUnit()) {
                return this.calcTargetNumberOfContainersForPartitionedSchema();
            }
            return this.calcTargetNumberOfContainersForStateless();
        }
        return this.calcDefaultTargetNumberOfContainers();
    }

    private boolean isStatefulProcessingUnit() {
        return this.getSchemaConfig().isPartitionedSync2BackupSchema();
    }

    private long getTotalPlannedMemoryInMB() {
        return AbstractCapacityScaleStrategyBean.getTotalMemoryInMB(this.plannedCapacity);
    }

    private static long getTotalMemoryInMB(CapacityRequirementsPerZonesConfig plannedCapacity) {
        CapacityRequirementsConfig totalCapacity = new CapacityRequirementsConfig(plannedCapacity.toCapacityRequirementsPerZones().getTotalAllocatedCapacity());
        return totalCapacity.getMemoryCapacityInMB();
    }

    private int calcTargetNumberOfContainersForStateless() {
        boolean log = true;
        return this.calcTargetNumberOfContainersForStateless(this.plannedCapacity, true);
    }

    private int calcTargetNumberOfContainersForStateless(CapacityRequirementsPerZonesConfig plannedCapacity, boolean log) {
        long totalMemoryInMB = this.getTotalPlannedMemoryInMB();
        int requiredNumberOfContainers = (int)Math.ceil(1.0 * (double)totalMemoryInMB / (double)this.containersConfig.getMaximumMemoryCapacityInMB());
        int targetNumberOfContainers = Math.max(this.getMinimumNumberOfMachines(), requiredNumberOfContainers);
        if (log) {
            this.getLogger().info((Object)("targetNumberOfContainers= max(minimumNumberOfMachines, ceil(memory/jvm-size))= max(" + this.getMinimumNumberOfMachines() + ",ceil(" + totalMemoryInMB + "/" + this.containersConfig.getMaximumMemoryCapacityInMB() + ")= max(" + this.getMinimumNumberOfMachines() + "," + requiredNumberOfContainers + ")= " + targetNumberOfContainers));
        }
        return targetNumberOfContainers;
    }

    private int calcDefaultTargetNumberOfContainers() {
        int targetNumberOfContainers = Math.max(this.getMinimumNumberOfMachines(), this.getProcessingUnit().getNumberOfBackups() + 1);
        this.getLogger().info((Object)("targetNumberOfContainers= max(minimumNumberOfMachines, numberOfBackupsPerPartition+1)= max(" + this.getMinimumNumberOfMachines() + "," + 1 + "+" + this.getProcessingUnit().getNumberOfBackups() + ")= " + targetNumberOfContainers));
        return targetNumberOfContainers;
    }

    private int calcTargetNumberOfContainersForPartitionedSchema() {
        double totalNumberOfInstances = this.getProcessingUnit().getTotalNumberOfInstances();
        long totalMemoryInMB = this.getTotalPlannedMemoryInMB();
        double avgInstanceCapacityInMB = (double)totalMemoryInMB / totalNumberOfInstances;
        this.getLogger().info((Object)("instanceCapacityInMB= memoryCapacityInMB/(numberOfInstances*(1+numberOfBackups))= " + totalMemoryInMB + "/" + totalNumberOfInstances + "= " + avgInstanceCapacityInMB));
        double containerCapacityInMB = this.containersConfig.getMaximumMemoryCapacityInMB();
        if (containerCapacityInMB < avgInstanceCapacityInMB) {
            throw new BeanConfigurationException("Reduce total capacity from " + totalMemoryInMB + "MB to " + containerCapacityInMB * totalNumberOfInstances + "MB. Container capacity is " + containerCapacityInMB + "MB , given " + totalNumberOfInstances + " instances, the total capacity =" + containerCapacityInMB + "MB *" + totalNumberOfInstances + "= " + containerCapacityInMB * totalNumberOfInstances + "MB. ");
        }
        int targetNumberOfContainers = (int)Math.ceil(1.0 * (double)totalMemoryInMB / containerCapacityInMB);
        this.getLogger().info((Object)("targetNumberOfContainers= ceil(memoryCapacity/containerCapacityInMB)= ceil(" + totalMemoryInMB + "/" + containerCapacityInMB + ") =" + targetNumberOfContainers));
        int numberOfBackups = this.getProcessingUnit().getNumberOfBackups();
        if (targetNumberOfContainers < numberOfBackups + 1) {
            int recommendedMemoryCapacityInMB = (int)((double)(numberOfBackups + 1) * containerCapacityInMB);
            throw new BeanConfigurationException(targetNumberOfContainers + " containers are needed in order to scale to " + totalMemoryInMB + "m , which cannot support " + (numberOfBackups == 1 ? "one backup" : numberOfBackups + " backups") + " per partition. Increase the memory capacity to " + recommendedMemoryCapacityInMB + "m");
        }
        if (targetNumberOfContainers == 0) {
            throw new IllegalStateException("targetNumberOfContainers cannot be zero");
        }
        return targetNumberOfContainers;
    }

    @Override
    protected boolean isUndeploying() {
        return false;
    }

    @Override
    protected void recoverStateOnEsmStart() throws MachinesSlaEnforcementInProgressException, SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, UndeployInProgressException {
        for (CapacityMachinesSlaPolicy sla : this.getMachinesSlas(this.getPlannedZones())) {
            this.machinesEndpoint.recoverStateOnEsmStart(sla);
        }
        this.machinesEndpoint.recoveredStateOnEsmStart(this.getProcessingUnit());
    }

    private List<ZonesConfig> sortZonesByRecoveryOrder(Set<ZonesConfig> zoness) throws MachinesSlaEnforcementInProgressException {
        ArrayList<ZonesConfig> sortedZones = new ArrayList<ZonesConfig>(zoness);
        Collections.sort(sortedZones, new Comparator<ZonesConfig>(){

            @Override
            public int compare(ZonesConfig z1, ZonesConfig z2) {
                return this.rank(z1.getClass()) - this.rank(z2.getClass());
            }

            private int rank(Class<? extends ZonesConfig> clazz) {
                if (ExactZonesConfig.class.isAssignableFrom(clazz)) {
                    return 0;
                }
                return 1;
            }
        });
        return sortedZones;
    }

    @Override
    protected MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit otherPu) {
        return this.machinesEndpoint.getRecoveredStateOnEsmStart(otherPu);
    }

    public CapacityRequirementsPerZones getAllocatedCapacity() throws MachinesSlaEnforcementInProgressException {
        CapacityRequirementsPerZones allocatedCapacityPerZones = new CapacityRequirementsPerZones();
        for (CapacityMachinesSlaPolicy sla : this.getMachinesSlas(this.machinesEndpoint.getGridServiceAgentsZones())) {
            CapacityRequirements allocatedCapacity = this.machinesEndpoint.getAllocatedCapacity(sla).getTotalAllocatedCapacity();
            if (allocatedCapacity.equalsZero()) continue;
            allocatedCapacityPerZones.add(sla.getGridServiceAgentZones(), allocatedCapacity);
        }
        return allocatedCapacityPerZones;
    }

    private List<CapacityMachinesSlaPolicy> getMachinesSlas(Set<ZonesConfig> zoness) throws MachinesSlaEnforcementInProgressException {
        ArrayList<CapacityMachinesSlaPolicy> machinesSlas = new ArrayList<CapacityMachinesSlaPolicy>();
        CapacityRequirementsPerZones capacityRequirementsPerZone = this.plannedCapacity.toCapacityRequirementsPerZones();
        List<ZonesConfig> sortedZoness = this.sortZonesByRecoveryOrder(zoness);
        int minimumNumberOfMachines = this.getMinimumNumberOfMachines();
        if (sortedZoness.size() > 1) {
            minimumNumberOfMachines = 1;
        }
        for (ZonesConfig zones : sortedZoness) {
            CapacityRequirements capacityRequirements = capacityRequirementsPerZone.getZonesCapacityOrZero(zones);
            CapacityMachinesSlaPolicy sla = this.getMachinesSla(zones, minimumNumberOfMachines, capacityRequirements);
            machinesSlas.add(sla);
        }
        return machinesSlas;
    }

    protected boolean isGridServiceAgentZonesAware() {
        boolean isGridServiceAgentZonesAware = false;
        ScaleStrategyConfig config = this.getConfig();
        if (config instanceof ScaleStrategyAgentZonesAwareConfig) {
            isGridServiceAgentZonesAware = ((ScaleStrategyAgentZonesAwareConfig)((Object)config)).isGridServiceAgentZonesAware();
        }
        return isGridServiceAgentZonesAware;
    }
}

