/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.monitor.event.EventsStore;
import org.openspaces.admin.Admin;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningProgressChangedEvent;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningProgressChangedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningProgressChangedEvent;
import org.openspaces.admin.internal.gsc.events.DefaultElasticGridServiceContainerProvisioningProgressChangedEvent;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningProgressChangedEvent;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.admin.internal.pu.elastic.ScaleStrategyConfigUtils;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingProgressChangedEvent;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticProcessingUnitInstanceProvisioningProgressChangedEvent;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticProcessingUnitScaleProgressChangedEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitProgressChangedEvent;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningProgressChangedEvent;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningProgressChangedEventListener;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.ManualCapacityScaleConfig;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.bean.Bean;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.core.util.StringProperties;
import org.openspaces.grid.gsm.ElasticMachineProvisioningAware;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.ProcessingUnitAware;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackup;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupAware;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolation;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolationAware;
import org.openspaces.grid.gsm.machines.plugins.ElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioningAdapter;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.BlockingAfterPropertiesSetFailedException;
import org.openspaces.grid.gsm.sla.exceptions.BlockingAfterPropertiesSetInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.CannotDiscoverEsmException;
import org.openspaces.grid.gsm.sla.exceptions.DisconnectedFromLookupServiceException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.TooManyEsmComponentsException;
import org.openspaces.grid.gsm.sla.exceptions.WrongNumberOfESMComponentsException;
import org.openspaces.grid.gsm.strategy.DiscoveredMachinesCache;
import org.openspaces.grid.gsm.strategy.ElasticMachineProvisioningDiscoveredMachinesCache;
import org.openspaces.grid.gsm.strategy.ElasticScaleStrategyEventStorageAware;
import org.openspaces.grid.gsm.strategy.ScaleStrategyBean;
import org.openspaces.grid.gsm.strategy.ScaleStrategyProgressEventState;

public abstract class AbstractScaleStrategyBean
implements ElasticMachineProvisioningAware,
ProcessingUnitAware,
ElasticScaleStrategyEventStorageAware,
ScaleStrategyBean,
ElasticProcessingUnitMachineIsolationAware,
MachinesStateBackupAware,
Bean,
Runnable {
    private static final int MAX_NUMBER_OF_MACHINES = 1000;
    private InternalAdmin admin;
    private InternalProcessingUnit pu;
    private ProcessingUnitSchemaConfig schemaConfig;
    private NonBlockingElasticMachineProvisioning machineProvisioning;
    private StringProperties properties;
    private Log logger;
    private int minimumNumberOfMachines;
    private ElasticProcessingUnitMachineIsolation isolation;
    private ScheduledFuture<?> scheduledTask;
    private ElasticMachineProvisioningDiscoveredMachinesCache provisionedMachines;
    private boolean isScaleInProgress;
    private ScaleStrategyProgressEventState machineProvisioningEventState;
    private ScaleStrategyProgressEventState agentProvisioningEventState;
    private ScaleStrategyProgressEventState containerProvisioningEventState;
    private ScaleStrategyProgressEventState puProvisioningEventState;
    private ScaleStrategyProgressEventState scaleEventState;
    private ScaleStrategyProgressEventState capacityPlanningEventState;
    private EventsStore eventsStore;
    private boolean discoveryQuiteMode;
    private final ExchangeCountDownLatch<Throwable> blockingAfterPropertiesSetComplete = new ExchangeCountDownLatch(1);
    private boolean loggedBlockingAfterPropertiesSetException = false;
    private MachinesStateBackup stateBackup;

    protected InternalAdmin getAdmin() {
        return this.admin;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected int getMinimumNumberOfMachines() {
        return this.minimumNumberOfMachines;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public void setProcessingUnit(ProcessingUnit pu) {
        this.pu = (InternalProcessingUnit)pu;
    }

    protected InternalProcessingUnit getProcessingUnit() {
        return this.pu;
    }

    protected long getPollingIntervalSeconds() {
        return ScaleStrategyConfigUtils.getPollingIntervalSeconds(this.properties);
    }

    @Override
    public void setElasticProcessingUnitMachineIsolation(ElasticProcessingUnitMachineIsolation isolation) {
        this.isolation = isolation;
    }

    protected ElasticProcessingUnitMachineIsolation getIsolation() {
        return this.isolation;
    }

    @Override
    public void setProcessingUnitSchema(ProcessingUnitSchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    protected ProcessingUnitSchemaConfig getSchemaConfig() {
        return this.schemaConfig;
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = (InternalAdmin)admin;
    }

    @Override
    public void setElasticMachineProvisioning(NonBlockingElasticMachineProvisioning machineProvisioning) {
        this.machineProvisioning = machineProvisioning;
    }

    @Override
    public void setMachinesStateBackup(MachinesStateBackup stateBackup) {
        this.stateBackup = stateBackup;
    }

    protected NonBlockingElasticMachineProvisioning getMachineProvisioning() {
        return this.machineProvisioning;
    }

    @Override
    public void setElasticScaleStrategyEventStorage(EventsStore eventQueue) {
        this.eventsStore = eventQueue;
    }

    protected void setMachineDiscoveryQuiteMode(boolean discoveryQuiteMode) {
        this.discoveryQuiteMode = discoveryQuiteMode;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.pu == null) {
            throw new IllegalStateException("pu cannot be null");
        }
        if (this.properties == null) {
            throw new IllegalStateException("properties cannot be null.");
        }
        if (this.admin == null) {
            throw new IllegalStateException("admin cannot be null.");
        }
        this.validateCorrectThread();
        if (this.machineProvisioning == null) {
            throw new IllegalStateException("machine provisioning cannot be null.");
        }
        if (this.schemaConfig == null) {
            throw new IllegalStateException("schemaConfig cannot be null.");
        }
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(this.getClass())), this.pu);
        this.logger.info((Object)("properties: " + this.properties));
        this.machineProvisioningEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticMachineProvisioningProgressChangedEvent.class);
        this.agentProvisioningEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticGridServiceAgentProvisioningProgressChangedEvent.class);
        this.containerProvisioningEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticGridServiceContainerProvisioningProgressChangedEvent.class);
        this.puProvisioningEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticProcessingUnitInstanceProvisioningProgressChangedEvent.class);
        this.scaleEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticProcessingUnitScaleProgressChangedEvent.class);
        this.capacityPlanningEventState = new ScaleStrategyProgressEventState(this.eventsStore, this.isUndeploying(), this.pu.getName(), DefaultElasticAutoScalingProgressChangedEvent.class);
        this.minimumNumberOfMachines = this.calcMinimumNumberOfMachines();
        this.provisionedMachines = new ElasticMachineProvisioningDiscoveredMachinesCache(this.pu, this.machineProvisioning, this.discoveryQuiteMode, this.getPollingIntervalSeconds());
        this.isScaleInProgress = true;
        this.validateCorrectThread();
        ElasticGridServiceAgentProvisioningProgressChangedEventListener agentEventListener = new ElasticGridServiceAgentProvisioningProgressChangedEventListener(){

            @Override
            public void elasticGridServiceAgentProvisioningProgressChanged(final ElasticGridServiceAgentProvisioningProgressChangedEvent event) {
                if (!(event instanceof InternalElasticProcessingUnitProgressChangedEvent)) {
                    throw new IllegalArgumentException("event must implement " + InternalElasticProcessingUnitProgressChangedEvent.class.getName());
                }
                AbstractScaleStrategyBean.this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        AbstractScaleStrategyBean.this.injectEventContext((InternalElasticProcessingUnitProgressChangedEvent)((Object)event));
                        AbstractScaleStrategyBean.this.agentProvisioningEventState.enqueuProvisioningInProgressEvent((InternalElasticProcessingUnitProgressChangedEvent)((Object)event));
                    }
                });
            }
        };
        this.machineProvisioning.setElasticGridServiceAgentProvisioningProgressEventListener(agentEventListener);
        ElasticMachineProvisioningProgressChangedEventListener machineEventListener = new ElasticMachineProvisioningProgressChangedEventListener(){

            @Override
            public void elasticMachineProvisioningProgressChanged(final ElasticMachineProvisioningProgressChangedEvent event) {
                if (!(event instanceof InternalElasticProcessingUnitProgressChangedEvent)) {
                    throw new IllegalArgumentException("event must implement " + InternalElasticProcessingUnitProgressChangedEvent.class.getName());
                }
                AbstractScaleStrategyBean.this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        AbstractScaleStrategyBean.this.injectEventContext((InternalElasticProcessingUnitProgressChangedEvent)((Object)event));
                        AbstractScaleStrategyBean.this.machineProvisioningEventState.enqueuProvisioningInProgressEvent((InternalElasticProcessingUnitProgressChangedEvent)((Object)event));
                    }
                });
            }
        };
        this.machineProvisioning.setElasticMachineProvisioningProgressChangedEventListener(machineEventListener);
        final ElasticMachineProvisioning emp = this.getElasticMachineProvisioningOrNull();
        if (emp == null) {
            this.blockingAfterPropertiesSetComplete.countDown(null);
        } else {
            this.admin.scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    try {
                        emp.blockingAfterPropertiesSet();
                        AbstractScaleStrategyBean.this.blockingAfterPropertiesSetComplete.countDown(null);
                    }
                    catch (Throwable t) {
                        AbstractScaleStrategyBean.this.blockingAfterPropertiesSetComplete.countDown((Object)t);
                    }
                }
            });
        }
        this.scheduledTask = this.admin.scheduleWithFixedDelayNonBlockingStateChange(this, 0L, this.getPollingIntervalSeconds(), TimeUnit.SECONDS);
        this.logger.debug((Object)(this.pu.getName() + " is being monitored for SLA violations every " + this.getPollingIntervalSeconds() + " seconds"));
    }

    private void injectEventContext(InternalElasticProcessingUnitProgressChangedEvent event) {
        event.setProcessingUnitName(this.pu.getName());
        event.setComplete(false);
        event.setUndeploying(this.isUndeploying());
    }

    @Override
    public void destroy() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
        this.provisionedMachines.destroy();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    protected DiscoveredMachinesCache getDiscoveredMachinesCache() {
        return this.provisionedMachines;
    }

    private int calcMinimumNumberOfMachines() {
        if (this.getSchemaConfig().isDefaultSchema()) {
            return 1;
        }
        if (this.getSchemaConfig().isPartitionedSync2BackupSchema()) {
            int minNumberOfMachines;
            if (this.getProcessingUnit().getMaxInstancesPerMachine() == 0) {
                minNumberOfMachines = 1;
                this.getLogger().info((Object)"minNumberOfMachines=1 (since max instances from same partition per machine is not defined)");
            } else {
                minNumberOfMachines = (int)Math.ceil((double)(1 + this.getProcessingUnit().getNumberOfBackups()) / (1.0 * (double)this.getProcessingUnit().getMaxInstancesPerMachine()));
                this.getLogger().info((Object)("minNumberOfMachines= ceil((1+backupsPerPartition)/maxInstancesPerPartitionPerMachine)= ceil(" + (1 + this.getProcessingUnit().getNumberOfBackups()) + "/" + this.getProcessingUnit().getMaxInstancesPerMachine() + ")= " + minNumberOfMachines));
            }
            return minNumberOfMachines;
        }
        throw new BeanConfigurationException("Processing Unit " + this.pu.getName() + "needs to be either stateless, or stateful or a space (it is " + this.schemaConfig.getSchema());
    }

    protected int getMaximumNumberOfInstances() {
        if (this.getSchemaConfig().isPartitionedSync2BackupSchema()) {
            return this.getProcessingUnit().getTotalNumberOfInstances();
        }
        return 1000;
    }

    public Fraction getContainerNumberOfCpuCores(ManualCapacityScaleConfig slaConfig) {
        if (this.getSchemaConfig().isPartitionedSync2BackupSchema()) {
            Fraction cpuCores = MachinesSlaUtils.convertCpuCoresFromDoubleToFraction(slaConfig.getNumberOfCpuCores());
            return cpuCores.divide(this.pu.getNumberOfInstances());
        }
        return Fraction.ONE;
    }

    @Override
    public void run() {
        if (!this.isScaleInProgress() && this.isUndeploying()) {
            return;
        }
        try {
            this.validateBlockingAfterPropertiesSetCompleted();
            this.recoverOnStartBeforeEnforceSLA();
            this.stateBackup.validateBackupCompleted(this.pu);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"enforcing SLA.");
            }
            this.enforceSla();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"SLA enforced.");
            }
            ZonesConfig zones = null;
            this.scaleEventState.enqueuProvisioningCompletedEvent(zones);
            this.isScaleInProgress = false;
        }
        catch (SlaEnforcementInProgressException e) {
            ZonesConfig zones = null;
            this.scaleEventState.enqueuDefaultProvisioningInProgressEvent(e, zones);
            this.isScaleInProgress = true;
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Unhandled Exception", t);
            ZonesConfig zones = null;
            this.scaleEventState.enqueuDefaultProvisioningInProgressEvent(t, zones);
            this.isScaleInProgress = true;
        }
    }

    private void validateBlockingAfterPropertiesSetCompleted() throws BlockingAfterPropertiesSetInProgressException, InterruptedException, BlockingAfterPropertiesSetFailedException {
        try {
            if (this.blockingAfterPropertiesSetComplete.getCount() > 0L) {
                throw new BlockingAfterPropertiesSetInProgressException(this.pu);
            }
            Throwable t = (Throwable)this.blockingAfterPropertiesSetComplete.get();
            if (t != null) {
                throw new BlockingAfterPropertiesSetFailedException((ProcessingUnit)this.pu, t);
            }
        }
        catch (BlockingAfterPropertiesSetInProgressException e) {
            if (!this.loggedBlockingAfterPropertiesSetException) {
                this.getLogger().warn((Object)"SLA is not enforced", (Throwable)e);
                this.loggedBlockingAfterPropertiesSetException = true;
            }
            throw e;
        }
    }

    private void recoverOnStartBeforeEnforceSLA() throws SlaEnforcementInProgressException {
        try {
            this.validateCorrectThread();
            this.validateAtLeastOneLookupServiceDiscovered();
            this.validateOnlyOneESMRunning();
            MachinesSlaEnforcementState.RecoveryState recoveryState = this.getRecoveredStateOnEsmStart();
            if (recoveryState.equals((Object)MachinesSlaEnforcementState.RecoveryState.RECOVERY_FAILED)) {
                ArrayList<ProcessingUnit> pusNotCompletedStateRecovery = new ArrayList<ProcessingUnit>();
                pusNotCompletedStateRecovery.add(this.getProcessingUnit());
                throw new SomeProcessingUnitsHaveNotCompletedStateRecoveryException((ProcessingUnit)this.getProcessingUnit(), pusNotCompletedStateRecovery);
            }
            if (recoveryState.equals((Object)MachinesSlaEnforcementState.RecoveryState.NOT_RECOVERED)) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)"recovering state on ESM start.");
                }
                this.recoverStateOnEsmStart();
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)"recovered state on ESM start.");
                }
                MachinesSlaEnforcementState.RecoveryState newRecoveryState = this.getRecoveredStateOnEsmStart();
                if (!this.getRecoveredStateOnEsmStart().equals((Object)MachinesSlaEnforcementState.RecoveryState.RECOVERY_SUCCESS)) {
                    throw new IllegalStateException("PU " + this.getProcessingUnit().getName() + " recovery state is " + (Object)((Object)newRecoveryState) + " instead of " + (Object)((Object)MachinesSlaEnforcementState.RecoveryState.RECOVERY_SUCCESS));
                }
            }
            this.validateAllProcessingUnitsRecoveredStateOnEsmStart();
            this.stateBackup.recoverAndStartBackup(this.pu);
        }
        catch (SlaEnforcementInProgressException e) {
            this.getLogger().info((Object)"SLA is not enforced", (Throwable)e);
            throw e;
        }
    }

    private void validateCorrectThread() {
        this.admin.assertStateChangesPermitted();
    }

    private MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart() {
        return this.getRecoveredStateOnEsmStart(this.pu);
    }

    protected abstract MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit var1);

    protected abstract void recoverStateOnEsmStart() throws MachinesSlaEnforcementInProgressException, SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, UndeployInProgressException;

    protected void validateAllProcessingUnitsRecoveredStateOnEsmStart() throws SomeProcessingUnitsHaveNotCompletedStateRecoveryException {
        ArrayList<ProcessingUnit> pusNotCompletedStateRecovery = new ArrayList<ProcessingUnit>();
        Admin admin = this.pu.getAdmin();
        for (ProcessingUnit otherPu : admin.getProcessingUnits()) {
            Map<String, String> elasticProperties = ((InternalProcessingUnit)otherPu).getElasticProperties();
            if (elasticProperties.isEmpty() || !this.getRecoveredStateOnEsmStart(otherPu).equals((Object)MachinesSlaEnforcementState.RecoveryState.NOT_RECOVERED)) continue;
            pusNotCompletedStateRecovery.add(otherPu);
        }
        if (!pusNotCompletedStateRecovery.isEmpty()) {
            throw new SomeProcessingUnitsHaveNotCompletedStateRecoveryException((ProcessingUnit)this.getProcessingUnit(), pusNotCompletedStateRecovery);
        }
    }

    private void validateAtLeastOneLookupServiceDiscovered() throws DisconnectedFromLookupServiceException {
        int numberOfLookupServices = this.admin.getLookupServices().getSize();
        if (numberOfLookupServices == 0) {
            DisconnectedFromLookupServiceException e = new DisconnectedFromLookupServiceException((ProcessingUnit)this.getProcessingUnit(), this.admin.getLocators(), this.admin.getGroups());
            ZonesConfig zones = null;
            this.machineProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
            throw e;
        }
    }

    private void validateOnlyOneESMRunning() throws WrongNumberOfESMComponentsException {
        int numberOfEsms = this.admin.getElasticServiceManagers().getSize();
        if (numberOfEsms != 1) {
            WrongNumberOfESMComponentsException e;
            if (numberOfEsms == 0) {
                e = new CannotDiscoverEsmException(this.getProcessingUnit().getName());
            } else {
                for (ElasticServiceManager esm : this.admin.getElasticServiceManagers()) {
                    this.logger.info((Object)("Found ESM " + MachinesSlaUtils.esmToString(esm) + ", discovered status=" + esm.isDiscovered()));
                }
                e = new TooManyEsmComponentsException(numberOfEsms, this.getProcessingUnit().getName());
            }
            ZonesConfig zones = null;
            this.machineProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
            throw e;
        }
    }

    protected abstract void enforceSla() throws SlaEnforcementInProgressException;

    protected abstract boolean isUndeploying();

    @Override
    public boolean isScaleInProgress() {
        return this.isScaleInProgress;
    }

    protected void agentProvisioningCompletedEvent(ZonesConfig zones) {
        this.agentProvisioningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void agentProvisioningInProgressEvent(GridServiceAgentSlaEnforcementInProgressException e, ZonesConfig zones) {
        this.agentProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
    }

    protected void machineProvisioningCompletedEvent(ZonesConfig zones) {
        this.machineProvisioningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void machineProvisioningInProgressEvent(MachinesSlaEnforcementInProgressException e, ZonesConfig zones) {
        this.machineProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
    }

    protected void containerProvisioningCompletedEvent() {
        ZonesConfig zones = null;
        this.containerProvisioningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void containerProvisioningInProgressEvent(ContainersSlaEnforcementInProgressException e) {
        ZonesConfig zones = null;
        this.containerProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
    }

    protected void puInstanceProvisioningCompletedEvent() {
        ZonesConfig zones = null;
        this.puProvisioningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void puInstanceProvisioningInProgressEvent(RebalancingSlaEnforcementInProgressException e) {
        ZonesConfig zones = null;
        this.puProvisioningEventState.enqueuProvisioningInProgressEvent(e, zones);
    }

    protected void capacityPlanningCompletedEvent() {
        ZonesConfig zones = null;
        this.capacityPlanningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void capacityPlanningCompletedEvent(ZonesConfig zones) {
        this.capacityPlanningEventState.enqueuProvisioningCompletedEvent(zones);
    }

    protected void capacityPlanningInProgressEvent(AutoScalingSlaEnforcementInProgressException e, ZonesConfig zones) {
        this.capacityPlanningEventState.enqueuProvisioningInProgressEvent(e, zones);
    }

    public void capacityPlanningInProgressEvent(ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent event) {
        this.capacityPlanningEventState.enqueuProvisioningInProgressEvent(event);
    }

    public ElasticMachineProvisioning getElasticMachineProvisioningOrNull() {
        NonBlockingElasticMachineProvisioning nonBlockingElasticMachineProvisioning = this.getMachineProvisioning();
        if (nonBlockingElasticMachineProvisioning instanceof NonBlockingElasticMachineProvisioningAdapter) {
            ElasticMachineProvisioning emp = ((NonBlockingElasticMachineProvisioningAdapter)nonBlockingElasticMachineProvisioning).getElasticMachineProvisioning();
            return emp;
        }
        return null;
    }

    public Remote getRemoteApi(String apiName) throws Exception {
        ElasticMachineProvisioning emp = this.getElasticMachineProvisioningOrNull();
        if (emp == null) {
            throw new IllegalStateException("NonBlockingElasticMachineProvisioning instance (" + this.getMachineProvisioning() + ") is not an instance of NonBlockingElasticMachineProvisioningAdapter");
        }
        return (Remote)emp.getExternalApi(apiName);
    }
}

