/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleConfig;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsPerZonesConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsIdConfigurer;
import org.openspaces.admin.pu.statistics.TimeWindowStatisticsConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaPolicy;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaUtils;
import org.openspaces.grid.gsm.autoscaling.AutomaticCapacityCooldownValidator;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingConfigConflictException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingHighThresholdBreachedException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingLowThresholdBreachedException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingThresholdBreachedException;
import org.openspaces.grid.gsm.autoscaling.exceptions.PerZoneAutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerZones;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaHasChangedException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.strategy.AbstractCapacityScaleStrategyBean;

public class AutomaticCapacityScaleStrategyBean
extends AbstractCapacityScaleStrategyBean
implements AutoScalingSlaEnforcementEndpointAware {
    private AutoScalingSlaEnforcementEndpoint autoScalingEndpoint;
    private AutomaticCapacityScaleConfig config;
    private AutomaticCapacityCooldownValidator cooldownValidator;
    private CapacityRequirementsPerZones enforced;

    @Override
    public void setAutoScalingSlaEnforcementEndpoint(AutoScalingSlaEnforcementEndpoint endpoint) {
        this.autoScalingEndpoint = endpoint;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.config = new AutomaticCapacityScaleConfig(super.getProperties());
        this.validateConfig();
        this.cooldownValidator = new AutomaticCapacityCooldownValidator();
        this.cooldownValidator.setCooldownAfterInstanceAdded(this.config.getCooldownAfterScaleOutSeconds(), TimeUnit.SECONDS);
        this.cooldownValidator.setCooldownAfterInstanceRemoved(this.config.getCooldownAfterScaleInSeconds(), TimeUnit.SECONDS);
        this.cooldownValidator.setProcessingUnit(this.getProcessingUnit());
        CapacityRequirementsConfig initialCapacity = this.config.getInitialCapacity();
        if (initialCapacity == null) {
            initialCapacity = this.config.getMinCapacity();
        }
        super.setPlannedCapacity(initialCapacity);
        super.setScaleStrategyConfig(this.config);
        this.getAdmin().scheduleAdminOperation(new Runnable(){

            @Override
            public void run() {
                AutomaticCapacityScaleStrategyBean.this.getProcessingUnit().setStatisticsInterval(AutomaticCapacityScaleStrategyBean.this.config.getStatisticsPollingIntervalSeconds(), TimeUnit.SECONDS);
                AutomaticCapacityScaleStrategyBean.this.getProcessingUnit().startStatisticsMonitor();
                if (AutomaticCapacityScaleStrategyBean.this.getLogger().isDebugEnabled()) {
                    AutomaticCapacityScaleStrategyBean.this.getLogger().debug((Object)("isGridServiceAgentZonesAware=" + AutomaticCapacityScaleStrategyBean.this.isGridServiceAgentZonesAware()));
                }
                AutomaticCapacityScaleStrategyBean.this.enablePuStatistics();
            }
        });
    }

    private void validateConfig() {
        this.validateRulesConfig();
        CapacityRequirements min = this.config.getMinCapacity().toCapacityRequirements();
        if (min == null) {
            throw new BeanConfigurationException("Minimum capacity requirements is undefined");
        }
        CapacityRequirements max = this.config.getMaxCapacity().toCapacityRequirements();
        if (max == null) {
            throw new BeanConfigurationException("Maximum capacity requirements is undefined");
        }
        if (min.greaterThan(max)) {
            throw new BeanConfigurationException("Maximum capacity (" + max + ") is less than minimum capacity (" + min + ")");
        }
        CapacityRequirementsConfig initialConfig = this.config.getInitialCapacity();
        if (initialConfig != null) {
            CapacityRequirements initial = initialConfig.toCapacityRequirements();
            if (min.greaterThan(initial)) {
                throw new BeanConfigurationException("Initial capacity (" + initial + ") is less than minimum capacity (" + min + ")");
            }
            if (initial.greaterThan(max)) {
                throw new BeanConfigurationException("Initial capacity (" + initial + ") is greater than maximum capacity (" + min + ")");
            }
        }
    }

    @Override
    public void destroy() {
        this.disablePuStatistics();
        super.destroy();
    }

    @Override
    public ScaleStrategyConfig getConfig() {
        return this.config;
    }

    @Override
    protected void recoverStateOnEsmStart() throws SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, MachinesSlaEnforcementInProgressException, UndeployInProgressException {
        super.recoverStateOnEsmStart();
        CapacityRequirementsPerZones recoveredCapacity = super.getAllocatedCapacity();
        if (!recoveredCapacity.equalsZero()) {
            this.setPlannedCapacity(recoveredCapacity);
        }
    }

    @Override
    protected boolean setPlannedCapacity(CapacityRequirementsPerZonesConfig config) {
        boolean planChanged = super.setPlannedCapacity(config);
        if (planChanged) {
            this.enablePuStatistics();
        }
        return planChanged;
    }

    @Override
    protected void enforceSla() throws SlaEnforcementInProgressException {
        PerZoneAutoScalingSlaEnforcementInProgressException pendingAutoscaleInProgressExceptions = new PerZoneAutoScalingSlaEnforcementInProgressException(this.getProcessingUnit(), "Multiple Exceptions");
        SlaEnforcementInProgressException pendingEnforcePlannedCapacityException = null;
        CapacityRequirementsPerZones planned = super.getPlannedCapacity().toCapacityRequirementsPerZones();
        try {
            super.enforcePlannedCapacity();
            this.enforced = planned;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("enforcedCapacityRequirementsPerZones = " + planned));
            }
        }
        catch (RebalancingSlaEnforcementInProgressException e) {
            throw e;
        }
        catch (ContainersSlaEnforcementInProgressException e) {
            throw e;
        }
        catch (MachinesSlaHasChangedException e) {
            throw e;
        }
        catch (SlaEnforcementInProgressException e) {
            if (this.enforced == null) {
                throw e;
            }
            pendingEnforcePlannedCapacityException = e;
        }
        CapacityRequirementsPerZones newPlanned = new CapacityRequirementsPerZones();
        this.cooldownValidator.validate();
        HashSet<ZonesConfig> zoness = new HashSet<ZonesConfig>();
        if (this.isGridServiceAgentZonesAware()) {
            zoness.addAll(this.enforced.getZones());
        } else {
            zoness.add(this.getDefaultZones());
        }
        for (ZonesConfig zones : zoness) {
            try {
                this.enforceAutoScalingSla(zones, this.enforced, newPlanned);
            }
            catch (AutoScalingHighThresholdBreachedException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("High threshold breached. Settings zones " + zones + " capacity to " + e.getNewCapacity()));
                }
                newPlanned = newPlanned.set(zones, e.getNewCapacity());
            }
            catch (AutoScalingLowThresholdBreachedException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Low threshold breached. Settings zones " + zones + " capacity to " + e.getNewCapacity()));
                }
                newPlanned = newPlanned.set(zones, e.getNewCapacity());
            }
            catch (AutoScalingSlaEnforcementInProgressException e) {
                pendingAutoscaleInProgressExceptions.addReason(zones, e);
            }
            if (newPlanned.getZones().contains(zones)) continue;
            CapacityRequirements plannedForZones = planned.getZonesCapacityOrZero(zones);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Copying existing zones " + zones + " capacity " + plannedForZones));
            }
            newPlanned = newPlanned.set(zones, plannedForZones);
        }
        boolean planChanged = this.setPlannedCapacity(new CapacityRequirementsPerZonesConfig(newPlanned));
        if (pendingEnforcePlannedCapacityException != null) {
            throw pendingEnforcePlannedCapacityException;
        }
        if (pendingAutoscaleInProgressExceptions.hasReason()) {
            throw pendingAutoscaleInProgressExceptions;
        }
        this.capacityPlanningCompletedEvent();
        if (planChanged) {
            super.enforcePlannedCapacity();
        }
    }

    private void enforceAutoScalingSla(ZonesConfig zones, CapacityRequirementsPerZones enforced, CapacityRequirementsPerZones newPlanned) throws AutoScalingSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing automatic scaling SLA.");
        }
        AutoScalingSlaPolicy sla = new AutoScalingSlaPolicy();
        sla.setCapacityRequirements(enforced.getZonesCapacityOrZero(zones));
        CapacityRequirements minimum = this.config.getMinCapacity().toCapacityRequirements();
        CapacityRequirements maximum = this.config.getMaxCapacity().toCapacityRequirements();
        if (this.isGridServiceAgentZonesAware()) {
            CapacityRequirements maximumPerZone = this.config.getMaxCapacityPerZone().toCapacityRequirements();
            CapacityRequirements minimumPerZone = this.config.getMinCapacityPerZone().toCapacityRequirements();
            maximum = AutoScalingSlaUtils.getMaximumCapacity(maximum, maximumPerZone, enforced, newPlanned, zones);
            minimum = AutoScalingSlaUtils.getMinimumCapacity(minimum, minimumPerZone, enforced, newPlanned, zones);
        }
        sla.setMaxCapacity(maximum);
        sla.setMinCapacity(minimum);
        sla.setRules(this.config.getRules());
        sla.setZonesConfig(zones);
        sla.setContainerMemoryCapacityInMB(this.getGridServiceContainerConfig().getMaximumMemoryCapacityInMB());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Automatic Scaling SLA Policy: " + sla));
        }
        try {
            if (!maximum.greaterOrEquals(minimum)) {
                throw new AutoScalingConfigConflictException(this.getProcessingUnit(), minimum, maximum, zones.getZones(), enforced, newPlanned);
            }
            this.autoScalingEndpoint.enforceSla(sla);
        }
        catch (AutoScalingThresholdBreachedException e) {
            CapacityRequirementsPerZones plannedPerZones = super.getPlannedCapacity().toCapacityRequirementsPerZones();
            if (plannedPerZones.getZones().contains(zones) && plannedPerZones.getZonesCapacity(zones).equals(e.getNewCapacity())) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Threshold breached. However existing plan already reflects that " + e.getNewCapacity()), (Throwable)e);
                }
            }
            CapacityRequirements oldPlan = plannedPerZones.getZonesCapacityOrZero(zones);
            e.setOldPlan(oldPlan);
            this.capacityPlanningInProgressEvent(e, zones);
            throw e;
        }
        catch (AutoScalingSlaEnforcementInProgressException e) {
            this.capacityPlanningInProgressEvent(e, zones);
            throw e;
        }
        this.capacityPlanningCompletedEvent(zones);
    }

    private void validateRulesConfig() {
        for (AutomaticCapacityScaleRuleConfig rule : this.config.getRules()) {
            if (rule.getLowThresholdBreachedDecrease().toCapacityRequirements().equalsZero() || rule.getHighThresholdBreachedIncrease().toCapacityRequirements().equalsZero()) continue;
            try {
                if (AutoScalingSlaUtils.compare(rule.getLowThreshold(), rule.getHighThreshold()) <= 0) continue;
                throw new BeanConfigurationException("Low threshold (" + rule.getLowThreshold() + ") cannot be higher than high threshold (" + rule.getHighThreshold() + ")");
            }
            catch (NumberFormatException e) {
                throw new BeanConfigurationException("Failed to compare low threshold (" + rule.getLowThreshold() + ") and high threshold (" + rule.getHighThreshold() + ")", e);
            }
        }
    }

    private void enablePuStatistics() {
        int maxNumberOfSamples = 1;
        this.getLogger().info((Object)("enabling pu statistics for processing unit " + this.getProcessingUnit().getName()));
        for (AutomaticCapacityScaleRuleConfig rule : this.config.getRules()) {
            ProcessingUnitStatisticsId statisticsId = rule.getStatistics();
            TimeWindowStatisticsConfig timeWindowStatistics = statisticsId.getTimeWindowStatistics();
            if (!this.isGridServiceAgentZonesAware()) {
                ProcessingUnitStatisticsId id = new ProcessingUnitStatisticsIdConfigurer().agentZones(this.getDefaultZones()).instancesStatistics(statisticsId.getInstancesStatistics()).metric(statisticsId.getMetric()).monitor(statisticsId.getMonitor()).timeWindowStatistics(statisticsId.getTimeWindowStatistics()).create();
                maxNumberOfSamples = Math.max(maxNumberOfSamples, timeWindowStatistics.getMaxNumberOfSamples(this.config.getStatisticsPollingIntervalSeconds(), TimeUnit.SECONDS));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("adding statistics calculation : " + id));
                }
                this.getProcessingUnit().addStatisticsCalculation(id);
                continue;
            }
            Set<ZonesConfig> plannedZones = super.getPlannedZones();
            this.getLogger().info((Object)("plannedZones = " + plannedZones));
            for (ZonesConfig zones : plannedZones) {
                zones.validate();
                ProcessingUnitStatisticsId id = new ProcessingUnitStatisticsIdConfigurer().agentZones(zones).instancesStatistics(statisticsId.getInstancesStatistics()).metric(statisticsId.getMetric()).monitor(statisticsId.getMonitor()).timeWindowStatistics(statisticsId.getTimeWindowStatistics()).create();
                this.getProcessingUnit().addStatisticsCalculation(id);
                maxNumberOfSamples = Math.max(maxNumberOfSamples, timeWindowStatistics.getMaxNumberOfSamples(this.config.getStatisticsPollingIntervalSeconds(), TimeUnit.SECONDS));
            }
        }
        this.getLogger().info((Object)("Start statistics polling for " + this.getProcessingUnit().getName() + " to " + this.config.getStatisticsPollingIntervalSeconds() + " seconds, history size is " + maxNumberOfSamples + " samples."));
        this.getProcessingUnit().setStatisticsHistorySize(maxNumberOfSamples);
    }

    private void disablePuStatistics() {
        this.getProcessingUnit().stopStatisticsMonitor();
    }
}

