/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.EagerScaleConfig;
import org.openspaces.admin.zone.config.AnyZonesConfig;
import org.openspaces.grid.gsm.GridServiceContainerConfigAware;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.containers.ContainersSlaPolicy;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementPendingProcessingUnitDeallocationException;
import org.openspaces.grid.gsm.machines.EagerMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.exceptions.FailedToDiscoverMachinesException;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementPendingContainerDeallocationException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.WaitingForDiscoveredMachinesException;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaPolicy;
import org.openspaces.grid.gsm.rebalancing.exceptions.RebalancingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.strategy.AbstractScaleStrategyBean;

public class EagerScaleStrategyBean
extends AbstractScaleStrategyBean
implements RebalancingSlaEnforcementEndpointAware,
ContainersSlaEnforcementEndpointAware,
MachinesSlaEnforcementEndpointAware,
GridServiceContainerConfigAware {
    private EagerScaleConfig slaConfig;
    private MachinesSlaEnforcementEndpoint machinesEndpoint;
    private ContainersSlaEnforcementEndpoint containersEndpoint;
    private RebalancingSlaEnforcementEndpoint rebalancingEndpoint;
    private GridServiceContainerConfig containersConfig;

    @Override
    public void setMachinesSlaEnforcementEndpoint(MachinesSlaEnforcementEndpoint endpoint) {
        this.machinesEndpoint = endpoint;
    }

    @Override
    public void setContainersSlaEnforcementEndpoint(ContainersSlaEnforcementEndpoint containersService) {
        this.containersEndpoint = containersService;
    }

    @Override
    public void setRebalancingSlaEnforcementEndpoint(RebalancingSlaEnforcementEndpoint relocationService) {
        this.rebalancingEndpoint = relocationService;
    }

    @Override
    public void setGridServiceContainerConfig(GridServiceContainerConfig containersConfig) {
        this.containersConfig = containersConfig;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.machinesEndpoint == null) {
            throw new IllegalStateException("machines endpoint cannot be null.");
        }
        if (this.containersEndpoint == null) {
            throw new IllegalStateException("containers endpoint cannot be null");
        }
        if (this.rebalancingEndpoint == null) {
            throw new IllegalStateException("rebalancing endpoint cannot be null.");
        }
        this.slaConfig = new EagerScaleConfig(super.getProperties());
    }

    @Override
    public void enforceSla() throws SlaEnforcementInProgressException {
        SlaEnforcementInProgressException pendingException = null;
        EagerMachinesSlaPolicy machinesSla = this.getMachinesSlaPolicy();
        try {
            this.enforceMachinesSla(machinesSla);
        }
        catch (GridServiceAgentSlaEnforcementPendingContainerDeallocationException e) {
            pendingException = e;
        }
        CapacityRequirementsPerAgent allocatedCapacity = this.machinesEndpoint.getAllocatedCapacity(machinesSla);
        try {
            this.enforceContainersSla(allocatedCapacity);
        }
        catch (ContainersSlaEnforcementPendingProcessingUnitDeallocationException e) {
            pendingException = e;
        }
        this.enforceRebalancingSla(allocatedCapacity, this.containersEndpoint.getContainers());
        if (pendingException != null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("Eager scale - pending resolution of: " + pendingException));
            }
            throw pendingException;
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)"Eager scale - SLA enforced.");
        }
    }

    private void enforceMachinesSla(EagerMachinesSlaPolicy sla) throws WaitingForDiscoveredMachinesException, GridServiceAgentSlaEnforcementInProgressException, FailedToDiscoverMachinesException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing machines SLA.");
        }
        try {
            this.machinesEndpoint.enforceSla(sla);
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningCompletedEvent(sla.getGridServiceAgentZones());
        }
        catch (GridServiceAgentSlaEnforcementInProgressException e) {
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningInProgressEvent(e, sla.getGridServiceAgentZones());
            throw e;
        }
    }

    private EagerMachinesSlaPolicy getMachinesSlaPolicy() {
        EagerMachinesSlaPolicy sla = new EagerMachinesSlaPolicy();
        sla.setAllowAboveAverageMemoryPerMachine(this.getConfig().isAllowAboveAverageMemoryPerMachine());
        sla.setMaximumNumberOfMachines(this.getMaximumNumberOfInstances());
        sla.setMinimumNumberOfMachines(this.getMinimumNumberOfMachines());
        sla.setMaximumNumberOfContainersPerMachine(this.getMaximumNumberOfContainersPerMachine());
        sla.setContainerMemoryCapacityInMB(this.containersConfig.getMaximumMemoryCapacityInMB());
        sla.setMachineIsolation(this.getIsolation());
        sla.setMachineProvisioning(super.getMachineProvisioning());
        sla.setDiscoveredMachinesCache(this.getDiscoveredMachinesCache());
        sla.setGridServiceAgentZones(new AnyZonesConfig());
        return sla;
    }

    private void enforceContainersSla(CapacityRequirementsPerAgent allocatedCapacity) throws ContainersSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing containers SLA.");
        }
        ContainersSlaPolicy sla = new ContainersSlaPolicy();
        sla.setNewContainerConfig(this.containersConfig);
        sla.setClusterCapacityRequirements(allocatedCapacity);
        sla.setAtMostOneContainerScalePerMachine(this.slaConfig.isAtMostOnceContainerScalePerMachine());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Containers Eager SLA Policy: #gridServiceAgents=" + sla.getClusterCapacityRequirements().getAgentUids().size() + " newContainerConfig.maximumMemoryCapacityInMB=" + sla.getNewContainerConfig().getMaximumMemoryCapacityInMB() + " at-most-one-container-scale-per-machine=" + this.slaConfig.isAtMostOnceContainerScalePerMachine()));
        }
        try {
            this.containersEndpoint.enforceSla(sla);
            this.containerProvisioningCompletedEvent();
        }
        catch (ContainersSlaEnforcementInProgressException e) {
            this.containerProvisioningInProgressEvent(e);
            throw e;
        }
    }

    private void enforceRebalancingSla(CapacityRequirementsPerAgent allocatedCapacity, GridServiceContainer[] containers) throws RebalancingSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enforcing rebalancing SLA.");
        }
        RebalancingSlaPolicy sla = new RebalancingSlaPolicy();
        sla.setContainers(containers);
        sla.setContainersMarkedForDeallocation(this.containersEndpoint.getContainersMarkedForDeallocation());
        sla.setMaximumNumberOfConcurrentRelocationsPerMachine(this.slaConfig.getMaxConcurrentRelocationsPerMachine());
        sla.setSchemaConfig(this.getSchemaConfig());
        sla.setAllocatedCapacity(allocatedCapacity);
        sla.setMinimumNumberOfInstancesPerPartition(1);
        sla.setAtMostOneConcurrentRelocation(this.getConfig().isAtMostOneConcurrentRelocation());
        sla.eager(true);
        try {
            this.rebalancingEndpoint.enforceSla(sla);
            this.puInstanceProvisioningCompletedEvent();
        }
        catch (RebalancingSlaEnforcementInProgressException e) {
            this.puInstanceProvisioningInProgressEvent(e);
            throw e;
        }
    }

    @Override
    public EagerScaleConfig getConfig() {
        return this.slaConfig;
    }

    private int getMaximumNumberOfContainersPerMachine() {
        return this.slaConfig.isAtMostOneContainerPerMachine() ? 1 : this.getMaximumNumberOfInstances();
    }

    @Override
    protected boolean isUndeploying() {
        return false;
    }

    @Override
    protected void recoverStateOnEsmStart() throws MachinesSlaEnforcementInProgressException, SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, UndeployInProgressException {
        EagerMachinesSlaPolicy sla = this.getMachinesSlaPolicy();
        this.machinesEndpoint.recoverStateOnEsmStart(sla);
        this.machinesEndpoint.recoveredStateOnEsmStart(this.getProcessingUnit());
    }

    @Override
    protected MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit otherPu) {
        return this.machinesEndpoint.getRecoveredStateOnEsmStart(otherPu);
    }
}

