/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.events.GridServiceAgentAddedEventListener;
import org.openspaces.admin.gsa.events.GridServiceAgentRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.machines.FutureGridServiceAgents;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.exceptions.FailedToDiscoverMachinesException;
import org.openspaces.grid.gsm.machines.exceptions.WaitingForDiscoveredMachinesException;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticGridServiceAgentProvisioningException;
import org.openspaces.grid.gsm.machines.plugins.exceptions.ElasticMachineProvisioningException;
import org.openspaces.grid.gsm.strategy.DiscoveredMachinesCache;

@Deprecated
public class ElasticMachineProvisioningDiscoveredMachinesCache
implements DiscoveredMachinesCache,
GridServiceAgentAddedEventListener,
GridServiceAgentRemovedEventListener,
Runnable {
    private static final long GET_DISCOVERED_MACHINES_TIMEOUT_SECONDS = 60L;
    private static final long GET_DISCOVERED_MACHINES_RETRY_SECONDS = 60L;
    private final ProcessingUnit pu;
    private final InternalAdmin admin;
    private final NonBlockingElasticMachineProvisioning machineProvisioning;
    private final boolean quiteMode;
    private Log logger;
    private ScheduledFuture<?> scheduledTask;
    private boolean syncAgents;
    private FutureGridServiceAgents futureAgents;

    public ElasticMachineProvisioningDiscoveredMachinesCache(ProcessingUnit pu, NonBlockingElasticMachineProvisioning machineProvisioning, boolean quiteMode, long pollingIntervalSeconds) {
        this.pu = pu;
        this.admin = (InternalAdmin)pu.getAdmin();
        this.machineProvisioning = machineProvisioning;
        this.quiteMode = quiteMode;
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(this.getClass())), pu);
        this.admin.getGridServiceAgents().getGridServiceAgentAdded().add(this);
        this.admin.getGridServiceAgents().getGridServiceAgentRemoved().add(this);
        this.syncAgents = true;
        this.scheduledTask = this.admin.scheduleWithFixedDelayNonBlockingStateChange(this, 0L, pollingIntervalSeconds, TimeUnit.SECONDS);
    }

    public void destroy() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
        this.admin.getGridServiceAgents().getGridServiceAgentAdded().remove(this);
        this.admin.getGridServiceAgents().getGridServiceAgentRemoved().remove(this);
    }

    @Override
    public Collection<GridServiceAgent> getDiscoveredAgents() throws WaitingForDiscoveredMachinesException, FailedToDiscoverMachinesException {
        if (this.futureAgents == null || !this.futureAgents.isDone()) {
            throw new WaitingForDiscoveredMachinesException(this.pu, "Need to wait until retrieved list of machines.");
        }
        GridServiceAgent[] agents = this.admin.getGridServiceAgents().getAgents();
        try {
            agents = (GridServiceAgent[])this.futureAgents.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ElasticMachineProvisioningException || cause instanceof ElasticGridServiceAgentProvisioningException || cause instanceof AdminException) {
                if (!this.quiteMode) {
                    throw new FailedToDiscoverMachinesException(this.pu, e);
                }
                this.logger.info((Object)"Failed to discover machines", (Throwable)e);
            }
            throw new IllegalStateException("Unexpected exception type", e);
        }
        catch (TimeoutException e) {
            if (!this.quiteMode) {
                throw new FailedToDiscoverMachinesException(this.pu, e);
            }
            this.logger.info((Object)"Failed to discover machines", (Throwable)e);
        }
        return MachinesSlaUtils.sortAndFilterAgents(agents, this.machineProvisioning.getConfig(), this.logger);
    }

    @Override
    public void gridServiceAgentRemoved(GridServiceAgent gridServiceAgent) {
        this.syncAgents = true;
    }

    @Override
    public void gridServiceAgentAdded(GridServiceAgent gridServiceAgent) {
        this.syncAgents = true;
    }

    @Override
    public void run() {
        if (this.syncAgents) {
            this.syncAgents = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Retrieving list of provisioned machines");
            }
            this.futureAgents = this.machineProvisioning.getDiscoveredMachinesAsync(60L, TimeUnit.SECONDS);
        }
        if (this.futureAgents != null && this.futureAgents.getException() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed retrieving list of machines. Retrying in 60 seconds.", (Throwable)this.futureAgents.getException());
            }
            this.admin.scheduleOneTimeWithDelayNonBlockingStateChange(new Runnable(){

                @Override
                public void run() {
                    ElasticMachineProvisioningDiscoveredMachinesCache.this.syncAgents = true;
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }
}

