/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.monitor.event.Event;
import org.jini.rio.monitor.event.EventsStore;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitDecisionEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitProgressChangedEvent;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitDecisionEvent;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementDecision;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementLoggerBehavior;

public class ScaleStrategyProgressEventState {
    private boolean inProgressEventRaised;
    private boolean completedEventRaised;
    private SlaEnforcementInProgressException lastInProgressException;
    private final EventsStore eventStore;
    private final boolean isUndeploying;
    private final String processingUnitName;
    private final Class<? extends InternalElasticProcessingUnitProgressChangedEvent> progressChangedEventClass;
    private final Log logger = LogFactory.getLog(ScaleStrategyProgressEventState.class);
    private final Log filteredLogger = new SingleThreadedPollingLog(this.logger);

    public ScaleStrategyProgressEventState(EventsStore eventStore, boolean isUndeploying, String processingUnitName, Class<? extends InternalElasticProcessingUnitProgressChangedEvent> progressChangedEventClass) {
        this.eventStore = eventStore;
        this.isUndeploying = isUndeploying;
        this.processingUnitName = processingUnitName;
        this.progressChangedEventClass = progressChangedEventClass;
    }

    public void enqueuProvisioningInProgressEvent(SlaEnforcementInProgressException e, ZonesConfig zones) {
        if (e instanceof SlaEnforcementDecision) {
            boolean isDuplicateException;
            boolean bl = isDuplicateException = this.lastInProgressException != null && this.lastInProgressException.equals(e);
            if (this.isAlwaysLogDuplicateException(e) || !isDuplicateException) {
                this.lastInProgressException = e;
                InternalElasticProcessingUnitDecisionEvent event = this.createDecisionEvent((SlaEnforcementDecision)((Object)e), zones);
                this.enqueuProvisioningInProgressEvent(event, e);
            } else {
                this.enqueuDefaultProvisioningInProgressEvent(e, zones);
            }
        } else {
            this.enqueuDefaultProvisioningInProgressEvent(e, zones);
            if (e instanceof SlaEnforcementFailure) {
                boolean isDuplicateException;
                boolean bl = isDuplicateException = this.lastInProgressException != null && this.lastInProgressException.equals(e);
                if (this.isAlwaysLogDuplicateException(e) || !isDuplicateException) {
                    this.lastInProgressException = e;
                    this.enqueuProvisioningFailureEvent(e, zones, isDuplicateException);
                }
            } else if (this.logger.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                this.appendPuPrefix(message, e.getProcessingUnitName());
                message.append("SLA in progress");
                if (this.isAlwaysLogStackTrace(e)) {
                    this.appendStackTrace(message, e);
                    this.filteredLogger.debug((Object)message);
                } else {
                    this.filteredLogger.debug((Object)message, (Throwable)e);
                }
            }
        }
    }

    private void enqueuProvisioningFailureEvent(SlaEnforcementInProgressException e, ZonesConfig zones, boolean isDuplicateException) {
        InternalElasticProcessingUnitFailureEvent event = this.createFailureEvent((SlaEnforcementFailure)((Object)e), zones);
        if (this.logger.isWarnEnabled()) {
            StringBuilder message = new StringBuilder();
            this.appendPuPrefix(message, event.getProcessingUnitName());
            String failureDescription = event.getFailureDescription();
            if (failureDescription == null) {
                throw new IllegalStateException("event " + event.getClass() + " failure description cannot be null");
            }
            message.append(failureDescription);
            if (this.isAlwaysLogStackTrace(e)) {
                this.appendStackTrace(message, e);
                this.logger.warn((Object)message);
            } else {
                this.logger.warn((Object)message, (Throwable)e);
            }
        }
        if (!isDuplicateException) {
            this.eventStore.addEvent((Event)event);
        }
    }

    private boolean isAlwaysLogStackTrace(Throwable t) {
        boolean logStackTrace = false;
        if (t != null && t instanceof SlaEnforcementLoggerBehavior) {
            SlaEnforcementLoggerBehavior loggerBehavior = (SlaEnforcementLoggerBehavior)((Object)t);
            logStackTrace = loggerBehavior.isAlwaysLogStackTrace();
        }
        return logStackTrace;
    }

    private boolean isAlwaysLogDuplicateException(Throwable t) {
        boolean logAlways = false;
        if (t != null && t instanceof SlaEnforcementLoggerBehavior) {
            SlaEnforcementLoggerBehavior loggerBehavior = (SlaEnforcementLoggerBehavior)((Object)t);
            logAlways = loggerBehavior.isAlwaysLogDuplicateException();
        }
        return logAlways;
    }

    private void enqueuProvisioningInProgressEvent(InternalElasticProcessingUnitProgressChangedEvent event, Throwable t) {
        StringBuilder message;
        boolean logged = false;
        boolean decisionEvent = event instanceof ElasticProcessingUnitDecisionEvent;
        if (decisionEvent && this.logger.isInfoEnabled()) {
            message = new StringBuilder();
            this.appendPuPrefix(message, event.getProcessingUnitName());
            String decisionDescription = ((ElasticProcessingUnitDecisionEvent)((Object)event)).getDecisionDescription();
            if (decisionDescription == null) {
                throw new IllegalStateException("event " + event.getClass() + " decision description cannot be null");
            }
            message.append(decisionDescription);
            if (t == null) {
                this.logger.info((Object)message);
            } else if (this.isAlwaysLogStackTrace(t)) {
                this.appendStackTrace(message, t);
                this.logger.info((Object)message);
            } else {
                this.logger.info((Object)message, t);
            }
            logged = true;
        }
        if (this.isAlwaysLogDuplicateException(t) || decisionEvent || !this.inProgressEventRaised) {
            this.completedEventRaised = false;
            this.inProgressEventRaised = true;
            this.eventStore.addEvent((Event)event);
            if (!logged && this.logger.isInfoEnabled()) {
                message = new StringBuilder(event.toString());
                if (this.isAlwaysLogStackTrace(t)) {
                    this.appendStackTrace(message, t);
                    this.logger.info((Object)message);
                } else {
                    this.logger.info((Object)message, t);
                }
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Ignoring event:" + event.toString()), t);
        }
    }

    public void enqueuDefaultProvisioningInProgressEvent(Throwable t, ZonesConfig zones) {
        boolean isComplete = false;
        InternalElasticProcessingUnitProgressChangedEvent event = this.createProgressChangedEvent(false, zones);
        this.enqueuProvisioningInProgressEvent(event, t);
    }

    public void enqueuProvisioningInProgressEvent(InternalElasticProcessingUnitProgressChangedEvent event) {
        this.enqueuProvisioningInProgressEvent(event, null);
    }

    public void enqueuProvisioningCompletedEvent(ZonesConfig zones) {
        boolean isComplete = true;
        InternalElasticProcessingUnitProgressChangedEvent event = this.createProgressChangedEvent(isComplete, zones);
        if (!this.completedEventRaised) {
            this.completedEventRaised = true;
            this.inProgressEventRaised = false;
            this.lastInProgressException = null;
            this.eventStore.addEvent((Event)event);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)event.toString());
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Ignoring event: " + event.toString()));
        }
    }

    private InternalElasticProcessingUnitProgressChangedEvent createProgressChangedEvent(boolean isComplete, ZonesConfig zones) {
        InternalElasticProcessingUnitProgressChangedEvent newEvent;
        try {
            newEvent = this.progressChangedEventClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("failed creating new event", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("failed creating new event", e);
        }
        newEvent.setComplete(isComplete);
        newEvent.setUndeploying(this.isUndeploying);
        newEvent.setProcessingUnitName(this.processingUnitName);
        if (zones != null) {
            newEvent.setGridServiceAgentZones(zones);
        }
        return newEvent;
    }

    private InternalElasticProcessingUnitFailureEvent createFailureEvent(SlaEnforcementFailure e, ZonesConfig zones) {
        InternalElasticProcessingUnitFailureEvent event = e.toEvent();
        event.setGridServiceAgentZones(zones);
        return event;
    }

    private InternalElasticProcessingUnitDecisionEvent createDecisionEvent(SlaEnforcementDecision e, ZonesConfig zones) {
        InternalElasticProcessingUnitDecisionEvent newEvent = e.toEvent();
        newEvent.setComplete(false);
        newEvent.setUndeploying(this.isUndeploying);
        newEvent.setProcessingUnitName(this.processingUnitName);
        if (zones != null) {
            newEvent.setGridServiceAgentZones(zones);
        }
        return newEvent;
    }

    private void appendStackTrace(StringBuilder message, Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            message.append("; Caused by: ").append(sw.toString());
        }
        catch (Exception ex) {
            message.append("; Caused by: ").append(e.toString());
            message.append(" - Unable to parse stack trace; Caught: ").append(ex);
        }
    }

    private void appendPuPrefix(StringBuilder message, String puName) {
        message.append("[" + puName + "]").append(" ");
    }
}

