/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.strategy;

import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.GridServiceContainerConfigAware;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.containers.UndeployContainersSlaPolicy;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.CapacityMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.UndeployMachinesSlaPolicy;
import org.openspaces.grid.gsm.machines.exceptions.GridServiceAgentSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.MachinesSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.NeedToWaitUntilAllGridServiceAgentsDiscoveredException;
import org.openspaces.grid.gsm.machines.exceptions.SomeProcessingUnitsHaveNotCompletedStateRecoveryException;
import org.openspaces.grid.gsm.machines.exceptions.UndeployInProgressException;
import org.openspaces.grid.gsm.machines.exceptions.WaitingForDiscoveredMachinesException;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.rebalancing.exceptions.ElasticProcessingUnitInstanceUndeployInProgress;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementInProgressException;
import org.openspaces.grid.gsm.strategy.AbstractScaleStrategyBean;

public class UndeployScaleStrategyBean
extends AbstractScaleStrategyBean
implements ContainersSlaEnforcementEndpointAware,
MachinesSlaEnforcementEndpointAware,
GridServiceContainerConfigAware {
    private MachinesSlaEnforcementEndpoint machinesEndpoint;
    private ContainersSlaEnforcementEndpoint containersEndpoint;
    private GridServiceContainerConfig containersConfig;
    private boolean plannedNumberOfInstancesEventFired;

    @Override
    public void setMachinesSlaEnforcementEndpoint(MachinesSlaEnforcementEndpoint endpoint) {
        this.machinesEndpoint = endpoint;
    }

    @Override
    public void setContainersSlaEnforcementEndpoint(ContainersSlaEnforcementEndpoint containersService) {
        this.containersEndpoint = containersService;
    }

    @Override
    public void setGridServiceContainerConfig(GridServiceContainerConfig containersConfig) {
        this.containersConfig = containersConfig;
    }

    @Override
    public void afterPropertiesSet() {
        super.setMachineDiscoveryQuiteMode(true);
        super.afterPropertiesSet();
        if (this.machinesEndpoint == null) {
            throw new IllegalStateException("machines endpoint cannot be null.");
        }
        if (this.containersEndpoint == null) {
            throw new IllegalStateException("containers endpoint cannot be null");
        }
    }

    @Override
    public void enforceSla() throws SlaEnforcementInProgressException {
        CapacityMachinesSlaPolicy sla;
        this.capacityPlannedNumberOfInstancesChangedEvent();
        if (this.getProcessingUnit().getInstances().length == 0) {
            this.puInstanceProvisioningCompletedEvent();
        } else {
            this.puInstanceProvisioningInProgressEvent(new ElasticProcessingUnitInstanceUndeployInProgress(this.getProcessingUnit()));
        }
        this.enforceContainersSla();
        this.machinesEndpoint.beforeUndeployedProcessingUnit(this.getProcessingUnit());
        for (ZonesConfig zones : this.machinesEndpoint.getGridServiceAgentsZones()) {
            sla = this.getMachinesSlaPolicy(zones);
            this.enforceMachinesSla(sla);
        }
        for (ZonesConfig zones : this.machinesEndpoint.getUndeployedGridServiceAgentsZones()) {
            sla = this.getMachinesSlaPolicy(zones);
            this.enforceMachinesSla(sla);
        }
        this.enforceCloudCleanup();
        this.machinesEndpoint.afterUndeployedProcessingUnit(this.getProcessingUnit());
    }

    private void enforceCloudCleanup() throws MachinesSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Cleanup Cloud for " + this.getProcessingUnit().getName()));
        }
        try {
            this.machinesEndpoint.cleanupCloud(this.getProcessingUnit(), this.getMachineProvisioning());
            this.machineProvisioningCompletedEvent(null);
        }
        catch (MachinesSlaEnforcementInProgressException e) {
            this.machineProvisioningInProgressEvent(e, null);
            throw e;
        }
    }

    private void capacityPlannedNumberOfInstancesChangedEvent() {
        if (!this.plannedNumberOfInstancesEventFired && !this.isStatefulProcessingUnit()) {
            int newPlannedNumberOfInstances = 0;
            int oldPlannedNumberOfInstances = this.getProcessingUnit().getNumberOfInstances();
            int actualNumberOfInstances = this.getProcessingUnit().getInstances().length;
            ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent event = new ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent(actualNumberOfInstances, oldPlannedNumberOfInstances, newPlannedNumberOfInstances);
            event.setComplete(false);
            event.setUndeploying(true);
            event.setProcessingUnitName(this.getProcessingUnit().getName());
            event.setGridServiceAgentZones(null);
            super.capacityPlanningInProgressEvent(event);
            this.plannedNumberOfInstancesEventFired = true;
        }
    }

    private boolean isStatefulProcessingUnit() {
        return this.getSchemaConfig().isPartitionedSync2BackupSchema();
    }

    private void enforceMachinesSla(CapacityMachinesSlaPolicy sla) throws WaitingForDiscoveredMachinesException, MachinesSlaEnforcementInProgressException, GridServiceAgentSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Undeploying machines for " + this.getProcessingUnit().getName()));
        }
        try {
            this.machinesEndpoint.enforceSla(sla);
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningCompletedEvent(sla.getGridServiceAgentZones());
        }
        catch (MachinesSlaEnforcementInProgressException e) {
            this.machineProvisioningInProgressEvent(e, sla.getGridServiceAgentZones());
            throw e;
        }
        catch (GridServiceAgentSlaEnforcementInProgressException e) {
            this.machineProvisioningCompletedEvent(sla.getGridServiceAgentZones());
            this.agentProvisioningInProgressEvent(e, sla.getGridServiceAgentZones());
            throw e;
        }
    }

    private CapacityMachinesSlaPolicy getMachinesSlaPolicy(ZonesConfig zones) {
        UndeployMachinesSlaPolicy sla = new UndeployMachinesSlaPolicy(this.getAdmin());
        NonBlockingElasticMachineProvisioning machineProvisioning = super.getMachineProvisioning();
        sla.setMachineProvisioning(machineProvisioning);
        sla.setMaximumNumberOfMachines(this.getMaximumNumberOfInstances());
        sla.setMaximumNumberOfContainersPerMachine(this.getMaximumNumberOfInstances());
        sla.setContainerMemoryCapacityInMB(this.containersConfig.getMaximumMemoryCapacityInMB());
        sla.setMachineIsolation(this.getIsolation());
        sla.setDiscoveredMachinesCache(this.getDiscoveredMachinesCache());
        sla.setGridServiceAgentZones(zones);
        return sla;
    }

    private void enforceContainersSla() throws ContainersSlaEnforcementInProgressException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Undeploying containers for " + this.getProcessingUnit().getName()));
        }
        UndeployContainersSlaPolicy sla = new UndeployContainersSlaPolicy();
        sla.setNewContainerConfig(this.containersConfig);
        try {
            this.containersEndpoint.enforceSla(sla);
            this.containerProvisioningCompletedEvent();
        }
        catch (ContainersSlaEnforcementInProgressException e) {
            this.containerProvisioningInProgressEvent(e);
            throw e;
        }
    }

    @Override
    public ScaleStrategyConfig getConfig() {
        return null;
    }

    @Override
    protected boolean isUndeploying() {
        return true;
    }

    @Override
    protected void recoverStateOnEsmStart() throws MachinesSlaEnforcementInProgressException, SomeProcessingUnitsHaveNotCompletedStateRecoveryException, NeedToWaitUntilAllGridServiceAgentsDiscoveredException, UndeployInProgressException {
        for (ZonesConfig zones : this.machinesEndpoint.getGridServiceAgentsZones()) {
            CapacityMachinesSlaPolicy sla = this.getMachinesSlaPolicy(zones);
            this.machinesEndpoint.recoverStateOnEsmStart(sla);
        }
        this.machinesEndpoint.recoveredStateOnEsmStart(this.getProcessingUnit());
    }

    @Override
    protected MachinesSlaEnforcementState.RecoveryState getRecoveredStateOnEsmStart(ProcessingUnit otherPu) {
        return this.machinesEndpoint.getRecoveredStateOnEsmStart(otherPu);
    }
}

