/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid;

import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.j_spaces.core.SpaceUnhealthyException;
import com.sun.jini.config.Config;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.resources.client.AbstractFaultDetectionHandler;
import org.openspaces.pu.container.servicegrid.PUServiceBean;

public class PUFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    public static final String INVOCATION_DELAY_KEY = "invocationDelay";
    private static final String COMPONENT = "org.openspaces.pu.container.servicegrid.PUFaultDetectionHandler";
    private static final Logger logger = Logger.getLogger("org.openspaces.pu.container.servicegrid.PUFaultDetectionHandler");

    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.configArgs = new String[configArgs.length];
            System.arraycopy(configArgs, 0, this.configArgs, 0, configArgs.length);
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.invocationDelay = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)INVOCATION_DELAY_KEY, (long)60000L, (long)0L, (long)Long.MAX_VALUE);
            this.retryCount = Config.getIntEntry((Configuration)this.config, (String)COMPONENT, (String)"retryCount", (int)3, (int)0, (int)Integer.MAX_VALUE);
            this.retryTimeout = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"retryTimeout", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.CONFIG)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("PUFaultDetectionHandler Properties : ");
                buffer.append("\n invocation delay=" + this.invocationDelay);
                buffer.append("\n retry count=" + this.retryCount + ", ");
                buffer.append("\n retry timeout=" + this.retryTimeout);
                buffer.append("\n configArgs: " + Arrays.toString(configArgs));
                logger.config(buffer.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    protected AbstractFaultDetectionHandler.ServiceMonitor getServiceMonitor() throws Exception {
        return new ServiceAdminManager();
    }

    private static class MemberReturnFalseException
    extends Exception {
        private static final long serialVersionUID = -1770702442289427619L;

        private MemberReturnFalseException() {
        }
    }

    class ServiceAdminManager
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        volatile int retriesCount = 0;
        volatile Throwable lastThrown;
        volatile long roundtrip;
        volatile long lastInvocationTime = 0L;
        final ServiceDetails serviceDetails = new ServiceDetails();

        public ServiceAdminManager() {
            this.serviceDetails.serviceId = PUFaultDetectionHandler.this.getServiceID();
            try {
                NIODetails nioDetails = ((PUServiceBean)PUFaultDetectionHandler.this.proxy).getNIODetails();
                JVMDetails jvmDetails = ((PUServiceBean)PUFaultDetectionHandler.this.proxy).getJVMDetails();
                this.serviceDetails.host = nioDetails.getHostName() + "/" + nioDetails.getHostAddress();
                this.serviceDetails.processId = jvmDetails.getPid();
            }
            catch (Exception nioDetails) {
                // empty catch block
            }
            try {
                this.serviceDetails.presentationName = ((PUServiceBean)PUFaultDetectionHandler.this.proxy).getPresentationName();
            }
            catch (Exception re) {
                this.serviceDetails.presentationName = PUFaultDetectionHandler.this.proxy.toString();
            }
        }

        public void drop() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Dropping monitor for service: " + this.serviceDetails);
            }
        }

        public void reportFirstError() {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Suspecting failure of service: " + this.serviceDetails + " - RTT[" + this.formatDuration(this.roundtrip) + "]. Retrying to reach service.", this.lastThrown);
            }
        }

        public void reportLastError() {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Detected failure of service: " + this.serviceDetails + ". This service cannot be reached.", this.lastThrown);
            }
        }

        public boolean verify() {
            long start = System.nanoTime();
            try {
                this.logIfLastInvocationOfIsAliveWasDelayed(start);
                LRMIInvocationContext.enableLivenessPriorityForNextInvocation();
                boolean isAlive = ((PUServiceBean)PUFaultDetectionHandler.this.proxy).isAlive();
                this.logIfInvocationOfIsAliveTookTooLong(start, isAlive);
                if (isAlive) {
                    this.retriesCount = 0;
                    if (logger.isLoggable(Level.FINEST)) {
                        long roundtrip = System.nanoTime() - start;
                        logger.finest("Successfully verified service: " + this.serviceDetails + " is alive - RTT[" + this.formatDuration(roundtrip) + "]");
                    }
                } else {
                    throw new MemberReturnFalseException();
                }
                return isAlive;
            }
            catch (Exception e) {
                this.lastThrown = e;
                this.roundtrip = System.nanoTime() - start;
                int retry = this.retriesCount++;
                if (logger.isLoggable(Level.FINER)) {
                    if (e instanceof MemberReturnFalseException) {
                        logger.log(Level.FINER, "Service Failure (isAlive:false): " + this.serviceDetails + " - RTT[" + this.formatDuration(this.roundtrip) + "], retry[" + retry + "]");
                    } else {
                        logger.log(Level.FINER, "Service Failure: " + this.serviceDetails + " - RTT[" + this.formatDuration(this.roundtrip) + "], retry[" + retry + "]", e);
                    }
                }
                return false;
            }
        }

        private void logIfLastInvocationOfIsAliveWasDelayed(long start) {
            if (logger.isLoggable(Level.FINE)) {
                long timeElapsedFromLastInvocation = start - this.lastInvocationTime;
                if (this.lastInvocationTime > 0L && timeElapsedFromLastInvocation > 60000000000L) {
                    logger.log(Level.FINE, "Verification of service: " + this.serviceDetails + " was delayed by [" + this.formatDuration(timeElapsedFromLastInvocation) + "]");
                }
            }
            this.lastInvocationTime = start;
        }

        private void logIfInvocationOfIsAliveTookTooLong(long start, boolean isAlive) {
            long timeElapsedForIsAliveInvocation;
            if (logger.isLoggable(Level.FINE) && (timeElapsedForIsAliveInvocation = System.nanoTime() - start) > 60000000000L) {
                logger.log(Level.FINE, "Verification of service: " + this.serviceDetails + " - RTT[" + this.formatDuration(timeElapsedForIsAliveInvocation) + "], isAlive[" + isAlive + "]");
            }
        }

        public boolean shouldRetry() {
            return this.lastThrown == null || !(this.lastThrown instanceof SpaceUnhealthyException);
        }

        private final String formatDuration(long nanos) {
            String svalue;
            int dot;
            String unit = " ms";
            double value = 1.0E-6 * (double)nanos;
            if (value > 1000.0) {
                unit = " sec";
                value = 0.001 * value;
            }
            if ((dot = (svalue = String.valueOf(value)).indexOf(46)) != -1 && dot + 2 < svalue.length()) {
                svalue = svalue.substring(0, dot + 2);
            }
            return svalue + unit;
        }

        public String toString() {
            return super.toString() + " " + this.serviceDetails;
        }

        class ServiceDetails {
            ServiceID serviceId;
            String presentationName;
            String host;
            long processId;

            ServiceDetails() {
            }

            public String toString() {
                String toString = "[" + this.presentationName + "] pid[" + this.processId + "] host[" + this.host + "]";
                if (logger.isLoggable(Level.FINE)) {
                    toString = toString + " Id[" + this.serviceId + "]";
                }
                return toString;
            }
        }
    }
}

