/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid;

import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceStateChangedEvent;
import com.gigaspaces.client.DirectSpaceProxyFactory;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.client.spaceproxy.DirectSpaceProxyFactoryImpl;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.io.FileUtils;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.utils.ClassLoaderUtils;
import com.gigaspaces.internal.utils.ObjectConverter;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.ClassLoaderType;
import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.ProductType;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.XapModules;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.RuntimeHolder;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.filters.StatisticsHolder;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.PUZipUtils;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.boot.SharedServiceData;
import org.jini.rio.boot.TLSUtils;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.GaugeWatch;
import org.jini.rio.watch.Watch;
import org.openspaces.admin.quiesce.QuiesceStateChangedListener;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoPropertyPlaceholderConfigurer;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.SpaceType;
import org.openspaces.core.util.PlaceholderReplacer;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.ProcessingUnitContainerProvider;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainerProvider;
import org.openspaces.pu.container.jee.JeeProcessingUnitContainerProvider;
import org.openspaces.pu.container.jee.context.BootstrapWebApplicationContextListener;
import org.openspaces.pu.container.servicegrid.PUDetails;
import org.openspaces.pu.container.servicegrid.PUMonitors;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.pu.container.servicegrid.PUServiceBeanProxy;
import org.openspaces.pu.container.servicegrid.jmxs.SecuredPUExtension;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainer;
import org.openspaces.pu.container.spi.ApplicationContextProcessingUnitContainerProvider;
import org.openspaces.pu.container.standalone.StandaloneServiceDetails;
import org.openspaces.pu.container.support.BeanLevelPropertiesUtils;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.WebsterFile;
import org.openspaces.pu.service.InvocableService;
import org.openspaces.pu.service.InvocableServiceLookupFailureException;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.openspaces.pu.sla.SLA;
import org.openspaces.pu.sla.monitor.ApplicationContextMonitor;
import org.openspaces.pu.sla.monitor.Monitor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

public class PUServiceBeanImpl
extends ServiceBeanAdapter
implements PUServiceBean,
InternalDumpProcessor {
    private static final Log logger = LogFactory.getLog(PUServiceBeanImpl.class);
    private volatile ProcessingUnitContainer container;
    private MetricManager metricManager;
    private List<MetricRegistrator> metricRegistrators;
    private int clusterGroup;
    private Integer instanceId;
    private Integer backupId;
    private volatile List<WatchTask> watchTasks = new ArrayList<WatchTask>();
    private volatile ScheduledExecutorService executorService;
    private volatile Callable<Boolean>[] memberAliveIndicators;
    private volatile Callable[] undeployingEventListeners;
    private volatile File deployPath;
    private volatile ClusterInfo clusterInfo;
    private volatile PUDetails puDetails;
    private final Collection<Callable> serviceMonitors = Collections.synchronizedCollection(new ArrayList());
    private final Collection<InternalDumpProcessor> dumpProcessors = Collections.synchronizedCollection(new ArrayList());
    private final Map<String, InvocableService> invocableServiceMap = new ConcurrentHashMap<String, InvocableService>();
    private volatile boolean stopping = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private volatile InternalQuiesceDetails quiesceDetails;

    public PUServiceBeanImpl() {
        TLSUtils.enableHttpsClient();
    }

    protected void initializeJMX(Object mbean) throws Exception {
        if (SecurityResolver.isSecurityEnabled()) {
            mbean = new SecuredPUExtension(mbean);
        }
        super.initializeJMX(mbean);
    }

    protected Object createProxy() {
        return PUServiceBeanProxy.getInstance((PUServiceBean)this.getExportedProxy(), this.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doStart(ServiceBeanContext context) throws Exception {
        String sBackupId;
        SLA sla;
        InternalQuiesceDetails quiesceDetails;
        this.context = context;
        OperationalStringManager operationalStringManager = context.getServiceBeanManager().getOperationalStringManager();
        InternalQuiesceDetails internalQuiesceDetails = quiesceDetails = operationalStringManager != null ? operationalStringManager.getQuiesceDetails() : null;
        if (quiesceDetails != null) {
            this.quiesceDetails = quiesceDetails;
        }
        if ((sla = this.getSLA(context)).getMonitors() != null) {
            for (Monitor monitor : sla.getMonitors()) {
                String watchName = monitor.getName();
                GaugeWatch watch = new GaugeWatch(watchName, context.getConfiguration());
                if (watch.getWatchDataSource() == null) {
                    throw new CannotCreateContainerException("Failed to add SLA monitor [" + watchName + "] for processing unit [" + this.getServiceBeanContext().getServiceElement().getName() + "]");
                }
                watch.getWatchDataSource().setSize(monitor.getHistorySize());
                context.getWatchRegistry().register((Watch)watch);
                this.watchTasks.add(new WatchTask(monitor, (Watch)watch));
            }
        }
        String springXML = (String)context.getInitParameter("pu");
        this.metricManager = MetricManager.acquire();
        this.clusterGroup = Integer.parseInt((String)context.getInitParameter("clusterGroup"));
        String sInstanceId = (String)context.getInitParameter("instanceId");
        if (sInstanceId != null) {
            this.instanceId = Integer.valueOf(sInstanceId);
        }
        if ((sBackupId = (String)context.getInitParameter("backupId")) != null) {
            this.backupId = Integer.valueOf(sBackupId);
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.logMessage("contextClassLoader=" + this.contextClassLoader + " origClassLoader=" + origClassLoader));
            }
            this.startPU(springXML);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                StringBuilder classpath = new StringBuilder();
                if (ClassLoaderUtils.isClassLoaderProblem((Throwable)e)) {
                    classpath.append(ClassLoaderUtils.getClassPathString((ClassLoader)classLoader, (String)"Context Class Loader"));
                }
                logger.debug((Object)this.logMessage("Failed to start PU with xml [" + springXML + "] " + classLoader + " " + classpath), e);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)this.logMessage("Failed to start processing unit [" + this.getServiceBeanContext().getServiceElement().getName() + "]"), e);
            }
            try {
                this.stopPU();
            }
            catch (Exception e1) {
                logger.debug((Object)this.logMessage("Failed to destroy PU after failed start, ignoring"), (Throwable)e1);
            }
            this.cleanClassLoaders();
            throw new CannotCreateContainerException("Failed to start processing unit [" + this.getServiceBeanContext().getServiceElement().getName() + "]", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            Object object = super.doStart(context);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private boolean isOnGsmHost(String deployHost) {
        InetAddress localHost = SystemInfo.singleton().network().getHost();
        logger.debug((Object)("Determining if managing GSM is on the same host as this GSC [deployHost=" + deployHost + ", localHost=" + localHost + "]"));
        return deployHost.equals(localHost.getHostAddress());
    }

    public void initialize(ServiceBeanContext context) throws Exception {
        super.initialize(context);
        JMXConnection jmxEntry = JMXUtilities.createJMXConnectionAttribute((String)context.getServiceElement().getName());
        if (jmxEntry != null) {
            this.addAttribute((Entry)jmxEntry);
        }
        if (this.quiesceDetails != null && this.quiesceDetails.getStatus().equals((Object)QuiesceState.QUIESCED)) {
            QuiesceStateChangedEvent event = new QuiesceStateChangedEvent(this.quiesceDetails.getStatus(), this.quiesceDetails.getToken(), this.quiesceDetails.getDescription());
            this.informQuiesceToListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force) {
        if (this.clusterInfo != null) {
            SharedServiceData.removeWebAppClassLoader((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeMemberAliveIndicator((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeUndeployingEventListeners((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeServiceDetails((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeServiceMonitors((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeDumpProcessors((String)this.clusterInfo.getUniqueName());
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        this.stopping = true;
        try {
            this.setNonNullContextClassLoader(this.contextClassLoader);
            logger.info((Object)this.logMessage("Stopping ..."));
            this.stopPU();
            logger.info((Object)this.logMessage("Stopped"));
        }
        finally {
            this.stopping = false;
            Thread.currentThread().setContextClassLoader(origClassLoader);
            this.serviceMonitors.clear();
            this.memberAliveIndicators = null;
            if (this.watchRegistry != null) {
                for (WatchTask watchTask : this.watchTasks) {
                    this.watchRegistry.deregister(watchTask.getWatch());
                }
            }
            this.watchTasks.clear();
        }
        super.stop(force);
    }

    private void setNonNullContextClassLoader(ClassLoader contextClassLoader) {
        if (contextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        } else {
            logger.warn((Object)this.logMessage("Service context classloader is null; fallback to class loader: " + Thread.currentThread().getContextClassLoader()));
        }
    }

    private static InputStream openUrlStream(String s) {
        try {
            return new URL(s).openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startPU(String springXml) throws IOException, ClassNotFoundException {
        List<URL> urls;
        InputStream inputStream;
        void var26_47;
        File[] libFiles;
        File libDir;
        String processingUnitContainerProviderClass;
        BeanLevelProperties beanLevelProperties;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.logMessage("Starting PU with [" + springXml + "]"));
        }
        ObjectConverter.clearRuntimeGeneratedCache();
        String puName = (String)this.context.getInitParameter("puName");
        String puPath = (String)this.context.getInitParameter("puPath");
        String codeserver = this.context.getExportCodebase();
        SLA sla = this.getSLA(this.getServiceBeanContext());
        Integer instanceId = this.instanceId;
        Integer backupId = this.backupId;
        if (instanceId == null) {
            boolean hasBackups;
            boolean bl = hasBackups = sla.getNumberOfBackups() > 0;
            if (hasBackups) {
                instanceId = this.clusterGroup;
                if (this.context.getServiceBeanConfig().getInstanceID().intValue() > 1) {
                    backupId = this.context.getServiceBeanConfig().getInstanceID().intValue() - 1;
                }
            } else {
                instanceId = this.context.getServiceBeanConfig().getInstanceID().intValue();
            }
        }
        this.clusterInfo = new ClusterInfo();
        String clusterSchema = sla.getClusterSchema();
        if (clusterSchema != null) {
            this.clusterInfo.setSchema(clusterSchema);
            int slaMax = this.getSLAMax(this.context);
            int numberOfInstances = Math.max(slaMax, sla.getNumberOfInstances());
            this.clusterInfo.setNumberOfInstances(Integer.valueOf(numberOfInstances));
        } else {
            this.clusterInfo.setNumberOfInstances(Integer.valueOf(sla.getNumberOfInstances()));
        }
        this.clusterInfo.setNumberOfBackups(Integer.valueOf(sla.getNumberOfBackups()));
        this.clusterInfo.setInstanceId(instanceId);
        this.clusterInfo.setBackupId(backupId);
        this.clusterInfo.setName(puName);
        ClusterInfoParser.guessSchema((ClusterInfo)this.clusterInfo);
        logger.info((Object)this.logMessage("ClusterInfo [" + this.clusterInfo + "]"));
        MarshalledObject beanLevelPropertiesMarshObj = this.getMarshalledObject(this.getServiceBeanContext(), "beanLevelProperties");
        if (beanLevelPropertiesMarshObj != null) {
            beanLevelProperties = (BeanLevelProperties)beanLevelPropertiesMarshObj.get();
            logger.info((Object)this.logMessage("BeanLevelProperties " + beanLevelProperties));
        } else {
            beanLevelProperties = new BeanLevelProperties();
        }
        beanLevelProperties.getContextProperties().putAll((Map<?, ?>)ClusterInfoPropertyPlaceholderConfigurer.createProperties((ClusterInfo)this.clusterInfo));
        File workLocation = new File(SystemInfo.singleton().locations().work());
        workLocation.mkdirs();
        beanLevelProperties.getContextProperties().setProperty("com.gs.work", workLocation.getAbsolutePath());
        boolean downloadPU = false;
        InputStream webXml = PUServiceBeanImpl.openUrlStream(codeserver + puPath + "/WEB-INF/web.xml");
        InputStream puConfig = PUServiceBeanImpl.openUrlStream(codeserver + puPath + "/pu.config");
        InputStream puInteropConfig = PUServiceBeanImpl.openUrlStream(codeserver + puPath + "/pu.interop.config");
        if (webXml != null) {
            webXml.close();
            downloadPU = true;
            String jeeContainer = JeeProcessingUnitContainerProvider.getJeeContainer((BeanLevelProperties)beanLevelProperties);
            String[] classesToLoad = null;
            if ("jetty".equals(jeeContainer)) {
                classesToLoad = new String[]{"org.eclipse.jetty.server.Server"};
            }
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
                ((ServiceClassLoader)this.contextClassLoader).addURLs(BootUtil.toURLs((String)JeeProcessingUnitContainerProvider.getJeeContainerJarPath((String)jeeContainer)));
                ((ServiceClassLoader)this.contextClassLoader).setParentClassLoader(SharedServiceData.getJeeClassLoader((String)jeeContainer, (String[])classesToLoad));
            }
            catch (Exception e) {
                throw new CannotCreateContainerException("Failed to configure JEE class loader", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            }
            String className = StringUtils.capitalize((String)jeeContainer) + "JeeProcessingUnitContainerProvider";
            processingUnitContainerProviderClass = "org.openspaces.pu.container.jee." + jeeContainer + "." + className;
        } else if (puConfig != null) {
            puConfig.close();
            downloadPU = true;
            processingUnitContainerProviderClass = "org.openspaces.interop.DotnetProcessingUnitContainerProvider";
        } else if (puInteropConfig != null) {
            puInteropConfig.close();
            downloadPU = true;
            processingUnitContainerProviderClass = IntegratedProcessingUnitContainerProvider.class.getName();
        } else {
            processingUnitContainerProviderClass = IntegratedProcessingUnitContainerProvider.class.getName();
            if (beanLevelProperties.getContextProperties().getProperty("pu.download", "true").equalsIgnoreCase("true")) {
                downloadPU = true;
            }
        }
        if (beanLevelProperties != null) {
            processingUnitContainerProviderClass = beanLevelProperties.getContextProperties().getProperty("pu.container.class", processingUnitContainerProviderClass);
        }
        if (downloadPU) {
            String deployName = puName + "_" + this.clusterInfo.getRunningNumberOffset1();
            String deployedProcessingUnitsLocation = workLocation.getAbsolutePath() + "/processing-units";
            int uuid = Math.abs(new Random().nextInt());
            this.deployPath = new File(deployedProcessingUnitsLocation + "/" + deployName.replace('.', '_') + "_" + uuid);
            FileSystemUtils.deleteRecursively((File)this.deployPath);
            this.deployPath.mkdirs();
            beanLevelProperties.getContextProperties().setProperty("jee.deployPath", this.deployPath.getAbsolutePath());
            beanLevelProperties.getContextProperties().setProperty("dotnet.deployPath", this.deployPath.getAbsolutePath());
            beanLevelProperties.getContextProperties().setProperty("deployPath", this.deployPath.getAbsolutePath());
            OperationalStringManager osm = this.context.getServiceBeanManager().getOperationalStringManager();
            try {
                if (osm == null) {
                    this.copyPu(puPath, this.deployPath, SystemInfo.singleton().locations().deploy());
                } else if (this.isOnGsmHost(osm.getDeployHost())) {
                    this.copyPu(puPath, this.deployPath, osm.getDeployPath());
                } else {
                    this.downloadAndExtractPU(puName, puPath, this.deployPath, new File(deployedProcessingUnitsLocation), osm.getDeployURL());
                }
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"Could not determine if GSC and GSM are on the same host", (Throwable)e);
                this.downloadAndExtractPU(puName, puPath, this.deployPath, new File(deployedProcessingUnitsLocation), osm.getDeployURL());
            }
            catch (UnknownHostException e) {
                logger.warn((Object)"Could not determine if GSC and GSM are on the same host", (Throwable)e);
                this.downloadAndExtractPU(puName, puPath, this.deployPath, new File(deployedProcessingUnitsLocation), osm.getDeployURL());
            }
            catch (RemoteException e) {
                logger.warn((Object)"Could not determine if GSC and GSM are on the same host", (Throwable)e);
                this.downloadAndExtractPU(puName, puPath, this.deployPath, new File(deployedProcessingUnitsLocation), osm.getDeployURL());
            }
            for (Map.Entry<Object, Object> entry : beanLevelProperties.getContextProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("com.gs.resolvePlaceholder")) continue;
                String path = (String)entry.getValue();
                File file = new File(this.deployPath, path);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolving placeholder for file [" + file.getAbsolutePath() + "]"));
                }
                BeanLevelPropertiesUtils.resolvePlaceholders((BeanLevelProperties)beanLevelProperties, (File)file);
            }
        }
        boolean sharedLibEnabled = beanLevelProperties.getContextProperties().containsKey("pu.shared-lib.enable") ? beanLevelProperties.getContextProperties().getProperty("pu.shared-lib").equals("true") : System.getProperty("com.gs.pu.shared-lib.enable", "false").equals("true");
        boolean disableManifestClassPathJars = Boolean.getBoolean("com.gs.pu.manifest.classpath.disable");
        boolean disableManifestClassPathCommonPuJars = Boolean.getBoolean("com.gs.pu.manifest.classpath.common.disable");
        List<Object> manifestClassPathJars = new ArrayList();
        CommonClassLoader commonClassLoader = CommonClassLoader.getInstance();
        if (downloadPU) {
            File file;
            ArrayList<URL> libUrls;
            block85: {
                File manifestFile;
                libUrls = new ArrayList<URL>();
                libDir = new File(this.deployPath, "lib");
                if (libDir.exists()) {
                    for (File libFile : libFiles = BootIOUtils.listFiles((File)libDir)) {
                        libUrls.add(libFile.toURI().toURL());
                    }
                }
                if (!disableManifestClassPathJars && (manifestFile = new File(this.deployPath, "META-INF/MANIFEST.MF")).isFile()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(manifestFile);
                        manifestClassPathJars = this.getManifestClassPathJars(puName, fileInputStream);
                        libUrls.addAll(manifestClassPathJars);
                    }
                    catch (IOException iOException) {
                        if (!logger.isWarnEnabled()) break block85;
                        logger.warn((Object)PUServiceBeanImpl.failedReadingManifest(puName), (Throwable)iOException);
                    }
                }
            }
            ArrayList<URL> sharedlibUrls = new ArrayList<URL>();
            File file2 = new File(this.deployPath, "shared-lib");
            if (file2.exists()) {
                File[] sharedlibFiles;
                File[] fileArray = sharedlibFiles = BootIOUtils.listFiles((File)file2);
                int libFile = fileArray.length;
                for (int i = 0; i < libFile; ++i) {
                    File sharedlibFile = fileArray[i];
                    sharedlibUrls.add(sharedlibFile.toURI().toURL());
                }
            }
            if ((file = new File(this.deployPath, "WEB-INF/shared-lib")).exists()) {
                File[] sharedlibFiles;
                for (File sharedlibFile : sharedlibFiles = BootIOUtils.listFiles((File)file)) {
                    sharedlibUrls.add(sharedlibFile.toURI().toURL());
                }
            }
            if (sharedLibEnabled) {
                ((ServiceClassLoader)this.contextClassLoader).setSlashPath(this.deployPath.toURI().toURL());
                ((ServiceClassLoader)this.contextClassLoader).setLibPath(libUrls);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)this.logMessage("Service Class Loader " + Arrays.toString(((ServiceClassLoader)this.contextClassLoader).getURLs())));
                }
                commonClassLoader.addComponent(puName, sharedlibUrls.toArray(new URL[sharedlibUrls.size()]));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)this.logMessage("Common Class Loader " + sharedlibUrls));
                }
            } else {
                List urls2;
                URLClassLoader urlClassLoader;
                InputStream puCommonManifestMF;
                if (sharedlibUrls.size() > 0) {
                    logger.warn((Object)"Using old 'shared-lib' directory, will add jars under it as if it was 'lib'");
                }
                libUrls.addAll(sharedlibUrls);
                String gsLibOpt = Locator.getLibOptional();
                String gsPuCommon = System.getProperty("com.gs.pu-common", gsLibOpt + "pu-common");
                libUrls.addAll(BootUtil.toURLs((String)gsPuCommon));
                libUrls.addAll(BootUtil.toURLs((String)Locator.getLibOptionalSecurity()));
                libUrls.addAll(BootUtil.toURLs((String)(gsLibOpt + "scala")));
                if (!disableManifestClassPathJars && !disableManifestClassPathCommonPuJars && (puCommonManifestMF = (urlClassLoader = new URLClassLoader((urls2 = BootUtil.toURLs((String)gsPuCommon)).toArray(new URL[urls2.size()]), null)).getResourceAsStream("META-INF/MANIFEST.MF")) != null) {
                    List<URL> manifestClassPathComonPuJars = this.getManifestClassPathJars(puName, puCommonManifestMF);
                    manifestClassPathJars.addAll(manifestClassPathComonPuJars);
                    libUrls.addAll(manifestClassPathComonPuJars);
                }
                ((ServiceClassLoader)this.contextClassLoader).setSlashPath(this.deployPath.toURI().toURL());
                ((ServiceClassLoader)this.contextClassLoader).setLibPath(libUrls);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)this.logMessage("Service Class Loader " + Arrays.toString(((ServiceClassLoader)this.contextClassLoader).getURLs())));
                }
            }
            try {
                this.prepareWebApplication(this.deployPath, this.clusterInfo, beanLevelProperties);
            }
            catch (Exception e) {
                throw new CannotCreateContainerException("Failed to bootstrap web application", (Throwable)e);
            }
        }
        ArrayList<Object> libUrls32 = new ArrayList<Object>();
        libDir = new WebsterFile(new URL(codeserver + puPath + "/lib"));
        libFiles = libDir.listFiles();
        boolean bl = false;
        while (var26_47 < libFiles.length) {
            libUrls32.add(new URL(codeserver + puPath + "/lib/" + libFiles[var26_47].getName()));
            ++var26_47;
        }
        if (!disableManifestClassPathJars && (inputStream = this.readManifestFromCodeServer(puName, puPath, codeserver, workLocation)) != null) {
            manifestClassPathJars = this.getManifestClassPathJars(puName, inputStream);
            libUrls32.addAll(manifestClassPathJars);
        }
        WebsterFile websterFile = new WebsterFile(new URL(codeserver + puPath + "/shared-lib"));
        File[] sharedlibFiles = websterFile.listFiles();
        ArrayList<URL> sharedlibUrls = new ArrayList<URL>();
        for (File sharedlibFile : sharedlibFiles) {
            sharedlibUrls.add(new URL(codeserver + puPath + "/shared-lib/" + sharedlibFile.getName()));
        }
        WebsterFile websterFile2 = new WebsterFile(new URL(codeserver + puPath + "/WEB-INF/shared-lib"));
        for (File sharedlibFile : sharedlibFiles = websterFile2.listFiles()) {
            sharedlibUrls.add(new URL(codeserver + puPath + "/WEB-INF/shared-lib/" + sharedlibFile.getName()));
        }
        if (sharedLibEnabled) {
            ((ServiceClassLoader)this.contextClassLoader).setSlashPath(new URL(codeserver + puPath + "/"));
            ((ServiceClassLoader)this.contextClassLoader).setLibPath(libUrls32);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.logMessage("Service Class Loader " + Arrays.toString(((ServiceClassLoader)this.contextClassLoader).getURLs())));
            }
            commonClassLoader.addComponent(puName, sharedlibUrls.toArray(new URL[sharedlibUrls.size()]));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.logMessage("Common Class Loader " + sharedlibUrls));
            }
        } else {
            if (sharedlibUrls.size() > 0) {
                logger.warn((Object)"Using old 'shared-lib' directory, will add jars under it as if it was 'lib'");
            }
            libUrls32.addAll(sharedlibUrls);
            ((ServiceClassLoader)this.contextClassLoader).setSlashPath(new URL(codeserver + puPath + "/"));
            ((ServiceClassLoader)this.contextClassLoader).setLibPath(libUrls32);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.logMessage("Service Class Loader " + Arrays.toString(((ServiceClassLoader)this.contextClassLoader).getURLs())));
            }
        }
        try {
            this.contextClassLoader.loadClass("org.mule.api.MuleContext");
            ((ServiceClassLoader)this.contextClassLoader).addURLs(BootUtil.toURLs((String)(SystemInfo.singleton().locations().lib() + "/optional/mule/xap-mule.jar")));
        }
        catch (Throwable libUrls32) {
            // empty catch block
        }
        if (PlatformVersion.getInstance().getProductType() == ProductType.InsightEdge) {
            logger.debug((Object)"Adding insightedge jars");
            Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
            ((ServiceClassLoader)this.contextClassLoader).addURLs(PUServiceBeanImpl.getInsightEdgeClassPath());
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        }
        if (springXml.contains("<os-core:rest")) {
            String jeeContainer = JeeProcessingUnitContainerProvider.getJeeContainer((BeanLevelProperties)beanLevelProperties);
            String[] classesToLoad = new String[]{"org.eclipse.jetty.server.Server"};
            String jettyJars = System.getProperty("com.gigaspaces.rest.jetty", JeeProcessingUnitContainerProvider.getJeeContainerJarPath((String)jeeContainer));
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
                ((ServiceClassLoader)this.contextClassLoader).addURLs(PUServiceBeanImpl.getRestClassPath(jettyJars));
                ((ServiceClassLoader)this.contextClassLoader).setParentClassLoader(SharedServiceData.getJeeClassLoader((String)jeeContainer, (String[])classesToLoad));
            }
            catch (Exception exception) {
                throw new CannotCreateContainerException("Failed to configure class loader", (Throwable)exception);
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            }
        }
        if (springXml.contains("<blob-store:rocksdb-blob-store") || springXml.contains("class=\"com.gigaspaces.blobstore.rocksdb.RocksDBBlobStoreHandler\"")) {
            urls = this.makeJarsUrls(new File(System.getProperty("com.gigaspaces.blobstore.rocksdb", SystemInfo.singleton().locations().lib() + "/optional/memoryxtend/rocksdb/")));
            Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
            ((ServiceClassLoader)this.contextClassLoader).addURLs(urls);
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        }
        if (springXml.contains("<blob-store:off-heap-blob-store") || springXml.contains("class=\"com.gigaspaces.blobstore.offheap.OffHeapBlobStoreHandler\"")) {
            urls = this.makeJarsUrls(new File(System.getProperty("com.gigaspaces.blobstore.offheap", SystemInfo.singleton().locations().lib() + "/optional/memoryxtend/off-heap/")));
            Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
            ((ServiceClassLoader)this.contextClassLoader).addURLs(urls);
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        }
        if (springXml.contains("<blob-store:pmem-blob-store") || springXml.contains("class=\"com.gigaspaces.blobstore.pmem.PmemBlobStoreHandler\"")) {
            urls = this.makeJarsUrls(new File(System.getProperty("com.gigaspaces.blobstore.pmem", SystemInfo.singleton().locations().lib() + "/optional/memoryxtend/pmem/")));
            Thread.currentThread().setContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
            ((ServiceClassLoader)this.contextClassLoader).addURLs(urls);
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        }
        Map<String, String> puTags = PUServiceBeanImpl.buildPuTags(this.clusterInfo);
        MetricRegistrator puMetricRegistrator = this.metricManager.createRegistrator("pu", puTags);
        this.metricRegistrators = this.metricManager.registerProcessMetrics(puTags);
        this.metricRegistrators.add(puMetricRegistrator);
        for (Map.Entry entry : puTags.entrySet()) {
            beanLevelProperties.getContextProperties().setProperty("metrics." + (String)entry.getKey(), (String)entry.getValue());
        }
        if (this.quiesceDetails != null && this.quiesceDetails.getStatus() == QuiesceState.QUIESCED) {
            beanLevelProperties.getContextProperties().setProperty("quiesce.token", this.quiesceDetails.getToken().toString());
            beanLevelProperties.getContextProperties().setProperty("quiesce.description", this.quiesceDetails.getDescription());
        }
        ProcessingUnitContainerProvider factory = this.createContainerProvider(processingUnitContainerProviderClass);
        factory.setDeployPath(this.deployPath);
        factory.setClassLoader(this.contextClassLoader);
        factory.setManifestUrls(manifestClassPathJars);
        if (webXml == null && factory instanceof ApplicationContextProcessingUnitContainerProvider && StringUtils.hasText((String)springXml)) {
            String string;
            String deployPath;
            if (springXml.contains("os-gateway:") && StringUtils.hasText((String)(deployPath = beanLevelProperties.getContextProperties().getProperty("deployPath"))) && StringUtils.hasText((String)(string = PUServiceBeanImpl.readFile(deployPath + "/META-INF/spring/pu.xml")))) {
                springXml = string;
            }
            ByteArrayResource resource = new ByteArrayResource(springXml.getBytes());
            ((ApplicationContextProcessingUnitContainerProvider)factory).addConfigLocation((Resource)resource);
        }
        factory.setClusterInfo(this.clusterInfo);
        factory.setBeanLevelProperties(beanLevelProperties);
        factory.setMetricRegistrator(puMetricRegistrator);
        this.container = factory.createContainer();
        ClassLoader webAppClassLoader = SharedServiceData.removeWebAppClassLoader((String)this.clusterInfo.getUniqueName());
        if (webAppClassLoader != null) {
            this.contextClassLoader = webAppClassLoader;
        }
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        this.buildMembersAliveIndicators();
        this.buildUndeployingEventListeners();
        this.buildDumpProcessors();
        ArrayList<Object> arrayList = this.buildServiceDetails();
        this.buildServiceMonitors();
        this.buildInvocableServices();
        this.puDetails = new PUDetails(this.context.getParentServiceID(), this.clusterInfo, beanLevelProperties, arrayList.toArray(new Object[arrayList.size()]));
        if (this.container instanceof ApplicationContextProcessingUnitContainer) {
            ApplicationContext applicationContext = ((ApplicationContextProcessingUnitContainer)this.container).getApplicationContext();
            int numberOfThreads = this.watchTasks.size() / 5;
            if (numberOfThreads == 0) {
                numberOfThreads = 1;
            }
            this.executorService = Executors.newScheduledThreadPool(numberOfThreads);
            for (WatchTask watchTask : this.watchTasks) {
                if (watchTask.getMonitor() instanceof ApplicationContextMonitor) {
                    ((ApplicationContextMonitor)watchTask.getMonitor()).setApplicationContext(applicationContext);
                }
                this.executorService.scheduleAtFixedRate(watchTask, watchTask.getMonitor().getPeriod(), watchTask.getMonitor().getPeriod(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private ServiceDetails buildStandaloneServiceDetails(MarshalledObject beanLevelPropertiesMarshObj, MarshalledObject sla) {
        StandaloneServiceDetails details = null;
        OperationalStringManager operationalStringManager = this.context.getServiceBeanManager().getOperationalStringManager();
        if (operationalStringManager == null) {
            details = new StandaloneServiceDetails();
            details.setBeanLevelProperties(beanLevelPropertiesMarshObj);
            details.setSLA(sla);
            details.setProcessingUnitType(String.valueOf(this.context.getInitParameter("pu.type")));
        }
        return details;
    }

    private static Map<String, String> buildPuTags(ClusterInfo clusterInfo) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("pu_name", clusterInfo != null ? clusterInfo.getName() : "unknown");
        tags.put("pu_instance_id", clusterInfo != null ? PUServiceBeanImpl.getInstanceId(clusterInfo) : "unknown");
        return tags;
    }

    private static String getInstanceId(ClusterInfo clusterInfo) {
        Integer id = clusterInfo.getInstanceId();
        if (clusterInfo.getNumberOfBackups() == 0) {
            return id.toString();
        }
        Integer bid = clusterInfo.getBackupId();
        if (bid == null) {
            bid = 0;
        }
        return id + "_" + (bid + 1);
    }

    private long copyPu(String puPath, File puWorkFolder, String deployPath) throws IOException {
        String puDeployPath = deployPath + "/" + puPath;
        File src = new File(puDeployPath);
        logger.info((Object)("Copying from GSM [" + puDeployPath + "] to [" + deployPath + "] ..."));
        FileSystemUtils.copyRecursively((File)src, (File)puWorkFolder);
        return src.getTotalSpace();
    }

    private void logDownloadSize(long size) {
        if (logger.isInfoEnabled()) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            String suffix = "kb";
            float factor = 1024.0f;
            if (size > 0x100000L) {
                suffix = "mb";
                factor = 1048576.0f;
            }
            logger.info((Object)("Downloaded [" + nf.format((float)size / factor) + suffix + "] to [" + this.deployPath + "]"));
        }
    }

    private InputStream readManifestFromCodeServer(String puName, String puPath, String codeserver, File workLocation) {
        try {
            URL manifestURL = new URL(codeserver + puPath + "/" + "META-INF/MANIFEST.MF");
            return manifestURL.openStream();
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)PUServiceBeanImpl.failedReadingManifest(puName), (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> getManifestClassPathJars(String puName, InputStream manifestStream) {
        ArrayList<URL> exportedManifestUrls;
        block24: {
            exportedManifestUrls = new ArrayList<URL>();
            try {
                String[] manifestLibFiles;
                Manifest manifest = new Manifest(manifestStream);
                String manifestClasspathLibs = manifest.getMainAttributes().getValue("Class-Path");
                if (manifestClasspathLibs == null) break block24;
                for (String fileName : manifestLibFiles = StringUtils.tokenizeToStringArray((String)manifestClasspathLibs, (String)" ")) {
                    File file;
                    block25: {
                        try {
                            fileName = PlaceholderReplacer.replacePlaceholders(System.getenv(), (String)fileName);
                        }
                        catch (PlaceholderReplacer.PlaceholderResolutionException e) {
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn((Object)("Could not resolve manifest classpath entry: " + fileName + " of processing unit " + puName), (Throwable)e);
                            continue;
                        }
                        URL url = null;
                        try {
                            url = new URL(fileName);
                            if (!"file".equals(url.getProtocol())) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn((Object)("Only file protocol is supported in urls, found : '" + fileName + "' in manifest classpath of processing unit " + puName));
                                continue;
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (url != null) {
                            try {
                                file = new File(url.toURI());
                                break block25;
                            }
                            catch (URISyntaxException e) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn((Object)("Invalid url: " + url + " provided in pu " + puName + " manifest classpath, ignoring entry"), (Throwable)e);
                                continue;
                            }
                        }
                        file = new File(fileName);
                    }
                    if (!file.isAbsolute()) {
                        file = new File(SystemInfo.singleton().getXapHome(), fileName);
                    }
                    if (!file.isFile()) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("Did not find manifest classpath entry: " + file.getAbsolutePath() + " for processing unit: " + puName + ", ignoring entry."));
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding " + file.getAbsolutePath() + " read from MANIFEST.MF to processing unit: " + puName + " classpath"));
                    }
                    URL urlToAdd = file.toURI().toURL();
                    exportedManifestUrls.add(urlToAdd);
                }
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)PUServiceBeanImpl.failedReadingManifest(puName), (Throwable)e);
                }
            }
            finally {
                block26: {
                    try {
                        manifestStream.close();
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block26;
                        logger.warn((Object)"Failed closing manifest input stream.", (Throwable)e);
                    }
                }
            }
        }
        return exportedManifestUrls;
    }

    private static String failedReadingManifest(String puName) {
        return "Could not read MANIFEST.MF in processing unit: , if you have no Class-Path defined in a MANIFEST.MF, you can safely ignore this message." + puName;
    }

    private static String readFile(String filePath) throws IOException {
        String line;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append(LINE_SEPARATOR);
        }
        reader.close();
        fis.close();
        return buffer.toString();
    }

    protected void buildInvocableServices() {
        if (this.container instanceof InvocableService) {
            this.invocableServiceMap.put("__container__", (InvocableService)this.container);
        }
        Map invocableServices = this.container.getInvocableServices();
        logger.info((Object)("registering invocable services: " + invocableServices));
        this.invocableServiceMap.putAll(invocableServices);
    }

    private void buildServiceMonitors() {
        final Collection serviceMonitorsProviders = this.container.getServiceMonitorsProviders();
        this.serviceMonitors.add(new Callable(){

            public Object call() throws Exception {
                ArrayList<ServiceMonitors> retMonitors = new ArrayList<ServiceMonitors>();
                for (ServiceMonitorsProvider serviceMonitorsProvider : serviceMonitorsProviders) {
                    ServiceMonitors[] monitors = serviceMonitorsProvider.getServicesMonitors();
                    if (monitors == null) continue;
                    for (ServiceMonitors mon : monitors) {
                        retMonitors.add(mon);
                    }
                }
                return retMonitors.toArray(new Object[retMonitors.size()]);
            }
        });
        List sharedMonitors = SharedServiceData.removeServiceMonitors((String)this.clusterInfo.getUniqueName());
        if (sharedMonitors != null) {
            this.serviceMonitors.addAll(sharedMonitors);
        }
    }

    private void buildDumpProcessors() {
        if (this.container instanceof InternalDumpProcessor) {
            this.dumpProcessors.add((InternalDumpProcessor)this.container);
        }
        this.dumpProcessors.addAll(this.container.getDumpProcessors());
        List sharedDumpProcessors = SharedServiceData.removeDumpProcessors((String)this.clusterInfo.getUniqueName());
        if (sharedDumpProcessors != null) {
            for (Object dumpProcesosr : sharedDumpProcessors) {
                if (!(dumpProcesosr instanceof InternalDumpProcessor)) continue;
                this.dumpProcessors.add((InternalDumpProcessor)dumpProcesosr);
            }
        }
    }

    private ArrayList<Object> buildServiceDetails() {
        ServiceDetails standaloneServiceDetails;
        ArrayList<Object> serviceDetails = new ArrayList<Object>();
        Collection serviceDetailsProviders = this.container.getServiceDetailsProviders();
        for (Object serviceDetailsProvider : serviceDetailsProviders) {
            ServiceDetails[] details = serviceDetailsProvider.getServicesDetails();
            if (details == null) continue;
            for (ServiceDetails detail : details) {
                serviceDetails.add(detail);
            }
        }
        List serviceDetailsProvider = SharedServiceData.removeServiceDetails((String)this.clusterInfo.getUniqueName());
        if (serviceDetailsProvider != null) {
            for (Callable serProvider : serviceDetailsProvider) {
                try {
                    Object[] details = (Object[])serProvider.call();
                    Collections.addAll(serviceDetails, details);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to add service details from custom provider", (Throwable)e);
                }
            }
        }
        if ((standaloneServiceDetails = this.buildStandaloneServiceDetails(this.getMarshalledObject(this.getServiceBeanContext(), "beanLevelProperties"), this.getMarshalledObject(this.getServiceBeanContext(), "sla"))) != null) {
            serviceDetails.add(standaloneServiceDetails);
        }
        return serviceDetails;
    }

    private void buildUndeployingEventListeners() {
        ArrayList<Callable> undeployingListeners = new ArrayList<Callable>();
        Collection listeners = this.container.getUndeployListeners();
        for (final ProcessingUnitUndeployingListener listener : listeners) {
            undeployingListeners.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    listener.processingUnitUndeploying();
                    return null;
                }
            });
        }
        List list = SharedServiceData.removeUndeployingEventListeners((String)this.clusterInfo.getUniqueName());
        if (list != null) {
            for (Callable c : list) {
                undeployingListeners.add(c);
            }
        }
        this.undeployingEventListeners = undeployingListeners.toArray(new Callable[undeployingListeners.size()]);
    }

    private void buildMembersAliveIndicators() {
        ArrayList<Callable> maIndicators = new ArrayList<Callable>();
        Collection puIndicators = this.container.getMemberAliveIndicators();
        for (final MemberAliveIndicator memberAliveIndicator : puIndicators) {
            if (!memberAliveIndicator.isMemberAliveEnabled()) continue;
            maIndicators.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return memberAliveIndicator.isAlive();
                }
            });
        }
        List memberAliveIndicatorProvider = SharedServiceData.removeMemberAliveIndicator((String)this.clusterInfo.getUniqueName());
        if (memberAliveIndicatorProvider != null) {
            for (Callable c : memberAliveIndicatorProvider) {
                maIndicators.add(c);
            }
        }
        this.memberAliveIndicators = maIndicators.toArray(new Callable[maIndicators.size()]);
    }

    private SLA getSLA(ServiceBeanContext context) throws IOException, ClassNotFoundException {
        MarshalledObject slaMarshObj = this.getMarshalledObject(context, "sla");
        return (SLA)slaMarshObj.get();
    }

    private MarshalledObject getMarshalledObject(ServiceBeanContext context, String param) {
        return (MarshalledObject)context.getInitParameter(param);
    }

    private void stopPU() {
        if (this.metricRegistrators != null) {
            for (MetricRegistrator registrator : this.metricRegistrators) {
                registrator.clear();
            }
        }
        if (this.metricManager != null) {
            this.metricManager.close();
        }
        if (this.clusterInfo != null) {
            SharedServiceData.removeWebAppClassLoader((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeMemberAliveIndicator((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeUndeployingEventListeners((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeServiceDetails((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeServiceMonitors((String)this.clusterInfo.getUniqueName());
            SharedServiceData.removeDumpProcessors((String)this.clusterInfo.getUniqueName());
        }
        this.serviceMonitors.clear();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        if (this.container != null) {
            try {
                this.container.close();
            }
            catch (Exception e) {
                logger.warn((Object)this.logMessage("Failed to close"), (Throwable)e);
            }
            finally {
                this.container = null;
                this.undeployingEventListeners = null;
                this.memberAliveIndicators = null;
                this.puDetails = null;
            }
        }
        if (this.deployPath != null) {
            boolean deleted = false;
            for (int i = 0; i < 2 && !(deleted = FileSystemUtils.deleteRecursively((File)this.deployPath)); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!deleted) {
                String message = "Failed to delete deployed processing unit from [" + this.deployPath + "]";
                logger.warn((Object)message);
            }
        }
    }

    public void undeployEvent() {
        super.undeployEvent();
        for (Callable c : this.undeployingEventListeners) {
            try {
                c.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isMemberAliveEnabled() {
        return this.memberAliveIndicators != null && this.memberAliveIndicators.length > 0;
    }

    public boolean isAlive() throws Exception {
        if (this.stopping) {
            return true;
        }
        if (this.memberAliveIndicators == null || this.memberAliveIndicators.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"PUServiceBeanImpl.isAlive() returned true - no memberAliveIndicators");
            }
            return true;
        }
        boolean alive = false;
        int count = 0;
        for (Callable<Boolean> memberAliveIndicator : this.memberAliveIndicators) {
            alive = memberAliveIndicator.call();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PUServiceBeanImpl.isAlive() memberAliveIndicators[" + count++ + "] returned " + alive));
            }
            if (!alive) break;
        }
        return alive;
    }

    public IJSpace getSpaceDirect(ServiceID serviceID) throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                Method spaceServiceId;
                if (!this.containsEmbeddedSpace(serviceDetails) || !(spaceServiceId = serviceDetails.getClass().getMethod("getServiceID", new Class[0])).invoke(serviceDetails, new Object[0]).equals(serviceID)) continue;
                Field spaceDetails = serviceDetails.getClass().getDeclaredField("directSpace");
                spaceDetails.setAccessible(true);
                return (IJSpace)spaceDetails.get(serviceDetails);
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get space", e);
            }
        }
        return null;
    }

    public DirectSpaceProxyFactory getSpaceDirectFactory(ServiceID serviceID) throws RemoteException {
        IJSpace space = this.getSpaceDirect(serviceID);
        if (space == null) {
            return null;
        }
        DirectSpaceProxyFactoryImpl result = (DirectSpaceProxyFactoryImpl)space.getDirectProxy().getFactory();
        result = result.createCopyWithoutClusterPolicyIfNeeded();
        return result;
    }

    public RuntimeHolder getSpaceRuntimeHolder(ServiceID serviceID) throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                Method spaceServiceId;
                if (!this.containsEmbeddedSpace(serviceDetails) || !(spaceServiceId = serviceDetails.getClass().getMethod("getServiceID", new Class[0])).invoke(serviceDetails, new Object[0]).equals(serviceID)) continue;
                Field spaceDetails = serviceDetails.getClass().getDeclaredField("directSpaceAdmin");
                spaceDetails.setAccessible(true);
                IInternalRemoteJSpaceAdmin spaceAdmin = (IInternalRemoteJSpaceAdmin)spaceDetails.get(serviceDetails);
                return spaceAdmin.getRuntimeHolder();
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get runtime holder", e);
            }
        }
        return null;
    }

    public StatisticsHolder getSpaceStatisticsHolder(ServiceID serviceID) throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                Method spaceServiceId;
                if (!this.containsEmbeddedSpace(serviceDetails) || !(spaceServiceId = serviceDetails.getClass().getMethod("getServiceID", new Class[0])).invoke(serviceDetails, new Object[0]).equals(serviceID)) continue;
                Field spaceDetails = serviceDetails.getClass().getDeclaredField("directSpaceAdmin");
                spaceDetails.setAccessible(true);
                IInternalRemoteJSpaceAdmin spaceAdmin = (IInternalRemoteJSpaceAdmin)spaceDetails.get(serviceDetails);
                return ((StatisticsAdmin)spaceAdmin).getHolder();
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get statistics holder", e);
            }
        }
        return null;
    }

    public SpaceURL[] listSpacesURLs() throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        ArrayList<SpaceURL> spaceUrls = new ArrayList<SpaceURL>();
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                if (!this.containsEmbeddedSpace(serviceDetails)) continue;
                IJSpace space = this.getSpaceFromServiceDetails(serviceDetails);
                spaceUrls.add(space.getFinderURL());
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get space url", e);
            }
        }
        return spaceUrls.toArray(new SpaceURL[spaceUrls.size()]);
    }

    public SpaceMode[] listSpacesModes() throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        ArrayList<SpaceMode> spacesModes = new ArrayList<SpaceMode>();
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                if (!this.containsEmbeddedSpace(serviceDetails)) continue;
                IJSpace space = this.getSpaceFromServiceDetails(serviceDetails);
                spacesModes.add(((IInternalRemoteJSpaceAdmin)space.getAdmin()).getSpaceMode());
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get space mode", e);
            }
        }
        return spacesModes.toArray(new SpaceMode[spacesModes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUMonitors getPUMonitors() throws RemoteException {
        ArrayList monitors = new ArrayList();
        Collection<Callable> collection = this.serviceMonitors;
        synchronized (collection) {
            for (Callable call : this.serviceMonitors) {
                try {
                    Collections.addAll(monitors, (Object[])call.call());
                }
                catch (Exception e) {
                    logger.error((Object)this.logMessage("Failed to get monitor information, ignoring it"), (Throwable)e);
                }
            }
        }
        return new PUMonitors(monitors.toArray(new Object[monitors.size()]));
    }

    public PUDetails getPUDetails() throws RemoteException {
        return this.puDetails;
    }

    public String getPresentationName() throws RemoteException {
        if (this.puDetails == null) {
            throw new RemoteException("processing unit shutdown");
        }
        return this.puDetails.getPresentationName();
    }

    public ClusterInfo getClusterInfo() throws RemoteException {
        return this.clusterInfo;
    }

    public Object[] listServiceDetails() throws RemoteException {
        if (this.puDetails == null) {
            return new ServiceDetails[0];
        }
        return this.puDetails.getDetails();
    }

    private int getMaxServiceCount(String[] args) {
        int count = -1;
        for (String arg : args) {
            if (arg.indexOf("ScalingPolicyHandler.MaxServices") == -1) continue;
            StringTokenizer tok = new StringTokenizer(arg, " =");
            tok.nextToken();
            String value = tok.nextToken();
            try {
                count = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            break;
        }
        return count;
    }

    private int getSLAMax(ServiceBeanContext context) {
        org.jini.rio.core.SLA[] spaceSLAs;
        int max = -1;
        ServiceLevelAgreements slas = context.getServiceElement().getServiceLevelAgreements();
        for (org.jini.rio.core.SLA spaceSLA : spaceSLAs = slas.getServiceSLAs()) {
            int count = this.getMaxServiceCount(spaceSLA.getConfigArgs());
            if (count == -1) continue;
            max = count;
            break;
        }
        return max;
    }

    private String logMessage(String message) {
        return message;
    }

    private ProcessingUnitContainerProvider createContainerProvider(String containerProviderType) {
        try {
            return (ProcessingUnitContainerProvider)ClassUtils.forName((String)containerProviderType, (ClassLoader)this.contextClassLoader).newInstance();
        }
        catch (Throwable e) {
            throw new CannotCreateContainerException("Failed to create a new instance of container [" + containerProviderType + "]", e);
        }
    }

    private void downloadAndExtractPU(String puName, String puPath, File path, File tempPath, String deployUrl) {
        URL url = null;
        for (int i = 3; i > 0; --i) {
            try {
                url = new URL(deployUrl + "/" + puPath);
                break;
            }
            catch (Exception e) {
                if (i != 1) continue;
                throw new CannotCreateContainerException("Failed to construct URL to download processing unit", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Downloading from GSM [" + url.toExternalForm() + "] to [" + this.deployPath + "] ..."));
        }
        try {
            long size = PUZipUtils.downloadProcessingUnit((String)puName, url, (File)path, (File)tempPath);
            this.logDownloadSize(size);
        }
        catch (Exception e) {
            throw new CannotCreateContainerException("Failed to download processing unit [" + puName + "]", (Throwable)e);
        }
    }

    private void prepareWebApplication(File deployPath, ClusterInfo clusterInfo, BeanLevelProperties beanLevelProperties) throws Exception {
        if (!new File(deployPath, "WEB-INF/web.xml").exists()) {
            return;
        }
        BootstrapWebApplicationContextListener.prepareForBoot((File)deployPath, (ClusterInfo)clusterInfo, (BeanLevelProperties)beanLevelProperties);
        File webInfLib = new File(deployPath, "WEB-INF/lib");
        webInfLib.mkdirs();
        if (webInfLib.exists()) {
            File[] filesToDelete;
            String gsLib = Locator.getLib();
            String gsRequired = Locator.getLibRequired();
            String gsOptional = Locator.getLibOptional();
            try {
                FileSystemUtils.copyRecursively((File)new File(gsRequired), (File)new File(deployPath, "WEB-INF/lib"));
                FileSystemUtils.copyRecursively((File)new File(gsOptional + "/spring"), (File)new File(deployPath, "WEB-INF/lib"));
                FileSystemUtils.copyRecursively((File)new File(gsOptional + "/security"), (File)new File(deployPath, "WEB-INF/lib"));
                for (XapModules xapModule : XapModules.getByClassLoaderType((ClassLoaderType)ClassLoaderType.SERVICE)) {
                    FileUtils.copyFile((File)new File(gsLib + xapModule.getJarFilePath()), (File)new File(deployPath, "WEB-INF/lib/" + xapModule.getJarFileName()));
                }
                FileSystemUtils.copyRecursively((File)new File(gsLib + "/optional/scala/xap-scala.jar"), (File)new File(deployPath, "WEB-INF/lib/xap-scala.jar"));
                logger.debug((Object)this.logMessage("Added spring jars to web application"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileFilter requiredCommonFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return XapModules.isRequiredCommonOrBoot((String)pathname.getName().toLowerCase());
                }
            };
            for (File file : filesToDelete = BootIOUtils.listFiles((File)webInfLib, (FileFilter)requiredCommonFilter)) {
                file.delete();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)this.logMessage("Deleted the following file from the web application: " + file.getName()));
            }
        }
    }

    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    public void runGc() throws RemoteException {
        System.gc();
    }

    public String[] getZones() throws RemoteException {
        return ZoneHelper.getSystemZones();
    }

    public String getName() {
        return this.puDetails.getPresentationName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderHelper.setContextClassLoader((ClassLoader)this.contextClassLoader, (boolean)true);
        try {
            String prefix = "processing-units/" + this.clusterInfo.getName() + "/" + this.clusterInfo.getInstanceId();
            if (this.clusterInfo.getBackupId() != null) {
                prefix = prefix + "_" + this.clusterInfo.getBackupId();
            }
            prefix = prefix + "/";
            dump.addPrefix(prefix);
            try {
                String springXML = (String)this.context.getInitParameter("pu");
                if (springXML != null) {
                    PrintWriter writer = new PrintWriter(dump.createFileWriter("pu.xml"));
                    writer.print(springXML);
                    writer.close();
                }
                Collection<InternalDumpProcessor> collection = this.dumpProcessors;
                synchronized (collection) {
                    for (InternalDumpProcessor dumpProcessor : this.dumpProcessors) {
                        try {
                            dumpProcessor.process(dump);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Failed to generate dump for [" + dumpProcessor + "]"), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                dump.removePrefix();
            }
        }
        finally {
            ClassLoaderHelper.setContextClassLoader((ClassLoader)prevClassLoader, (boolean)true);
        }
    }

    public Object invoke(String serviceBeanName, Map<String, Object> namedArgs) throws RemoteException {
        InvocableService invocableService = this.invocableServiceMap.get(serviceBeanName);
        if (invocableService == null) {
            throw new InvocableServiceLookupFailureException("Could not find an InvocableService with name " + serviceBeanName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invoking service " + serviceBeanName + " with args " + namedArgs));
        }
        return invocableService.invoke(namedArgs);
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void quiesceStateChanged(QuiesceStateChangedEvent quiesceStateChangedEvent) throws RemoteException {
        this.quiesceDetails = new InternalQuiesceDetails(quiesceStateChangedEvent.getQuiesceState(), quiesceStateChangedEvent.getToken(), quiesceStateChangedEvent.getDescription());
        if (this.quiesceDetails.getStatus() == QuiesceState.QUIESCED) {
            this.informQuiesceToListeners(quiesceStateChangedEvent);
            this.informQuiesceToSpaces(quiesceStateChangedEvent);
        } else {
            this.informQuiesceToSpaces(quiesceStateChangedEvent);
            this.informQuiesceToListeners(quiesceStateChangedEvent);
        }
    }

    private void informQuiesceToSpaces(QuiesceStateChangedEvent quiesceStateChangedEvent) {
        for (Object serviceDetails : this.puDetails.getDetails()) {
            if (!this.isSpaceServiceDetails(serviceDetails)) continue;
            try {
                if (!this.containsEmbeddedSpace(serviceDetails)) continue;
                IJSpace space = this.getSpaceFromServiceDetails(serviceDetails);
                space.getDirectProxy().getSpaceImplIfEmbedded().getQuiesceHandler().setQuiesceMode(quiesceStateChangedEvent);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to inform a space about quiesce state changed", (Throwable)e);
            }
        }
    }

    private void informQuiesceToListeners(QuiesceStateChangedEvent event) {
        Collection listeners = this.container.getQuiesceStateChangedListeners();
        for (QuiesceStateChangedListener listener : listeners) {
            listener.quiesceStateChanged(event);
        }
    }

    private boolean containsEmbeddedSpace(Object serviceDetails) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method spaceType = serviceDetails.getClass().getMethod("getSpaceType", new Class[0]);
        return spaceType.invoke(serviceDetails, new Object[0]).toString().equals(SpaceType.EMBEDDED.toString());
    }

    private boolean isSpaceServiceDetails(Object serviceDetails) {
        return serviceDetails.getClass().getName().equals(SpaceServiceDetails.class.getName());
    }

    private IJSpace getSpaceFromServiceDetails(Object serviceDetails) throws NoSuchFieldException, IllegalAccessException {
        Field spaceDetails = serviceDetails.getClass().getDeclaredField("space");
        spaceDetails.setAccessible(true);
        return (IJSpace)spaceDetails.get(serviceDetails);
    }

    private List<URL> makeJarsUrls(File file) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File[] jarFilesAndDirs = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jarFilesAndDirs != null) {
            for (File jarOrDir : jarFilesAndDirs) {
                if (jarOrDir.isDirectory()) {
                    urls.addAll(this.makeJarsUrls(jarOrDir));
                    continue;
                }
                urls.add(jarOrDir.toURI().toURL());
            }
        }
        return urls;
    }

    private static List<URL> getRestClassPath(String jettyJars) throws MalformedURLException {
        return new ClasspathBuilder().append(jettyJars).appendOptional("jetty").appendOptional("spring/spring-web-4.3.19.RELEASE.jar").appendOptional("spring/spring-webmvc-4.3.19.RELEASE.jar").appendOptional("jackson/jackson-core-2.6.2.jar").appendOptional("jackson/jackson-databind-2.6.2.jar").appendOptional("jackson/jackson-annotations-2.6.2.jar").appendOptional("rest/xap-rest-spring.jar").toURLs();
    }

    private static List<URL> getInsightEdgeClassPath() throws MalformedURLException {
        String insightEdgeHome = PUServiceBeanImpl.path(SystemInfo.singleton().getXapHome(), "insightedge");
        return new ClasspathBuilder().append(PUServiceBeanImpl.path(insightEdgeHome, "lib")).append(PUServiceBeanImpl.path(insightEdgeHome, "lib", "analytics-xtreme")).appendPlatform("scala").toURLs();
    }

    private static String path(String ... tokens) {
        return String.join((CharSequence)File.separator, tokens);
    }

    private static class WatchTask
    implements Runnable {
        private final Monitor monitor;
        private final Watch watch;

        public WatchTask(Monitor monitor, Watch watch) {
            this.monitor = monitor;
            this.watch = watch;
        }

        public Monitor getMonitor() {
            return this.monitor;
        }

        public Watch getWatch() {
            return this.watch;
        }

        @Override
        public void run() {
            this.watch.addWatchRecord(new Calculable(this.watch.getId(), this.monitor.getValue(), System.currentTimeMillis()));
        }
    }
}

