/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid.deploy;

import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.service.ServiceConfigLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.jini.config.Configuration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.PUZipUtils;
import org.jini.rio.boot.TLSUtils;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.opstring.OpString;
import org.jini.rio.opstring.OpStringLoader;
import org.openspaces.admin.pu.ProcessingUnitType;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.jee.JeeProcessingUnitContainerProvider;
import org.openspaces.pu.container.servicegrid.deploy.GSMNotFoundException;
import org.openspaces.pu.container.servicegrid.deploy.ProcessingUnitNotFoundException;
import org.openspaces.pu.container.servicegrid.deploy.ServiceFinder;
import org.openspaces.pu.container.support.BeanLevelPropertiesParser;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.CommandLineParser;
import org.openspaces.pu.container.support.RequiredDependenciesCommandLineParser;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.openspaces.pu.sla.InstanceSLA;
import org.openspaces.pu.sla.Policy;
import org.openspaces.pu.sla.RelocationPolicy;
import org.openspaces.pu.sla.SLA;
import org.openspaces.pu.sla.ScaleUpPolicy;
import org.openspaces.pu.sla.requirement.HostRequirement;
import org.openspaces.pu.sla.requirement.RangeRequirement;
import org.openspaces.pu.sla.requirement.Requirement;
import org.openspaces.pu.sla.requirement.SystemRequirement;
import org.openspaces.pu.sla.requirement.ZoneRequirement;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Deploy {
    private static final Log logger = LogFactory.getLog(Deploy.class);
    private GSM gsm = null;
    private boolean disableGSM = false;
    private DeployAdmin deployAdmin;
    private String[] groups;
    private LookupLocator[] locators;
    private int lookupTimeout = 5000;
    private long deployTimeout = Long.MAX_VALUE;
    private static boolean sout = false;
    private static boolean disableInfoLogging = false;
    public static final String KEY_HELP1 = "h";
    public static final String KEY_HELP2 = "help";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_SECURED = "secured";
    public static final String KEY_SLA = "sla";
    public static final String KEY_CLUSTER = "cluster";
    public static final String KEY_SCHEMA = "schema";
    public static final String KEY_TOTAL_MEMBERS = "total_members";
    public static final String KEY_GROUPS = "groups";
    public static final String KEY_LOCATORS = "locators";
    public static final String KEY_TIMEOUT = "timeout";
    public static final String KEY_PROPERTIES = "properties";
    public static final String KEY_OVERRIDE_NAME = "override-name";
    public static final String KEY_ZONES = "zones";
    public static final String KEY_PRIMARY_ZONE = "primary-zone";
    public static final String KEY_APPLICATION_NAME = "application-name";
    public static final String KEY_ELASTIC_PROPERTIES = "elastic-properties";
    public static final String KEY_DEPLOY_TIMEOUT = "deploy-timeout";
    public static final String KEY_REQUIRES_ISOLATION = "requires-isolation";
    public static final String KEY_MAX_INSTANCES_PER_VM = "max-instances-per-vm";
    public static final String KEY_MAX_INSTANCES_PER_MACHINE = "max-instances-per-machine";
    public static final String KEY_MAX_INSTANCES_PER_ZONE = "max-instances-per-zone";
    public static final String[] validOptionsArray = new String[]{"h", "help", "user", "password", "secured", "sla", "cluster", "groups", "locators", "timeout", "properties", "override-name", "zones", "deploy-timeout", "application-name", "requires-isolation", "max-instances-per-vm", "max-instances-per-machine", "max-instances-per-zone"};
    private Boolean secured;
    private UserDetails userDetails;
    private CredentialsProvider credentialsProvider;
    private String applicationName;
    private static final String LINE_SEPARATOR;

    public static void setDisableInfoLogging(boolean disableInfoLogging) {
        Deploy.disableInfoLogging = disableInfoLogging;
    }

    private void initGSM() {
        if (this.gsm != null || this.disableGSM) {
            return;
        }
        Deploy.info("Searching for GSM in groups " + Arrays.toString(this.getGroups()) + " and locators [" + Arrays.toString(this.getLocators()) + "]");
        ServiceItem[] result = ServiceFinder.find(null, GSM.class, this.lookupTimeout, this.getGroups(), this.getLocators());
        if (result == null || result.length <= 0) {
            throw new GSMNotFoundException(this.getGroups(), this.lookupTimeout);
        }
        this.gsm = (GSM)result[0].service;
    }

    private void initDeployAdmin() {
        if (this.deployAdmin != null || this.disableGSM) {
            return;
        }
        try {
            this.deployAdmin = (DeployAdmin)this.gsm.getAdmin();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to get deploy admin", e);
        }
    }

    public Deploy disableGSM() {
        this.disableGSM = true;
        return this;
    }

    public static void setSout(boolean soutVal) {
        sout = soutVal;
    }

    public void initializeDiscovery(GSM gsm) {
        if (this.disableGSM) {
            return;
        }
        this.gsm = gsm;
        try {
            this.deployAdmin = (DeployAdmin)gsm.getAdmin();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to get deploy admin", e);
        }
    }

    public String[] getGroups() {
        if (this.groups == null) {
            String groupsProperty = SystemInfo.singleton().lookup().groups();
            if (groupsProperty != null) {
                StringTokenizer tokenizer = new StringTokenizer(groupsProperty);
                int count = tokenizer.countTokens();
                this.groups = new String[count];
                for (int i = 0; i < count; ++i) {
                    this.groups[i] = tokenizer.nextToken();
                }
            } else {
                this.groups = new String[]{SystemInfo.singleton().lookup().defaultGroups()};
            }
        }
        return this.groups;
    }

    public LookupLocator[] getLocators() {
        String locatorsProperty;
        if (this.locators == null && (locatorsProperty = SystemInfo.singleton().lookup().locators()) != null) {
            this.locators = BootUtil.toLookupLocators((String)locatorsProperty);
        }
        return this.locators;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public void setLocators(String locators) {
        this.locators = BootUtil.toLookupLocators((String)locators);
    }

    public void setLookupTimeout(int lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    @Deprecated
    public void setUserDetails(UserDetails userDetails) {
        this.userDetails = userDetails;
    }

    @Deprecated
    public void setUserDetails(String userName, String password) {
        this.userDetails = new User(userName, password);
    }

    public void setCredentials(String userName, String password) {
        this.credentialsProvider = new DefaultCredentialsProvider(userName, password);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setDeployTimeout(long deployTimeout) {
        this.deployTimeout = deployTimeout;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void deployAndWait(String[] args) throws Exception {
        long expireDeployTimeout;
        OperationalString opString = this.buildOperationalString(args);
        if (this.deployAdmin.hasDeployed(opString.getName())) {
            Deploy.info("Processing Unit already deployed, exiting");
            return;
        }
        int totalPlanned = Deploy.sumUpServices(opString);
        DeployListener listener = new DeployListener();
        Configuration config = ServiceConfigLoader.getConfiguration();
        this.deployAdmin.deploy(opString, (ServiceProvisionListener)ExporterConfig.getExporter((Configuration)config, (String)"com.gigaspaces.transport", (String)"defaultExporter").export((Remote)((Object)listener)));
        Deploy.info("Waiting " + (this.deployTimeout != Long.MAX_VALUE ? this.deployTimeout + " ms" : "indefinitely") + " for [" + totalPlanned + "] processing unit instances to be deployed...");
        long l = expireDeployTimeout = this.deployTimeout != Long.MAX_VALUE ? SystemTime.timeMillis() + this.deployTimeout : Long.MAX_VALUE;
        while (listener.getTotalEvents() < totalPlanned && SystemTime.timeMillis() < expireDeployTimeout) {
            Thread.sleep(200L);
        }
        if (SystemTime.timeMillis() >= expireDeployTimeout) {
            Deploy.info("Timed-out deploying [" + totalPlanned + "] processing unit instances");
        } else {
            Deploy.info("Finished deploying [" + totalPlanned + "] processing unit instances");
        }
    }

    public void deploy(String[] args) throws Exception {
        this.deploy(args, null);
    }

    public void deploy(String[] args, ServiceProvisionListener listener) throws Exception {
        OperationalString opString = this.buildOperationalString(args);
        if (listener != null) {
            this.deployAdmin.deploy(opString, listener);
        } else {
            this.deployAdmin.deploy(opString);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OperationalString buildOperationalString(String[] args) throws Exception {
        void var19_39;
        ClusterInfo clusterInfo;
        String codeserver;
        String puName;
        if (args.length == 0) {
            throw new IllegalArgumentException("The pu name must be defined");
        }
        boolean deletePUFile = false;
        String puPath = args[args.length - 1];
        if (Deploy.isRemoteUrl(puPath)) {
            puPath = Deploy.download(new URL(puPath));
            deletePUFile = true;
        }
        File puFile = new File(puPath);
        String overridePuName = puName = puFile.getName().replace(' ', '_');
        String fullArchiveName = this.fetchFullArchiveName(puFile);
        if (puFile.exists() && puFile.isDirectory()) {
            File zipPUFile = new File(System.getProperty("java.io.tmpdir") + "/" + puName + ".zip");
            Deploy.info("Deploying a directory [" + puFile.getAbsolutePath() + "], zipping it into [" + zipPUFile.getAbsolutePath() + "]");
            PUZipUtils.zip((File)puFile, (File)zipPUFile);
            puFile = zipPUFile;
            deletePUFile = true;
        }
        if (puFile.getName().endsWith(".zip") || puFile.getName().endsWith(".jar") || puFile.getName().endsWith(".war")) {
            if (!puFile.exists()) {
                throw new IllegalArgumentException("File [" + puFile.getAbsolutePath() + "] not found and can't be deployed");
            }
            puPath = overridePuName = puFile.getName().substring(0, puFile.getName().length() - 4).replace(' ', '_');
        }
        CommandLineParser.Parameter[] params = CommandLineParser.parse((String[])args, (int)(args.length - 1));
        RequiredDependencies instanceDeploymentDependencies = new RequiredDependencies();
        RequiredDependencies instanceStartDependencies = new RequiredDependencies();
        for (CommandLineParser.Parameter param : params) {
            if (param.getName().equalsIgnoreCase(KEY_GROUPS)) {
                this.setGroups(param.getArguments());
            }
            if (param.getName().equalsIgnoreCase(KEY_LOCATORS)) {
                StringBuilder sb = new StringBuilder();
                for (String string : param.getArguments()) {
                    sb.append(string).append(',');
                }
                this.setLocators(sb.toString());
            }
            if (param.getName().equalsIgnoreCase(KEY_TIMEOUT)) {
                this.setLookupTimeout(Integer.valueOf(param.getArguments()[0]));
            }
            if (param.getName().equalsIgnoreCase(KEY_OVERRIDE_NAME)) {
                overridePuName = param.getArguments()[0];
            }
            if (param.getName().equalsIgnoreCase(KEY_DEPLOY_TIMEOUT)) {
                this.setDeployTimeout(Long.valueOf(param.getArguments()[0]));
            }
            if (RequiredDependenciesCommandLineParser.isInstanceDeploymentDependencies(param)) {
                instanceDeploymentDependencies = RequiredDependenciesCommandLineParser.convertCommandlineParameterToInstanceDeploymentDependencies(param);
            }
            if (RequiredDependenciesCommandLineParser.isInstanceStartDependencies(param)) {
                instanceStartDependencies = RequiredDependenciesCommandLineParser.convertCommandlineParameterToInstanceStartDependencies(param);
            }
            if (!param.getName().equalsIgnoreCase(KEY_APPLICATION_NAME)) continue;
            this.setApplicationName(param.getArguments()[0]);
        }
        Deploy.info("Deploying [" + puName + "] with name [" + overridePuName + "] under groups " + Arrays.toString(this.getGroups()) + " and locators " + Arrays.toString(this.getLocators()));
        this.initGSM();
        this.initDeployAdmin();
        if (puFile.exists() && (puFile.getName().endsWith(".zip") || puFile.getName().endsWith(".jar") || puFile.getName().endsWith(".war"))) {
            try {
                if (this.disableGSM) {
                    Deploy.copyPu(puPath, puFile, SystemInfo.singleton().locations().deploy());
                } else if (this.isOnGsmHost()) {
                    Deploy.copyPu(puPath, puFile, this.gsm.getDeployPath());
                } else {
                    this.uploadPU(puPath, puFile);
                }
            }
            catch (UnknownHostException uhe) {
                logger.warn((Object)("Could not determine if client and GSM[" + this.gsm.getGSAServiceID() + "] are on the same host"), (Throwable)uhe);
                this.uploadPU(puPath, puFile);
            }
            catch (RemoteException re) {
                logger.warn((Object)("Could not determine if client and GSM[" + this.gsm.getGSAServiceID() + "] are on the same host"), (Throwable)re);
                this.uploadPU(puPath, puFile);
            }
            if (deletePUFile) {
                puFile.delete();
            }
        }
        if (!this.disableGSM && !this.gsm.hasPUUnderDeploy(puPath)) {
            throw new ProcessingUnitNotFoundException(puName, this.gsm);
        }
        String string = codeserver = this.disableGSM ? new File(SystemInfo.singleton().locations().deploy()).toURL().toString() : this.getCodebase(this.deployAdmin);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using codeserver [" + codeserver + "]"));
        }
        URL root = new URL(codeserver);
        BeanLevelProperties beanLevelProperties = new BeanLevelProperties();
        URL puPropsURL = new URL(root, puPath + "/META-INF/spring/pu.properties");
        try {
            InputStream is2 = puPropsURL.openStream();
            if (is2 != null) {
                beanLevelProperties.getContextProperties().load(is2);
                is2.close();
            }
        }
        catch (Exception is2) {
            // empty catch block
        }
        puPropsURL = new URL(root, puPath + "/pu.properties");
        try {
            InputStream is3 = puPropsURL.openStream();
            if (is3 != null) {
                beanLevelProperties.getContextProperties().load(is3);
                is3.close();
            }
        }
        catch (Exception is3) {
            // empty catch block
        }
        beanLevelProperties = BeanLevelPropertiesParser.parse((BeanLevelProperties)beanLevelProperties, (CommandLineParser.Parameter[])params);
        String puString = "";
        try {
            puString = Deploy.readFile(root, puPath, "/META-INF/spring/pu.xml");
        }
        catch (IOException e) {
            logger.debug((Object)("Failed to find puPath " + puPath), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using PU xml [" + puString + "]"));
        }
        boolean slaInPu = true;
        String slaString = puString;
        for (CommandLineParser.Parameter param : params) {
            if (!param.getName().equalsIgnoreCase(KEY_SLA)) continue;
            String slaLocation = param.getArguments()[0];
            Deploy.info("Loading SLA from [" + slaLocation + "]");
            Resource resource = new DefaultResourceLoader(){

                protected Resource getResourceByPath(String path) {
                    return new FileSystemResource(path);
                }
            }.getResource(slaLocation);
            InputStreamReader reader = new InputStreamReader(resource.getInputStream());
            slaString = FileCopyUtils.copyToString((Reader)reader);
            reader.close();
            slaInPu = false;
        }
        if (slaString == puString) {
            try {
                slaString = Deploy.readFile(root, puPath, "/META-INF/spring/sla.xml");
                slaInPu = false;
            }
            catch (IOException iOException) {
                try {
                    slaString = Deploy.readFile(root, puPath, "/sla.xml");
                    slaInPu = false;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        if (slaInPu && !slaString.isEmpty()) {
            slaString = this.extractSlaFromPu(slaString);
        }
        SLA sLA = new SLA();
        if (StringUtils.hasText((String)slaString)) {
            ByteArrayResource resource = new ByteArrayResource(slaString.getBytes());
            if (slaInPu) {
                XmlBeanFactory xmlBeanFactory = new XmlBeanFactory((Resource)resource);
                try {
                    SLA sLA2 = (SLA)xmlBeanFactory.getBean("SLA");
                }
                catch (NoSuchBeanDefinitionException e) {
                    Deploy.info("SLA Not Found in PU.  Using Default SLA.");
                    SLA sLA3 = new SLA();
                }
            } else {
                ProcessingUnitContainerConfig config = new ProcessingUnitContainerConfig();
                config.setBeanLevelProperties(beanLevelProperties);
                applicationContext.refresh();
                try (ResourceApplicationContext applicationContext = new ResourceApplicationContext(new Resource[]{resource}, null, config);){
                    SLA sLA4 = (SLA)applicationContext.getBean("SLA");
                }
            }
        }
        if ((clusterInfo = ClusterInfoParser.parse((CommandLineParser.Parameter[])params)) != null) {
            if (clusterInfo.getSchema() != null && clusterInfo.getSchema().length() > 0) {
                Deploy.info("Overriding SLA cluster schema with [" + clusterInfo.getSchema() + "]");
                var19_39.setClusterSchema(clusterInfo.getSchema());
            }
            if (clusterInfo.getNumberOfInstances() != null) {
                Deploy.info("Overriding SLA numberOfInstances with [" + clusterInfo.getNumberOfInstances() + "]");
                var19_39.setNumberOfInstances(clusterInfo.getNumberOfInstances());
                if (clusterInfo.getNumberOfBackups() == null) {
                    Deploy.info("Overriding SLA numberOfBackups with [" + clusterInfo.getNumberOfBackups() + "]");
                    var19_39.setNumberOfBackups(0);
                } else {
                    Deploy.info("Overriding SLA numberOfBackups with [" + clusterInfo.getNumberOfBackups() + "]");
                    var19_39.setNumberOfBackups(clusterInfo.getNumberOfBackups());
                }
            }
        }
        for (CommandLineParser.Parameter param : params) {
            if (param.getName().equalsIgnoreCase(KEY_REQUIRES_ISOLATION)) {
                String requiresIsolation = param.getArguments()[0];
                var19_39.setRequiresIsolation(Boolean.parseBoolean(requiresIsolation));
                Deploy.info("Overriding SLA requiresIsolation with [" + requiresIsolation + "]");
            }
            if (param.getName().equalsIgnoreCase(KEY_MAX_INSTANCES_PER_VM)) {
                String maxInstancePerVm = param.getArguments()[0];
                var19_39.setMaxInstancesPerVM(Integer.valueOf(maxInstancePerVm));
                Deploy.info("Overriding SLA maxInstancesPerVM with [" + maxInstancePerVm + "]");
            }
            if (param.getName().equalsIgnoreCase(KEY_MAX_INSTANCES_PER_MACHINE)) {
                String maxInstancePerMachine = param.getArguments()[0];
                var19_39.setMaxInstancesPerMachine(Integer.valueOf(maxInstancePerMachine));
                Deploy.info("Overriding SLA maxInstancesPerMachine with [" + maxInstancePerMachine + "]");
            }
            if (param.getName().equalsIgnoreCase(KEY_MAX_INSTANCES_PER_ZONE)) {
                String[] map = new HashMap();
                String[] stringArray = param.getArguments();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String arg = stringArray[i];
                    map.putAll(ZoneHelper.parse((String)arg));
                }
                var19_39.setMaxInstancesPerZone((Map<String, Integer>)map);
                Deploy.info("Overriding SLA maxInstancesPerZone with [" + ZoneHelper.unparse((Map)map) + "]");
            }
            if (param.getName().equalsIgnoreCase(KEY_ZONES)) {
                for (String arg : param.getArguments()) {
                    var19_39.getRequirements().add(new ZoneRequirement(arg));
                    Deploy.info("Adding SLA required zone with [" + arg + "]");
                }
            }
            if (!param.getName().equalsIgnoreCase(KEY_PRIMARY_ZONE)) continue;
            String primaryZone = param.getArguments()[0];
            var19_39.setPrimaryZone(primaryZone);
            Deploy.info("Overriding SLA primaryZone with [" + primaryZone + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using SLA " + var19_39));
        }
        this.processSecurityParameters(beanLevelProperties, params);
        HashMap<String, String> elasticProperties = new HashMap<String, String>();
        for (CommandLineParser.Parameter param : params) {
            if (!param.getName().equalsIgnoreCase(KEY_ELASTIC_PROPERTIES)) continue;
            for (String argument : param.getArguments()) {
                int indexOfEqual = argument.indexOf("=");
                String name = argument.substring(0, indexOfEqual);
                String value = argument.substring(indexOfEqual + 1);
                elasticProperties.put(name, value);
            }
        }
        String puType = this.guessProcessingUnitType(puPath, puFile, root, puString, (SLA)var19_39, beanLevelProperties);
        beanLevelProperties.getContextProperties().put("pu.type", puType);
        return this.loadDeployment(puString, codeserver, (SLA)var19_39, puPath, overridePuName, beanLevelProperties, elasticProperties, instanceDeploymentDependencies, instanceStartDependencies, this.applicationName, fullArchiveName);
    }

    private static String download(URL url) throws PUZipUtils.DownloadProcessingUnitException {
        String path = url.getPath();
        String name = path.substring(path.lastIndexOf(47) + 1);
        File target = new File(SystemInfo.singleton().locations().work(), name);
        logger.info((Object)("Downloading processing unit from [" + url + "] to [" + target + "]"));
        PUZipUtils.downloadProcessingUnit((URL)url, (File)target, (String)name);
        return target.getAbsolutePath();
    }

    private static boolean isRemoteUrl(String path) {
        return path.startsWith("http:") || path.startsWith("https:");
    }

    private String fetchFullArchiveName(File puFile) {
        return puFile.getName().replace(' ', '_');
    }

    protected String extractSlaFromPu(String puString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Document doc = XmlUtils.getDocumentBuilder((boolean)false).parse(new ByteArrayInputStream(puString.getBytes()));
        Element documentElement = doc.getDocumentElement();
        documentElement.normalize();
        Node beans = doc.getFirstChild();
        String nodeName = beans.getNodeName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> beans.getNodeName()=" + nodeName));
        }
        if (!nodeName.equals("beans") && !nodeName.equals("spring:beans")) {
            throw new IllegalStateException("Context xml must contain beans element");
        }
        Document slaDocument = XmlUtils.getDocumentBuilder().newDocument();
        Node beansNew = slaDocument.importNode(beans, false);
        slaDocument.appendChild(beansNew);
        NodeList nl = documentElement.getElementsByTagName("os-sla:sla");
        if (nl.getLength() > 0) {
            Node newNode = slaDocument.importNode(nl.item(0), true);
            beansNew.appendChild(newNode);
        }
        return XmlUtils.nodeToString((Node)slaDocument.getDocumentElement().getParentNode());
    }

    private static void copyPu(String puPath, File puFile, String deployPath) throws Exception {
        PUZipUtils.unzip((File)new File(puFile.getAbsolutePath()), (File)new File(deployPath, puPath));
    }

    private boolean isOnGsmHost() throws UnknownHostException, RemoteException {
        InetAddress localHost = SystemInfo.singleton().network().getHost();
        InetAddress gsmHostByName = null;
        InetAddress gsmHostByAddress = null;
        if (SystemInfo.singleton().network().isPublicHostConfigured()) {
            String hostName = this.gsm.getOSDetails().getHostName();
            String hostAddress = this.gsm.getOSDetails().getHostAddress();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("local host: " + localHost + " GSM host: " + hostName + "/" + hostAddress));
            }
            return localHost.getHostName().equals(hostName) && localHost.getHostAddress().equals(hostAddress);
        }
        try {
            gsmHostByName = InetAddress.getByName(this.gsm.getOSDetails().getHostName());
        }
        catch (UnknownHostException e1) {
            try {
                gsmHostByAddress = InetAddress.getByName(this.gsm.getOSDetails().getHostAddress());
            }
            catch (UnknownHostException e2) {
                throw new UnknownHostException("failed to resolve host by name (" + this.gsm.getOSDetails().getHostName() + ")  - caused by " + e1 + "; failed to resolve host by address (" + this.gsm.getOSDetails().getHostAddress() + ") - caused by " + e2.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("local host: " + localHost + " GSM host-by-name: " + gsmHostByName + " host-by-address: " + gsmHostByAddress));
        }
        return localHost.equals(gsmHostByName) || localHost.equals(gsmHostByAddress);
    }

    private void processSecurityParameters(BeanLevelProperties beanLevelProperties, CommandLineParser.Parameter[] params) throws IOException {
        String userName = null;
        String password = null;
        for (CommandLineParser.Parameter param : params) {
            if (param.getName().equals(KEY_USER)) {
                userName = param.getArguments()[0];
                continue;
            }
            if (param.getName().equals(KEY_PASSWORD)) {
                password = param.getArguments()[0];
                continue;
            }
            if (!param.getName().equals(KEY_SECURED)) continue;
            if (param.getArguments().length == 0) {
                this.setSecured(true);
                continue;
            }
            this.setSecured(Boolean.parseBoolean(param.getArguments()[0]));
        }
        if (userName != null && password != null) {
            this.setUserDetails(userName, password);
        }
        if (this.userDetails == null) {
            userName = (String)beanLevelProperties.getContextProperties().remove("security.username");
            password = (String)beanLevelProperties.getContextProperties().remove("security.password");
            if (userName != null && password != null) {
                this.setUserDetails(userName, password);
            }
        }
        if (this.userDetails != null || this.credentialsProvider != null) {
            beanLevelProperties.getContextProperties().setProperty(KEY_SECURED, "true");
            CredentialsProviderHelper.appendMarshalledCredentials((Properties)beanLevelProperties.getContextProperties(), (UserDetails)this.userDetails, (CredentialsProvider)this.credentialsProvider);
        } else if (this.secured != null && this.secured.booleanValue()) {
            beanLevelProperties.getContextProperties().setProperty(KEY_SECURED, "true");
        }
    }

    private String guessProcessingUnitType(String puPath, File puFile, URL root, String puString, SLA sla, BeanLevelProperties beanLevelProperties) {
        if (this.containsWEB_INF(puPath, root)) {
            return ProcessingUnitType.WEB.name();
        }
        if (this.containsEXT(puPath, root)) {
            return ProcessingUnitType.UNIVERSAL.name();
        }
        if (sla.getClusterSchema() != null) {
            return ProcessingUnitType.STATEFUL.name();
        }
        String puStringWithoutComments = this.removeCommentsFromPuString(puString);
        if (puStringWithoutComments.contains("os-core:mirror") || puStringWithoutComments.contains("schema=\"mirror\"")) {
            return ProcessingUnitType.MIRROR.name();
        }
        if (puStringWithoutComments.contains("os-core:space")) {
            int endIndex;
            int beginIndex;
            if (puStringWithoutComments.contains("url=\"/./")) {
                return ProcessingUnitType.STATEFUL.name();
            }
            if (puStringWithoutComments.contains("url=\"${") && (beginIndex = puStringWithoutComments.indexOf("url=\"${") + 7) != -1 && (endIndex = puStringWithoutComments.indexOf("}", beginIndex)) != -1) {
                String propertyKey = puStringWithoutComments.substring(beginIndex, endIndex);
                if (beanLevelProperties.getContextProperties().getProperty(propertyKey, "").startsWith("/./")) {
                    return ProcessingUnitType.STATEFUL.name();
                }
            }
        }
        if (puStringWithoutComments.contains("os-core:embedded-space")) {
            return ProcessingUnitType.STATEFUL.name();
        }
        if (puStringWithoutComments.contains("os-gateway:sink") || puStringWithoutComments.contains("os-gateway:delegator")) {
            return ProcessingUnitType.GATEWAY.name();
        }
        if (puStringWithoutComments.length() == 0 && beanLevelProperties.getContextProperties().containsKey("dataGridName")) {
            return ProcessingUnitType.STATEFUL.name();
        }
        return ProcessingUnitType.STATELESS.name();
    }

    private boolean containsWEB_INF(String puPath, URL root) {
        boolean containsWebInf = false;
        try {
            URL webInfURL = new URL(root, puPath + "/WEB-INF");
            InputStream is = webInfURL.openStream();
            if (is != null) {
                containsWebInf = true;
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containsWebInf;
    }

    private boolean containsEXT(String puPath, URL root) {
        boolean containsExt = false;
        try {
            URL extURL = new URL(root, puPath + "/ext");
            InputStream is = extURL.openStream();
            if (is != null) {
                containsExt = true;
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containsExt;
    }

    private String removeCommentsFromPuString(String puString) {
        if (puString.length() == 0) {
            return puString;
        }
        String openComment = "<!--";
        String closeComment = "-->";
        String parsedString = puString;
        String newString = "";
        while (true) {
            int startCommentIdx = parsedString.indexOf("<!--");
            int endCommentIdx = parsedString.indexOf("-->", startCommentIdx);
            if (startCommentIdx == -1 || endCommentIdx == -1) break;
            newString = newString.concat(parsedString.substring(0, startCommentIdx));
            parsedString = parsedString.substring(endCommentIdx + "-->".length());
        }
        newString = newString.concat(parsedString);
        return newString;
    }

    private String[] getSLAConfigArgs(String type, String max, long lowerDampener, long upperDampener) {
        String[] args;
        int handlerType;
        String handler = "org.jini.rio.qos.";
        if (type.equals("scaling")) {
            handler = handler + "ScalingPolicyHandler";
            handlerType = 1;
        } else if (type.equals("relocation")) {
            handler = handler + "RelocationPolicyHandler";
            handlerType = 2;
        } else {
            handler = handler + "SLAPolicyHandler";
            handlerType = 3;
        }
        String slaPolicyHandler = "org.jini.rio.qos.SLAPolicyHandler.slaPolicyHandler";
        switch (handlerType) {
            case 1: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)", handler + ".MaxServices=" + max, handler + ".LowerThresholdDampeningFactor=" + lowerDampener, handler + ".UpperThresholdDampeningFactor=" + upperDampener};
                break;
            }
            case 2: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)", handler + ".LowerThresholdDampeningFactor=" + lowerDampener, handler + ".UpperThresholdDampeningFactor=" + upperDampener};
                break;
            }
            default: {
                args = new String[]{"-", slaPolicyHandler + "=new " + handler + "((org.jini.rio.core.SLA)$data)"};
            }
        }
        return args;
    }

    protected static String readFile(URL root, String puPath, String filePath) throws IOException {
        String line;
        URL puURL = new URL(root, puPath + filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(puURL.openStream()));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append(LINE_SEPARATOR);
        }
        reader.close();
        return buffer.toString();
    }

    private String getCodebase(DeployAdmin deployAdmin) throws MalformedURLException, RemoteException {
        return deployAdmin.getDeployURL();
    }

    private OperationalString loadDeployment(String puString, String codeserver, SLA sla, String puPath, String puName, BeanLevelProperties beanLevelProperties, Map<String, String> elasticProperties, RequiredDependencies deploymentRequiredDependencies, RequiredDependencies startRequiredDependencies, String applicationName, String fullArchiveName) throws Exception {
        InputStream opstringURL = Deploy.class.getResourceAsStream("/org/openspaces/pu/container/servicegrid/puservicebean.xml");
        OpStringLoader opStringLoader = new OpStringLoader();
        opStringLoader.setDefaultGroups(this.getGroups());
        opStringLoader.setDefaultLookupLocators(this.getLocators());
        opStringLoader.setCodebaseOverride(codeserver);
        OperationalString opString = opStringLoader.parseOperationalString(opstringURL)[0];
        ((OpString)opString).setName(puName);
        ServiceElement[] serviceElements = opString.getServices();
        ServiceElement element = serviceElements[0];
        element.getServiceBeanConfig().addInitParameter((Object)"pu", (Object)puString);
        if (beanLevelProperties != null) {
            element.getServiceBeanConfig().addInitParameter((Object)"pu.type", beanLevelProperties.getContextProperties().remove("pu.type"));
            element.getServiceBeanConfig().addInitParameter((Object)"beanLevelProperties", new MarshalledObject<BeanLevelProperties>(beanLevelProperties));
            element.getServiceBeanConfig().addInitParameter((Object)"jee.container", (Object)JeeProcessingUnitContainerProvider.getJeeContainer((BeanLevelProperties)beanLevelProperties));
        }
        int numberOfInstances = sla.getNumberOfInstances();
        int numberOfBackups = sla.getNumberOfBackups();
        Policy policy = sla.getPolicy();
        if (policy != null) {
            String type;
            if (policy instanceof ScaleUpPolicy) {
                type = "scaling";
            } else if (policy instanceof RelocationPolicy) {
                type = "relocation";
            } else {
                throw new IllegalArgumentException("Unknown SLA Policy:" + policy);
            }
            String max = String.valueOf(sla.getNumberOfInstances());
            if (policy instanceof ScaleUpPolicy) {
                max = String.valueOf(((ScaleUpPolicy)policy).getMaxInstances());
                numberOfInstances = ((ScaleUpPolicy)policy).getMaxInstances();
            }
            String[] configParms = this.getSLAConfigArgs(type, max, policy.getLowerDampener(), policy.getUpperDampener());
            org.jini.rio.core.SLA slaElement = new org.jini.rio.core.SLA(policy.getMonitor(), new double[]{policy.getLow(), policy.getHigh()}, configParms, null);
            element.getServiceLevelAgreements().addServiceSLA(slaElement);
        }
        this.applyRequirements(element, sla.getRequirements());
        element.getFaultDetectionHandlerBundle().addMethod("setConfiguration", new Object[]{new String[]{"-", "org.openspaces.pu.container.servicegrid.PUFaultDetectionHandler.invocationDelay = " + sla.getMemberAliveIndicator().getInvocationDelay(), "org.openspaces.pu.container.servicegrid.PUFaultDetectionHandler.retryCount = " + sla.getMemberAliveIndicator().getRetryCount(), "org.openspaces.pu.container.servicegrid.PUFaultDetectionHandler.retryTimeout = " + sla.getMemberAliveIndicator().getRetryTimeout()}});
        if (sla.getMaxInstancesPerVM() > 0) {
            element.setMaxPerMachine(sla.getMaxInstancesPerVM());
        }
        if (sla.getMaxInstancesPerMachine() > 0) {
            element.setMaxPerPhysicalMachine(sla.getMaxInstancesPerMachine());
        }
        element.setRequiresIsolation(sla.isRequiresIsolation());
        element.setMaxPerZone(sla.getMaxInstancesPerZone());
        element.setElasticProperties(elasticProperties);
        element.setInstanceDeploymentDependencies(deploymentRequiredDependencies);
        element.setInstanceStartDependencies(startRequiredDependencies);
        element.setApplicationName(applicationName);
        element.setTotalNumberOfServices(sla.getNumberOfInstances());
        element.getServiceBeanConfig().setName(element.getOperationalStringName().replace(' ', '-'));
        element.getServiceBeanConfig().addInitParameter((Object)KEY_SLA, new MarshalledObject<SLA>(sla));
        element.getServiceBeanConfig().addInitParameter((Object)"numberOfInstances", (Object)numberOfInstances);
        element.getServiceBeanConfig().addInitParameter((Object)"numberOfBackups", (Object)numberOfBackups);
        element.getServiceBeanConfig().addInitParameter((Object)"puName", (Object)puName);
        element.getServiceBeanConfig().addInitParameter((Object)"fullArchiveName", (Object)fullArchiveName);
        element.getServiceBeanConfig().addInitParameter((Object)"puPath", (Object)puPath);
        element.getServiceBeanConfig().addInitParameter((Object)"primaryZone", (Object)sla.getPrimaryZone());
        if (sla.getInstanceSLAs() != null && sla.getInstanceSLAs().size() > 0) {
            element.setPlanned(1);
            String name = element.getName();
            opString.removeService(element);
            for (int instanceId = 1; instanceId <= sla.getNumberOfInstances(); ++instanceId) {
                ServiceElement clone = this.deepCopy(element);
                clone.getServiceBeanConfig().setName(name + "." + instanceId);
                clone.getServiceBeanConfig().addInitParameter((Object)"clusterGroup", (Object)String.valueOf(instanceId));
                clone.getServiceBeanConfig().addInitParameter((Object)"instanceId", (Object)String.valueOf(instanceId));
                InstanceSLA instanceSLA = this.findInstanceSLA(instanceId, null, sla.getInstanceSLAs());
                if (instanceSLA != null) {
                    this.applyRequirements(clone, instanceSLA.getRequirements());
                }
                opString.addService(clone);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Using Service Element " + element.toString()));
                }
                for (int backupId = 1; backupId <= sla.getNumberOfBackups(); ++backupId) {
                    clone = this.deepCopy(element);
                    clone.getServiceBeanConfig().setName(name + "." + instanceId + "_" + backupId);
                    clone.getServiceBeanConfig().addInitParameter((Object)"clusterGroup", (Object)String.valueOf(instanceId));
                    clone.getServiceBeanConfig().addInitParameter((Object)"instanceId", (Object)String.valueOf(instanceId));
                    clone.getServiceBeanConfig().addInitParameter((Object)"backupId", (Object)String.valueOf(backupId));
                    instanceSLA = this.findInstanceSLA(instanceId, backupId, sla.getInstanceSLAs());
                    if (instanceSLA != null) {
                        this.applyRequirements(clone, instanceSLA.getRequirements());
                    }
                    opString.addService(clone);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Using Service Element " + element.toString()));
                }
            }
        } else {
            boolean hasBackups;
            boolean bl = hasBackups = sla.getNumberOfBackups() > 0;
            if (hasBackups) {
                element.setPlanned(sla.getNumberOfBackups() + 1);
                String name = element.getName();
                opString.removeService(element);
                for (int i = 1; i <= sla.getNumberOfInstances(); ++i) {
                    ServiceElement clone = this.deepCopy(element);
                    clone.getServiceBeanConfig().setName(name + "." + i);
                    clone.getServiceBeanConfig().addInitParameter((Object)"clusterGroup", (Object)String.valueOf(i));
                    opString.addService(clone);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Using Service Element " + element.toString()));
                }
            } else {
                element.setPlanned(sla.getNumberOfInstances());
                element.getServiceBeanConfig().addInitParameter((Object)"clusterGroup", (Object)String.valueOf(1));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Using Service Element " + element.toString()));
                }
            }
        }
        return opString;
    }

    private InstanceSLA findInstanceSLA(Integer instanceId, Integer backupId, List<InstanceSLA> instanceSLAs) {
        for (InstanceSLA instanceSLA : instanceSLAs) {
            if (!instanceId.equals(instanceSLA.getInstanceId())) continue;
            if (backupId != null) {
                if (!backupId.equals(instanceSLA.getBackupId())) continue;
                return instanceSLA;
            }
            return instanceSLA;
        }
        return null;
    }

    private void applyRequirements(ServiceElement element, List<Requirement> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            return;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        for (Requirement requirement : requirements) {
            if (requirement instanceof RangeRequirement) {
                RangeRequirement range = (RangeRequirement)requirement;
                ThresholdValues thresholdValues = new ThresholdValues(range.getLow(), range.getHigh());
                element.getServiceLevelAgreements().addSystemThreshold(range.getWatch(), thresholdValues);
                continue;
            }
            if (requirement instanceof HostRequirement) {
                hosts.add(((HostRequirement)requirement).getIp());
                continue;
            }
            if (requirement instanceof ZoneRequirement) {
                element.addRequiredZone(((ZoneRequirement)requirement).getZone());
                continue;
            }
            if (!(requirement instanceof SystemRequirement)) continue;
            SystemRequirement systemAttributes = (SystemRequirement)requirement;
            ServiceLevelAgreements.SystemRequirement systemRequirement = new ServiceLevelAgreements.SystemRequirement(systemAttributes.getName(), null, systemAttributes.getAttributes());
            element.getServiceLevelAgreements().addSystemRequirement(systemRequirement);
        }
        if (hosts.size() > 0) {
            element.setCluster(hosts.toArray(new String[hosts.size()]));
        }
    }

    private void uploadPU(String puPath, File puFile) throws IOException {
        String line;
        if (puFile.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File " + puFile.getPath() + " is too big: " + puFile.length() + " bytes");
        }
        byte[] buffer = new byte[4098];
        String codebase = this.getCodebase(this.deployAdmin);
        Deploy.info("Uploading [" + puPath + "] [" + puFile.getPath() + "] to [" + codebase + "]");
        HttpURLConnection conn = (HttpURLConnection)new URL(codebase + puFile.getName()).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Extract", "true");
        conn.setFixedLengthStreamingMode((int)puFile.length());
        conn.connect();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(puFile));
        int byteCount = 0;
        int bytesRead = -1;
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
        int responseCode = conn.getResponseCode();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        reader.close();
        conn.disconnect();
        if (responseCode != 200 && responseCode != 201) {
            throw new RuntimeException("Failed to upload file, response code [" + responseCode + "], response: " + sb.toString());
        }
    }

    private ServiceElement deepCopy(ServiceElement element) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(element);
        byte[] writtenBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(writtenBytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object readObject = objectInputStream.readObject();
        return (ServiceElement)readObject;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println(Deploy.getUsage());
            return;
        }
        GSLogConfigLoader.getLoader();
        Deploy deployer = new Deploy();
        deployer.deployAndWait(args);
    }

    public static String getUsage() {
        return Deploy.getUsage(false);
    }

    public static String getUsage(boolean managed) {
        StringBuilder sb = new StringBuilder();
        if (!managed) {
            sb.append("Usage: Deploy [-sla ...] [-cluster ...] [-groups groups] [-locators hots1 hots2] [-timeout timeoutValue] [-properties ...] [-user xxx -password yyy] [-secured true/false] PU_Name");
        } else {
            sb.append("Usage: deploy [-sla ...] [-cluster ...] [-properties ...] [-user xxx -password yyy] [-secured true/false] PU_Name");
        }
        sb.append("\n    PU_Name: The name of the processing unit under the deploy directory, or packaged jar file");
        sb.append("\n    -sla [sla-location]                      : Location of an optional xml file holding the SLA element");
        sb.append("\n    -cluster [cluster properties]            : Allows to override the cluster parameters of the SLA elements");
        sb.append("\n             schema=partitioned              : The cluster schema to override");
        sb.append("\n             total_members=1,1               : The number of instances and number of backups to override");
        if (!managed) {
            sb.append("\n    -groups [groupName] [groupName] ...      : The lookup groups used to look up the GSM");
            sb.append("\n    -locators [host1] [host2] ...            : The lookup locators used to look up the GSM");
            sb.append("\n    -timeout [timeout value]                 : The timeout value of GSM lookup (defaults to 5000) in milliseconds");
        }
        sb.append("\n    -user xxx -password yyyy                 : Deploys a secured processing unit propagated with the supplied user and password");
        sb.append("\n    -secured true                            : Deploys a secured processing unit (implicit when using -user/-password)");
        sb.append("\n    -properties [properties-loc]             : Location of context level properties");
        sb.append("\n    -properties [bean-name] [properties-loc] : Location of properties used applied only for a specified bean");
        sb.append("\n    -override-name [override pu name]        : An override pu name, useful when using pu as a template");
        sb.append("\n    -requires-isolation [true/false]           : Allows to set the SLA requires isolation");
        sb.append("\n    -max-instances-per-vm [number]           : Allows to set the SLA number of instances per VM");
        sb.append("\n    -max-instances-per-machine [number]      : Allows to set the SLA number of instances per machine");
        sb.append("\n    -max-instances-per-zone [zone/number,...]: Allows to set the SLA number of instances per zone");
        sb.append("\n    -zones [zoneName] [zoneName] ...         : Allows to set the SLA zone requirements");
        sb.append("\n    -deploy-timeout [timeout value in ms]    : Timeout for deploy operation, otherwise blocks until all successful/failed deployment events arrive (default)");
        sb.append("\n");
        sb.append("\n");
        sb.append("\nSome Examples:");
        sb.append("\n1. Deploy data-processor");
        sb.append("\n    - Deploys a processing unit called data-processor");
        sb.append("\n2. Deploy -sla file://config/sla.xml data-processor");
        sb.append("\n    - Deploys a processing unit called data-processor using an SLA element read from sla.xml");
        sb.append("\n3. Deploy -properties file://config/context.properties -properties space1 file://config/space1.properties data-processor");
        sb.append("\n    - Deploys a processing unit called data-processor using context level properties called context.properties and bean level properties called space1.properties applied to bean named space1");
        sb.append("\n4. Deploy -properties embed://prop1=value1 -properties space1 embed://prop2=value2;prop3=value3 data-processor");
        sb.append("\n    - Deploys a processing unit called data-processor using context level properties with a single property called prop1 with value1 and bean level properties with two properties");
        return sb.toString();
    }

    private static void info(String message) {
        if (disableInfoLogging) {
            return;
        }
        if (sout) {
            System.out.println(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)message);
        }
    }

    private static int sumUpServices(OperationalString deployment) {
        int summation = 0;
        ServiceElement[] elems = deployment.getServices();
        for (int i = 0; i < elems.length; ++i) {
            ServiceElement element = elems[i];
            summation += element.getPlanned();
        }
        OperationalString[] nested = deployment.getNestedOperationalStrings();
        for (int i = 0; i < nested.length; ++i) {
            summation += Deploy.sumUpServices(nested[i]);
        }
        return summation;
    }

    static {
        TLSUtils.enableHttpsClient();
        LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    }

    private static class DeployListener
    implements ServiceProvisionListener {
        private final AtomicInteger totalEvents = new AtomicInteger();

        private DeployListener() {
        }

        public void succeeded(ServiceBeanInstance jsbInstance) throws RemoteException {
            Deploy.info("[" + jsbInstance.getServiceBeanConfig().getName() + "] [" + jsbInstance.getServiceBeanConfig().getInstanceID() + "] deployed successfully on [" + jsbInstance.getHostAddress() + "]");
            this.totalEvents.incrementAndGet();
        }

        public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
            Deploy.info("[" + sElem.getName() + "] [" + sElem.getServiceBeanConfig().getInstanceID() + "] failed to deploy, resubmitted [" + resubmitted + "]");
            this.totalEvents.incrementAndGet();
        }

        public int getTotalEvents() {
            return this.totalEvents.intValue();
        }
    }
}

