/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid.deploy;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPFileSystemView {
    private static final Log logger = LogFactory.getLog(HTTPFileSystemView.class);
    private File lastDir;
    private File[] lastResults;
    private URL root;

    public HTTPFileSystemView(URL root) {
        this.root = root;
    }

    public File createFileObject(String path) {
        return new File(path);
    }

    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    public File[] getFiles(File dir) {
        if (this.lastDir != null && this.lastDir.equals(dir)) {
            return this.lastResults;
        }
        File[] files = new File[]{};
        try {
            String line;
            ArrayList<HTTPFile> filesList = new ArrayList<HTTPFile>();
            URL url = new URL(this.root, dir.getPath().replace('\\', '/'));
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String name = tokenizer.nextToken();
                String type = tokenizer.nextToken();
                String size = tokenizer.nextToken();
                long time = Long.parseLong(tokenizer.nextToken());
                HTTPFile add = new HTTPFile(dir, name, time, type.equals("d"));
                filesList.add(add);
            }
            reader.close();
            files = filesList.toArray(new File[filesList.size()]);
        }
        catch (Exception e) {
            logger.debug((Object)("Error getting file list:" + e.toString()));
        }
        this.lastDir = dir;
        this.lastResults = files;
        return files;
    }

    public boolean isHiddenFile(File f) {
        return false;
    }

    public File[] getRoots() {
        return new File[]{new File("/")};
    }

    public File getHomeDirectory() {
        return this.getRoots()[0];
    }

    public boolean isRoot(File f) {
        return f.equals(this.getRoots()[0]);
    }

    static class HTTPFile
    extends File {
        private static final long serialVersionUID = -3743494534964914431L;
        private long time;
        private boolean dir;

        public HTTPFile(File parent, String pathname, long time, boolean isDir) {
            super(parent, pathname);
            this.time = time;
            this.dir = isDir;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return this.dir;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public boolean isFile() {
            return !this.dir;
        }

        @Override
        public long lastModified() {
            return this.time;
        }
    }
}

