/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.servicegrid.deploy;

import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.start.SystemInfo;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.core.OperationalStringManager;
import org.openspaces.pu.container.servicegrid.deploy.GSMNotFoundException;
import org.openspaces.pu.container.servicegrid.deploy.ProcessingUnitNotFoundException;
import org.openspaces.pu.container.servicegrid.deploy.ServiceFinder;
import org.openspaces.pu.container.support.CommandLineParser;

public class Undeploy {
    private static final Log logger = LogFactory.getLog(Undeploy.class);
    private String[] groups;
    private LookupLocator[] locators;
    private int lookupTimeout = 5000;

    public GSM[] findGSMs() {
        GSM[] gsms;
        logger.info((Object)("Searching for GSMs  in groups " + Arrays.toString(this.getGroups()) + " and locators " + Arrays.toString(this.getLocators())));
        ServiceItem[] result = ServiceFinder.find(null, GSM.class, this.lookupTimeout, this.getGroups(), this.getLocators());
        if (result != null && result.length > 0) {
            gsms = new GSM[result.length];
            for (int i = 0; i < result.length; ++i) {
                gsms[i] = (GSM)result[i].service;
            }
        } else {
            gsms = new GSM[]{};
        }
        return gsms;
    }

    public String[] getGroups() {
        if (this.groups == null) {
            String groupsProperty = SystemInfo.singleton().lookup().groups();
            if (groupsProperty != null) {
                StringTokenizer tokenizer = new StringTokenizer(groupsProperty);
                int count = tokenizer.countTokens();
                this.groups = new String[count];
                for (int i = 0; i < count; ++i) {
                    this.groups[i] = tokenizer.nextToken();
                }
            } else {
                this.groups = new String[]{SystemInfo.singleton().lookup().defaultGroups()};
            }
        }
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public LookupLocator[] getLocators() {
        String locatorsProperty;
        if (this.locators == null && (locatorsProperty = SystemInfo.singleton().lookup().locators()) != null) {
            this.locators = BootUtil.toLookupLocators((String)locatorsProperty);
        }
        return this.locators;
    }

    public void setLocators(String locators) {
        this.locators = BootUtil.toLookupLocators((String)locators);
    }

    public void setLookupTimeout(int lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void undeploy(String[] args) throws Exception {
        CommandLineParser.Parameter[] params;
        if (args.length == 0) {
            throw new IllegalArgumentException("The pu name must be defined");
        }
        String puPath = args[args.length - 1];
        int index = puPath.lastIndexOf(47);
        index = index == -1 ? 0 : index;
        String puName = puPath.substring(index);
        for (CommandLineParser.Parameter param : params = CommandLineParser.parse((String[])args, (int)(args.length - 1))) {
            if (param.getName().equalsIgnoreCase("groups")) {
                this.setGroups(param.getArguments());
            }
            if (param.getName().equalsIgnoreCase("locators")) {
                StringBuilder sb = new StringBuilder();
                for (String arg : param.getArguments()) {
                    sb.append(arg).append(',');
                }
                this.setLocators(sb.toString());
            }
            if (!param.getName().equalsIgnoreCase("timeout")) continue;
            this.setLookupTimeout(Integer.valueOf(param.getArguments()[0]));
        }
        GSM[] gsms = this.findGSMs();
        if (gsms == null || gsms.length == 0) {
            throw new GSMNotFoundException(this.getGroups(), this.lookupTimeout);
        }
        OperationalStringManager operationalStringManager = Undeploy.findDeployAdmin(gsms, puName);
        if (operationalStringManager == null) throw new ProcessingUnitNotFoundException(puName, gsms[0]);
        try {
            operationalStringManager.undeploy();
            return;
        }
        catch (ConnectException e) {
            if (e.getCause() instanceof ClosedChannelException) return;
            throw e;
        }
    }

    static OperationalStringManager findDeployAdmin(GSM[] items, String opstringName) {
        if (items.length > 0) {
            try {
                return items[0].getPrimary(opstringName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        Undeploy undeploy = new Undeploy();
        undeploy.undeploy(args);
    }
}

