/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.support;

import com.gigaspaces.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.core.RequiredDependency;
import org.openspaces.pu.container.support.CommandLineParser;

public class RequiredDependenciesCommandLineParser {
    public static final String INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES_PARAMETER_NAME = "deployment-dependencies";
    public static final String INSTANCE_START_REQUIRED_DEPENDENCIES_PARAMETER_NAME = "start-dependencies";
    private static final String DEPENDENCY_KEYVALUE_SEPERATOR = "=";
    private static final String DEPENDENCY_PROPERTIES_SEPERATOR = ",";

    public static CommandLineParser.Parameter convertRequiredDependenciesToCommandLineParameter(String commandLineParameter, RequiredDependencies requiredDependencies) {
        ArrayList<String> opStringArguments = new ArrayList<String>();
        for (String requiredDependencyName : requiredDependencies.getRequiredDependenciesNames()) {
            Map properties = requiredDependencies.getRequiredDependencyByName(requiredDependencyName).getProperties();
            Object[] keyValuePairs = StringUtils.convertKeyValuePairsToArray((Map)properties, (String)DEPENDENCY_KEYVALUE_SEPERATOR);
            String opStringArgument = StringUtils.arrayToDelimitedString((Object[])keyValuePairs, (String)DEPENDENCY_PROPERTIES_SEPERATOR);
            opStringArguments.add(opStringArgument);
        }
        return new CommandLineParser.Parameter(commandLineParameter, opStringArguments.toArray(new String[opStringArguments.size()]));
    }

    public static boolean isInstanceDeploymentDependencies(CommandLineParser.Parameter parameter) {
        return parameter.getName().equalsIgnoreCase(INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES_PARAMETER_NAME);
    }

    public static boolean isInstanceStartDependencies(CommandLineParser.Parameter parameter) {
        return parameter.getName().equalsIgnoreCase(INSTANCE_START_REQUIRED_DEPENDENCIES_PARAMETER_NAME);
    }

    public static RequiredDependencies convertCommandlineParameterToInstanceDeploymentDependencies(CommandLineParser.Parameter parameter) {
        if (!RequiredDependenciesCommandLineParser.isInstanceDeploymentDependencies(parameter)) {
            throw new IllegalArgumentException("Parameter is " + parameter.getName() + " instead of " + INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES_PARAMETER_NAME);
        }
        return RequiredDependenciesCommandLineParser.convertCommandlineParameterToRequiredDependencies(parameter);
    }

    public static RequiredDependencies convertCommandlineParameterToInstanceStartDependencies(CommandLineParser.Parameter parameter) {
        if (!RequiredDependenciesCommandLineParser.isInstanceStartDependencies(parameter)) {
            throw new IllegalArgumentException("Parameter is " + parameter.getName() + " instead of " + INSTANCE_START_REQUIRED_DEPENDENCIES_PARAMETER_NAME);
        }
        return RequiredDependenciesCommandLineParser.convertCommandlineParameterToRequiredDependencies(parameter);
    }

    private static RequiredDependencies convertCommandlineParameterToRequiredDependencies(CommandLineParser.Parameter parameter) {
        RequiredDependencies requiredDependencies = new RequiredDependencies();
        for (String opStringArgument : parameter.getArguments()) {
            String[] keyValueParis = StringUtils.delimitedListToStringArray((String)opStringArgument, (String)DEPENDENCY_PROPERTIES_SEPERATOR);
            Map properties = StringUtils.convertArrayToKeyValuePairs((String[])keyValueParis, (String)DEPENDENCY_KEYVALUE_SEPERATOR);
            requiredDependencies.addRequiredDependency(new RequiredDependency(properties));
        }
        return requiredDependencies;
    }
}

