/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.sla;

import com.gigaspaces.grid.zone.ZoneHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.ProcessingUnitPartition;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.space.SecurityConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PrimaryZoneController
implements InitializingBean,
DisposableBean,
ClusterInfoAware {
    private static Logger logger = Logger.getLogger(PrimaryZoneController.class.getName());
    private String primaryZone;
    private String puName;
    private Admin admin = null;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> handle;
    private int delayBetweenChecks = 60;
    private ClusterInfo clusterInfo;
    private SecurityConfig securityConfig;

    public void afterPropertiesSet() throws Exception {
        if (this.clusterInfo == null) {
            throw new IllegalStateException(PrimaryZoneController.class.getSimpleName() + " doesn't run on non-clustered pu.");
        }
        this.puName = this.clusterInfo.getName();
        AdminFactory a = new AdminFactory();
        if (this.securityConfig != null) {
            a.credentialsProvider(this.securityConfig.getCredentialsProvider());
        }
        this.admin = a.create();
        GridServiceManager gsm = this.admin.getGridServiceManagers().waitForAtLeastOne(30L, TimeUnit.SECONDS);
        if (gsm == null) {
            throw new IllegalStateException("Can't find GSM - Abort deploy");
        }
        RebalancingTask task = new RebalancingTask();
        this.scheduler = Executors.newScheduledThreadPool(1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Primary zone [" + this.primaryZone + " ] balancer for [" + this.puName + "] started.");
        }
        this.handle = this.scheduler.scheduleWithFixedDelay(task, 10L, this.delayBetweenChecks, TimeUnit.SECONDS);
    }

    private void rebalancePrimaryZoneIfNecessary() {
        ProcessingUnit pu = this.admin.getProcessingUnits().waitFor(this.puName, 30L, TimeUnit.SECONDS);
        if (pu == null) {
            logger.warning("PU [" + this.puName + "] is offline");
            return;
        }
        if (pu.getStatus() != DeploymentStatus.INTACT) {
            logger.fine("Waiting for pu [" + this.puName + "] to be deployed.");
            return;
        }
        ProcessingUnitPartition[] partitions = pu.getPartitions();
        Arrays.sort(partitions, new PUSorter());
        for (int i = 0; i < partitions.length; ++i) {
            ProcessingUnitInstance primary = partitions[i].getPrimary();
            if (primary == null) {
                logger.fine("Primary instace is not available for " + partitions[i].getProcessingUnit().getName());
                return;
            }
            Set<String> currentPrimaryZones = this.getZones(primary);
            ProcessingUnitInstance backup = partitions[i].getBackup();
            if (backup == null) {
                logger.fine("Backup instance is not available for " + partitions[i].getProcessingUnit().getName());
                return;
            }
            LinkedHashSet primaryZones = ZoneHelper.parseZones((String)this.primaryZone);
            Set<String> currentBackupZones = this.getZones(backup);
            if (this.containsAny(currentPrimaryZones, primaryZones) || !this.containsAny(currentBackupZones, primaryZones)) continue;
            logger.warning("Primary instance of PU " + primary.getProcessingUnitInstanceName() + " located on machine [" + primary.getMachine().getHostName() + ":" + primary.getMachine().getHostAddress() + "] is not running on primary zone [" + this.primaryZone + "]. It will be restarted.");
            primary.restartAndWait(60L, TimeUnit.SECONDS);
        }
    }

    private boolean containsAny(Set<String> containerZones, Set<String> primaryZones) {
        for (String primaryZone : primaryZones) {
            if (!containerZones.contains(primaryZone)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getZones(ProcessingUnitInstance puInstance) {
        if (puInstance.getGridServiceContainer() == null) {
            throw new IllegalStateException("GSC not available for pu instance " + puInstance.getProcessingUnitInstanceName());
        }
        Set<String> currentPrimaryZones = puInstance.getGridServiceContainer().getExactZones().getZones();
        return currentPrimaryZones;
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    public void destroy() {
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.scheduler != null) {
            this.handle.cancel(true);
            this.scheduler.shutdown();
        }
    }

    public int getDelayBetweenChecks() {
        return this.delayBetweenChecks;
    }

    public void setDelayBetweenChecks(int delayBetweenChecks) {
        this.delayBetweenChecks = delayBetweenChecks;
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    class RebalancingTask
    implements Runnable {
        RebalancingTask() {
        }

        @Override
        public void run() {
            try {
                if ((long)PrimaryZoneController.this.clusterInfo.getInstanceId().intValue() == 1L && PrimaryZoneController.this.clusterInfo.getBackupId() == null) {
                    logger.finest("Checking primary-zone [" + PrimaryZoneController.this.primaryZone + "] sla.");
                    PrimaryZoneController.this.rebalancePrimaryZoneIfNecessary();
                }
            }
            catch (IllegalStateException ise) {
                logger.warning(ise.getMessage());
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to rebalance primary zone [" + PrimaryZoneController.this.primaryZone + "] for pu [" + PrimaryZoneController.this.puName + "]", e);
            }
        }
    }

    class PUSorter
    implements Comparator<ProcessingUnitPartition> {
        PUSorter() {
        }

        @Override
        public int compare(ProcessingUnitPartition o1, ProcessingUnitPartition o2) {
            int o1Count = o1.getPartitionId();
            int o2Count = o2.getPartitionId();
            return o1Count - o2Count;
        }
    }
}

