/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.sla;

import com.gigaspaces.grid.zone.ZoneHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openspaces.pu.sla.InstanceSLA;
import org.openspaces.pu.sla.MemberAliveIndicator;
import org.openspaces.pu.sla.Policy;
import org.openspaces.pu.sla.monitor.Monitor;
import org.openspaces.pu.sla.requirement.Requirement;
import org.openspaces.pu.sla.requirement.ZoneRequirement;
import org.springframework.beans.factory.InitializingBean;

public class SLA
implements Serializable,
InitializingBean {
    private static final long serialVersionUID = -7596100914791517899L;
    private static final Map<String, Integer> EMPTY_MAP = new HashMap<String, Integer>();
    private int numberOfInstances = 1;
    private int numberOfBackups = 0;
    private String clusterSchema;
    private Policy policy;
    private transient String primaryZone;
    private List<Requirement> requirements = new ArrayList<Requirement>();
    private List<Monitor> monitors;
    private int maxInstancesPerVM;
    private int maxInstancesPerMachine;
    private boolean requiresIsolation;
    private Map<String, Integer> maxInstancesPerZone = EMPTY_MAP;
    private List<InstanceSLA> instanceSLAs;
    private MemberAliveIndicator memberAliveIndicator = new MemberAliveIndicator();

    public String getClusterSchema() {
        return this.clusterSchema;
    }

    public void setClusterSchema(String clusterSchema) {
        this.clusterSchema = clusterSchema;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public int getNumberOfBackups() {
        return this.numberOfBackups;
    }

    public void setNumberOfBackups(int numberOfBackups) {
        this.numberOfBackups = numberOfBackups;
    }

    public int getMaxInstancesPerVM() {
        return this.maxInstancesPerVM;
    }

    public void setMaxInstancesPerVM(int maxInstancesPerVM) {
        this.maxInstancesPerVM = maxInstancesPerVM;
    }

    public int getMaxInstancesPerMachine() {
        return this.maxInstancesPerMachine;
    }

    public void setMaxInstancesPerMachine(int maxInstancesPerMachine) {
        this.maxInstancesPerMachine = maxInstancesPerMachine;
    }

    public Map<String, Integer> getMaxInstancesPerZone() {
        return this.maxInstancesPerZone;
    }

    public void setMaxInstancesPerZone(Map<String, Integer> maxInstancesPerZone) {
        this.maxInstancesPerZone = maxInstancesPerZone;
    }

    public void setMaxInstancesPerZoneAsString(String maxInstancesPerZone) {
        this.maxInstancesPerZone = ZoneHelper.parse((String)maxInstancesPerZone);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    public boolean isRequiresIsolation() {
        return this.requiresIsolation;
    }

    public void setRequiresIsolation(boolean requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
    }

    public List<Monitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public List<InstanceSLA> getInstanceSLAs() {
        return this.instanceSLAs;
    }

    public void setInstanceSLAs(List<InstanceSLA> instanceSLAs) {
        this.instanceSLAs = instanceSLAs;
    }

    public MemberAliveIndicator getMemberAliveIndicator() {
        return this.memberAliveIndicator;
    }

    public void setMemberAliveIndicator(MemberAliveIndicator memberAliveIndicator) {
        this.memberAliveIndicator = memberAliveIndicator;
    }

    public String toString() {
        return "numberOfInstances [" + this.numberOfInstances + "] numberOfBackups [" + this.numberOfBackups + "] clusterSchema [" + this.clusterSchema + "] policy " + this.policy;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.primaryZone != null && !this.primaryZone.trim().isEmpty()) {
            LinkedHashSet primaryZones = ZoneHelper.parseZones((String)this.primaryZone);
            Object[] requiredZones = this.getRequiredZones();
            for (String primaryZone : primaryZones) {
                if (ZoneHelper.zoneExists((String)primaryZone, (String[])requiredZones)) continue;
                throw new IllegalArgumentException("Primary zone [" + primaryZone + "] doesn't exist. Defined zone are - " + Arrays.toString(requiredZones) + ".");
            }
            if (this.numberOfBackups > 1) {
                throw new IllegalArgumentException("Primary zone was set with number-of-backups=" + this.numberOfBackups + ", must be set to 1. ");
            }
            for (String primaryZone : primaryZones) {
                Integer maxInstancesPerPrimaryZone = this.maxInstancesPerZone.get(primaryZone);
                if (maxInstancesPerPrimaryZone == null) {
                    throw new IllegalArgumentException("Primary zone [" + primaryZone + "] max-instances-per-zone is not defined, must be set to 1.");
                }
                if (maxInstancesPerPrimaryZone <= 1) continue;
                throw new IllegalArgumentException("Primary zone [" + primaryZone + "] max-instances-per-zone=" + maxInstancesPerPrimaryZone + ", must be set to 1.");
            }
        }
    }

    private String[] getRequiredZones() {
        ArrayList<String> zones = new ArrayList<String>();
        for (Requirement req : this.requirements) {
            if (!(req instanceof ZoneRequirement)) continue;
            zones.add(((ZoneRequirement)req).getZone());
        }
        return zones.toArray(new String[zones.size()]);
    }
}

