/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.sla.config;

import java.util.List;
import org.openspaces.pu.sla.SLA;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SLABeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<SLA> getBeanClass(Element element) {
        return SLA.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "SLA";
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String primaryZone;
        String maxInstancesPerZone;
        String requiresIsolation;
        String maxInstancesPerMachine;
        String maxInstancesPerVm;
        String clusterSchema;
        String numberOfBackups;
        String numberOfInstances = element.getAttribute("number-of-instances");
        if (StringUtils.hasLength((String)numberOfInstances)) {
            builder.addPropertyValue("numberOfInstances", (Object)numberOfInstances);
        }
        if (StringUtils.hasLength((String)(numberOfBackups = element.getAttribute("number-of-backups")))) {
            builder.addPropertyValue("numberOfBackups", (Object)numberOfBackups);
        }
        if (StringUtils.hasLength((String)(clusterSchema = element.getAttribute("cluster-schema")))) {
            builder.addPropertyValue("clusterSchema", (Object)clusterSchema);
        }
        if (StringUtils.hasLength((String)(maxInstancesPerVm = element.getAttribute("max-instances-per-vm")))) {
            builder.addPropertyValue("maxInstancesPerVM", (Object)maxInstancesPerVm);
        }
        if (StringUtils.hasLength((String)(maxInstancesPerMachine = element.getAttribute("max-instances-per-machine")))) {
            builder.addPropertyValue("maxInstancesPerMachine", (Object)maxInstancesPerMachine);
        }
        if (StringUtils.hasLength((String)(requiresIsolation = element.getAttribute("requires-isolation")))) {
            builder.addPropertyValue("requiresIsolation", (Object)requiresIsolation);
        }
        if (StringUtils.hasLength((String)(maxInstancesPerZone = element.getAttribute("max-instances-per-zone")))) {
            builder.addPropertyValue("maxInstancesPerZoneAsString", (Object)maxInstancesPerZone);
        }
        if (StringUtils.hasLength((String)(primaryZone = element.getAttribute("primary-zone")))) {
            builder.addPropertyValue("primaryZone", (Object)primaryZone);
        }
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element instanceSLAsEle;
        Element requirementsEle;
        Element monitorsEle;
        Element memberAliveIndicatorEle;
        Element relocationPolicyEle;
        super.doParse(element, parserContext, builder);
        Element scaleUpPolicyEle = DomUtils.getChildElementByTagName((Element)element, (String)"scale-up-policy");
        if (scaleUpPolicyEle != null) {
            builder.addPropertyValue("policy", parserContext.getDelegate().parsePropertySubElement(scaleUpPolicyEle, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        if ((relocationPolicyEle = DomUtils.getChildElementByTagName((Element)element, (String)"relocation-policy")) != null) {
            builder.addPropertyValue("policy", parserContext.getDelegate().parsePropertySubElement(relocationPolicyEle, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        if ((memberAliveIndicatorEle = DomUtils.getChildElementByTagName((Element)element, (String)"member-alive-indicator")) != null) {
            builder.addPropertyValue("memberAliveIndicator", parserContext.getDelegate().parsePropertySubElement(memberAliveIndicatorEle, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        if ((monitorsEle = DomUtils.getChildElementByTagName((Element)element, (String)"monitors")) != null) {
            List monitors = parserContext.getDelegate().parseListElement(monitorsEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("monitors", (Object)monitors);
        }
        if ((requirementsEle = DomUtils.getChildElementByTagName((Element)element, (String)"requirements")) != null) {
            List requirements = parserContext.getDelegate().parseListElement(requirementsEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("requirements", (Object)requirements);
        }
        if ((instanceSLAsEle = DomUtils.getChildElementByTagName((Element)element, (String)"instance-SLAs")) != null) {
            List instanceSLAs = parserContext.getDelegate().parseListElement(instanceSLAsEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("instanceSLAs", (Object)instanceSLAs);
        }
    }
}

