/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.sla.monitor;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.openspaces.pu.sla.monitor.AbstractMonitor;
import org.openspaces.pu.sla.monitor.ApplicationContextMonitor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.StringUtils;

public class BeanPropertyMonitor
extends AbstractMonitor
implements ApplicationContextMonitor {
    private static final long serialVersionUID = -6401809881237930697L;
    private String ref;
    private String propertyName;
    private transient MethodInvoker methodInvoker;

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getRef() {
        return this.ref;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        Object bean;
        Assert.notNull((Object)this.getName(), (String)"name property is required");
        Assert.notNull((Object)this.ref, (String)"ref property is required");
        Assert.notNull((Object)this.propertyName, (String)"propertyName property is required");
        try {
            bean = applicationContext.getBean(this.ref);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException("Monitor did not find bean [" + this.ref + "] under Spring application context, available beans are " + Arrays.toString(applicationContext.getBeanDefinitionNames()));
        }
        this.methodInvoker = new MethodInvoker();
        this.methodInvoker.setTargetMethod("get" + StringUtils.capitalize((String)this.propertyName));
        this.methodInvoker.setTargetObject(bean);
        try {
            this.methodInvoker.prepare();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to find class for bean [" + bean + "]", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find method for bean [" + bean + "]", e);
        }
    }

    @Override
    public double getValue() {
        try {
            Number number = (Number)this.methodInvoker.invoke();
            return number.doubleValue();
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to invoke method", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to invoke method", e);
        }
    }
}

