/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Map;
import org.openspaces.remoting.scripting.AbstractLocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptCompilationException;
import org.openspaces.remoting.scripting.ScriptExecutionException;

public class GroovyLocalScriptExecutor
extends AbstractLocalScriptExecutor<groovy.lang.Script> {
    private GroovyShell groovyShell = new GroovyShell(Thread.currentThread().getContextClassLoader());

    protected groovy.lang.Script doCompile(Script script) throws ScriptCompilationException {
        try {
            return this.groovyShell.parse(script.getScriptAsString());
        }
        catch (Exception e) {
            throw new ScriptCompilationException("Failed to compile script [" + script.getName() + "]: " + e.getMessage());
        }
    }

    public Object execute(Script script, groovy.lang.Script compiledScript, Map<String, Object> parameters) throws ScriptExecutionException {
        Binding binding = new Binding();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
        }
        compiledScript.setBinding(binding);
        try {
            return compiledScript.run();
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Failed to execute script [" + script.getName() + "]", (Throwable)e);
        }
    }

    public void close(groovy.lang.Script compiledScript) {
    }

    public boolean isThreadSafe() {
        return false;
    }
}

