/*
 * Decompiled with CFR 0.152.
 */
package com.insightedge.cli.commands;

import com.gigaspaces.cli.commands.host.HostRunAgentCommand;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import java.util.Collection;
import org.gigaspaces.cli.CliCommandException;
import picocli.CommandLine;

@CommandLine.Command(name="run-agent", header={"Run a Grid Service Agent on the current host (--help for options)"})
public class I9EHostRunAgentCommand
extends HostRunAgentCommand {
    private final String SPARK_MASTER_OPTION = "--spark-master";
    private final String SPARK_WORKER_OPTION = "--spark-worker";
    private final String ZEPPELIN_OPTION = "--zeppelin";
    @CommandLine.Option(names={"--spark-master"}, description={"Run the Spark Master"})
    Boolean sparkMaster;
    @CommandLine.Option(names={"--spark-worker"}, description={"Run the Spark Worker"})
    Boolean sparkWorker;
    @CommandLine.Option(names={"--zeppelin"}, description={"Run the Zeppelin interpreter"})
    Boolean zeppelin;

    protected void appendOptions(Collection<String> command) throws CliCommandException {
        super.appendOptions(command);
        this.validateConfiguration();
        this.processOption(this.sparkMaster, "--spark-master", command);
        this.processOption(this.sparkWorker, "--spark-worker", command);
        this.processOption(this.zeppelin, "--zeppelin", command);
    }

    private void validateConfiguration() {
        XapManagerClusterInfo managerClusterInfo;
        if (!this.auto && !this.isTrue(this.manager) && (this.isTrue(this.sparkMaster) || this.isTrue(this.sparkWorker)) && (managerClusterInfo = SystemInfo.singleton().getManagerClusterInfo()).getServers().length == 0) {
            System.err.println("XAP Manager configuration is missing.\n- To run a local Spark cluster on this machine, use --auto\n- To configure a Spark cluster, set the XAP_MANAGER_SERVERS environment variable with a list of designated Manager servers.\n");
            System.exit(1);
        }
    }

    protected void addAutoComponents(Collection<String> command, boolean isManager) {
        super.addAutoComponents(command, isManager);
        if (isManager) {
            command.add("--spark-master");
            command.add("--spark-worker");
            command.add("--zeppelin");
        }
    }
}

