/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.support.StringBuilderVar;
import org.pegdown.Parser;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.TextNode;
import org.pegdown.plugins.BlockPluginParser;
import org.pegdown.plugins.PegDownPlugins;

public class PegdownWebSequencelPlugin
extends Parser
implements BlockPluginParser {
    private static final String WEBSEQ_URL = "http://www.websequencediagrams.com";
    public static final String TAG = "%%%";

    public PegdownWebSequencelPlugin() {
        super(Integer.valueOf(3472383), Long.valueOf(10000L), DefaultParseRunnerProvider);
    }

    public PegdownWebSequencelPlugin(Integer opts, Long millis, Parser.ParseRunnerProvider provider, PegDownPlugins plugins) {
        super(opts, millis, provider, plugins);
    }

    Rule StartMarker() {
        return this.Sequence(this.Spn1(), TAG, new Object[]{this.Sp(), "sequence", this.Sp()});
    }

    String EndMarker() {
        return TAG;
    }

    Rule Body() {
        return this.OneOrMore(this.TestNot(TAG), BaseParser.ANY, new Object[0]);
    }

    Rule BlockRule() {
        StringBuilderVar style = new StringBuilderVar();
        StringBuilderVar body = new StringBuilderVar();
        return this.NodeSequence(new Object[]{this.StartMarker(), this.Optional(this.String("style="), this.Sequence(this.OneOrMore(this.Letter()), style.append(this.match()), new Object[]{this.Spn1()}), new Object[0]), this.Sequence(this.Body(), body.append(this.match()), new Object[0]), this.EndMarker(), this.push(new ExpImageNode("title", PegdownWebSequencelPlugin.createWebsequenceUrl(style.getString(), body.getString()), (Node)new TextNode("")))});
    }

    public static String createWebsequenceUrl(String style, String content) {
        style = StringUtils.defaultString((String)style, (String)"default");
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        String webSeqUrl = "";
        try {
            String line;
            String query = "style=" + style + "&message=" + URLEncoder.encode(content, "UTF-8") + "&apiVersion=1";
            URL url = new URL(WEBSEQ_URL);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            writer.write(query);
            writer.flush();
            StringBuilder response = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            writer.close();
            reader.close();
            String json = response.toString();
            int start = json.indexOf("?png=");
            int end = json.indexOf("\"", start);
            if (start != -1 && end != -1) {
                webSeqUrl = "http://www.websequencediagrams.com/" + json.substring(start, end);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to get proper response from websequencediagrams.com", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Reader)reader);
        return webSeqUrl;
    }

    public Rule[] blockPluginRules() {
        return new Rule[]{this.BlockRule()};
    }
}

