/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBColumnFamilySample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws RocksDBException {
        if (args.length < 1) {
            System.out.println("usage: RocksDBColumnFamilySample db_path");
            return;
        }
        String db_path = args[0];
        System.out.println("RocksDBColumnFamilySample");
        RocksDB db = null;
        Options options = null;
        ColumnFamilyHandle columnFamilyHandle = null;
        WriteBatch wb = null;
        try {
            options = new Options().setCreateIfMissing(true);
            db = RocksDB.open((Options)options, (String)db_path);
            assert (db != null);
            columnFamilyHandle = db.createColumnFamily(new ColumnFamilyDescriptor("new_cf".getBytes(), new ColumnFamilyOptions()));
            assert (columnFamilyHandle != null);
        }
        finally {
            if (columnFamilyHandle != null) {
                columnFamilyHandle.close();
            }
            if (db != null) {
                db.close();
                db = null;
            }
            if (options != null) {
                options.close();
            }
        }
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, new ColumnFamilyOptions()));
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor("new_cf".getBytes(), new ColumnFamilyOptions()));
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor("new_cf2".getBytes(), new ColumnFamilyOptions()));
        ArrayList columnFamilyHandles = new ArrayList();
        try {
            db = RocksDB.open((DBOptions)new DBOptions(), (String)db_path, columnFamilyDescriptors, columnFamilyHandles);
            assert (db != null);
            db.put((ColumnFamilyHandle)columnFamilyHandles.get(0), new WriteOptions(), "key".getBytes(), "value".getBytes());
            String value = new String(db.get((ColumnFamilyHandle)columnFamilyHandles.get(0), "key".getBytes()));
            wb = new WriteBatch();
            wb.put((ColumnFamilyHandle)columnFamilyHandles.get(0), "key2".getBytes(), "value2".getBytes());
            wb.put((ColumnFamilyHandle)columnFamilyHandles.get(1), "key3".getBytes(), "value3".getBytes());
            wb.remove((ColumnFamilyHandle)columnFamilyHandles.get(0), "key".getBytes());
            db.write(new WriteOptions(), wb);
            db.dropColumnFamily((ColumnFamilyHandle)columnFamilyHandles.get(1));
        }
        finally {
            for (ColumnFamilyHandle handle : columnFamilyHandles) {
                handle.close();
            }
            if (db != null) {
                db.close();
            }
            if (wb != null) {
                wb.close();
            }
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

