/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb;

import com.gigaspaces.blobstore.rocksdb.RocksDBBlobStoreRecoveryHelper;
import com.gigaspaces.blobstore.rocksdb.RocksDBBlobStoreStatistics;
import com.gigaspaces.blobstore.rocksdb.RocksDBContainerIterator;
import com.gigaspaces.blobstore.rocksdb.RocksDBServiceMonitors;
import com.gigaspaces.blobstore.rocksdb.config.RocksDBBlobStoreConfigurer;
import com.gigaspaces.blobstore.rocksdb.config.XAPColumnFamilyOptions;
import com.gigaspaces.blobstore.rocksdb.config.XAPDBOptions;
import com.gigaspaces.blobstore.rocksdb.utils.FreeDevice;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationType;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import com.j_spaces.core.cache.blobStore.recovery.BlobStoreRecoveryHelper;
import java.io.File;
import java.io.Serializable;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.openspaces.core.util.FileUtils;
import org.openspaces.pu.service.CustomServiceDetails;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.TickerType;
import org.rocksdb.WriteBatch;

public class RocksDBBlobStoreHandler
extends BlobStoreStorageHandler
implements ServiceDetailsProvider,
ServiceMonitorsProvider {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.cache");
    private RocksDB rocksDB;
    private ColumnFamilyHandle defaultColumnFamilyHandle;
    private ColumnFamilyHandle dataColumnFamilyHandle;
    private ColumnFamilyHandle syncListColumnFamilyHandle;
    private ColumnFamilyHandle metadataColumnFamilyHandle;
    private ColumnFamilyHandle adminColumnFamilyHandle;
    private ColumnFamilyHandle syncOverflowColumnFamilyHandle;
    private Statistics stats;
    private final RocksDBBlobStoreRecoveryHelper blobStoreRecoveryHelper;
    private final String mappingDir;
    private final boolean centralStorage;
    private final boolean fsync;
    private long cacheSizeMB;
    private long blockSizeKB;
    private final String offHeapCacheMemoryThreshold;
    private final Map<String, String> serviceDetails = new HashMap<String, String>();
    private final XAPDBOptions dbOptions;
    private final XAPColumnFamilyOptions dataColumnFamilyOptions;
    private ColumnFamilyOptions nonDataColumnFamilyOptions;
    private String spaceInstanceDBPath;

    public RocksDBBlobStoreHandler(RocksDBBlobStoreConfigurer configurer) {
        this.mappingDir = configurer.getMappingDir();
        if (this.mappingDir == null) {
            throw new IllegalArgumentException("Please configure mapping dir. it's a required property.");
        }
        this.dbOptions = configurer.getDbOptions() != null ? configurer.getDbOptions() : new XAPDBOptions();
        this.dataColumnFamilyOptions = configurer.getDataColumnFamilyOptions() != null ? configurer.getDataColumnFamilyOptions() : new XAPColumnFamilyOptions();
        this.centralStorage = configurer.isCentralStorage();
        this.fsync = configurer.isFsync();
        this.cacheSizeMB = configurer.getCacheSizeMB();
        this.blockSizeKB = configurer.getBlockSizeKB();
        this.offHeapCacheMemoryThreshold = configurer.getOffHeapCacheMemoryThreshold();
        String paths = configurer.getPaths();
        if (paths == null) {
            throw new IllegalArgumentException("Please configure paths. it's a required property.");
        }
        this.blobStoreRecoveryHelper = new RocksDBBlobStoreRecoveryHelper(paths, this.mappingDir, this.centralStorage);
    }

    protected long getCacheSizeMB() {
        return this.cacheSizeMB;
    }

    protected long getBlockSizeKB() {
        return this.blockSizeKB;
    }

    public void initialize(BlobStoreConfig blobStoreConfig) {
        LicenseManager.getInstance().validate("MemoryXtend RocksDB plug-in", LicenseType.ENTERPRISE);
        String path = this.getDeviceName(blobStoreConfig);
        this.spaceInstanceDBPath = path + File.separator + blobStoreConfig.getSpaceName().replace(":", "-");
        File spaceInstanceDBPathFile = new File(this.spaceInstanceDBPath);
        if (!blobStoreConfig.isWarmStart() && spaceInstanceDBPathFile.exists()) {
            try {
                FileUtils.deleteFileOrDirectory((File)new File(this.spaceInstanceDBPath));
            }
            catch (RuntimeException e) {
                throw new BlobStoreException("Failed to delete db directory " + spaceInstanceDBPathFile.getAbsolutePath());
            }
        }
        if (!spaceInstanceDBPathFile.exists() && !spaceInstanceDBPathFile.mkdirs()) {
            throw new BlobStoreException("Failed to create db directory " + spaceInstanceDBPathFile.getAbsolutePath());
        }
        this.serviceDetails.put("path", this.spaceInstanceDBPath);
        this.serviceDetails.put("mappingDir", this.mappingDir);
        this.serviceDetails.put("centralStorage", String.valueOf(this.centralStorage));
        if (!this.dataColumnFamilyOptions.tableOptionsIsSet()) {
            logger.finest("TableFormatConfig is not set, using default with values: cacheSize=" + this.cacheSizeMB + "MB and blockSize=" + this.blockSizeKB + "KB");
            BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
            tableOptions.setNoBlockCache(this.cacheSizeMB == 0L).setBlockCacheSize(this.cacheSizeMB * 0x100000L).setFilter((Filter)new BloomFilter(10, false)).setBlockSize(this.blockSizeKB * 1024L).setFormatVersion(0);
            this.dataColumnFamilyOptions.setTableFormatConfig((TableFormatConfig)tableOptions);
        } else {
            logger.warning("Custom TableFormatConfig is set, the following handler's properties are ignored: cache-size and block-size");
            this.blockSizeKB = -1L;
            this.cacheSizeMB = -1L;
        }
        if (!this.dbOptions.useFsyncIsSet()) {
            logger.finest("FSync is not set in dbOptions, using value from bean [" + this.fsync + "]");
            this.dbOptions.setUseFsync(this.fsync);
        }
        this.serviceDetails.put("fsync", String.valueOf(this.dbOptions.useFsync()));
        this.dbOptions.setCreateIfMissing(true);
        this.dbOptions.setCreateMissingColumnFamilies(true);
        this.dataColumnFamilyOptions.setMergeOperatorName("put");
        this.nonDataColumnFamilyOptions = new ColumnFamilyOptions().setMergeOperatorName("put");
        List<ColumnFamilyDescriptor> columnFamilyDescs = Arrays.asList(this.createColumnFamilyDescriptor("default", this.nonDataColumnFamilyOptions), this.createColumnFamilyDescriptor(BlobStoreObjectType.DATA.name(), this.dataColumnFamilyOptions), this.createColumnFamilyDescriptor(BlobStoreObjectType.SYNC.name(), this.nonDataColumnFamilyOptions), this.createColumnFamilyDescriptor(BlobStoreObjectType.METADATA.name(), this.nonDataColumnFamilyOptions), this.createColumnFamilyDescriptor(BlobStoreObjectType.ADMIN.name(), this.nonDataColumnFamilyOptions), this.createColumnFamilyDescriptor(BlobStoreObjectType.SYNC_OVERFLOW.name(), this.nonDataColumnFamilyOptions));
        ArrayList<ColumnFamilyHandle> list = new ArrayList<ColumnFamilyHandle>();
        this.dbOptions.setStatistics(new Statistics()).setCreateIfMissing(true);
        this.stats = this.dbOptions.statistics();
        this.rocksDB = this.createDB(this.dbOptions, this.spaceInstanceDBPath, columnFamilyDescs, list);
        this.defaultColumnFamilyHandle = list.get(0);
        this.dataColumnFamilyHandle = list.get(1);
        this.syncListColumnFamilyHandle = list.get(2);
        this.metadataColumnFamilyHandle = list.get(3);
        this.adminColumnFamilyHandle = list.get(4);
        this.syncOverflowColumnFamilyHandle = list.get(5);
        this.registerMetrics(blobStoreConfig.getMetricRegistrator());
        logger.info("RocksDB Storage Handler [ " + ((Object)((Object)this)).getClass().getName() + " ] initialized on space: " + blobStoreConfig.getSpaceName());
        CodeSource src = this.rocksDB.getClass().getProtectionDomain().getCodeSource();
        String rocksdbVersion = "unknown";
        if (src != null) {
            String path1 = src.getLocation().getPath();
            rocksdbVersion = path1.substring(path1.indexOf("rocksdbjni-") + 11, path1.indexOf("rocksdbjni-") + 17);
        }
        logger.info("Running with RocksDB version: " + rocksdbVersion);
        if (this.offHeapCacheMemoryThreshold != null) {
            logger.info("Using off-heap cache, memory threshold = " + this.offHeapCacheMemoryThreshold);
        }
    }

    private ColumnFamilyDescriptor createColumnFamilyDescriptor(String columnFamilyName, ColumnFamilyOptions columnFamilyOptions) {
        return new ColumnFamilyDescriptor(columnFamilyName.getBytes(), columnFamilyOptions);
    }

    public Properties getProperties() {
        Properties configProperties = new Properties();
        configProperties.put(BlobStoreRecoveryHelper.BLOB_STORE_RECOVERY_HELPER_PROPERTY_NAME, this.blobStoreRecoveryHelper);
        configProperties.put("cacheSize", (Object)this.cacheSizeMB);
        if (this.offHeapCacheMemoryThreshold != null) {
            configProperties.put("off-heap-cache-memory-threshold", this.offHeapCacheMemoryThreshold);
        }
        if (this.spaceInstanceDBPath != null) {
            configProperties.put("path", this.spaceInstanceDBPath);
        }
        configProperties.put("mappingDir", this.mappingDir);
        configProperties.put("blobStoreHandler", ((Object)((Object)this)).getClass().getSimpleName());
        return configProperties;
    }

    public Object add(Serializable id, Serializable data, BlobStoreObjectType objectType) {
        try {
            switch (objectType) {
                case DATA: {
                    this.rocksDB.put(this.dataColumnFamilyHandle, this.dbOptions.getWriteOptions(), id.toString().getBytes(), (byte[])data);
                    break;
                }
                case SYNC: {
                    this.rocksDB.put(this.syncListColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case SYNC_OVERFLOW: {
                    this.rocksDB.put(this.syncOverflowColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case METADATA: {
                    this.rocksDB.put(this.metadataColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case ADMIN: {
                    this.rocksDB.put(this.adminColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                }
            }
        }
        catch (RocksDBException e) {
            throw new BlobStoreException((Throwable)e);
        }
        return 0;
    }

    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType) {
        byte[] data = null;
        try {
            switch (objectType) {
                case DATA: {
                    data = this.rocksDB.get(this.dataColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case SYNC: {
                    data = this.rocksDB.get(this.syncListColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case SYNC_OVERFLOW: {
                    data = this.rocksDB.get(this.syncOverflowColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case METADATA: {
                    data = this.rocksDB.get(this.metadataColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case ADMIN: {
                    data = this.rocksDB.get(this.adminColumnFamilyHandle, id.toString().getBytes());
                }
            }
        }
        catch (RocksDBException e) {
            throw new BlobStoreException((Throwable)e);
        }
        if (data != null && data.length > 0) {
            return data;
        }
        return null;
    }

    public Object replace(Serializable id, Serializable data, Object position, BlobStoreObjectType objectType) {
        try {
            switch (objectType) {
                case DATA: {
                    this.rocksDB.put(this.dataColumnFamilyHandle, this.dbOptions.getWriteOptions(), id.toString().getBytes(), (byte[])data);
                    break;
                }
                case SYNC: {
                    this.rocksDB.put(this.syncListColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case SYNC_OVERFLOW: {
                    this.rocksDB.put(this.syncOverflowColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case METADATA: {
                    this.rocksDB.put(this.metadataColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                    break;
                }
                case ADMIN: {
                    this.rocksDB.put(this.adminColumnFamilyHandle, id.toString().getBytes(), (byte[])data);
                }
            }
        }
        catch (RocksDBException e) {
            throw new BlobStoreException((Throwable)e);
        }
        return 0;
    }

    public BlobStoreStorageStatistics getStatistics() {
        return new RocksDBBlobStoreStatistics().setMemtableHit(this.stats.getTickerCount(TickerType.MEMTABLE_HIT)).setMemtableMiss(this.stats.getTickerCount(TickerType.MEMTABLE_MISS)).setGetHitL0(this.stats.getTickerCount(TickerType.GET_HIT_L0)).setGetHitL1(this.stats.getTickerCount(TickerType.GET_HIT_L1)).setGetHitL2AndUp(this.stats.getTickerCount(TickerType.GET_HIT_L2_AND_UP)).setNumberKeysWritten(this.stats.getTickerCount(TickerType.NUMBER_KEYS_WRITTEN)).setNumberKeysRead(this.stats.getTickerCount(TickerType.NUMBER_KEYS_READ)).setNumberKeysUpdated(this.stats.getTickerCount(TickerType.NUMBER_KEYS_UPDATED)).setBytesWritten(this.stats.getTickerCount(TickerType.BYTES_WRITTEN)).setBytesRead(this.stats.getTickerCount(TickerType.BYTES_READ)).setIterBytesRead(this.stats.getTickerCount(TickerType.ITER_BYTES_READ)).setNumberMultigetCalls(this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_CALLS)).setNumberMultigetKeysRead(this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_KEYS_READ)).setNumberMultigetBytesRead(this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_BYTES_READ));
    }

    public Serializable remove(Serializable id, Object position, BlobStoreObjectType objectType) {
        try {
            switch (objectType) {
                case DATA: {
                    this.rocksDB.delete(this.dataColumnFamilyHandle, this.dbOptions.getWriteOptions(), id.toString().getBytes());
                    break;
                }
                case SYNC: {
                    this.rocksDB.delete(this.syncListColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case SYNC_OVERFLOW: {
                    this.rocksDB.delete(this.syncOverflowColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case METADATA: {
                    this.rocksDB.delete(this.metadataColumnFamilyHandle, id.toString().getBytes());
                    break;
                }
                case ADMIN: {
                    this.rocksDB.delete(this.adminColumnFamilyHandle, id.toString().getBytes());
                }
            }
        }
        catch (RocksDBException e) {
            throw new BlobStoreException((Throwable)e);
        }
        return null;
    }

    public List<BlobStoreBulkOperationResult> executeBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        return this.executeRocksDBBulk(operations, objectType, transactional);
    }

    public DataIterator<BlobStoreGetBulkOperationResult> iterator(BlobStoreObjectType objectType) {
        return new RocksDBContainerIterator(this, objectType);
    }

    public void close() {
        if (this.defaultColumnFamilyHandle != null) {
            this.defaultColumnFamilyHandle.close();
        }
        if (this.dataColumnFamilyHandle != null) {
            this.dataColumnFamilyHandle.close();
        }
        if (this.syncListColumnFamilyHandle != null) {
            this.syncListColumnFamilyHandle.close();
        }
        if (this.metadataColumnFamilyHandle != null) {
            this.metadataColumnFamilyHandle.close();
        }
        if (this.adminColumnFamilyHandle != null) {
            this.adminColumnFamilyHandle.close();
        }
        if (this.syncOverflowColumnFamilyHandle != null) {
            this.syncOverflowColumnFamilyHandle.close();
        }
        if (this.dbOptions != null && this.dbOptions.getWriteOptions() != null) {
            this.dbOptions.getWriteOptions().close();
        }
        if (this.dbOptions != null) {
            this.dbOptions.close();
        }
        if (this.dataColumnFamilyOptions != null) {
            this.dataColumnFamilyOptions.close();
        }
        if (this.nonDataColumnFamilyOptions != null) {
            this.nonDataColumnFamilyOptions.close();
        }
        if (this.rocksDB != null) {
            this.rocksDB.close();
        }
    }

    private synchronized RocksDB createDB(DBOptions options, String dbPath, List<ColumnFamilyDescriptor> columnFamilyDescs, ArrayList<ColumnFamilyHandle> list) {
        try {
            return RocksDB.open((DBOptions)options, (String)dbPath, columnFamilyDescs, list);
        }
        catch (RocksDBException e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    public RocksIterator createDataRocksIterator() {
        return this.rocksDB.newIterator(this.dataColumnFamilyHandle);
    }

    public RocksIterator createMetadataRocksIterator() {
        return this.rocksDB.newIterator(this.metadataColumnFamilyHandle);
    }

    public RocksIterator createSyncListRocksIterator() {
        return this.rocksDB.newIterator(this.syncListColumnFamilyHandle);
    }

    public RocksIterator createSyncOverflowRocksIterator() {
        return this.rocksDB.newIterator(this.syncOverflowColumnFamilyHandle);
    }

    public RocksIterator createAdminRocksIterator() {
        return this.rocksDB.newIterator(this.adminColumnFamilyHandle);
    }

    private List<BlobStoreBulkOperationResult> executeRocksDBBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        ConcurrentHashMap<BlobStoreBulkOperationRequest, BlobStoreBulkOperationResult> idRequestsMap = new ConcurrentHashMap<BlobStoreBulkOperationRequest, BlobStoreBulkOperationResult>();
        boolean isGetOnly = operations.get(0).getOpType().equals((Object)BlobStoreBulkOperationType.GET);
        try {
            this.setOperations(operations, idRequestsMap);
            if (isGetOnly) {
                ArrayList<byte[]> keys = new ArrayList<byte[]>();
                Map rocksdbResult = null;
                for (BlobStoreBulkOperationRequest request : operations) {
                    keys.add(request.getId().toString().getBytes());
                }
                ArrayList<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>();
                if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
                    columnFamilyHandles.add(this.dataColumnFamilyHandle);
                    rocksdbResult = this.rocksDB.multiGet(columnFamilyHandles, keys);
                }
                if (objectType.equals((Object)BlobStoreObjectType.SYNC)) {
                    columnFamilyHandles.add(this.syncListColumnFamilyHandle);
                    rocksdbResult = this.rocksDB.multiGet(columnFamilyHandles, keys);
                }
                if (objectType.equals((Object)BlobStoreObjectType.SYNC_OVERFLOW)) {
                    columnFamilyHandles.add(this.syncOverflowColumnFamilyHandle);
                    rocksdbResult = this.rocksDB.multiGet(columnFamilyHandles, keys);
                }
                if (objectType.equals((Object)BlobStoreObjectType.ADMIN)) {
                    columnFamilyHandles.add(this.adminColumnFamilyHandle);
                    rocksdbResult = this.rocksDB.multiGet(columnFamilyHandles, keys);
                }
                for (byte[] res : rocksdbResult.keySet()) {
                    BlobStoreGetBulkOperationResult blobStoreBulkOperationResult = new BlobStoreGetBulkOperationResult((Serializable)((Object)new String(res)), (Serializable)rocksdbResult.get(res), (Object)0, null);
                    idRequestsMap.put((BlobStoreBulkOperationRequest)new BlobStoreGetBulkOperationRequest((Serializable)((Object)new String(res)), (Object)0, null), (BlobStoreBulkOperationResult)blobStoreBulkOperationResult);
                }
            } else {
                WriteBatch wb = null;
                if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
                    wb = this.opsBatch(operations, transactional, this.dataColumnFamilyHandle);
                    this.rocksDB.write(this.dbOptions.getWriteOptions(), wb);
                }
                if (objectType.equals((Object)BlobStoreObjectType.SYNC)) {
                    wb = this.opsBatch(operations, transactional, this.syncListColumnFamilyHandle);
                    this.rocksDB.write(this.dbOptions.getWriteOptions(), wb);
                }
                if (objectType.equals((Object)BlobStoreObjectType.SYNC_OVERFLOW)) {
                    wb = this.opsBatch(operations, transactional, this.syncOverflowColumnFamilyHandle);
                    this.rocksDB.write(this.dbOptions.getWriteOptions(), wb);
                }
                if (objectType.equals((Object)BlobStoreObjectType.ADMIN)) {
                    wb = this.opsBatch(operations, transactional, this.adminColumnFamilyHandle);
                    this.rocksDB.write(this.dbOptions.getWriteOptions(), wb);
                }
                wb.close();
            }
            this.convertToBlobStoreAndPutResults(operations, idRequestsMap);
            return this.gatherResultsFromOperations(operations, idRequestsMap);
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    private WriteBatch opsBatch(List<BlobStoreBulkOperationRequest> operations, boolean transactional, ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        WriteBatch wb;
        block11: {
            int i;
            int size;
            block10: {
                size = operations.size();
                wb = new WriteBatch();
                if (!transactional) break block10;
                for (BlobStoreBulkOperationRequest request : operations) {
                    switch (request.getOpType()) {
                        case ADD: {
                            wb.put(columnFamilyHandle, request.getId().toString().getBytes(), (byte[])request.getData());
                            break;
                        }
                        case REMOVE: {
                            wb.remove(columnFamilyHandle, ((String)((Object)request.getId())).getBytes());
                            break;
                        }
                        case REPLACE: {
                            wb.put(columnFamilyHandle, request.getId().toString().getBytes(), (byte[])request.getData());
                        }
                    }
                }
                break block11;
            }
            if (operations.get(0).getOpType().equals((Object)BlobStoreBulkOperationType.REMOVE)) {
                for (i = 0; i < size; ++i) {
                    wb.remove(columnFamilyHandle, ((BlobStoreRemoveBulkOperationRequest)operations.get(i)).getId().toString().getBytes());
                }
            }
            if (!operations.get(0).getOpType().equals((Object)BlobStoreBulkOperationType.ADD) && !operations.get(0).getOpType().equals((Object)BlobStoreBulkOperationType.REPLACE)) break block11;
            for (i = 0; i < size; ++i) {
                if (operations.get(i).getOpType().equals((Object)BlobStoreBulkOperationType.ADD)) {
                    wb.put(columnFamilyHandle, operations.get(i).getId().toString().getBytes(), (byte[])operations.get(i).getData());
                    continue;
                }
                wb.put(columnFamilyHandle, operations.get(i).getId().toString().getBytes(), (byte[])operations.get(i).getData());
            }
        }
        return wb;
    }

    private void setOperations(List<BlobStoreBulkOperationRequest> operations, Map<BlobStoreBulkOperationRequest, BlobStoreBulkOperationResult> idRequestsMap) {
        for (int i = 0; i < operations.size(); ++i) {
            BlobStoreBulkOperationResult nullIndicator = this.getNullIndicator(operations.get(i));
            BlobStoreBulkOperationResult res = idRequestsMap.put(operations.get(i), nullIndicator);
            if (res == null && !nullIndicator.equals(res)) continue;
            throw new BlobStoreException("Internal RocksDBHandler error");
        }
    }

    private List<BlobStoreBulkOperationResult> gatherResultsFromOperations(List<BlobStoreBulkOperationRequest> operations, Map<BlobStoreBulkOperationRequest, BlobStoreBulkOperationResult> idRequestsMap) {
        ArrayList<BlobStoreBulkOperationResult> results = new ArrayList<BlobStoreBulkOperationResult>();
        for (BlobStoreBulkOperationRequest request : operations) {
            BlobStoreBulkOperationResult res = idRequestsMap.get(request);
            BlobStoreBulkOperationResult nullIndicator = this.getNullIndicator(request);
            if (nullIndicator.equals(res)) {
                throw new BlobStoreException("Inconsistent results returned from RocksDB. object id [ " + request.getId() + " ]");
            }
            results.add(res);
        }
        return results;
    }

    private BlobStoreBulkOperationResult getNullIndicator(BlobStoreBulkOperationRequest request) {
        if (request.getOpType().equals((Object)BlobStoreBulkOperationType.ADD)) {
            return new BlobStoreAddBulkOperationResult(null, null);
        }
        if (request.getOpType().equals((Object)BlobStoreBulkOperationType.GET)) {
            return new BlobStoreGetBulkOperationResult(null, null);
        }
        if (request.getOpType().equals((Object)BlobStoreBulkOperationType.REMOVE)) {
            return new BlobStoreRemoveBulkOperationResult(null, null);
        }
        if (request.getOpType().equals((Object)BlobStoreBulkOperationType.REPLACE)) {
            return new BlobStoreReplaceBulkOperationResult(null, null);
        }
        return null;
    }

    private void convertToBlobStoreAndPutResults(List<BlobStoreBulkOperationRequest> ops, Map<BlobStoreBulkOperationRequest, BlobStoreBulkOperationResult> opsIdsMap) {
        int i = 0;
        for (BlobStoreBulkOperationRequest containerOp : ops) {
            String reqId;
            Throwable exception = null;
            if (containerOp.getOpType().ordinal() == BlobStoreBulkOperationType.ADD.ordinal()) {
                reqId = ops.get(i).getId().toString();
                opsIdsMap.put(ops.get(i), (BlobStoreBulkOperationResult)new BlobStoreAddBulkOperationResult((Serializable)((Object)reqId), exception));
            }
            if (containerOp.getOpType().ordinal() == BlobStoreBulkOperationType.REMOVE.ordinal()) {
                reqId = ops.get(i).getId().toString();
                opsIdsMap.put(ops.get(i), (BlobStoreBulkOperationResult)new BlobStoreRemoveBulkOperationResult((Serializable)((Object)reqId), exception));
            }
            if (containerOp.getOpType().ordinal() == BlobStoreBulkOperationType.REPLACE.ordinal()) {
                reqId = ops.get(i).getId().toString();
                opsIdsMap.put(ops.get(i), (BlobStoreBulkOperationResult)new BlobStoreReplaceBulkOperationResult((Serializable)((Object)reqId), exception));
            }
            ++i;
        }
    }

    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new RocksDBServiceMonitors("RocksDB", this.stats.getTickerCount(TickerType.MEMTABLE_HIT), this.stats.getTickerCount(TickerType.MEMTABLE_MISS), this.stats.getTickerCount(TickerType.GET_HIT_L0), this.stats.getTickerCount(TickerType.GET_HIT_L1), this.stats.getTickerCount(TickerType.GET_HIT_L2_AND_UP), this.stats.getTickerCount(TickerType.NUMBER_KEYS_WRITTEN), this.stats.getTickerCount(TickerType.NUMBER_KEYS_READ), this.stats.getTickerCount(TickerType.NUMBER_KEYS_UPDATED), this.stats.getTickerCount(TickerType.BYTES_WRITTEN), this.stats.getTickerCount(TickerType.BYTES_READ), this.stats.getTickerCount(TickerType.ITER_BYTES_READ), this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_CALLS), this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_KEYS_READ), this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_BYTES_READ))};
    }

    public ServiceDetails[] getServicesDetails() {
        CustomServiceDetails customServiceDetails = new CustomServiceDetails("RocksDB", "", "RocksDB BlobStore service details", "RocksDB BlobStore service d1etails");
        for (String key : this.serviceDetails.keySet()) {
            customServiceDetails.getAttributes().put(key, this.serviceDetails.get(key));
        }
        customServiceDetails.getAttributes().put("blobStore-handler", ((Object)((Object)this)).getClass().getSimpleName());
        return new ServiceDetails[]{customServiceDetails};
    }

    private void registerMetrics(MetricRegistrator metricRegistrator) {
        Gauge<Long> memtableHit = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.MEMTABLE_HIT);
            }
        };
        Gauge<Long> memtableMiss = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.MEMTABLE_MISS);
            }
        };
        Gauge<Long> getHitL0 = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.GET_HIT_L0);
            }
        };
        Gauge<Long> getHitL1 = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.GET_HIT_L1);
            }
        };
        Gauge<Long> getHitL2AndUp = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.GET_HIT_L2_AND_UP);
            }
        };
        Gauge<Long> numberKeysWritten = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_KEYS_WRITTEN);
            }
        };
        Gauge<Long> numberKeysRead = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_KEYS_READ);
            }
        };
        Gauge<Long> numberKeysUpdated = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_KEYS_UPDATED);
            }
        };
        Gauge<Long> bytesWritten = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.BYTES_WRITTEN);
            }
        };
        Gauge<Long> bytesRead = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.BYTES_READ);
            }
        };
        Gauge<Long> iterBytesRead = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.ITER_BYTES_READ);
            }
        };
        Gauge<Long> numberMultigetCalls = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_CALLS);
            }
        };
        Gauge<Long> numberMultigetKeysRead = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_KEYS_READ);
            }
        };
        Gauge<Long> numberMultigetBytesRead = new Gauge<Long>(){

            public Long getValue() throws Exception {
                return RocksDBBlobStoreHandler.this.stats.getTickerCount(TickerType.NUMBER_MULTIGET_BYTES_READ);
            }
        };
        metricRegistrator.register("memtable-hit", (Metric)memtableHit);
        metricRegistrator.register("memtable-miss", (Metric)memtableMiss);
        metricRegistrator.register("get-hit-l0", (Metric)getHitL0);
        metricRegistrator.register("get-hit-l1", (Metric)getHitL1);
        metricRegistrator.register("get-hit-l2-and-up", (Metric)getHitL2AndUp);
        metricRegistrator.register("number-keys-written", (Metric)numberKeysWritten);
        metricRegistrator.register("number-keys-read", (Metric)numberKeysRead);
        metricRegistrator.register("number-keys-updated", (Metric)numberKeysUpdated);
        metricRegistrator.register("bytes-written", (Metric)bytesWritten);
        metricRegistrator.register("bytes-read", (Metric)bytesRead);
        metricRegistrator.register("iter-bytes-read", (Metric)iterBytesRead);
        metricRegistrator.register("number-multiget-calls", (Metric)numberMultigetCalls);
        metricRegistrator.register("number-multiget-keys-read", (Metric)numberMultigetKeysRead);
        metricRegistrator.register("number-multiget-bytes-read", (Metric)numberMultigetBytesRead);
    }

    private String getDeviceName(BlobStoreConfig blobStoreConfig) {
        FreeDevice freeDevice = this.blobStoreRecoveryHelper.getFreeDevice();
        blobStoreConfig.setWarmStart(blobStoreConfig.isWarmStart() && freeDevice.isUsedBeforeWithCurrentSpace());
        return freeDevice.getDeviceName();
    }

    protected XAPDBOptions getDBOptions() {
        return this.dbOptions;
    }

    protected XAPColumnFamilyOptions getDataColumnFamilyOptions() {
        return this.dataColumnFamilyOptions;
    }

    protected String getMappingDir() {
        return this.mappingDir;
    }

    protected boolean isCentralStorage() {
        return this.centralStorage;
    }
}

