/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb;

import com.gigaspaces.blobstore.rocksdb.utils.DeviceController;
import com.gigaspaces.blobstore.rocksdb.utils.FreeDevice;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.j_spaces.core.cache.blobStore.recovery.BlobStoreRecoveryHelper;
import java.io.Serializable;
import java.util.List;

public class RocksDBBlobStoreRecoveryHelper
extends BlobStoreRecoveryHelper
implements Serializable {
    private String spaceName;
    private DeviceController deviceController;
    private FreeDevice freeDevice;
    private String devices;

    public RocksDBBlobStoreRecoveryHelper(String devices, String blobStoreDevicesMappingDir, boolean isCentralDevice) {
        this.deviceController = new DeviceController(blobStoreDevicesMappingDir, isCentralDevice);
        this.devices = devices;
    }

    public DeviceController getDeviceController() {
        return this.deviceController;
    }

    public void initialize(String spaceNamee, int numberOfPartitions, int numberOfBackups) {
        this.spaceName = spaceNamee.replace(":", "-");
        this.deviceController.setNumberOfPartitions(numberOfPartitions);
        this.deviceController.setNumberOfBackups(numberOfBackups);
        List<String> devs = this.deviceController.getDevicesArray(this.devices);
        this.freeDevice = this.deviceController.insertIfAbsent(this.spaceName, devs);
    }

    public StorageConsistencyModes getStorageState() {
        return this.getStorageConsistencyModeFromDevice(this.deviceController.getSpaceDevice(this.spaceName));
    }

    public void setStorageState(StorageConsistencyModes storageConsistencyMode) {
        this.deviceController.setSpaceStorageConsistencyMode(this.spaceName, storageConsistencyMode);
    }

    public boolean isPerInstancePersistency() {
        return true;
    }

    private StorageConsistencyModes getStorageConsistencyModeFromDevice(String device) {
        return StorageConsistencyModes.valueOf((String)device.substring(device.indexOf("@") + 1, device.indexOf("^")));
    }

    public FreeDevice getFreeDevice() {
        return this.freeDevice;
    }
}

