/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class RocksDBBlobStoreStatistics
implements BlobStoreStorageStatistics,
Externalizable {
    private static final long serialVersionUID = 1L;
    private long memtableHit;
    private long memtableMiss;
    private long getHitL0;
    private long getHitL1;
    private long getHitL2AndUp;
    private long numberKeysWritten;
    private long numberKeysRead;
    private long numberKeysUpdated;
    private long bytesWritten;
    private long bytesRead;
    private long iterBytesRead;
    private long numberMultigetCalls;
    private long numberMultigetKeysRead;
    private long numberMultigetBytesRead;

    public String getName() {
        return "RocksDB";
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("memtable-hit", String.valueOf(this.memtableHit));
        properties.put("memtable-miss", String.valueOf(this.memtableMiss));
        properties.put("get-hit-l0", String.valueOf(this.getHitL0));
        properties.put("get-hit-l1", String.valueOf(this.getHitL1));
        properties.put("get-hit-l2-and-up", String.valueOf(this.getHitL2AndUp));
        properties.put("number-keys-written", String.valueOf(this.numberKeysWritten));
        properties.put("number-keys-read", String.valueOf(this.numberKeysRead));
        properties.put("number-keys-updated", String.valueOf(this.numberKeysUpdated));
        properties.put("bytes-written", String.valueOf(this.bytesWritten));
        properties.put("bytes-read", String.valueOf(this.bytesRead));
        properties.put("iter-bytes-read", String.valueOf(this.iterBytesRead));
        properties.put("number-multiget-calls", String.valueOf(this.numberMultigetCalls));
        properties.put("number-multiget-keys-read", String.valueOf(this.numberMultigetKeysRead));
        properties.put("number-multiget-bytes-read", String.valueOf(this.numberMultigetBytesRead));
        return properties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (PlatformLogicalVersion.getLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_3_1)) {
            IOUtils.writeLong((ObjectOutput)out, (long)this.memtableHit);
            IOUtils.writeLong((ObjectOutput)out, (long)this.memtableMiss);
            IOUtils.writeLong((ObjectOutput)out, (long)this.getHitL0);
            IOUtils.writeLong((ObjectOutput)out, (long)this.getHitL1);
            IOUtils.writeLong((ObjectOutput)out, (long)this.getHitL2AndUp);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberKeysWritten);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberKeysRead);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberKeysUpdated);
            IOUtils.writeLong((ObjectOutput)out, (long)this.bytesWritten);
            IOUtils.writeLong((ObjectOutput)out, (long)this.bytesRead);
            IOUtils.writeLong((ObjectOutput)out, (long)this.iterBytesRead);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberMultigetCalls);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberMultigetKeysRead);
            IOUtils.writeLong((ObjectOutput)out, (long)this.numberMultigetBytesRead);
        } else {
            out.writeLong(this.bytesWritten);
            out.writeLong(this.bytesRead);
            out.writeLong(0L);
            out.writeDouble(0.0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (PlatformLogicalVersion.getLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_3_1)) {
            this.memtableHit = IOUtils.readLong((ObjectInput)in);
            this.memtableMiss = IOUtils.readLong((ObjectInput)in);
            this.getHitL0 = IOUtils.readLong((ObjectInput)in);
            this.getHitL1 = IOUtils.readLong((ObjectInput)in);
            this.getHitL2AndUp = IOUtils.readLong((ObjectInput)in);
            this.numberKeysWritten = IOUtils.readLong((ObjectInput)in);
            this.numberKeysRead = IOUtils.readLong((ObjectInput)in);
            this.numberKeysUpdated = IOUtils.readLong((ObjectInput)in);
            this.bytesWritten = IOUtils.readLong((ObjectInput)in);
            this.bytesRead = IOUtils.readLong((ObjectInput)in);
            this.iterBytesRead = IOUtils.readLong((ObjectInput)in);
            this.numberMultigetCalls = IOUtils.readLong((ObjectInput)in);
            this.numberMultigetKeysRead = IOUtils.readLong((ObjectInput)in);
            this.numberMultigetBytesRead = IOUtils.readLong((ObjectInput)in);
        } else {
            this.bytesWritten = in.readLong();
            this.bytesRead = in.readLong();
            in.readLong();
            in.readDouble();
        }
    }

    RocksDBBlobStoreStatistics setMemtableHit(long memtableHit) {
        this.memtableHit = memtableHit;
        return this;
    }

    public long getMemtableHit() {
        return this.memtableHit;
    }

    RocksDBBlobStoreStatistics setMemtableMiss(long memtableMiss) {
        this.memtableMiss = memtableMiss;
        return this;
    }

    public long getMemtableMiss() {
        return this.memtableMiss;
    }

    RocksDBBlobStoreStatistics setGetHitL0(long getHitL0) {
        this.getHitL0 = getHitL0;
        return this;
    }

    public long getGetHitL0() {
        return this.getHitL0;
    }

    RocksDBBlobStoreStatistics setGetHitL1(long getHitL1) {
        this.getHitL1 = getHitL1;
        return this;
    }

    public long getGetHitL1() {
        return this.getHitL1;
    }

    RocksDBBlobStoreStatistics setGetHitL2AndUp(long getHitL2AndUp) {
        this.getHitL2AndUp = getHitL2AndUp;
        return this;
    }

    public long getHitL2AndUp() {
        return this.getHitL2AndUp;
    }

    RocksDBBlobStoreStatistics setNumberKeysWritten(long numberKeysWritten) {
        this.numberKeysWritten = numberKeysWritten;
        return this;
    }

    public long getNumberKeysWritten() {
        return this.numberKeysWritten;
    }

    RocksDBBlobStoreStatistics setNumberKeysRead(long numberKeysRead) {
        this.numberKeysRead = numberKeysRead;
        return this;
    }

    public long getNumberKeysRead() {
        return this.numberKeysRead;
    }

    RocksDBBlobStoreStatistics setNumberKeysUpdated(long numberKeysUpdated) {
        this.numberKeysUpdated = numberKeysUpdated;
        return this;
    }

    public long getNumberKeysUpdated() {
        return this.numberKeysUpdated;
    }

    RocksDBBlobStoreStatistics setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
        return this;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    RocksDBBlobStoreStatistics setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
        return this;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    RocksDBBlobStoreStatistics setIterBytesRead(long iterBytesRead) {
        this.iterBytesRead = iterBytesRead;
        return this;
    }

    public long getIterBytesRead() {
        return this.iterBytesRead;
    }

    RocksDBBlobStoreStatistics setNumberMultigetCalls(long numberMultigetCalls) {
        this.numberMultigetCalls = numberMultigetCalls;
        return this;
    }

    public long getNumberMultigetCalls() {
        return this.numberMultigetCalls;
    }

    RocksDBBlobStoreStatistics setNumberMultigetKeysRead(long numberMultigetKeysRead) {
        this.numberMultigetKeysRead = numberMultigetKeysRead;
        return this;
    }

    public long getNumberMultigetKeysRead() {
        return this.numberMultigetKeysRead;
    }

    RocksDBBlobStoreStatistics setNumberMultigetBytesRead(long numberMultigetBytesRead) {
        this.numberMultigetBytesRead = numberMultigetBytesRead;
        return this;
    }

    public long getNumberMultigetBytesRead() {
        return this.numberMultigetBytesRead;
    }
}

