/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb;

import com.gigaspaces.blobstore.rocksdb.RocksDBBlobStoreHandler;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import java.io.Serializable;
import java.util.logging.Logger;
import org.rocksdb.RocksIterator;

public class RocksDBContainerIterator
implements DataIterator<BlobStoreGetBulkOperationResult> {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.com.gigaspaces.blobstore.storagehandler");
    private final int dbIndex;
    private RocksIterator rocksDBIterator;
    private boolean isFinish;
    private boolean initialized = false;
    private boolean closed = false;
    private final BlobStoreObjectType objectType;
    private RocksDBBlobStoreHandler handler;

    public RocksDBContainerIterator(RocksDBBlobStoreHandler handler, int dbIndex, BlobStoreObjectType objectType) {
        this.handler = handler;
        this.dbIndex = dbIndex;
        this.objectType = objectType;
    }

    public RocksDBContainerIterator(RocksDBBlobStoreHandler handler, BlobStoreObjectType objectType) {
        this.handler = handler;
        this.objectType = objectType;
        this.dbIndex = 0;
    }

    public void close() {
        try {
            if (this.closed) {
                logger.warning("Trying to close FDFContainerIterator but it already closed. Iterator properties [ object type = " + this.objectType + ", db index = " + this.dbIndex + " ].");
            }
            if (this.initialized && !this.closed) {
                this.isFinish = true;
                this.closed = true;
            }
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (this.isFinish) {
            return false;
        }
        this.isFinish = !this.rocksDBIterator.isValid();
        return !this.isFinish;
    }

    public BlobStoreGetBulkOperationResult next() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        BlobStoreGetBulkOperationResult result = new BlobStoreGetBulkOperationResult((Serializable)this.rocksDBIterator.key(), (Serializable)this.rocksDBIterator.value(), null, null);
        this.rocksDBIterator.next();
        return result;
    }

    private void initialize() {
        switch (this.objectType) {
            case DATA: {
                this.rocksDBIterator = this.handler.createDataRocksIterator();
                this.rocksDBIterator.seekToFirst();
                break;
            }
            case SYNC: {
                this.rocksDBIterator = this.handler.createSyncListRocksIterator();
                this.rocksDBIterator.seekToFirst();
                break;
            }
            case SYNC_OVERFLOW: {
                this.rocksDBIterator = this.handler.createSyncOverflowRocksIterator();
                this.rocksDBIterator.seekToFirst();
                break;
            }
            case METADATA: {
                this.rocksDBIterator = this.handler.createMetadataRocksIterator();
                this.rocksDBIterator.seekToFirst();
                break;
            }
            case ADMIN: {
                this.rocksDBIterator = this.handler.createAdminRocksIterator();
                this.rocksDBIterator.seekToFirst();
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

