/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.config;

import com.gigaspaces.blobstore.rocksdb.config.RocksDBBlobStoreDataPolicyFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RocksDBBlobStoreBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String PATHS = "paths";
    private static final String DB_OPTIONS = "db-options";
    private static final String DATA_COLUMN_FAMILY_OPTIONS = "data-column-family-options";
    private static final String MAPPING_DIR = "mapping-dir";
    private static final String CENTRAL_STORAGE = "central-storage";
    private static final String FSYNC = "fsync";
    private static final String CACHE_SIZE_MB = "cache-size-mb";
    private static final String BLOCK_SIZE_KB = "block-size-kb";
    private static final String OFF_HEAP_THRESHOLD = "off-heap-cache-memory-threshold";

    protected Class<RocksDBBlobStoreDataPolicyFactoryBean> getBeanClass(Element element) {
        return RocksDBBlobStoreDataPolicyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String offHeapCacheMemoryThreshold;
        String blockSizeKB;
        String cacheSizeMB;
        String mappingDir;
        String dataColumnFamilyOptions;
        String paths = element.getAttribute(PATHS);
        if (!StringUtils.hasText((String)paths)) {
            throw new IllegalArgumentException("Please configure paths. it's a required property.");
        }
        builder.addPropertyValue(PATHS, (Object)paths);
        String dbOptions = element.getAttribute(DB_OPTIONS);
        if (StringUtils.hasText((String)dbOptions)) {
            builder.addPropertyReference("dbOptions", dbOptions);
        }
        if (StringUtils.hasText((String)(dataColumnFamilyOptions = element.getAttribute(DATA_COLUMN_FAMILY_OPTIONS)))) {
            builder.addPropertyReference("dataColumnFamilyOptions", dataColumnFamilyOptions);
        }
        if (!StringUtils.hasText((String)(mappingDir = element.getAttribute(MAPPING_DIR)))) {
            throw new IllegalArgumentException("Please configure mapping dir. it's a required property.");
        }
        builder.addPropertyValue("mappingDir", (Object)mappingDir);
        String centralStorage = element.getAttribute(CENTRAL_STORAGE);
        if (StringUtils.hasText((String)centralStorage)) {
            builder.addPropertyValue("centralStorage", (Object)centralStorage);
        } else {
            builder.addPropertyValue("centralStorage", (Object)false);
        }
        String sync = element.getAttribute(FSYNC);
        if (StringUtils.hasText((String)sync)) {
            builder.addPropertyValue(FSYNC, (Object)sync);
        }
        if (StringUtils.hasText((String)(cacheSizeMB = element.getAttribute(CACHE_SIZE_MB)))) {
            builder.addPropertyValue("cacheSizeMB", (Object)cacheSizeMB);
        }
        if (StringUtils.hasText((String)(blockSizeKB = element.getAttribute(BLOCK_SIZE_KB)))) {
            builder.addPropertyValue("blockSizeKB", (Object)blockSizeKB);
        }
        if (StringUtils.hasText((String)(offHeapCacheMemoryThreshold = element.getAttribute(OFF_HEAP_THRESHOLD)))) {
            builder.addPropertyValue("offHeapCacheMemoryThreshold", (Object)offHeapCacheMemoryThreshold);
        }
    }
}

