/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.config;

import com.gigaspaces.blobstore.rocksdb.RocksDBBlobStoreHandler;
import com.gigaspaces.blobstore.rocksdb.config.XAPColumnFamilyOptions;
import com.gigaspaces.blobstore.rocksdb.config.XAPDBOptions;

public class RocksDBBlobStoreConfigurer {
    private RocksDBBlobStoreHandler rocksDBBlobStoreHandler;
    private String paths;
    private String mappingDir;
    private boolean centralStorage;
    private XAPDBOptions dbOptions;
    private XAPColumnFamilyOptions dataColumnFamilyOptions;
    private boolean fsync;
    private long cacheSizeMB = 100L;
    private long blockSizeKB = 16L;
    private String offHeapCacheMemoryThreshold;

    public String getPaths() {
        return this.paths;
    }

    public RocksDBBlobStoreConfigurer setPaths(String paths) {
        this.paths = paths;
        return this;
    }

    public XAPDBOptions getDbOptions() {
        return this.dbOptions;
    }

    public RocksDBBlobStoreConfigurer setDBOptions(XAPDBOptions dbOptions) {
        this.dbOptions = dbOptions;
        return this;
    }

    public XAPColumnFamilyOptions getDataColumnFamilyOptions() {
        return this.dataColumnFamilyOptions;
    }

    public RocksDBBlobStoreConfigurer setDataColumnFamilyOptions(XAPColumnFamilyOptions columnFamilyOptions) {
        this.dataColumnFamilyOptions = columnFamilyOptions;
        return this;
    }

    public String getMappingDir() {
        return this.mappingDir;
    }

    public RocksDBBlobStoreConfigurer setMappingDir(String mappingDir) {
        this.mappingDir = mappingDir;
        return this;
    }

    public boolean isCentralStorage() {
        return this.centralStorage;
    }

    public RocksDBBlobStoreConfigurer setCentralStorage(boolean centralStorage) {
        this.centralStorage = centralStorage;
        return this;
    }

    public boolean isFsync() {
        return this.fsync;
    }

    public RocksDBBlobStoreConfigurer setFsync(boolean fsync) {
        this.fsync = fsync;
        return this;
    }

    public long getCacheSizeMB() {
        return this.cacheSizeMB;
    }

    public RocksDBBlobStoreConfigurer setCacheSizeMB(long cacheSizeMB) {
        this.cacheSizeMB = cacheSizeMB;
        return this;
    }

    public long getBlockSizeKB() {
        return this.blockSizeKB;
    }

    public RocksDBBlobStoreConfigurer setBlockSizeKB(long blockSizeKB) {
        this.blockSizeKB = blockSizeKB;
        return this;
    }

    public String getOffHeapCacheMemoryThreshold() {
        return this.offHeapCacheMemoryThreshold;
    }

    public RocksDBBlobStoreConfigurer setOffHeapCacheMemoryThreshold(String offHeapCacheMemoryThreshold) {
        this.offHeapCacheMemoryThreshold = offHeapCacheMemoryThreshold;
        return this;
    }

    public RocksDBBlobStoreHandler create() {
        if (this.rocksDBBlobStoreHandler == null) {
            this.rocksDBBlobStoreHandler = new RocksDBBlobStoreHandler(this);
        }
        return this.rocksDBBlobStoreHandler;
    }

    public RocksDBBlobStoreHandler storageHandler() {
        return this.create();
    }

    public void destroy() {
        if (this.rocksDBBlobStoreHandler != null) {
            this.rocksDBBlobStoreHandler.close();
        }
    }
}

