/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.config;

import java.util.ArrayList;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.TableFormatConfig;

public class XAPColumnFamilyOptions
extends ColumnFamilyOptions {
    private boolean _tableOptionsIsSet = false;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public XAPColumnFamilyOptions() {
        this.setWriteBufferSize(0x4000000L);
        this.setLevelZeroSlowdownWritesTrigger(8);
        this.setMaxWriteBufferNumber(4);
        this.setTargetFileSizeBase(0x4000000L);
        this.setSoftPendingCompactionBytesLimit(0L);
        this.setHardPendingCompactionBytesLimit(0L);
        this.setLevelCompactionDynamicLevelBytes(false);
        this.setMaxBytesForLevelBase(0x20000000L);
        if (!XAPColumnFamilyOptions.isWindows()) {
            ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
            compressionTypes.add(CompressionType.NO_COMPRESSION);
            compressionTypes.add(CompressionType.NO_COMPRESSION);
            compressionTypes.add(CompressionType.SNAPPY_COMPRESSION);
            this.setCompressionPerLevel(compressionTypes);
        }
        this.setMergeOperatorName("put");
    }

    public XAPColumnFamilyOptions setTableFormatConfig(TableFormatConfig config) {
        this._tableOptionsIsSet = true;
        super.setTableFormatConfig(config);
        return this;
    }

    public boolean tableOptionsIsSet() {
        return this._tableOptionsIsSet;
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }
}

